/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.googleai;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import dev.langchain4j.model.googleai.GeminiPart;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
class GeminiContent {
    private List<GeminiPart> parts;
    private String role;

    public GeminiContent(String role) {
        this.parts = new ArrayList<GeminiPart>();
        this.role = role;
    }

    @JsonCreator
    public GeminiContent(@JsonProperty(value="parts") List<GeminiPart> parts, @JsonProperty(value="role") String role) {
        this.parts = parts;
        this.role = role;
    }

    public static GeminiContentBuilder builder() {
        return new GeminiContentBuilder();
    }

    void addPart(GeminiPart part) {
        this.parts.add(part);
    }

    public List<GeminiPart> getParts() {
        return this.parts;
    }

    public String getRole() {
        return this.role;
    }

    public void setParts(List<GeminiPart> parts) {
        this.parts = parts;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeminiContent)) {
            return false;
        }
        GeminiContent other = (GeminiContent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<GeminiPart> this$parts = this.getParts();
        List<GeminiPart> other$parts = other.getParts();
        if (this$parts == null ? other$parts != null : !((Object)this$parts).equals(other$parts)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        return !(this$role == null ? other$role != null : !this$role.equals(other$role));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeminiContent;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<GeminiPart> $parts = this.getParts();
        result = result * 59 + ($parts == null ? 43 : ((Object)$parts).hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        return result;
    }

    public String toString() {
        return "GeminiContent(parts=" + String.valueOf(this.getParts()) + ", role=" + this.getRole() + ")";
    }

    public static class GeminiContentBuilder {
        private List<GeminiPart> parts;
        private String role;

        GeminiContentBuilder() {
        }

        public GeminiContentBuilder parts(List<GeminiPart> parts) {
            this.parts = parts;
            return this;
        }

        public GeminiContentBuilder role(String role) {
            this.role = role;
            return this;
        }

        public GeminiContent build() {
            return new GeminiContent(this.parts, this.role);
        }

        public String toString() {
            return "GeminiContent.GeminiContentBuilder(parts=" + String.valueOf(this.parts) + ", role=" + this.role + ")";
        }
    }
}

