/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.explain_error;

import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.model.Action;
import hudson.model.Item;
import hudson.model.Run;
import io.jenkins.plugins.explain_error.ErrorExplainer;
import io.jenkins.plugins.explain_error.ErrorExplanationAction;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ConsoleExplainErrorAction
implements Action {
    private static final Logger LOGGER = Logger.getLogger(ConsoleExplainErrorAction.class.getName());
    private final Run<?, ?> run;

    public ConsoleExplainErrorAction(Run<?, ?> run) {
        this.run = run;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "console-explain-error";
    }

    @RequirePOST
    public void doExplainConsoleError(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        try {
            List logLines;
            String errorText;
            ErrorExplainer explainer;
            String explanation;
            this.run.checkPermission(Item.READ);
            boolean forceNew = "true".equals(req.getParameter("forceNew"));
            ErrorExplanationAction existingAction = (ErrorExplanationAction)this.run.getAction(ErrorExplanationAction.class);
            if (!forceNew && existingAction != null && existingAction.hasValidExplanation()) {
                this.writeJsonResponse(rsp, this.createCachedResponse(existingAction.getExplanation()));
                return;
            }
            int maxLines = 200;
            String maxLinesParam = req.getParameter("maxLines");
            if (maxLinesParam != null) {
                try {
                    maxLines = Integer.parseInt(maxLinesParam);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((explanation = (explainer = new ErrorExplainer()).explainErrorText(errorText = String.join((CharSequence)"\n", logLines = this.run.getLog(maxLines)), this.run)) != null && !explanation.trim().isEmpty()) {
                ErrorExplanationAction action = new ErrorExplanationAction(explanation, errorText);
                this.run.addOrReplaceAction((Action)action);
                this.writeJsonResponse(rsp, explanation);
            } else {
                this.writeJsonResponse(rsp, "Error: Could not generate explanation. Please check your AI API configuration.");
            }
        }
        catch (Exception e) {
            LOGGER.severe("=== EXPLAIN ERROR REQUEST FAILED ===");
            LOGGER.severe("Error explaining console error: " + e.getMessage());
            this.writeJsonResponse(rsp, "Error: " + e.getMessage());
        }
    }

    @RequirePOST
    public void doCheckExistingExplanation(StaplerRequest2 req, StaplerResponse2 rsp) throws ServletException, IOException {
        try {
            this.run.checkPermission(Item.READ);
            ErrorExplanationAction existingAction = (ErrorExplanationAction)this.run.getAction(ErrorExplanationAction.class);
            boolean hasExplanation = existingAction != null && existingAction.hasValidExplanation();
            rsp.setContentType("application/json");
            rsp.setCharacterEncoding("UTF-8");
            PrintWriter writer = rsp.getWriter();
            if (hasExplanation) {
                String response = String.format("{\"hasExplanation\": true, \"timestamp\": \"%s\"}", existingAction.getFormattedTimestamp());
                writer.write(response);
            } else {
                writer.write("{\"hasExplanation\": false}");
            }
            writer.flush();
        }
        catch (Exception e) {
            LOGGER.severe("Error checking existing explanation: " + e.getMessage());
            rsp.setStatus(500);
        }
    }

    private void writeJsonResponse(StaplerResponse2 rsp, String message) throws IOException {
        rsp.setContentType("application/json");
        rsp.setCharacterEncoding("UTF-8");
        PrintWriter writer = rsp.getWriter();
        try {
            ObjectMapper mapper = new ObjectMapper();
            String jsonResponse = mapper.writeValueAsString((Object)message);
            writer.write(jsonResponse);
        }
        catch (Exception e) {
            writer.write("\"" + message.replace("\"", "\\\"") + "\"");
        }
        writer.flush();
    }

    private String createCachedResponse(String explanation) {
        return explanation + "\n\n[Note: This is a previously generated explanation. Use the 'Generate New' option to create a new one.]";
    }

    public Run<?, ?> getRun() {
        return this.run;
    }
}

