/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.store.embedding;

import dev.langchain4j.data.embedding.Embedding;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.store.embedding.filter.Filter;
import java.util.Objects;

public class EmbeddingSearchRequest {
    private final Embedding queryEmbedding;
    private final int maxResults;
    private final double minScore;
    private final Filter filter;

    public EmbeddingSearchRequest(Embedding queryEmbedding, Integer maxResults, Double minScore, Filter filter) {
        this.queryEmbedding = ValidationUtils.ensureNotNull(queryEmbedding, "queryEmbedding");
        this.maxResults = ValidationUtils.ensureGreaterThanZero(Utils.getOrDefault(maxResults, 3), "maxResults");
        this.minScore = ValidationUtils.ensureBetween(Utils.getOrDefault(minScore, 0.0), 0.0, 1.0, "minScore");
        this.filter = filter;
    }

    public static EmbeddingSearchRequestBuilder builder() {
        return new EmbeddingSearchRequestBuilder();
    }

    public Embedding queryEmbedding() {
        return this.queryEmbedding;
    }

    public int maxResults() {
        return this.maxResults;
    }

    public double minScore() {
        return this.minScore;
    }

    public Filter filter() {
        return this.filter;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmbeddingSearchRequest)) {
            return false;
        }
        EmbeddingSearchRequest other = (EmbeddingSearchRequest)o;
        return this.maxResults == other.maxResults && this.minScore == other.minScore && Objects.equals(this.queryEmbedding, other.queryEmbedding) && Objects.equals(this.filter, other.filter);
    }

    public int hashCode() {
        return Objects.hash(this.queryEmbedding, this.maxResults, this.minScore, this.filter);
    }

    public String toString() {
        return "EmbeddingSearchRequest(queryEmbedding=" + String.valueOf(this.queryEmbedding) + ", maxResults=" + this.maxResults + ", minScore=" + this.minScore + ", filter=" + String.valueOf(this.filter) + ")";
    }

    public static class EmbeddingSearchRequestBuilder {
        private Embedding queryEmbedding;
        private Integer maxResults;
        private Double minScore;
        private Filter filter;

        EmbeddingSearchRequestBuilder() {
        }

        public EmbeddingSearchRequestBuilder queryEmbedding(Embedding queryEmbedding) {
            this.queryEmbedding = queryEmbedding;
            return this;
        }

        public EmbeddingSearchRequestBuilder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public EmbeddingSearchRequestBuilder minScore(Double minScore) {
            this.minScore = minScore;
            return this;
        }

        public EmbeddingSearchRequestBuilder filter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public EmbeddingSearchRequest build() {
            return new EmbeddingSearchRequest(this.queryEmbedding, this.maxResults, this.minScore, this.filter);
        }
    }
}

