/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.brat;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import opennlp.tools.formats.brat.BratDocument;
import opennlp.tools.formats.brat.BratDocumentParser;
import opennlp.tools.formats.brat.SegmenterObjectStream;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.tokenize.Tokenizer;
import opennlp.tools.tokenize.TokenizerME;
import opennlp.tools.tokenize.TokenizerModel;
import opennlp.tools.util.ObjectStream;

public class BratNameSampleStream
extends SegmenterObjectStream<BratDocument, NameSample> {
    private final BratDocumentParser parser;

    public BratNameSampleStream(SentenceDetector sentDetector, Tokenizer tokenizer, ObjectStream<BratDocument> samples) {
        this(sentDetector, tokenizer, samples, null);
    }

    public BratNameSampleStream(SentenceModel sentModel, TokenizerModel tokenModel, ObjectStream<BratDocument> samples) {
        this(new SentenceDetectorME(sentModel), new TokenizerME(tokenModel), samples, null);
    }

    public BratNameSampleStream(SentenceDetector sentDetector, Tokenizer tokenizer, ObjectStream<BratDocument> samples, Set<String> nameTypes) {
        super(samples);
        this.parser = new BratDocumentParser(sentDetector, tokenizer, nameTypes);
    }

    public BratNameSampleStream(SentenceModel sentModel, TokenizerModel tokenModel, ObjectStream<BratDocument> samples, Set<String> nameTypes) {
        super(samples);
        this.parser = new BratDocumentParser(new SentenceDetectorME(sentModel), new TokenizerME(tokenModel), nameTypes);
    }

    @Override
    protected List<NameSample> read(BratDocument sample) throws IOException {
        return this.parser.parse(sample);
    }
}

