/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.service;

import dev.langchain4j.Internal;
import dev.langchain4j.agent.tool.ToolExecutionRequest;
import dev.langchain4j.agent.tool.ToolSpecification;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.data.message.ChatMessage;
import dev.langchain4j.data.message.ToolExecutionResultMessage;
import dev.langchain4j.guardrail.ChatExecutor;
import dev.langchain4j.guardrail.GuardrailRequestParams;
import dev.langchain4j.guardrail.OutputGuardrailRequest;
import dev.langchain4j.internal.Utils;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.invocation.InvocationContext;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.chat.request.ChatRequest;
import dev.langchain4j.model.chat.response.ChatResponse;
import dev.langchain4j.model.chat.response.CompleteToolCall;
import dev.langchain4j.model.chat.response.PartialResponse;
import dev.langchain4j.model.chat.response.PartialResponseContext;
import dev.langchain4j.model.chat.response.PartialThinking;
import dev.langchain4j.model.chat.response.PartialThinkingContext;
import dev.langchain4j.model.chat.response.StreamingChatResponseHandler;
import dev.langchain4j.model.chat.response.StreamingHandle;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.observability.api.event.AiServiceCompletedEvent;
import dev.langchain4j.observability.api.event.AiServiceErrorEvent;
import dev.langchain4j.observability.api.event.AiServiceEvent;
import dev.langchain4j.observability.api.event.AiServiceResponseReceivedEvent;
import dev.langchain4j.observability.api.event.ToolExecutedEvent;
import dev.langchain4j.service.AiServiceContext;
import dev.langchain4j.service.CancellationUnsupportedStreamingHandle;
import dev.langchain4j.service.tool.BeforeToolExecution;
import dev.langchain4j.service.tool.ToolArgumentsErrorHandler;
import dev.langchain4j.service.tool.ToolExecution;
import dev.langchain4j.service.tool.ToolExecutionErrorHandler;
import dev.langchain4j.service.tool.ToolExecutionResult;
import dev.langchain4j.service.tool.ToolExecutor;
import dev.langchain4j.service.tool.ToolService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
class AiServiceStreamingResponseHandler
implements StreamingChatResponseHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AiServiceStreamingResponseHandler.class);
    private final ChatExecutor chatExecutor;
    private final AiServiceContext context;
    private final InvocationContext invocationContext;
    private final GuardrailRequestParams commonGuardrailParams;
    private final Object methodKey;
    private final Consumer<String> partialResponseHandler;
    private final BiConsumer<PartialResponse, PartialResponseContext> partialResponseWithContextHandler;
    private final Consumer<PartialThinking> partialThinkingHandler;
    private final BiConsumer<PartialThinking, PartialThinkingContext> partialThinkingWithContextHandler;
    private final Consumer<BeforeToolExecution> beforeToolExecutionHandler;
    private final Consumer<ToolExecution> toolExecutionHandler;
    private final Consumer<ChatResponse> intermediateResponseHandler;
    private final Consumer<ChatResponse> completeResponseHandler;
    private final Consumer<Throwable> errorHandler;
    private final ChatMemory temporaryMemory;
    private final TokenUsage tokenUsage;
    private final List<ToolSpecification> toolSpecifications;
    private final Map<String, ToolExecutor> toolExecutors;
    private final ToolArgumentsErrorHandler toolArgumentsErrorHandler;
    private final ToolExecutionErrorHandler toolExecutionErrorHandler;
    private final Executor toolExecutor;
    private final Queue<Future<ToolRequestResult>> toolExecutionFutures = new ConcurrentLinkedQueue<Future<ToolRequestResult>>();
    private final List<String> responseBuffer = new ArrayList<String>();
    private final boolean hasOutputGuardrails;

    AiServiceStreamingResponseHandler(ChatExecutor chatExecutor, AiServiceContext context, InvocationContext invocationContext, Consumer<String> partialResponseHandler, BiConsumer<PartialResponse, PartialResponseContext> partialResponseWithContextHandler, Consumer<PartialThinking> partialThinkingHandler, BiConsumer<PartialThinking, PartialThinkingContext> partialThinkingWithContextHandler, Consumer<BeforeToolExecution> beforeToolExecutionHandler, Consumer<ToolExecution> toolExecutionHandler, Consumer<ChatResponse> intermediateResponseHandler, Consumer<ChatResponse> completeResponseHandler, Consumer<Throwable> errorHandler, ChatMemory temporaryMemory, TokenUsage tokenUsage, List<ToolSpecification> toolSpecifications, Map<String, ToolExecutor> toolExecutors, ToolArgumentsErrorHandler toolArgumentsErrorHandler, ToolExecutionErrorHandler toolExecutionErrorHandler, Executor toolExecutor, GuardrailRequestParams commonGuardrailParams, Object methodKey) {
        this.chatExecutor = (ChatExecutor)ValidationUtils.ensureNotNull((Object)chatExecutor, (String)"chatExecutor");
        this.context = (AiServiceContext)ValidationUtils.ensureNotNull((Object)context, (String)"context");
        this.invocationContext = (InvocationContext)ValidationUtils.ensureNotNull((Object)invocationContext, (String)"invocationContext");
        this.methodKey = methodKey;
        this.partialResponseHandler = partialResponseHandler;
        this.partialResponseWithContextHandler = partialResponseWithContextHandler;
        this.partialThinkingHandler = partialThinkingHandler;
        this.partialThinkingWithContextHandler = partialThinkingWithContextHandler;
        this.intermediateResponseHandler = intermediateResponseHandler;
        this.completeResponseHandler = completeResponseHandler;
        this.beforeToolExecutionHandler = beforeToolExecutionHandler;
        this.toolExecutionHandler = toolExecutionHandler;
        this.errorHandler = errorHandler;
        this.temporaryMemory = temporaryMemory;
        this.tokenUsage = (TokenUsage)ValidationUtils.ensureNotNull((Object)tokenUsage, (String)"tokenUsage");
        this.commonGuardrailParams = commonGuardrailParams;
        this.toolSpecifications = Utils.copy(toolSpecifications);
        this.toolExecutors = Utils.copy(toolExecutors);
        this.toolArgumentsErrorHandler = (ToolArgumentsErrorHandler)ValidationUtils.ensureNotNull((Object)toolArgumentsErrorHandler, (String)"toolArgumentsErrorHandler");
        this.toolExecutionErrorHandler = (ToolExecutionErrorHandler)ValidationUtils.ensureNotNull((Object)toolExecutionErrorHandler, (String)"toolExecutionErrorHandler");
        this.toolExecutor = toolExecutor;
        this.hasOutputGuardrails = context.guardrailService().hasOutputGuardrails(methodKey);
    }

    public void onPartialResponse(String partialResponse) {
        if (this.hasOutputGuardrails) {
            this.responseBuffer.add(partialResponse);
        } else if (this.partialResponseHandler != null) {
            this.partialResponseHandler.accept(partialResponse);
        } else if (this.partialResponseWithContextHandler != null) {
            PartialResponseContext context = new PartialResponseContext((StreamingHandle)new CancellationUnsupportedStreamingHandle());
            this.partialResponseWithContextHandler.accept(new PartialResponse(partialResponse), context);
        }
    }

    public void onPartialResponse(PartialResponse partialResponse, PartialResponseContext context) {
        if (this.hasOutputGuardrails) {
            this.responseBuffer.add(partialResponse.text());
        } else if (this.partialResponseHandler != null) {
            this.partialResponseHandler.accept(partialResponse.text());
        } else if (this.partialResponseWithContextHandler != null) {
            this.partialResponseWithContextHandler.accept(partialResponse, context);
        }
    }

    public void onPartialThinking(PartialThinking partialThinking) {
        if (this.partialThinkingHandler != null) {
            this.partialThinkingHandler.accept(partialThinking);
        } else if (this.partialThinkingWithContextHandler != null) {
            PartialThinkingContext context = new PartialThinkingContext((StreamingHandle)new CancellationUnsupportedStreamingHandle());
            this.partialThinkingWithContextHandler.accept(partialThinking, context);
        }
    }

    public void onPartialThinking(PartialThinking partialThinking, PartialThinkingContext context) {
        if (this.partialThinkingHandler != null) {
            this.partialThinkingHandler.accept(partialThinking);
        } else if (this.partialThinkingWithContextHandler != null) {
            this.partialThinkingWithContextHandler.accept(partialThinking, context);
        }
    }

    public void onCompleteToolCall(CompleteToolCall completeToolCall) {
        if (this.toolExecutor != null) {
            ToolExecutionRequest toolRequest = completeToolCall.toolExecutionRequest();
            CompletableFuture<ToolRequestResult> future = CompletableFuture.supplyAsync(() -> {
                ToolExecutionResult toolResult = this.execute(toolRequest);
                return new ToolRequestResult(toolRequest, toolResult);
            }, this.toolExecutor);
            this.toolExecutionFutures.add(future);
        }
    }

    private <T> void fireInvocationComplete(T result) {
        this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceCompletedEvent.builder().invocationContext(this.invocationContext).result(result).build());
    }

    private void fireToolExecutedEvent(ToolRequestResult toolRequestResult) {
        this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)ToolExecutedEvent.builder().invocationContext(this.invocationContext).request(toolRequestResult.request()).resultText(toolRequestResult.result().resultText()).build());
    }

    private void fireResponseReceivedEvent(ChatResponse chatResponse) {
        this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceResponseReceivedEvent.builder().invocationContext(this.invocationContext).response(chatResponse).build());
    }

    private void fireErrorReceived(Throwable error) {
        this.context.eventListenerRegistrar.fireEvent((AiServiceEvent)AiServiceErrorEvent.builder().invocationContext(this.invocationContext).error(error).build());
    }

    public void onCompleteResponse(ChatResponse chatResponse) {
        this.fireResponseReceivedEvent(chatResponse);
        AiMessage aiMessage = chatResponse.aiMessage();
        this.addToMemory((ChatMessage)aiMessage);
        if (aiMessage.hasToolExecutionRequests()) {
            if (this.intermediateResponseHandler != null) {
                this.intermediateResponseHandler.accept(chatResponse);
            }
            boolean immediateToolReturn = true;
            if (this.toolExecutor != null) {
                for (Future future : this.toolExecutionFutures) {
                    try {
                        ToolRequestResult toolRequestResult = (ToolRequestResult)future.get();
                        this.fireToolExecutedEvent(toolRequestResult);
                        ToolExecutionResultMessage toolExecutionResultMessage = ToolExecutionResultMessage.from((ToolExecutionRequest)toolRequestResult.request(), (String)toolRequestResult.result().resultText());
                        this.addToMemory((ChatMessage)toolExecutionResultMessage);
                        immediateToolReturn = immediateToolReturn && this.context.toolService.isImmediateTool(toolExecutionResultMessage.toolName());
                    }
                    catch (ExecutionException e) {
                        Throwable throwable = e.getCause();
                        if (throwable instanceof RuntimeException) {
                            RuntimeException re = (RuntimeException)throwable;
                            throw re;
                        }
                        throw new RuntimeException(e.getCause());
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException(e);
                    }
                }
            } else {
                for (ToolExecutionRequest toolExecutionRequest : aiMessage.toolExecutionRequests()) {
                    ToolExecutionResult toolResult = this.execute(toolExecutionRequest);
                    ToolRequestResult toolRequestResult = new ToolRequestResult(toolExecutionRequest, toolResult);
                    this.fireToolExecutedEvent(toolRequestResult);
                    this.addToMemory((ChatMessage)ToolExecutionResultMessage.from((ToolExecutionRequest)toolExecutionRequest, (String)toolResult.resultText()));
                    immediateToolReturn = immediateToolReturn && this.context.toolService.isImmediateTool(toolExecutionRequest.name());
                }
            }
            if (immediateToolReturn) {
                ChatResponse finalChatResponse = this.finalResponse(chatResponse, aiMessage);
                this.fireInvocationComplete(finalChatResponse);
                if (this.completeResponseHandler != null) {
                    this.completeResponseHandler.accept(finalChatResponse);
                }
                return;
            }
            ChatRequest chatRequest = ChatRequest.builder().messages(this.messagesToSend(this.invocationContext.chatMemoryId())).toolSpecifications(this.toolSpecifications).build();
            AiServiceStreamingResponseHandler aiServiceStreamingResponseHandler = new AiServiceStreamingResponseHandler(this.chatExecutor, this.context, this.invocationContext, this.partialResponseHandler, this.partialResponseWithContextHandler, this.partialThinkingHandler, this.partialThinkingWithContextHandler, this.beforeToolExecutionHandler, this.toolExecutionHandler, this.intermediateResponseHandler, this.completeResponseHandler, this.errorHandler, this.temporaryMemory, TokenUsage.sum((TokenUsage)this.tokenUsage, (TokenUsage)chatResponse.metadata().tokenUsage()), this.toolSpecifications, this.toolExecutors, this.toolArgumentsErrorHandler, this.toolExecutionErrorHandler, this.toolExecutor, this.commonGuardrailParams, this.methodKey);
            this.context.streamingChatModel.chat(chatRequest, (StreamingChatResponseHandler)aiServiceStreamingResponseHandler);
        } else {
            ChatResponse finalChatResponse = this.finalResponse(chatResponse, aiMessage);
            if (this.completeResponseHandler != null) {
                if (this.hasOutputGuardrails) {
                    if (this.commonGuardrailParams != null) {
                        GuardrailRequestParams newCommonParams = this.commonGuardrailParams.toBuilder().chatMemory(this.getMemory()).build();
                        OutputGuardrailRequest outputGuardrailRequest = OutputGuardrailRequest.builder().responseFromLLM(finalChatResponse).chatExecutor(this.chatExecutor).requestParams(newCommonParams).build();
                        finalChatResponse = (ChatResponse)this.context.guardrailService().executeGuardrails(this.methodKey, outputGuardrailRequest);
                    }
                    if (this.partialResponseHandler != null) {
                        this.responseBuffer.forEach(this.partialResponseHandler::accept);
                    }
                    this.responseBuffer.clear();
                }
                this.fireInvocationComplete(finalChatResponse);
                this.completeResponseHandler.accept(finalChatResponse);
            } else {
                this.fireInvocationComplete(finalChatResponse);
            }
        }
    }

    private ChatResponse finalResponse(ChatResponse completeResponse, AiMessage aiMessage) {
        return ChatResponse.builder().aiMessage(aiMessage).metadata(completeResponse.metadata().toBuilder().tokenUsage(this.tokenUsage.add(completeResponse.metadata().tokenUsage())).build()).build();
    }

    private ToolExecutionResult execute(ToolExecutionRequest toolRequest) {
        ToolExecutor toolExecutor = this.toolExecutors.get(toolRequest.name());
        this.handleBeforeTool(toolRequest);
        ToolExecutionResult toolResult = toolExecutor == null ? this.context.toolService.applyToolHallucinationStrategy(toolRequest) : ToolService.executeWithErrorHandling(toolRequest, toolExecutor, this.invocationContext, this.toolArgumentsErrorHandler, this.toolExecutionErrorHandler);
        this.handleAfterTool(toolRequest, toolResult);
        return toolResult;
    }

    private void handleBeforeTool(ToolExecutionRequest request) {
        if (this.beforeToolExecutionHandler != null) {
            BeforeToolExecution beforeToolExecution = BeforeToolExecution.builder().request(request).build();
            this.beforeToolExecutionHandler.accept(beforeToolExecution);
        }
    }

    private void handleAfterTool(ToolExecutionRequest request, ToolExecutionResult result) {
        if (this.toolExecutionHandler != null) {
            ToolExecution toolExecution = ToolExecution.builder().request(request).result(result).build();
            this.toolExecutionHandler.accept(toolExecution);
        }
    }

    private ChatMemory getMemory() {
        return this.getMemory(this.invocationContext.chatMemoryId());
    }

    private ChatMemory getMemory(Object memId) {
        return this.context.hasChatMemory() ? this.context.chatMemoryService.getOrCreateChatMemory(this.invocationContext.chatMemoryId()) : this.temporaryMemory;
    }

    private void addToMemory(ChatMessage chatMessage) {
        this.getMemory().add(chatMessage);
    }

    private List<ChatMessage> messagesToSend(Object memoryId) {
        return this.getMemory(memoryId).messages();
    }

    public void onError(Throwable error) {
        if (this.errorHandler != null) {
            try {
                this.fireErrorReceived(error);
                this.errorHandler.accept(error);
            }
            catch (Exception e) {
                LOG.error("While handling the following error...", error);
                LOG.error("...the following error happened", (Throwable)e);
            }
        } else {
            LOG.warn("Ignored error", error);
        }
    }

    private record ToolRequestResult(ToolExecutionRequest request, ToolExecutionResult result) {
    }
}

