/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.emoji.symbols;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Emojis {
    private static final Logger LOGGER = Logger.getLogger(Emojis.class.getName());
    private static final String EMOJIS_LIST_RESOURCE_PATH = "io/jenkins/plugins/emoji/symbols/Emojis/emojis.list";
    private static final String PLUGIN_NAME = "emoji-symbols-api";
    private static final String EMOJI_PREFIX = "emoji_";
    private static final String ICON_CLASS_NAME_PATTERN = "symbol-emoji_%s plugin-emoji-symbols-api";
    private static final Emojis INSTANCE = new Emojis();
    private final Map<String, String> availableIcons;
    private final Map<String, String> availableEmojis;

    private Emojis() {
        block15: {
            this.availableIcons = new LinkedHashMap<String, String>();
            this.availableEmojis = new LinkedHashMap<String, String>();
            try (InputStream stream = this.getClass().getClassLoader().getResourceAsStream(EMOJIS_LIST_RESOURCE_PATH);){
                if (stream != null) {
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            String[] splitLine = line.split(":");
                            String entry = splitLine[0];
                            String emoji = splitLine[1];
                            this.availableEmojis.put(entry, emoji);
                            this.availableIcons.put(entry, Emojis.getIconClassName(entry));
                        }
                        break block15;
                    }
                }
                LOGGER.warning("Unable to read available emojis: Resource unavailable.");
            }
            catch (Exception ex) {
                LOGGER.log(Level.WARNING, "Unable to read available emojis: Resource unavailable.", ex);
            }
        }
    }

    public static String getIconClassName(String emoji) {
        return String.format(ICON_CLASS_NAME_PATTERN, emoji);
    }

    public static Map<String, String> getAvailableIcons() {
        return Emojis.INSTANCE.availableIcons;
    }

    public static Map<String, String> getAvailableEmojis() {
        return Emojis.INSTANCE.availableEmojis;
    }
}

