/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.emailext.watching;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.JobProperty;
import hudson.model.User;
import hudson.model.UserPropertyDescriptor;
import hudson.plugins.emailext.ExtendedEmailPublisher;
import hudson.plugins.emailext.ExtendedEmailPublisherDescriptor;
import hudson.plugins.emailext.Messages;
import hudson.plugins.emailext.plugins.EmailTrigger;
import hudson.plugins.emailext.watching.EmailExtWatchJobProperty;
import hudson.tasks.Mailer;
import hudson.tasks.Publisher;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.export.Exported;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;

public class EmailExtWatchAction
implements Action {
    private final AbstractProject<?, ?> project;

    public EmailExtWatchAction(AbstractProject<?, ?> project) {
        this.project = project;
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        if (this.isWatching()) {
            return Messages.EmailExtWatchAction_DisplayNameWatching();
        }
        return Messages.EmailExtWatchAction_DisplayName();
    }

    public String getUrlName() {
        return "emailExtWatch";
    }

    public AbstractProject<?, ?> getProject() {
        return this.project;
    }

    public boolean isWatching() {
        List<EmailTrigger> triggers = this.getTriggers();
        return triggers != null && !triggers.isEmpty();
    }

    public List<EmailTrigger> getTriggers() {
        UserProperty p;
        User current = User.current();
        if (current != null && (p = (UserProperty)current.getProperty(UserProperty.class)) != null && this.project.getFullName().equalsIgnoreCase(p.getProjectName())) {
            return p.getTriggers();
        }
        return null;
    }

    public EmailExtWatchJobProperty getJobProperty() throws IOException {
        EmailExtWatchJobProperty prop = (EmailExtWatchJobProperty)this.project.getProperty(EmailExtWatchJobProperty.class);
        if (prop == null) {
            prop = new EmailExtWatchJobProperty();
            this.project.addProperty((JobProperty)prop);
        }
        return prop;
    }

    public Mailer.UserProperty getMailerProperty() {
        User current = User.current();
        if (current != null) {
            return (Mailer.UserProperty)current.getProperty(Mailer.UserProperty.class);
        }
        return null;
    }

    public ExtendedEmailPublisher getPublisher() {
        for (Publisher pub : this.project.getPublishersList()) {
            if (!(pub instanceof ExtendedEmailPublisher)) continue;
            ExtendedEmailPublisher publisher = (ExtendedEmailPublisher)pub;
            return publisher;
        }
        return null;
    }

    @POST
    public void doStopWatching(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException {
        User user = User.current();
        if (user != null && ((ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class)).isWatchingEnabled()) {
            this.project.checkPermission(Item.READ);
            this.stopWatching();
            for (hudson.model.UserProperty property : user.getAllProperties()) {
                if (!(property instanceof UserProperty)) continue;
                UserProperty userProperty = (UserProperty)property;
                userProperty.clearTriggers();
                break;
            }
        }
        rsp.sendRedirect(this.project.getAbsoluteUrl());
    }

    @RequirePOST
    public void doConfigSubmit(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        User user = User.current();
        if (user != null && ((ExtendedEmailPublisherDescriptor)Jenkins.get().getDescriptorByType(ExtendedEmailPublisherDescriptor.class)).isWatchingEnabled()) {
            this.project.checkPermission(Item.READ);
            Object json = req.getSubmittedForm().get("triggers");
            List triggers = req.bindJSONToList(EmailTrigger.class, json);
            ArrayList<EmailTrigger> unwatchable = new ArrayList<EmailTrigger>();
            for (EmailTrigger trigger : triggers) {
                if (trigger.getDescriptor().isWatchable()) continue;
                unwatchable.add(trigger);
            }
            triggers.removeAll(unwatchable);
            Mailer.UserProperty mailerProperty = this.getMailerProperty();
            if (mailerProperty != null) {
                for (EmailTrigger trigger : triggers) {
                    trigger.getEmail().setRecipientList(mailerProperty.getAddress());
                    trigger.getEmail().getRecipientProviders().clear();
                }
                this.startWatching();
                user.addProperty((hudson.model.UserProperty)new UserProperty(this.project.getFullName(), triggers));
            }
        }
        rsp.sendRedirect(this.project.getAbsoluteUrl());
    }

    public void startWatching() throws IOException {
        User user = User.current();
        if (user != null) {
            this.getJobProperty().addWatcher(user);
            this.project.save();
        }
    }

    public void stopWatching() throws IOException {
        User user = User.current();
        if (user != null) {
            this.getJobProperty().removeWatcher(user);
            this.project.save();
        }
    }

    public boolean isWatching(User user) throws IOException {
        return this.getJobProperty().isWatching(user);
    }

    public static class UserProperty
    extends hudson.model.UserProperty {
        private List<EmailTrigger> triggers = new ArrayList<EmailTrigger>();
        private String projectName;

        public UserProperty(String projectId, List<EmailTrigger> triggers) {
            if (triggers != null) {
                this.triggers = Collections.unmodifiableList(triggers);
            }
            this.projectName = projectId;
        }

        @Exported
        public List<EmailTrigger> getTriggers() {
            return this.triggers;
        }

        private void clearTriggers() {
            this.triggers = Collections.emptyList();
        }

        public String getProjectName() {
            return this.projectName;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Extension
        public static final class DescriptorImpl
        extends UserPropertyDescriptor {
            public DescriptorImpl() {
                super(UserProperty.class);
            }

            @NonNull
            public String getDisplayName() {
                return "Extended Email Job Watching";
            }

            public UserProperty newInstance(User user) {
                return new UserProperty("", null);
            }

            @NonNull
            public UserProperty newInstance(StaplerRequest2 req, @NonNull JSONObject json) throws Descriptor.FormException {
                List triggers = req != null ? req.bindJSONToList(EmailTrigger.class, (Object)json) : Collections.emptyList();
                return new UserProperty("", triggers);
            }
        }
    }
}

