/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.plugins.eggplant;

import hudson.EnvVars;
import hudson.Extension;
import hudson.ExtensionPoint;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Proc;
import hudson.model.AbstractProject;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import hudson.util.Secret;
import io.jenkins.plugins.eggplant.common.LogLevel;
import io.jenkins.plugins.eggplant.common.OperatingSystem;
import io.jenkins.plugins.eggplant.exception.BuilderException;
import io.jenkins.plugins.eggplant.exception.CLIExitException;
import io.jenkins.plugins.eggplant.utils.CLIRunnerHelper;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.tasks.SimpleBuildStep;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class EggplantRunnerBuilder
extends Builder
implements SimpleBuildStep {
    private String serverURL;
    private String testConfigId;
    private String testConfigName;
    private String modelName;
    private String suiteName;
    private String clientId;
    private Secret clientSecret;
    private LogLevel logLevel;
    private String CACertPath;
    private String testResultPath;
    private String requestTimeout;
    private String requestRetries;
    private String backoffFactor;
    private Boolean dryRun;
    private String eggplantRunnerPath;
    private TestConfig testConfig;
    private String parameters;
    private String parametersFilePath;
    private String filterBy;
    private String filterByJson;
    private String previousTaskInstanceID;

    @DataBoundConstructor
    public EggplantRunnerBuilder() {
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public String getTestConfigId() {
        return this.testConfigId;
    }

    public String getTestConfigName() {
        return this.testConfigName;
    }

    public String getModelName() {
        return this.modelName;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public String getClientId() {
        return this.clientId;
    }

    public Secret getClientSecret() {
        return this.clientSecret;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public String getCACertPath() {
        return this.CACertPath;
    }

    public String getTestResultPath() {
        return this.testResultPath;
    }

    public String getRequestTimeout() {
        return this.requestTimeout;
    }

    public String getRequestRetries() {
        return this.requestRetries;
    }

    public String getBackoffFactor() {
        return this.backoffFactor;
    }

    public String getEggplantRunnerPath() {
        return this.eggplantRunnerPath;
    }

    public String getParameters() {
        return this.parameters;
    }

    public String getParametersFilePath() {
        return this.parametersFilePath;
    }

    public String getFilterBy() {
        return this.filterBy;
    }

    public String getFilterByJson() {
        return this.filterByJson;
    }

    public String getPreviousTaskInstanceID() {
        return this.previousTaskInstanceID;
    }

    public TestConfig getTestConfig() {
        if (this.testConfigId != null) {
            this.testConfig = new TestConfigId(this.testConfigId);
            this.testConfigId = null;
        }
        return this.testConfig;
    }

    @DataBoundSetter
    public void setServerURL(String serverURL) {
        this.serverURL = serverURL;
    }

    @DataBoundSetter
    public void setTestConfigId(String testConfigId) {
        this.testConfigId = testConfigId;
    }

    @DataBoundSetter
    public void setTestConfigName(String testConfigName) {
        this.testConfigName = testConfigName;
    }

    @DataBoundSetter
    public void setModelName(String modelName) {
        this.modelName = modelName;
    }

    @DataBoundSetter
    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    @DataBoundSetter
    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    @DataBoundSetter
    public void setClientSecret(Secret clientSecret) {
        this.clientSecret = clientSecret;
    }

    @DataBoundSetter
    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    @DataBoundSetter
    public void setCACertPath(String CACertPath) {
        this.CACertPath = CACertPath;
    }

    @DataBoundSetter
    public void setTestResultPath(String testResultPath) {
        this.testResultPath = testResultPath;
    }

    @DataBoundSetter
    public void setRequestTimeout(String requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    @DataBoundSetter
    public void setRequestRetries(String requestRetries) {
        this.requestRetries = requestRetries;
    }

    @DataBoundSetter
    public void setBackoffFactor(String backoffFactor) {
        this.backoffFactor = backoffFactor;
    }

    @DataBoundSetter
    public void setDryRun(boolean dryRun) {
        this.dryRun = dryRun;
    }

    @DataBoundSetter
    public void setEggplantRunnerPath(String eggplantRunnerPath) {
        this.eggplantRunnerPath = eggplantRunnerPath;
    }

    @DataBoundSetter
    public void setTestConfig(TestConfig testConfig) {
        this.testConfig = testConfig;
    }

    @DataBoundSetter
    public void setParameters(String parameters) {
        this.parameters = parameters;
    }

    @DataBoundSetter
    public void setParametersFilePath(String parametersFilePath) {
        this.parametersFilePath = parametersFilePath;
    }

    @DataBoundSetter
    public void setFilterBy(String filterBy) {
        this.filterBy = filterBy;
    }

    @DataBoundSetter
    public void setFilterByJson(String filterByJson) {
        this.filterByJson = filterByJson;
    }

    @DataBoundSetter
    public void setPreviousTaskInstanceID(String previousTaskInstanceID) {
        this.previousTaskInstanceID = previousTaskInstanceID;
    }

    public void perform(Run<?, ?> run, FilePath workspace, EnvVars env, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream logger = listener.getLogger();
        String buildId = run.getId();
        String localeString = "";
        OperatingSystem os = this.getOperatingSystem(workspace, launcher);
        FilePath uniqueWorkspace = workspace.child(buildId);
        uniqueWorkspace.mkdirs();
        localeString = os == OperatingSystem.LINUX ? this.getLocale(logger) : String.format("%s.utf-8", "en_US");
        logger.println("Exported locale: " + localeString);
        EnvVars envVars = new EnvVars();
        envVars.put("LC_ALL", localeString);
        envVars.put("LANG", localeString);
        CLIRunnerHelper CLIRunnerHelper2 = new CLIRunnerHelper(workspace, os, logger);
        if (this.eggplantRunnerPath != null && !this.eggplantRunnerPath.equals("")) {
            CLIRunnerHelper2.copyRunnerFrom(this.eggplantRunnerPath);
        } else {
            CLIRunnerHelper2.downloadRunner((String)env.get((Object)"gitlabAccessToken"));
        }
        FilePath cliRunnerPath = CLIRunnerHelper2.getFilePath();
        Object[] command = this.getCommand(cliRunnerPath, env, os);
        logger.println("command: " + Arrays.toString(command));
        cliRunnerPath.chmod(493);
        logger.println(">> Executing " + String.valueOf(cliRunnerPath));
        Launcher.ProcStarter procStarter = launcher.launch();
        Proc process = procStarter.pwd(uniqueWorkspace).cmds((String[])command).envs((Map)envVars).quiet(false).stderr((OutputStream)logger).stdout((OutputStream)logger).start();
        int exitCode = process.join();
        if (exitCode != 0) {
            throw new CLIExitException(exitCode);
        }
    }

    private String getdefaultLocale(PrintStream logger) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder("sh", "-c", "echo $LANG");
        Process process = pb.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream(), StandardCharsets.UTF_8));
        String line = reader.readLine();
        if (line != null) {
            logger.println("Default locale:" + line);
            reader.close();
            return line;
        }
        reader.close();
        return "";
    }

    private String getLocale(PrintStream logger) throws IOException, InterruptedException {
        String defaultLocale = this.getdefaultLocale(logger);
        if (defaultLocale.isEmpty()) {
            String line;
            Process proc = Runtime.getRuntime().exec("locale -a");
            int exitStatus = proc.waitFor();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(proc.getInputStream(), StandardCharsets.UTF_8));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.isEmpty() || !line.toLowerCase().endsWith(".utf-8") && !line.toLowerCase().endsWith(".utf8")) continue;
                logger.println("Available locale:" + line);
                bufferedReader.close();
                return line;
            }
            if (exitStatus != 0) {
                bufferedReader.close();
            }
            bufferedReader.close();
        }
        return defaultLocale;
    }

    private OperatingSystem getOperatingSystem(FilePath workspace, Launcher launcher) throws IOException, InterruptedException {
        if (!launcher.isUnix()) {
            return OperatingSystem.WINDOWS;
        }
        Launcher.ProcStarter procStarter = launcher.launch();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Proc process = procStarter.pwd(workspace).cmds(new String[]{"uname"}).quiet(true).stdout((OutputStream)outputStream).start();
        process.join();
        String output = outputStream.toString("UTF-8");
        if (output.startsWith("Darwin")) {
            return OperatingSystem.MACOS;
        }
        return OperatingSystem.LINUX;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void getBackwardCompatibilityCommands() throws BuilderException {
        if (this.testConfig != null) return;
        if (this.testConfigId != null) {
            this.testConfig = new TestConfigId(this.testConfigId);
            return;
        } else {
            if (this.testConfigName == null) throw new BuilderException("testConfigId and testConfigName not found. Use only testConfigId or testConfigName (with modelName or suiteName) to continue.");
            if (this.modelName != null && this.suiteName != null) {
                throw new BuilderException("modelName and suiteName found,  Use testConfigName with only suiteName or modelName to continue.");
            }
            if (this.modelName != null) {
                this.testConfig = new ModelBased(this.testConfigName, this.modelName);
                return;
            } else {
                if (this.suiteName == null) throw new BuilderException("testConfigName found, suiteName or modelName is required.");
                this.testConfig = new ScriptBased(this.testConfigName, this.suiteName);
            }
        }
    }

    public List<String> getMandatoryCommandList(EnvVars env) {
        ArrayList<String> args = new ArrayList<String>();
        if (this.testConfig instanceof TestConfigId) {
            TestConfigId testconfigid = (TestConfigId)this.testConfig;
            args.add(this.serverURL);
            args.add(testconfigid.getId());
        }
        if (this.testConfig instanceof ModelBased) {
            ModelBased modelbased = (ModelBased)this.testConfig;
            args.add("modelbased");
            args.add(this.serverURL);
            args.add(String.format("--test-config-name=%s", modelbased.getName()));
            args.add(String.format("--model-name=%s", modelbased.getModel()));
        }
        if (this.testConfig instanceof ScriptBased) {
            ScriptBased scriptbased = (ScriptBased)this.testConfig;
            args.add("scriptbased");
            args.add(this.serverURL);
            args.add(String.format("--test-config-name=%s", scriptbased.getName()));
            args.add(String.format("--suite-name=%s", scriptbased.getSuite()));
        }
        if (this.clientId != null && !this.clientId.equals("")) {
            args.add(String.format("--client-id=%s", this.clientId));
        }
        if (this.clientSecret != null && !this.clientSecret.getPlainText().isEmpty()) {
            args.add(String.format("--client-secret=%s", this.clientSecret));
        } else if (env.get((Object)"DAI_CLIENT_SECRET") != null && !((String)env.get((Object)"DAI_CLIENT_SECRET")).equals("")) {
            args.add(String.format("--client-secret=%s", env.get((Object)"DAI_CLIENT_SECRET")));
        }
        return args;
    }

    public List<String> getOptionalCommandList(OperatingSystem os) {
        String[] values;
        ArrayList<String> args = new ArrayList<String>();
        if (this.logLevel != null) {
            args.add(String.format("--log-level=%s", new Object[]{this.logLevel}));
        }
        if (this.CACertPath != null && !this.CACertPath.equals("")) {
            args.add(String.format("--ca-cert-path=%s", this.CACertPath));
        }
        if (this.testResultPath != null && !this.testResultPath.equals("")) {
            args.add(String.format("--test-result-path=%s", this.testResultPath));
        }
        if (this.requestTimeout != null && !this.requestTimeout.equals("")) {
            args.add(String.format("--request-timeout=%s", this.requestTimeout));
        }
        if (this.requestRetries != null && !this.requestRetries.equals("")) {
            args.add(String.format("--request-retries=%s", this.requestRetries));
        }
        if (this.dryRun != null && this.dryRun.booleanValue()) {
            args.add("--dry-run");
        }
        if (this.backoffFactor != null && !this.backoffFactor.equals("")) {
            args.add(String.format("--backoff-factor=%s", this.backoffFactor));
        }
        if (this.parameters != null && !this.parameters.equals("")) {
            for (String value : values = this.parameters.split(";;")) {
                args.add("--param");
                if (os == OperatingSystem.LINUX || os == OperatingSystem.MACOS || !value.contains(" ")) {
                    args.add(value);
                    continue;
                }
                args.add(value.replace("\"", "\\\""));
            }
        }
        if (this.parametersFilePath != null && !this.parametersFilePath.equals("")) {
            args.add(String.format("--param-file=%s", this.parametersFilePath));
        }
        if (this.filterBy != null && !this.filterBy.equals("")) {
            for (String value : values = this.filterBy.split(";;")) {
                args.add("--filter-by");
                if (os == OperatingSystem.LINUX || os == OperatingSystem.MACOS || !value.contains(" ")) {
                    args.add(value);
                    continue;
                }
                args.add(value.replace("\"", "\\\""));
            }
        }
        if (this.filterByJson != null && !this.filterByJson.equals("")) {
            args.add(String.format("--filter-by-json=%s", this.filterByJson));
        }
        if (this.previousTaskInstanceID != null && !this.previousTaskInstanceID.equals("")) {
            args.add(String.format("--previous-task-instance-id=%s", this.previousTaskInstanceID));
        }
        return args;
    }

    private String[] getCommand(FilePath cliFile, EnvVars env, OperatingSystem os) throws BuilderException {
        ArrayList<String> commandList = new ArrayList<String>();
        commandList.add(cliFile.getRemote());
        this.getBackwardCompatibilityCommands();
        commandList.addAll(this.getMandatoryCommandList(env));
        commandList.addAll(this.getOptionalCommandList(os));
        return commandList.toArray(new String[0]);
    }

    public static class TestConfigId
    extends TestConfig {
        private final String id;

        @DataBoundConstructor
        public TestConfigId(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<TestConfig> {
            public String getDisplayName() {
                return "By Test Config Id";
            }

            public FormValidation doCheckId(@QueryParameter String value) throws IOException {
                if (value.isEmpty()) {
                    return FormValidation.error((String)"Test Config Id cannot be empty.");
                }
                if (!this.isValidUuid(value).booleanValue()) {
                    return FormValidation.error((String)"Invalid test configuration id.");
                }
                return FormValidation.ok();
            }

            private Boolean isValidUuid(String value) {
                Pattern p = Pattern.compile("[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}$");
                Boolean isMatch = p.matcher(value).matches();
                if (isMatch.booleanValue()) {
                    return true;
                }
                return false;
            }
        }
    }

    public static abstract class TestConfig
    implements ExtensionPoint,
    Describable<TestConfig> {
        public Descriptor<TestConfig> getDescriptor() {
            return Jenkins.get().getDescriptor(this.getClass());
        }
    }

    public static class ModelBased
    extends TestConfig {
        private final String name;
        private final String model;

        @DataBoundConstructor
        public ModelBased(String name, String model) {
            this.name = name;
            this.model = model;
        }

        public String getName() {
            return this.name;
        }

        public String getModel() {
            return this.model;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<TestConfig> {
            public String getDisplayName() {
                return "By Test Config Name and Model Name (Model-based)";
            }

            public FormValidation doCheckName(@QueryParameter String value) throws IOException {
                if (value.isEmpty()) {
                    return FormValidation.error((String)"Test Config Name cannot be empty.");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckModel(@QueryParameter String value) throws IOException {
                if (value.isEmpty()) {
                    return FormValidation.error((String)"Model Name cannot be empty.");
                }
                return FormValidation.ok();
            }
        }
    }

    public static class ScriptBased
    extends TestConfig {
        private final String name;
        private final String suite;

        @DataBoundConstructor
        public ScriptBased(String name, String suite) {
            this.name = name;
            this.suite = suite;
        }

        public String getName() {
            return this.name;
        }

        public String getSuite() {
            return this.suite;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<TestConfig> {
            public String getDisplayName() {
                return "By Test Config Name and Suite Name (Script-based)";
            }

            public FormValidation doCheckName(@QueryParameter String value) throws IOException {
                if (value.isEmpty()) {
                    return FormValidation.error((String)"Test Config Name cannot be empty.");
                }
                return FormValidation.ok();
            }

            public FormValidation doCheckSuite(@QueryParameter String value) throws IOException {
                if (value.isEmpty()) {
                    return FormValidation.error((String)"Suite Name cannot be empty.");
                }
                return FormValidation.ok();
            }
        }
    }

    @Symbol(value={"eggplantRunner"})
    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return "Eggplant Runner";
        }

        public FormValidation doCheckServerURL(@QueryParameter String value) throws IOException {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Server URL cannot be empty.");
            }
            if (!this.isValidURL(value).booleanValue()) {
                return FormValidation.error((String)"Invalid server url.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClientId(@QueryParameter String value) throws IOException {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Client Id cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckClientSecret(@QueryParameter String value) throws IOException {
            if (value.isEmpty()) {
                return FormValidation.error((String)"Client Secret cannot be empty.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckTestResultPath(@QueryParameter String value) throws IOException {
            if (!value.isEmpty() && !DescriptorImpl.isValidPath(value, "xml")) {
                return FormValidation.error((String)"Invalid Test Result Path.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRequestTimeout(@QueryParameter String value) throws IOException {
            if (!value.isEmpty() && !this.isValidNumeric(value).booleanValue()) {
                return FormValidation.error((String)"Invalid Request Timeout.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckRequestRetries(@QueryParameter String value) throws IOException {
            if (!value.isEmpty() && !this.isValidNumeric(value).booleanValue()) {
                return FormValidation.error((String)"Invalid Request Retries.");
            }
            return FormValidation.ok();
        }

        public FormValidation doCheckBackoffFactor(@QueryParameter String value) throws IOException {
            if (!value.isEmpty() && !this.isValidDecimal(value).booleanValue()) {
                return FormValidation.error((String)"Invalid Backoff Factor.");
            }
            return FormValidation.ok();
        }

        private Boolean isValidURL(String value) {
            Pattern p = Pattern.compile("^https?:\\/\\/([a-zA-Z0-9]+)((\\-|\\.)[a-zA-Z0-9]+)*(:[0-9]+)?(\\/?)$");
            Boolean isMatch = p.matcher(value).matches();
            if (isMatch.booleanValue()) {
                return true;
            }
            return false;
        }

        private Boolean isValidNumeric(String value) {
            Pattern p = Pattern.compile("^\\d+$");
            Boolean isMatch = p.matcher(value).matches();
            if (isMatch.booleanValue()) {
                return true;
            }
            return false;
        }

        private Boolean isValidDecimal(String value) {
            Pattern p = Pattern.compile("^\\d+\\.?\\d*$");
            Boolean isMatch = p.matcher(value).matches();
            if (isMatch.booleanValue()) {
                return true;
            }
            return false;
        }

        public static boolean isValidPath(String path, String extension) {
            Pattern p = Pattern.compile("[^?\"*<>|]+." + extension + "$");
            Boolean isMatch = p.matcher(path).matches();
            return isMatch != false;
        }
    }
}

