/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutestexecution.steps;

import com.google.common.collect.ImmutableSet;
import de.tracetronic.jenkins.plugins.ecutestexecution.TGInstallation;
import de.tracetronic.jenkins.plugins.ecutestexecution.clients.RestApiClient;
import de.tracetronic.jenkins.plugins.ecutestexecution.clients.RestApiClientFactory;
import de.tracetronic.jenkins.plugins.ecutestexecution.clients.model.TGUploadOrder;
import de.tracetronic.jenkins.plugins.ecutestexecution.model.AdditionalSetting;
import de.tracetronic.jenkins.plugins.ecutestexecution.model.UploadResult;
import de.tracetronic.jenkins.plugins.ecutestexecution.util.CredentialsUtil;
import de.tracetronic.jenkins.plugins.ecutestexecution.util.StepUtil;
import de.tracetronic.jenkins.plugins.ecutestexecution.util.ValidationUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jenkins.security.MasterToSlaveCallable;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerRequest2;

public class UploadReportsStep
extends Step
implements GroovyObject {
    private String testGuideUrl;
    private String credentialsId;
    private int projectId;
    private boolean useSettingsFromServer;
    private List<AdditionalSetting> additionalSettings;
    private List<String> reportIds;
    private boolean failOnError;
    private String tgConfiguration;
    private boolean configurationMode;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @DataBoundConstructor
    public UploadReportsStep() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Object var2_2 = null;
        this.testGuideUrl = IndyInterface.bootstrap("cast", "()", 0, var2_2);
        Object var3_3 = null;
        this.credentialsId = IndyInterface.bootstrap("cast", "()", 0, var3_3);
        int n = 1;
        this.projectId = DefaultTypeTransformation.intUnbox((Object)n);
        boolean bl = true;
        this.useSettingsFromServer = DefaultTypeTransformation.booleanUnbox((Object)bl);
        List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.additionalSettings = IndyInterface.bootstrap("cast", "()", 0, list);
        List list2 = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.reportIds = IndyInterface.bootstrap("cast", "()", 0, list2);
        boolean bl2 = true;
        this.failOnError = DefaultTypeTransformation.booleanUnbox((Object)bl2);
        String string = "";
        this.tgConfiguration = IndyInterface.bootstrap("cast", "()", 0, string);
        boolean bl3 = false;
        this.configurationMode = DefaultTypeTransformation.booleanUnbox((Object)bl3);
    }

    public UploadReportsStep(String testGuideUrl, String credentialsId) {
        this();
        String string = testGuideUrl;
        this.testGuideUrl = IndyInterface.bootstrap("cast", "()", 0, string);
        String string2 = credentialsId;
        this.credentialsId = IndyInterface.bootstrap("cast", "()", 0, string2);
    }

    public UploadReportsStep(String tgConfiguration) {
        this();
        String string = tgConfiguration;
        this.tgConfiguration = IndyInterface.bootstrap("cast", "()", 0, string);
        boolean bl = true;
        this.configurationMode = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public String getTestGuideUrl() {
        if (DefaultTypeTransformation.booleanUnbox((Object)this.testGuideUrl) && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "endsWith", 0, this.testGuideUrl, "/"))) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "substring", 0, this.testGuideUrl, false, IndyInterface.bootstrap("invoke", "minus", 0, IndyInterface.bootstrap("invoke", "length", 0, this.testGuideUrl), true)));
        }
        return this.testGuideUrl;
    }

    @DataBoundSetter
    public void setTestGuideUrl(String testGuideUrl) {
        String string = testGuideUrl;
        this.testGuideUrl = IndyInterface.bootstrap("cast", "()", 0, string);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        String string = credentialsId;
        this.credentialsId = IndyInterface.bootstrap("cast", "()", 0, string);
    }

    public int getProjectId() {
        return this.projectId;
    }

    @DataBoundSetter
    public void setProjectId(int projectId) {
        int n = projectId;
        this.projectId = DefaultTypeTransformation.intUnbox((Object)n);
    }

    public boolean getUseSettingsFromServer() {
        return this.useSettingsFromServer;
    }

    @DataBoundSetter
    public void setUseSettingsFromServer(boolean useSettingsFromServer) {
        boolean bl = useSettingsFromServer;
        this.useSettingsFromServer = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public List<AdditionalSetting> getAdditionalSettings() {
        public class _getAdditionalSettings_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _getAdditionalSettings_closure1(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                return IndyInterface.bootstrap("init", "<init>", 0, AdditionalSetting.class, it);
            }

            public Object doCall() {
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _getAdditionalSettings_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, this.additionalSettings, new _getAdditionalSettings_closure1((Object)this, (Object)this)));
    }

    @DataBoundSetter
    public void setAdditionalSettings(List<AdditionalSetting> additionalSettings) {
        Object object = IndyInterface.bootstrap("cast", "()", 0, additionalSettings) != false ? IndyInterface.bootstrap("invoke", "removeEmptySettings", 0, UploadReportsStep.class, additionalSettings) : ScriptBytecodeAdapter.createList((Object[])new Object[0]);
        this.additionalSettings = IndyInterface.bootstrap("cast", "()", 0, object);
    }

    public List<String> getReportIds() {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, this.reportIds));
    }

    @DataBoundSetter
    public void setReportIds(Object reportIds) {
        if (reportIds instanceof String) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "trimAndRemoveEmpty", 0, StepUtil.class, IndyInterface.bootstrap("invoke", "toList", 0, IndyInterface.bootstrap("invoke", "split", 0, reportIds, ",")));
            this.reportIds = IndyInterface.bootstrap("cast", "()", 0, callSite);
        } else if (reportIds instanceof List) {
            CallSite callSite = IndyInterface.bootstrap("invoke", "trimAndRemoveEmpty", 0, StepUtil.class, reportIds);
            this.reportIds = IndyInterface.bootstrap("cast", "()", 0, callSite);
        } else {
            List list = ScriptBytecodeAdapter.createList((Object[])new Object[0]);
            this.reportIds = IndyInterface.bootstrap("cast", "()", 0, list);
        }
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }

    @DataBoundSetter
    public void setFailOnError(boolean failOnError) {
        boolean bl = failOnError;
        this.failOnError = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public String getTgConfiguration() {
        return this.tgConfiguration;
    }

    @DataBoundSetter
    public void setTgConfiguration(String tgConfiguration) {
        String string = tgConfiguration;
        this.tgConfiguration = IndyInterface.bootstrap("cast", "()", 0, string);
    }

    public void setConfigurationMode(boolean configurationMode) {
        boolean bl = configurationMode;
        this.configurationMode = DefaultTypeTransformation.booleanUnbox((Object)bl);
    }

    public String getConfigurationMode() {
        return IndyInterface.bootstrap("cast", "()", 0, this.configurationMode);
    }

    public StepExecution start(StepContext context) throws Exception {
        if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isNotBlank", 0, StringUtils.class, this.tgConfiguration)) != false) {
            CallSite installation = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "get", 0, TGInstallation.class, this.tgConfiguration));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)installation, null)) {
                boolean bl;
                this.configurationMode = bl = true;
                CallSite callSite = IndyInterface.bootstrap("invoke", "getTestGuideUrl", 0, installation);
                this.testGuideUrl = IndyInterface.bootstrap("cast", "()", 0, callSite);
                CallSite callSite2 = IndyInterface.bootstrap("invoke", "getCredentialsId", 0, installation);
                this.credentialsId = IndyInterface.bootstrap("cast", "()", 0, callSite2);
                CallSite callSite3 = IndyInterface.bootstrap("invoke", "getProjectId", 0, installation);
                this.projectId = DefaultTypeTransformation.intUnbox((Object)callSite3);
                CallSite callSite4 = IndyInterface.bootstrap("invoke", "getUseSettingsFromServer", 0, installation);
                this.useSettingsFromServer = DefaultTypeTransformation.booleanUnbox((Object)callSite4);
                CallSite callSite5 = IndyInterface.bootstrap("invoke", "getAdditionalSettings", 0, installation);
                this.additionalSettings = IndyInterface.bootstrap("cast", "()", 0, callSite5);
            } else {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AbortException.class, new GStringImpl(new Object[]{this.tgConfiguration}, new String[]{"Selected test.guide installation '", "' not found."})));
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Execution.class, this, context));
    }

    private static List<AdditionalSetting> removeEmptySettings(List<AdditionalSetting> settings) {
        public class _removeEmptySettings_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _removeEmptySettings_closure2(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object setting) {
                return IndyInterface.bootstrap("invoke", "isNotBlank", 0, StringUtils.class, IndyInterface.bootstrap("getProperty", "name", 0, setting));
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _removeEmptySettings_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "findAll", 0, settings, new _removeEmptySettings_closure2(UploadReportsStep.class, UploadReportsStep.class)));
    }

    private static List<AdditionalSetting> expandSettings(List<AdditionalSetting> settings, EnvVars envVars) {
        Reference envVars2 = new Reference((Object)envVars);
        public class _expandSettings_closure3
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference envVars;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _expandSettings_closure3(Object _outerInstance, Object _thisObject, Reference envVars) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.envVars = reference = envVars;
            }

            public Object doCall(Object setting) {
                return IndyInterface.bootstrap("invoke", "expand", 0, setting, this.envVars.get());
            }

            public EnvVars getEnvVars() {
                return IndyInterface.bootstrap("cast", "()", 0, this.envVars.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _expandSettings_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collect", 0, settings, new _expandSettings_closure3(UploadReportsStep.class, UploadReportsStep.class, envVars2)));
    }

    private static Map<String, String> toSettingsMap(List<AdditionalSetting> settings) {
        public class _toSettingsMap_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _toSettingsMap_closure4(Object _outerInstance, Object _thisObject) {
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object setting) {
                return ScriptBytecodeAdapter.createList((Object[])new Object[]{IndyInterface.bootstrap("getProperty", "name", 0, setting), IndyInterface.bootstrap("getProperty", "value", 0, setting)});
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _toSettingsMap_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "collectEntries", 0, settings, new _toSettingsMap_closure4(UploadReportsStep.class, UploadReportsStep.class)));
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != UploadReportsStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(UploadReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$3(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, UploadReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$3(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(UploadReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<List<UploadResult>>
    implements GroovyObject {
        private static final long serialVersionUID = 1L;
        private final transient UploadReportsStep step;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Execution(UploadReportsStep step, StepContext context) {
            super(context);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            UploadReportsStep uploadReportsStep = step;
            this.step = IndyInterface.bootstrap("cast", "()", 0, uploadReportsStep);
        }

        protected List<UploadResult> run() throws Exception {
            CallSite expSettings = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "expandSettings", 2, this, IndyInterface.bootstrap("getProperty", "additionalSettings", 4, this.step), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "context", 12, this), EnvVars.class)));
            CallSite expSettingsMap = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "toSettingsMap", 2, this, expSettings));
            CallSite credentials = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getCredentials", 0, CredentialsUtil.class, IndyInterface.bootstrap("invoke", "getParent", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "context", 12, this), Run.class)), IndyInterface.bootstrap("getProperty", "credentialsId", 4, this.step)));
            if (ScriptBytecodeAdapter.compareEqual((Object)credentials, null)) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AbortException.class, IndyInterface.bootstrap("invoke", "plus", 0, "No credentials found for authentication key. ", "Please check the credentials configuration.")));
            }
            CallSite authKey = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getSecretString", 0, CredentialsUtil.class, credentials));
            CallSite callSite = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, IndyInterface.bootstrap("invoke", "getChannel", 0, IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("invoke", "getContext", 2, this), Launcher.class)), IndyInterface.bootstrap("init", "<init>", 0, ExecutionCallable.class, IndyInterface.bootstrap("getProperty", "testGuideUrl", 4, this.step), authKey, IndyInterface.bootstrap("getProperty", "projectId", 4, this.step), IndyInterface.bootstrap("getProperty", "useSettingsFromServer", 4, this.step), expSettingsMap, IndyInterface.bootstrap("getProperty", "reportIds", 4, this.step), IndyInterface.bootstrap("getProperty", "failOnError", 4, this.step), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "context", 12, this), EnvVars.class), IndyInterface.bootstrap("invoke", "get", 0, IndyInterface.bootstrap("getProperty", "context", 12, this), TaskListener.class))));
            try {
                return callSite;
            }
            catch (Exception e) {
                throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AbortException.class, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "message", 0, e)}, new String[]{"Upload failed: ", ""})));
            }
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Execution.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Execution.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Execution.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Execution.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Execution.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    static final class ExecutionCallable
    extends MasterToSlaveCallable<List<UploadResult>, IOException>
    implements GroovyObject {
        private static final long serialVersionUID = 1L;
        private final String testGuideUrl;
        private final String authKey;
        private final int projectId;
        private final boolean useSettingsFromServer;
        private final Map<String, String> additionalSettings;
        private List<String> reportIds;
        private boolean failOnError;
        private final EnvVars envVars;
        private final TaskListener listener;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ExecutionCallable(String testGuideUrl, String authKey, int projectId, boolean useSettingsFromServer, Map<String, String> additionalSettings, List<String> reportIds, boolean failOnError, EnvVars envVars, TaskListener listener) {
            MetaClass metaClass;
            Reference envVars2 = new Reference((Object)envVars);
            this.metaClass = metaClass = this.$getStaticMetaClass();
            CallSite callSite = IndyInterface.bootstrap("invoke", "expand", 0, (EnvVars)envVars2.get(), testGuideUrl);
            this.testGuideUrl = IndyInterface.bootstrap("cast", "()", 0, callSite);
            String string = authKey;
            this.authKey = IndyInterface.bootstrap("cast", "()", 0, string);
            int n = projectId;
            this.projectId = DefaultTypeTransformation.intUnbox((Object)n);
            boolean bl = useSettingsFromServer;
            this.useSettingsFromServer = DefaultTypeTransformation.booleanUnbox((Object)bl);
            Map<String, String> map = additionalSettings;
            this.additionalSettings = IndyInterface.bootstrap("cast", "()", 0, map);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "collect", 0, reportIds, new _closure1((Object)this, (Object)this, envVars2));
            this.reportIds = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            boolean bl2 = failOnError;
            this.failOnError = DefaultTypeTransformation.booleanUnbox((Object)bl2);
            EnvVars envVars3 = (EnvVars)envVars2.get();
            this.envVars = IndyInterface.bootstrap("cast", "()", 0, envVars3);
            TaskListener taskListener = listener;
            this.listener = IndyInterface.bootstrap("cast", "()", 0, taskListener);
        }

        public List<UploadResult> call() throws IOException {
            Reference result = new Reference((Object)ScriptBytecodeAdapter.createList((Object[])new Object[0]));
            Reference apiClient = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getRestApiClient", 0, RestApiClientFactory.class, IndyInterface.bootstrap("invoke", "get", 0, this.envVars, "ET_API_HOSTNAME"), IndyInterface.bootstrap("invoke", "get", 0, this.envVars, "ET_API_PORT"))));
            Reference uploadOrder = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TGUploadOrder.class, this.testGuideUrl, this.authKey, this.projectId, this.useSettingsFromServer, this.additionalSettings)));
            IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), new GStringImpl(new Object[]{this.testGuideUrl}, new String[]{"Uploading reports to test.guide ", "..."}));
            if (ScriptBytecodeAdapter.compareEqual(this.reportIds, null) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isEmpty", 0, this.reportIds))) {
                CallSite callSite = IndyInterface.bootstrap("invoke", "getAllReportIds", 0, (RestApiClient)apiClient.get());
                this.reportIds = IndyInterface.bootstrap("cast", "()", 0, callSite);
            }
            CallSite cntReports = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "size", 0, this.reportIds));
            Reference cntStable = new Reference((Object)0);
            public class _call_closure2
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference apiClient;
                private /* synthetic */ Reference uploadOrder;
                private /* synthetic */ Reference cntStable;
                private /* synthetic */ Reference result;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _call_closure2(Object _outerInstance, Object _thisObject, Reference apiClient, Reference uploadOrder, Reference cntStable, Reference result) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    Reference reference2;
                    Reference reference3;
                    Reference reference4;
                    this.apiClient = reference4 = apiClient;
                    this.uploadOrder = reference3 = uploadOrder;
                    this.cntStable = reference2 = cntStable;
                    this.result = reference = result;
                }

                public Object doCall(Object reportId) {
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, IndyInterface.bootstrap("getProperty", "listener", 12, this)), new GStringImpl(new Object[]{reportId}, new String[]{"- Uploading ATX report for report id ", "..."}));
                    CallSite uploadResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "uploadReport", 0, this.apiClient.get(), reportId, this.uploadOrder.get()));
                    boolean resultError = ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("invoke", "toLowerCase", 0, IndyInterface.bootstrap("getProperty", "uploadResult", 4, uploadResult)), (Object)"error");
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, IndyInterface.bootstrap("getProperty", "listener", 12, this)), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "uploadMessage", 4, uploadResult)}, new String[]{"  -> ", ""}));
                    if (!resultError) {
                        this.cntStable.set((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "plus", 0, this.cntStable.get(), true)));
                    } else if (resultError && DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "failOnError", 12, this))) {
                        IndyInterface.bootstrap("invoke", "flush", 0, IndyInterface.bootstrap("getProperty", "logger", 0, IndyInterface.bootstrap("getProperty", "listener", 12, this)));
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, AbortException.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "FAILURE", 0, Result.class))}, new String[]{"Build result set to ", " due to failed report upload. "}), "Set Pipeline step property 'Fail On Error' to 'false' to ignore failed report uploads.")));
                    }
                    return IndyInterface.bootstrap("invoke", "add", 0, this.result.get(), uploadResult);
                }

                public RestApiClient getApiClient() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.apiClient.get());
                }

                public TGUploadOrder getUploadOrder() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.uploadOrder.get());
                }

                public Integer getCntStable() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.cntStable.get());
                }

                public List getResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.result.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _call_closure2.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, this.reportIds, new _call_closure2((Object)this, (Object)this, apiClient, uploadOrder, cntStable, result));
            if (ScriptBytecodeAdapter.compareEqual((Object)cntReports, (Object)((Integer)cntStable.get()))) {
                IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), "Report upload(s) successful");
            } else {
                IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), "Report upload(s) unstable. Please see the logging of the uploads.");
            }
            return (List)result.get();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != ExecutionCallable.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExecutionCallable.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ExecutionCallable.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExecutionCallable.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ExecutionCallable.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public class _closure1
        extends Closure
        implements GeneratedClosure {
            private /* synthetic */ Reference envVars;
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;

            public _closure1(Object _outerInstance, Object _thisObject, Reference envVars) {
                super(_outerInstance, _thisObject);
                Reference reference;
                this.envVars = reference = envVars;
            }

            public Object doCall(Object id) {
                return IndyInterface.bootstrap("invoke", "expand", 0, this.envVars.get(), id);
            }

            public EnvVars getEnvVars() {
                return IndyInterface.bootstrap("cast", "()", 0, this.envVars.get());
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public DescriptorImpl() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public String getFunctionName() {
            return "ttUploadReports";
        }

        public String getDisplayName() {
            return "[TT] Upload ecu.test reports to test.guide";
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, ImmutableSet.class, Launcher.class, EnvVars.class, TaskListener.class, Run.class));
        }

        public UploadReportsStep newInstance(StaplerRequest req, JSONObject formData) throws Descriptor.FormException {
            CallSite processedFormData = IndyInterface.bootstrap("invoke", "processFormData", 0, DescriptorImpl.class, formData);
            return IndyInterface.bootstrap("cast", "()", 0, ScriptBytecodeAdapter.invokeMethodOnSuperN(StepDescriptor.class, (GroovyObject)this, (String)"newInstance", (Object[])new Object[]{req, processedFormData}));
        }

        protected static JSONObject processFormData(JSONObject formData) {
            if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "containsKey", 0, formData, "configurationMode")) == false) {
                return formData;
            }
            boolean configMode = DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "getBoolean", 0, formData, "configurationMode"));
            if (configMode) {
                IndyInterface.bootstrap("invoke", "remove", 0, formData, "testGuideUrl");
                IndyInterface.bootstrap("invoke", "remove", 0, formData, "credentialsId");
                IndyInterface.bootstrap("invoke", "remove", 0, formData, "projectId");
                IndyInterface.bootstrap("invoke", "remove", 0, formData, "useSettingsFromServer");
                IndyInterface.bootstrap("invoke", "remove", 0, formData, "additionalSettings");
            } else {
                IndyInterface.bootstrap("invoke", "put", 0, formData, "configurationMode", false);
                IndyInterface.bootstrap("invoke", "put", 0, formData, "tgConfiguration", "");
            }
            return formData;
        }

        public ListBoxModel doFillTgConfigurationItems() {
            Reference model = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, ListBoxModel.class)));
            public class _doFillTgConfigurationItems_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference model;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _doFillTgConfigurationItems_closure1(Object _outerInstance, Object _thisObject, Reference model) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.model = reference = model;
                }

                public Object doCall(Object installation) {
                    return IndyInterface.bootstrap("invoke", "add", 0, this.model.get(), IndyInterface.bootstrap("invoke", "getName", 0, installation));
                }

                public ListBoxModel getModel() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.model.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _doFillTgConfigurationItems_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, IndyInterface.bootstrap("invoke", "all", 0, TGInstallation.class), new _doFillTgConfigurationItems_closure1((Object)this, (Object)this, model));
            return (ListBoxModel)model.get();
        }

        @CapturedParameterNames(value={"value"})
        public FormValidation doCheckTestGuideUrl(@QueryParameter String value) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateServerUrl", 0, ValidationUtil.class, value));
        }

        @CapturedParameterNames(value={"item", "credentialsId"})
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "fillCredentialsIdItems", 0, CredentialsUtil.class, item, credentialsId));
        }

        @CapturedParameterNames(value={"item", "value"})
        public FormValidation doCheckCredentialsId(@AncestorInPath Item item, @QueryParameter String value) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateCredentialsId", 0, ValidationUtil.class, item, value));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != DescriptorImpl.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorImpl.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorImpl.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescriptorImpl.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescriptorImpl.class, UploadReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public /* synthetic */ Describable super$2$newInstance(StaplerRequest staplerRequest, JSONObject jSONObject) {
            return super.newInstance(staplerRequest, jSONObject);
        }

        public /* synthetic */ Describable super$2$newInstance(StaplerRequest staplerRequest) {
            return super.newInstance(staplerRequest);
        }

        public /* synthetic */ Describable super$2$newInstance(StaplerRequest2 staplerRequest2, JSONObject jSONObject) {
            return super.newInstance(staplerRequest2, jSONObject);
        }

        public /* synthetic */ String super$2$getDisplayName() {
            return super.getDisplayName();
        }

        public /* synthetic */ Step super$3$newInstance(Map map) {
            return super.newInstance(map);
        }
    }
}

