/*
 * Decompiled with CFR 0.152.
 */
package de.tracetronic.jenkins.plugins.ecutestexecution.steps;

import com.google.common.collect.ImmutableSet;
import de.tracetronic.jenkins.plugins.ecutestexecution.steps.AbstractDownloadReportStep;
import de.tracetronic.jenkins.plugins.ecutestexecution.util.ValidationUtil;
import de.tracetronic.jenkins.plugins.ecutestexecution.util.ZipUtil;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.lang.Reference;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.junit.TestResult;
import hudson.tasks.junit.TestResultAction;
import hudson.util.FormValidation;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Set;
import jenkins.security.MasterToSlaveCallable;
import org.apache.commons.lang3.StringUtils;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.vmplugin.v7.IndyInterface;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.CapturedParameterNames;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class ProvideUnitReportsStep
extends AbstractDownloadReportStep {
    public static final String DEFAULT_REPORT_GLOB = "**/junit-report.xml";
    private static final String SUPPORT_VERSION = "2024.3";
    private static final String OUT_DIR_NAME = "Unit Reports";
    private Double unstableThreshold;
    private Double failedThreshold;
    private String reportGlob;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static final /* synthetic */ BigDecimal $const$0;
    private static final /* synthetic */ BigDecimal $const$1;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @DataBoundConstructor
    public ProvideUnitReportsStep() {
        String string;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        String string2 = OUT_DIR_NAME;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string2, ProvideUnitReportsStep.class, (GroovyObject)this, (String)"outDirName");
        String string3 = SUPPORT_VERSION;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string3, ProvideUnitReportsStep.class, (GroovyObject)this, (String)"supportVersion");
        Object var4_4 = null;
        this.unstableThreshold = IndyInterface.bootstrap("cast", "()", 0, var4_4);
        Object var5_5 = null;
        this.failedThreshold = IndyInterface.bootstrap("cast", "()", 0, var5_5);
        this.reportGlob = string = DEFAULT_REPORT_GLOB;
    }

    public ProvideUnitReportsStep(Double failedThreshold, Double unstableThreshold) {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        Double d = failedThreshold;
        this.failedThreshold = IndyInterface.bootstrap("cast", "()", 0, d);
        Double d2 = unstableThreshold;
        this.unstableThreshold = IndyInterface.bootstrap("cast", "()", 0, d2);
    }

    public Double getUnstableThreshold() {
        return this.unstableThreshold;
    }

    public Double getFailedThreshold() {
        return this.failedThreshold;
    }

    public String getReportGlob() {
        String string = this.reportGlob;
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("cast", "()", 0, string) != false ? string : DEFAULT_REPORT_GLOB);
    }

    @DataBoundSetter
    public void setUnstableThreshold(Double value) {
        CallSite callSite = ScriptBytecodeAdapter.compareNotEqual((Object)value, null) ? IndyInterface.bootstrap("invoke", "max", 0, Math.class, $const$0, IndyInterface.bootstrap("invoke", "min", 0, Math.class, value, $const$1)) : null;
        this.unstableThreshold = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @DataBoundSetter
    public void setFailedThreshold(Double value) {
        CallSite callSite = ScriptBytecodeAdapter.compareNotEqual((Object)value, null) ? IndyInterface.bootstrap("invoke", "max", 0, Math.class, $const$0, IndyInterface.bootstrap("invoke", "min", 0, Math.class, value, $const$1)) : null;
        this.failedThreshold = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    @DataBoundSetter
    public void setReportGlob(String value) {
        CallSite callSite = IndyInterface.bootstrap("invoke", "trim", 0, IndyInterface.bootstrap("invoke", "defaultIfBlank", 0, StringUtils.class, value, DEFAULT_REPORT_GLOB));
        this.reportGlob = IndyInterface.bootstrap("cast", "()", 0, callSite);
    }

    public boolean isUnstable(TestResult results) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "totalCount", 0, results), (Object)0) || ScriptBytecodeAdapter.compareEqual((Object)this.unstableThreshold, null)) {
            return false;
        }
        double failed = DefaultTypeTransformation.doubleUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("getProperty", "failCount", 0, results), IndyInterface.bootstrap("getProperty", "totalCount", 0, results)), $const$1));
        return ScriptBytecodeAdapter.compareLessThan((Object)this.unstableThreshold, (Object)failed);
    }

    public boolean isFailure(TestResult results) {
        if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "totalCount", 0, results), (Object)0) || ScriptBytecodeAdapter.compareEqual((Object)this.failedThreshold, null)) {
            return false;
        }
        double failed = DefaultTypeTransformation.doubleUnbox((Object)IndyInterface.bootstrap("invoke", "multiply", 0, IndyInterface.bootstrap("invoke", "div", 0, IndyInterface.bootstrap("getProperty", "failCount", 0, results), IndyInterface.bootstrap("getProperty", "totalCount", 0, results)), $const$1));
        return ScriptBytecodeAdapter.compareLessThan((Object)this.failedThreshold, (Object)failed);
    }

    @Override
    protected ArrayList<String> processReport(File reportFile, String reportDirName, String outDirPath, TaskListener listener) {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "extractFilesByGlobPattern", 0, ZipUtil.class, reportFile, this.reportGlob, new GStringImpl(new Object[]{outDirPath, reportDirName}, new String[]{"", "/", ""})));
    }

    public StepExecution start(StepContext context) throws Exception {
        return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, Execution.class, this, context));
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ProvideUnitReportsStep.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$4(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(ProvideUnitReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$4(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)object, ProvideUnitReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public /* synthetic */ Object this$dist$get$4(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectProperty(ProvideUnitReportsStep.class, (GroovyObject)this, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
    }

    public static /* synthetic */ void __$swapInit() {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        $const$0 = bigDecimal2 = new BigDecimal("0.0");
        $const$1 = bigDecimal = new BigDecimal("100.0");
    }

    static {
        ProvideUnitReportsStep.__$swapInit();
    }

    public /* synthetic */ MetaClass super$4$$getStaticMetaClass() {
        return super.$getStaticMetaClass();
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Void>
    implements GroovyObject {
        private static final long serialVersionUID = 1L;
        private final transient ProvideUnitReportsStep step;
        private final transient Run run;
        private final transient TaskListener listener;
        private final transient Launcher launcher;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public Execution(ProvideUnitReportsStep step, StepContext context) {
            super(context);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            ProvideUnitReportsStep provideUnitReportsStep = step;
            this.step = IndyInterface.bootstrap("cast", "()", 0, provideUnitReportsStep);
            CallSite callSite = IndyInterface.bootstrap("invoke", "get", 0, context, Run.class);
            this.run = IndyInterface.bootstrap("cast", "()", 0, callSite);
            CallSite callSite2 = IndyInterface.bootstrap("invoke", "get", 0, context, TaskListener.class);
            this.listener = IndyInterface.bootstrap("cast", "()", 0, callSite2);
            CallSite callSite3 = IndyInterface.bootstrap("invoke", "get", 0, context, Launcher.class);
            this.launcher = IndyInterface.bootstrap("cast", "()", 0, callSite3);
        }

        public ArrayList<String> getUnitReportFilePaths() throws IOException {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, IndyInterface.bootstrap("invoke", "getChannel", 0, this.launcher), IndyInterface.bootstrap("init", "<init>", 0, AbstractDownloadReportStep.DownloadReportCallable.class, this.step, IndyInterface.bootstrap("getProperty", "timeout", 0, IndyInterface.bootstrap("getProperty", "publishConfig", 4, this.step)), IndyInterface.bootstrap("getProperty", "context", 12, this))));
        }

        public TestResult parseReportFiles(ArrayList<String> reportPaths) throws IOException {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "call", 0, IndyInterface.bootstrap("invoke", "getChannel", 0, this.launcher), IndyInterface.bootstrap("init", "<init>", 0, ParseReportsExecutable.class, reportPaths)));
        }

        public void addResultsToRun(TestResult result) {
            CallSite action = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getAction", 0, this.run, TestResultAction.class));
            if (ScriptBytecodeAdapter.compareNotEqual((Object)action, null)) {
                IndyInterface.bootstrap("invoke", "mergeResult", 0, action, result, this.listener);
            } else {
                CallSite callSite = IndyInterface.bootstrap("init", "<init>", 0, TestResultAction.class, this.run, result, this.listener);
                action = IndyInterface.bootstrap("cast", "()", 0, callSite);
                IndyInterface.bootstrap("invoke", "addAction", 0, this.run, action);
            }
        }

        protected Void run() throws Exception {
            try {
                CallSite reportPaths = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "getUnitReportFilePaths", 2, this));
                CallSite testResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "parseReportFiles", 2, this, reportPaths));
                IndyInterface.bootstrap("invoke", "tally", 0, testResult);
                if (ScriptBytecodeAdapter.compareEqual((Object)IndyInterface.bootstrap("getProperty", "totalCount", 0, testResult), (Object)0)) {
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), "No unit test results found.");
                    if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "allowMissing", 0, IndyInterface.bootstrap("getProperty", "publishConfig", 4, this.step))) == false) {
                        throw (Throwable)((Object)IndyInterface.bootstrap("init", "<init>", 0, Exception.class, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("invoke", "toString", 0, IndyInterface.bootstrap("getProperty", "FAILURE", 0, Result.class))}, new String[]{"Build result set to ", " due to missing test "}), "results. Adjust AllowMissing step property if this is not intended.")));
                    }
                } else {
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), IndyInterface.bootstrap("invoke", "plus", 0, IndyInterface.bootstrap("invoke", "plus", 0, new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "totalCount", 0, testResult)}, new String[]{"Found ", " test result(s) in total: "}), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "passCount", 0, testResult), IndyInterface.bootstrap("getProperty", "failCount", 0, testResult)}, new String[]{"#Passed: ", ", #Failed: ", ", "})), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "skipCount", 0, testResult)}, new String[]{"#Skipped: ", ""})));
                    IndyInterface.bootstrap("invoke", "addResultsToRun", 2, this, testResult);
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), "Successfully added test results to Jenkins.");
                }
                CallSite newResult = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "SUCCESS", 0, Result.class));
                String reason = "unknown";
                if (IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "isFailure", 0, this.step, testResult)) != false) {
                    String string;
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "FAILURE", 0, Result.class);
                    newResult = IndyInterface.bootstrap("cast", "()", 0, callSite);
                    reason = string = "percentage of failed tests is higher than the configured threshold";
                } else if (DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("invoke", "isUnstable", 0, this.step, testResult)) || DefaultTypeTransformation.booleanUnbox((Object)IndyInterface.bootstrap("getProperty", "hasWarnings", 4, this.step))) {
                    String string;
                    CallSite callSite = IndyInterface.bootstrap("getProperty", "UNSTABLE", 0, Result.class);
                    newResult = IndyInterface.bootstrap("cast", "()", 0, callSite);
                    reason = string = IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "hasWarnings", 4, this.step)) != false ? "warnings" : "percentage of failed tests is higher than the configured threshold";
                }
                if (ScriptBytecodeAdapter.compareNotEqual((Object)newResult, (Object)IndyInterface.bootstrap("getProperty", "SUCCESS", 0, Result.class))) {
                    IndyInterface.bootstrap("invoke", "setResult", 0, this.run, newResult);
                    IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), new GStringImpl(new Object[]{newResult, reason}, new String[]{"Build result set to ", " due to ", "."}));
                }
            }
            catch (Exception e) {
                IndyInterface.bootstrap("invoke", "setResult", 0, this.run, IndyInterface.bootstrap("getProperty", "FAILURE", 0, Result.class));
                IndyInterface.bootstrap("invoke", "println", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener), new GStringImpl(new Object[]{IndyInterface.bootstrap("getProperty", "outDirName", 4, this.step)}, new String[]{"Providing ", " failed!"}));
                IndyInterface.bootstrap("invoke", "error", 0, this.listener, IndyInterface.bootstrap("getProperty", "message", 0, e));
            }
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "flush", 0, IndyInterface.bootstrap("getProperty", "logger", 0, this.listener)));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != Execution.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Execution.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(Execution.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Execution.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(Execution.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    static final class ParseReportsExecutable
    extends MasterToSlaveCallable<TestResult, IOException>
    implements Serializable,
    GroovyObject {
        private static final long serialVersionUID = 1L;
        private final ArrayList<String> reports;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public ParseReportsExecutable(ArrayList<String> reportPaths) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            ArrayList<String> arrayList = reportPaths;
            this.reports = arrayList;
        }

        public TestResult call() {
            Reference testResult = new Reference((Object)IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("init", "<init>", 0, TestResult.class)));
            public class _call_closure1
            extends Closure
            implements GeneratedClosure {
                private /* synthetic */ Reference testResult;
                private static /* synthetic */ ClassInfo $staticClassInfo;
                public static transient /* synthetic */ boolean __$stMC;

                public _call_closure1(Object _outerInstance, Object _thisObject, Reference testResult) {
                    super(_outerInstance, _thisObject);
                    Reference reference;
                    this.testResult = reference = testResult;
                }

                public Object doCall(Object report) {
                    IndyInterface.bootstrap("invoke", "parse", 0, this.testResult.get(), IndyInterface.bootstrap("init", "<init>", 0, File.class, report), null);
                    return IndyInterface.bootstrap("invoke", "tally", 0, this.testResult.get());
                }

                public TestResult getTestResult() {
                    return IndyInterface.bootstrap("cast", "()", 0, this.testResult.get());
                }

                protected /* synthetic */ MetaClass $getStaticMetaClass() {
                    if (((Object)((Object)this)).getClass() != _call_closure1.class) {
                        return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                    }
                    ClassInfo classInfo = $staticClassInfo;
                    if (classInfo == null) {
                        $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                    }
                    return classInfo.getMetaClass();
                }
            }
            IndyInterface.bootstrap("invoke", "each", 0, this.reports, new _call_closure1(this, this, testResult));
            return (TestResult)testResult.get();
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != ParseReportsExecutable.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ParseReportsExecutable.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(ParseReportsExecutable.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ParseReportsExecutable.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(ParseReportsExecutable.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor
    implements GroovyObject {
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static final /* synthetic */ BigDecimal $const$0;
        private static final /* synthetic */ BigDecimal $const$1;
        private static /* synthetic */ ClassInfo $staticClassInfo$;

        public DescriptorImpl() {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
        }

        public static String getDefaultReportGlob() {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("getProperty", "DEFAULT_REPORT_GLOB", 0, ProvideUnitReportsStep.class));
        }

        public String getFunctionName() {
            return "ttProvideUnitReports";
        }

        public String getDisplayName() {
            return "[TT] Provide generated unit reports as job test results.";
        }

        @CapturedParameterNames(value={"value"})
        public FormValidation doCheckUnstableThreshold(@QueryParameter String value) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateDoubleInRange", 0, ValidationUtil.class, value, $const$0, $const$1));
        }

        @CapturedParameterNames(value={"value"})
        public FormValidation doCheckFailedThreshold(@QueryParameter String value) {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "validateDoubleInRange", 0, ValidationUtil.class, value, $const$0, $const$1));
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return IndyInterface.bootstrap("cast", "()", 0, IndyInterface.bootstrap("invoke", "of", 0, ImmutableSet.class, Launcher.class, EnvVars.class, TaskListener.class));
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != DescriptorImpl.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorImpl.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public static /* synthetic */ Object $static_methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(DescriptorImpl.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ void $static_propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setProperty((Object)object, null, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescriptorImpl.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public static /* synthetic */ Object $static_propertyMissing(String name) {
            return ScriptBytecodeAdapter.getProperty(DescriptorImpl.class, ProvideUnitReportsStep.class, (String)((Object)IndyInterface.bootstrap("cast", "()", 0, new GStringImpl(new Object[]{name}, new String[]{"", ""}))));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
            BigDecimal bigDecimal;
            BigDecimal bigDecimal2;
            $const$0 = bigDecimal2 = new BigDecimal("0.0");
            $const$1 = bigDecimal = new BigDecimal("100.0");
        }

        static {
            DescriptorImpl.__$swapInit();
        }

        public /* synthetic */ String super$2$getDisplayName() {
            return super.getDisplayName();
        }
    }
}

