/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import hudson.model.Computer;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import hudson.plugins.ec2.ssh.verifiers.HostKeyHelper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.signature.BuiltinSignatures;

public final class SSHClientHelper {
    private static final SSHClientHelper INSTANCE = new SSHClientHelper();

    private SSHClientHelper() {
    }

    public static SSHClientHelper getInstance() {
        return INSTANCE;
    }

    public SshClient setupSshClient(EC2Computer computer) {
        SshClient client = SshClient.setUpDefaultClient();
        List<BuiltinSignatures> preferred = this.getPreferredSignatures(computer);
        if (!preferred.isEmpty()) {
            LinkedHashSet<BuiltinSignatures> signatureFactoriesSet = new LinkedHashSet<BuiltinSignatures>(preferred);
            signatureFactoriesSet.addAll(client.getSignatureFactories());
            client.setSignatureFactories(new ArrayList<BuiltinSignatures>(signatureFactoriesSet));
        }
        return client;
    }

    public List<BuiltinSignatures> getPreferredSignatures(EC2Computer computer) {
        List<BuiltinSignatures> preferred;
        String trustedAlgorithm;
        try {
            HostKey trustedHostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
            if (trustedHostKey == null) {
                return List.of();
            }
            trustedAlgorithm = trustedHostKey.getAlgorithm();
        }
        catch (IOException e) {
            return List.of();
        }
        switch (trustedAlgorithm) {
            case "ssh-rsa": {
                preferred = List.of(BuiltinSignatures.rsa, BuiltinSignatures.rsaSHA256, BuiltinSignatures.rsaSHA256_cert, BuiltinSignatures.rsaSHA512, BuiltinSignatures.rsaSHA512_cert);
                break;
            }
            case "ecdsa-sha2-nistp256": {
                preferred = List.of(BuiltinSignatures.nistp256, BuiltinSignatures.nistp256_cert);
                break;
            }
            case "ecdsa-sha2-nistp384": {
                preferred = List.of(BuiltinSignatures.nistp384, BuiltinSignatures.nistp384_cert);
                break;
            }
            case "ecdsa-sha2-nistp521": {
                preferred = List.of(BuiltinSignatures.nistp521, BuiltinSignatures.nistp521_cert);
                break;
            }
            case "ssh-ed25519": {
                preferred = List.of(BuiltinSignatures.ed25519, BuiltinSignatures.ed25519_cert, BuiltinSignatures.sk_ssh_ed25519);
                break;
            }
            default: {
                return List.of();
            }
        }
        return NamedFactory.setUpBuiltinFactories((boolean)true, preferred);
    }
}

