/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import software.amazon.awssdk.services.ec2.model.InstanceType;

@Restricted(value={NoExternalUse.class})
public final class InstanceTypeCompat {
    private static final Map<String, String> AWS_SDK_JAVA_V1;

    public static InstanceType of(String instanceType) {
        String oldInstanceType;
        InstanceType foundInstanceType = InstanceType.fromValue((String)instanceType);
        if (foundInstanceType == InstanceType.UNKNOWN_TO_SDK_VERSION && (oldInstanceType = AWS_SDK_JAVA_V1.get(instanceType)) != null) {
            foundInstanceType = InstanceType.fromValue((String)oldInstanceType);
        }
        return foundInstanceType;
    }

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("A1Medium", "a1.medium");
        map.put("A1Large", "a1.large");
        map.put("A1Xlarge", "a1.xlarge");
        map.put("A12xlarge", "a1.2xlarge");
        map.put("A14xlarge", "a1.4xlarge");
        map.put("A1Metal", "a1.metal");
        map.put("C1Medium", "c1.medium");
        map.put("C1Xlarge", "c1.xlarge");
        map.put("C3Large", "c3.large");
        map.put("C3Xlarge", "c3.xlarge");
        map.put("C32xlarge", "c3.2xlarge");
        map.put("C34xlarge", "c3.4xlarge");
        map.put("C38xlarge", "c3.8xlarge");
        map.put("C4Large", "c4.large");
        map.put("C4Xlarge", "c4.xlarge");
        map.put("C42xlarge", "c4.2xlarge");
        map.put("C44xlarge", "c4.4xlarge");
        map.put("C48xlarge", "c4.8xlarge");
        map.put("C5Large", "c5.large");
        map.put("C5Xlarge", "c5.xlarge");
        map.put("C52xlarge", "c5.2xlarge");
        map.put("C54xlarge", "c5.4xlarge");
        map.put("C59xlarge", "c5.9xlarge");
        map.put("C512xlarge", "c5.12xlarge");
        map.put("C518xlarge", "c5.18xlarge");
        map.put("C524xlarge", "c5.24xlarge");
        map.put("C5Metal", "c5.metal");
        map.put("C5aLarge", "c5a.large");
        map.put("C5aXlarge", "c5a.xlarge");
        map.put("C5a2xlarge", "c5a.2xlarge");
        map.put("C5a4xlarge", "c5a.4xlarge");
        map.put("C5a8xlarge", "c5a.8xlarge");
        map.put("C5a12xlarge", "c5a.12xlarge");
        map.put("C5a16xlarge", "c5a.16xlarge");
        map.put("C5a24xlarge", "c5a.24xlarge");
        map.put("C5adLarge", "c5ad.large");
        map.put("C5adXlarge", "c5ad.xlarge");
        map.put("C5ad2xlarge", "c5ad.2xlarge");
        map.put("C5ad4xlarge", "c5ad.4xlarge");
        map.put("C5ad8xlarge", "c5ad.8xlarge");
        map.put("C5ad12xlarge", "c5ad.12xlarge");
        map.put("C5ad16xlarge", "c5ad.16xlarge");
        map.put("C5ad24xlarge", "c5ad.24xlarge");
        map.put("C5dLarge", "c5d.large");
        map.put("C5dXlarge", "c5d.xlarge");
        map.put("C5d2xlarge", "c5d.2xlarge");
        map.put("C5d4xlarge", "c5d.4xlarge");
        map.put("C5d9xlarge", "c5d.9xlarge");
        map.put("C5d12xlarge", "c5d.12xlarge");
        map.put("C5d18xlarge", "c5d.18xlarge");
        map.put("C5d24xlarge", "c5d.24xlarge");
        map.put("C5dMetal", "c5d.metal");
        map.put("C5nLarge", "c5n.large");
        map.put("C5nXlarge", "c5n.xlarge");
        map.put("C5n2xlarge", "c5n.2xlarge");
        map.put("C5n4xlarge", "c5n.4xlarge");
        map.put("C5n9xlarge", "c5n.9xlarge");
        map.put("C5n18xlarge", "c5n.18xlarge");
        map.put("C5nMetal", "c5n.metal");
        map.put("C6gMedium", "c6g.medium");
        map.put("C6gLarge", "c6g.large");
        map.put("C6gXlarge", "c6g.xlarge");
        map.put("C6g2xlarge", "c6g.2xlarge");
        map.put("C6g4xlarge", "c6g.4xlarge");
        map.put("C6g8xlarge", "c6g.8xlarge");
        map.put("C6g12xlarge", "c6g.12xlarge");
        map.put("C6g16xlarge", "c6g.16xlarge");
        map.put("C6gMetal", "c6g.metal");
        map.put("C6gdMedium", "c6gd.medium");
        map.put("C6gdLarge", "c6gd.large");
        map.put("C6gdXlarge", "c6gd.xlarge");
        map.put("C6gd2xlarge", "c6gd.2xlarge");
        map.put("C6gd4xlarge", "c6gd.4xlarge");
        map.put("C6gd8xlarge", "c6gd.8xlarge");
        map.put("C6gd12xlarge", "c6gd.12xlarge");
        map.put("C6gd16xlarge", "c6gd.16xlarge");
        map.put("C6gdMetal", "c6gd.metal");
        map.put("C6gnMedium", "c6gn.medium");
        map.put("C6gnLarge", "c6gn.large");
        map.put("C6gnXlarge", "c6gn.xlarge");
        map.put("C6gn2xlarge", "c6gn.2xlarge");
        map.put("C6gn4xlarge", "c6gn.4xlarge");
        map.put("C6gn8xlarge", "c6gn.8xlarge");
        map.put("C6gn12xlarge", "c6gn.12xlarge");
        map.put("C6gn16xlarge", "c6gn.16xlarge");
        map.put("C6iLarge", "c6i.large");
        map.put("C6iXlarge", "c6i.xlarge");
        map.put("C6i2xlarge", "c6i.2xlarge");
        map.put("C6i4xlarge", "c6i.4xlarge");
        map.put("C6i8xlarge", "c6i.8xlarge");
        map.put("C6i12xlarge", "c6i.12xlarge");
        map.put("C6i16xlarge", "c6i.16xlarge");
        map.put("C6i24xlarge", "c6i.24xlarge");
        map.put("C6i32xlarge", "c6i.32xlarge");
        map.put("C6iMetal", "c6i.metal");
        map.put("Cc14xlarge", "cc1.4xlarge");
        map.put("Cc28xlarge", "cc2.8xlarge");
        map.put("Cg14xlarge", "cg1.4xlarge");
        map.put("Cr18xlarge", "cr1.8xlarge");
        map.put("D2Xlarge", "d2.xlarge");
        map.put("D22xlarge", "d2.2xlarge");
        map.put("D24xlarge", "d2.4xlarge");
        map.put("D28xlarge", "d2.8xlarge");
        map.put("D3Xlarge", "d3.xlarge");
        map.put("D32xlarge", "d3.2xlarge");
        map.put("D34xlarge", "d3.4xlarge");
        map.put("D38xlarge", "d3.8xlarge");
        map.put("D3enXlarge", "d3en.xlarge");
        map.put("D3en2xlarge", "d3en.2xlarge");
        map.put("D3en4xlarge", "d3en.4xlarge");
        map.put("D3en6xlarge", "d3en.6xlarge");
        map.put("D3en8xlarge", "d3en.8xlarge");
        map.put("D3en12xlarge", "d3en.12xlarge");
        map.put("Dl124xlarge", "dl1.24xlarge");
        map.put("F12xlarge", "f1.2xlarge");
        map.put("F14xlarge", "f1.4xlarge");
        map.put("F116xlarge", "f1.16xlarge");
        map.put("G22xlarge", "g2.2xlarge");
        map.put("G28xlarge", "g2.8xlarge");
        map.put("G34xlarge", "g3.4xlarge");
        map.put("G38xlarge", "g3.8xlarge");
        map.put("G316xlarge", "g3.16xlarge");
        map.put("G3sXlarge", "g3s.xlarge");
        map.put("G4adXlarge", "g4ad.xlarge");
        map.put("G4ad2xlarge", "g4ad.2xlarge");
        map.put("G4ad4xlarge", "g4ad.4xlarge");
        map.put("G4ad8xlarge", "g4ad.8xlarge");
        map.put("G4ad16xlarge", "g4ad.16xlarge");
        map.put("G4dnXlarge", "g4dn.xlarge");
        map.put("G4dn2xlarge", "g4dn.2xlarge");
        map.put("G4dn4xlarge", "g4dn.4xlarge");
        map.put("G4dn8xlarge", "g4dn.8xlarge");
        map.put("G4dn12xlarge", "g4dn.12xlarge");
        map.put("G4dn16xlarge", "g4dn.16xlarge");
        map.put("G4dnMetal", "g4dn.metal");
        map.put("G5Xlarge", "g5.xlarge");
        map.put("G52xlarge", "g5.2xlarge");
        map.put("G54xlarge", "g5.4xlarge");
        map.put("G58xlarge", "g5.8xlarge");
        map.put("G512xlarge", "g5.12xlarge");
        map.put("G516xlarge", "g5.16xlarge");
        map.put("G524xlarge", "g5.24xlarge");
        map.put("G548xlarge", "g5.48xlarge");
        map.put("G5gXlarge", "g5g.xlarge");
        map.put("G5g2xlarge", "g5g.2xlarge");
        map.put("G5g4xlarge", "g5g.4xlarge");
        map.put("G5g8xlarge", "g5g.8xlarge");
        map.put("G5g16xlarge", "g5g.16xlarge");
        map.put("G5gMetal", "g5g.metal");
        map.put("Hi14xlarge", "hi1.4xlarge");
        map.put("Hpc6a48xlarge", "hpc6a.48xlarge");
        map.put("Hs18xlarge", "hs1.8xlarge");
        map.put("H12xlarge", "h1.2xlarge");
        map.put("H14xlarge", "h1.4xlarge");
        map.put("H18xlarge", "h1.8xlarge");
        map.put("H116xlarge", "h1.16xlarge");
        map.put("I2Xlarge", "i2.xlarge");
        map.put("I22xlarge", "i2.2xlarge");
        map.put("I24xlarge", "i2.4xlarge");
        map.put("I28xlarge", "i2.8xlarge");
        map.put("I3Large", "i3.large");
        map.put("I3Xlarge", "i3.xlarge");
        map.put("I32xlarge", "i3.2xlarge");
        map.put("I34xlarge", "i3.4xlarge");
        map.put("I38xlarge", "i3.8xlarge");
        map.put("I316xlarge", "i3.16xlarge");
        map.put("I3Metal", "i3.metal");
        map.put("I3enLarge", "i3en.large");
        map.put("I3enXlarge", "i3en.xlarge");
        map.put("I3en2xlarge", "i3en.2xlarge");
        map.put("I3en3xlarge", "i3en.3xlarge");
        map.put("I3en6xlarge", "i3en.6xlarge");
        map.put("I3en12xlarge", "i3en.12xlarge");
        map.put("I3en24xlarge", "i3en.24xlarge");
        map.put("I3enMetal", "i3en.metal");
        map.put("Im4gnLarge", "im4gn.large");
        map.put("Im4gnXlarge", "im4gn.xlarge");
        map.put("Im4gn2xlarge", "im4gn.2xlarge");
        map.put("Im4gn4xlarge", "im4gn.4xlarge");
        map.put("Im4gn8xlarge", "im4gn.8xlarge");
        map.put("Im4gn16xlarge", "im4gn.16xlarge");
        map.put("Inf1Xlarge", "inf1.xlarge");
        map.put("Inf12xlarge", "inf1.2xlarge");
        map.put("Inf16xlarge", "inf1.6xlarge");
        map.put("Inf124xlarge", "inf1.24xlarge");
        map.put("Is4genMedium", "is4gen.medium");
        map.put("Is4genLarge", "is4gen.large");
        map.put("Is4genXlarge", "is4gen.xlarge");
        map.put("Is4gen2xlarge", "is4gen.2xlarge");
        map.put("Is4gen4xlarge", "is4gen.4xlarge");
        map.put("Is4gen8xlarge", "is4gen.8xlarge");
        map.put("M1Small", "m1.small");
        map.put("M1Medium", "m1.medium");
        map.put("M1Large", "m1.large");
        map.put("M1Xlarge", "m1.xlarge");
        map.put("M2Xlarge", "m2.xlarge");
        map.put("M22xlarge", "m2.2xlarge");
        map.put("M24xlarge", "m2.4xlarge");
        map.put("M3Medium", "m3.medium");
        map.put("M3Large", "m3.large");
        map.put("M3Xlarge", "m3.xlarge");
        map.put("M32xlarge", "m3.2xlarge");
        map.put("M4Large", "m4.large");
        map.put("M4Xlarge", "m4.xlarge");
        map.put("M42xlarge", "m4.2xlarge");
        map.put("M44xlarge", "m4.4xlarge");
        map.put("M410xlarge", "m4.10xlarge");
        map.put("M416xlarge", "m4.16xlarge");
        map.put("M5Large", "m5.large");
        map.put("M5Xlarge", "m5.xlarge");
        map.put("M52xlarge", "m5.2xlarge");
        map.put("M54xlarge", "m5.4xlarge");
        map.put("M58xlarge", "m5.8xlarge");
        map.put("M512xlarge", "m5.12xlarge");
        map.put("M516xlarge", "m5.16xlarge");
        map.put("M524xlarge", "m5.24xlarge");
        map.put("M5Metal", "m5.metal");
        map.put("M5aLarge", "m5a.large");
        map.put("M5aXlarge", "m5a.xlarge");
        map.put("M5a2xlarge", "m5a.2xlarge");
        map.put("M5a4xlarge", "m5a.4xlarge");
        map.put("M5a8xlarge", "m5a.8xlarge");
        map.put("M5a12xlarge", "m5a.12xlarge");
        map.put("M5a16xlarge", "m5a.16xlarge");
        map.put("M5a24xlarge", "m5a.24xlarge");
        map.put("M5adLarge", "m5ad.large");
        map.put("M5adXlarge", "m5ad.xlarge");
        map.put("M5ad2xlarge", "m5ad.2xlarge");
        map.put("M5ad4xlarge", "m5ad.4xlarge");
        map.put("M5ad8xlarge", "m5ad.8xlarge");
        map.put("M5ad12xlarge", "m5ad.12xlarge");
        map.put("M5ad16xlarge", "m5ad.16xlarge");
        map.put("M5ad24xlarge", "m5ad.24xlarge");
        map.put("M5dLarge", "m5d.large");
        map.put("M5dXlarge", "m5d.xlarge");
        map.put("M5d2xlarge", "m5d.2xlarge");
        map.put("M5d4xlarge", "m5d.4xlarge");
        map.put("M5d8xlarge", "m5d.8xlarge");
        map.put("M5d12xlarge", "m5d.12xlarge");
        map.put("M5d16xlarge", "m5d.16xlarge");
        map.put("M5d24xlarge", "m5d.24xlarge");
        map.put("M5dMetal", "m5d.metal");
        map.put("M5dnLarge", "m5dn.large");
        map.put("M5dnXlarge", "m5dn.xlarge");
        map.put("M5dn2xlarge", "m5dn.2xlarge");
        map.put("M5dn4xlarge", "m5dn.4xlarge");
        map.put("M5dn8xlarge", "m5dn.8xlarge");
        map.put("M5dn12xlarge", "m5dn.12xlarge");
        map.put("M5dn16xlarge", "m5dn.16xlarge");
        map.put("M5dn24xlarge", "m5dn.24xlarge");
        map.put("M5dnMetal", "m5dn.metal");
        map.put("M5nLarge", "m5n.large");
        map.put("M5nXlarge", "m5n.xlarge");
        map.put("M5n2xlarge", "m5n.2xlarge");
        map.put("M5n4xlarge", "m5n.4xlarge");
        map.put("M5n8xlarge", "m5n.8xlarge");
        map.put("M5n12xlarge", "m5n.12xlarge");
        map.put("M5n16xlarge", "m5n.16xlarge");
        map.put("M5n24xlarge", "m5n.24xlarge");
        map.put("M5nMetal", "m5n.metal");
        map.put("M5znLarge", "m5zn.large");
        map.put("M5znXlarge", "m5zn.xlarge");
        map.put("M5zn2xlarge", "m5zn.2xlarge");
        map.put("M5zn3xlarge", "m5zn.3xlarge");
        map.put("M5zn6xlarge", "m5zn.6xlarge");
        map.put("M5zn12xlarge", "m5zn.12xlarge");
        map.put("M5znMetal", "m5zn.metal");
        map.put("M6aLarge", "m6a.large");
        map.put("M6aXlarge", "m6a.xlarge");
        map.put("M6a2xlarge", "m6a.2xlarge");
        map.put("M6a4xlarge", "m6a.4xlarge");
        map.put("M6a8xlarge", "m6a.8xlarge");
        map.put("M6a12xlarge", "m6a.12xlarge");
        map.put("M6a16xlarge", "m6a.16xlarge");
        map.put("M6a24xlarge", "m6a.24xlarge");
        map.put("M6a32xlarge", "m6a.32xlarge");
        map.put("M6a48xlarge", "m6a.48xlarge");
        map.put("M6gMetal", "m6g.metal");
        map.put("M6gMedium", "m6g.medium");
        map.put("M6gLarge", "m6g.large");
        map.put("M6gXlarge", "m6g.xlarge");
        map.put("M6g2xlarge", "m6g.2xlarge");
        map.put("M6g4xlarge", "m6g.4xlarge");
        map.put("M6g8xlarge", "m6g.8xlarge");
        map.put("M6g12xlarge", "m6g.12xlarge");
        map.put("M6g16xlarge", "m6g.16xlarge");
        map.put("M6gdMetal", "m6gd.metal");
        map.put("M6gdMedium", "m6gd.medium");
        map.put("M6gdLarge", "m6gd.large");
        map.put("M6gdXlarge", "m6gd.xlarge");
        map.put("M6gd2xlarge", "m6gd.2xlarge");
        map.put("M6gd4xlarge", "m6gd.4xlarge");
        map.put("M6gd8xlarge", "m6gd.8xlarge");
        map.put("M6gd12xlarge", "m6gd.12xlarge");
        map.put("M6gd16xlarge", "m6gd.16xlarge");
        map.put("M6iLarge", "m6i.large");
        map.put("M6iXlarge", "m6i.xlarge");
        map.put("M6i2xlarge", "m6i.2xlarge");
        map.put("M6i4xlarge", "m6i.4xlarge");
        map.put("M6i8xlarge", "m6i.8xlarge");
        map.put("M6i12xlarge", "m6i.12xlarge");
        map.put("M6i16xlarge", "m6i.16xlarge");
        map.put("M6i24xlarge", "m6i.24xlarge");
        map.put("M6i32xlarge", "m6i.32xlarge");
        map.put("M6iMetal", "m6i.metal");
        map.put("Mac1Metal", "mac1.metal");
        map.put("P2Xlarge", "p2.xlarge");
        map.put("P28xlarge", "p2.8xlarge");
        map.put("P216xlarge", "p2.16xlarge");
        map.put("P32xlarge", "p3.2xlarge");
        map.put("P38xlarge", "p3.8xlarge");
        map.put("P316xlarge", "p3.16xlarge");
        map.put("P3dn24xlarge", "p3dn.24xlarge");
        map.put("P4d24xlarge", "p4d.24xlarge");
        map.put("R3Large", "r3.large");
        map.put("R3Xlarge", "r3.xlarge");
        map.put("R32xlarge", "r3.2xlarge");
        map.put("R34xlarge", "r3.4xlarge");
        map.put("R38xlarge", "r3.8xlarge");
        map.put("R4Large", "r4.large");
        map.put("R4Xlarge", "r4.xlarge");
        map.put("R42xlarge", "r4.2xlarge");
        map.put("R44xlarge", "r4.4xlarge");
        map.put("R48xlarge", "r4.8xlarge");
        map.put("R416xlarge", "r4.16xlarge");
        map.put("R5Large", "r5.large");
        map.put("R5Xlarge", "r5.xlarge");
        map.put("R52xlarge", "r5.2xlarge");
        map.put("R54xlarge", "r5.4xlarge");
        map.put("R58xlarge", "r5.8xlarge");
        map.put("R512xlarge", "r5.12xlarge");
        map.put("R516xlarge", "r5.16xlarge");
        map.put("R524xlarge", "r5.24xlarge");
        map.put("R5Metal", "r5.metal");
        map.put("R5aLarge", "r5a.large");
        map.put("R5aXlarge", "r5a.xlarge");
        map.put("R5a2xlarge", "r5a.2xlarge");
        map.put("R5a4xlarge", "r5a.4xlarge");
        map.put("R5a8xlarge", "r5a.8xlarge");
        map.put("R5a12xlarge", "r5a.12xlarge");
        map.put("R5a16xlarge", "r5a.16xlarge");
        map.put("R5a24xlarge", "r5a.24xlarge");
        map.put("R5adLarge", "r5ad.large");
        map.put("R5adXlarge", "r5ad.xlarge");
        map.put("R5ad2xlarge", "r5ad.2xlarge");
        map.put("R5ad4xlarge", "r5ad.4xlarge");
        map.put("R5ad8xlarge", "r5ad.8xlarge");
        map.put("R5ad12xlarge", "r5ad.12xlarge");
        map.put("R5ad16xlarge", "r5ad.16xlarge");
        map.put("R5ad24xlarge", "r5ad.24xlarge");
        map.put("R5bLarge", "r5b.large");
        map.put("R5bXlarge", "r5b.xlarge");
        map.put("R5b2xlarge", "r5b.2xlarge");
        map.put("R5b4xlarge", "r5b.4xlarge");
        map.put("R5b8xlarge", "r5b.8xlarge");
        map.put("R5b12xlarge", "r5b.12xlarge");
        map.put("R5b16xlarge", "r5b.16xlarge");
        map.put("R5b24xlarge", "r5b.24xlarge");
        map.put("R5bMetal", "r5b.metal");
        map.put("R5dLarge", "r5d.large");
        map.put("R5dXlarge", "r5d.xlarge");
        map.put("R5d2xlarge", "r5d.2xlarge");
        map.put("R5d4xlarge", "r5d.4xlarge");
        map.put("R5d8xlarge", "r5d.8xlarge");
        map.put("R5d12xlarge", "r5d.12xlarge");
        map.put("R5d16xlarge", "r5d.16xlarge");
        map.put("R5d24xlarge", "r5d.24xlarge");
        map.put("R5dMetal", "r5d.metal");
        map.put("R5dnLarge", "r5dn.large");
        map.put("R5dnXlarge", "r5dn.xlarge");
        map.put("R5dn2xlarge", "r5dn.2xlarge");
        map.put("R5dn4xlarge", "r5dn.4xlarge");
        map.put("R5dn8xlarge", "r5dn.8xlarge");
        map.put("R5dn12xlarge", "r5dn.12xlarge");
        map.put("R5dn16xlarge", "r5dn.16xlarge");
        map.put("R5dn24xlarge", "r5dn.24xlarge");
        map.put("R5dnMetal", "r5dn.metal");
        map.put("R5nLarge", "r5n.large");
        map.put("R5nXlarge", "r5n.xlarge");
        map.put("R5n2xlarge", "r5n.2xlarge");
        map.put("R5n4xlarge", "r5n.4xlarge");
        map.put("R5n8xlarge", "r5n.8xlarge");
        map.put("R5n12xlarge", "r5n.12xlarge");
        map.put("R5n16xlarge", "r5n.16xlarge");
        map.put("R5n24xlarge", "r5n.24xlarge");
        map.put("R5nMetal", "r5n.metal");
        map.put("R6gMedium", "r6g.medium");
        map.put("R6gLarge", "r6g.large");
        map.put("R6gXlarge", "r6g.xlarge");
        map.put("R6g2xlarge", "r6g.2xlarge");
        map.put("R6g4xlarge", "r6g.4xlarge");
        map.put("R6g8xlarge", "r6g.8xlarge");
        map.put("R6g12xlarge", "r6g.12xlarge");
        map.put("R6g16xlarge", "r6g.16xlarge");
        map.put("R6gMetal", "r6g.metal");
        map.put("R6gdMedium", "r6gd.medium");
        map.put("R6gdLarge", "r6gd.large");
        map.put("R6gdXlarge", "r6gd.xlarge");
        map.put("R6gd2xlarge", "r6gd.2xlarge");
        map.put("R6gd4xlarge", "r6gd.4xlarge");
        map.put("R6gd8xlarge", "r6gd.8xlarge");
        map.put("R6gd12xlarge", "r6gd.12xlarge");
        map.put("R6gd16xlarge", "r6gd.16xlarge");
        map.put("R6gdMetal", "r6gd.metal");
        map.put("R6iLarge", "r6i.large");
        map.put("R6iXlarge", "r6i.xlarge");
        map.put("R6i2xlarge", "r6i.2xlarge");
        map.put("R6i4xlarge", "r6i.4xlarge");
        map.put("R6i8xlarge", "r6i.8xlarge");
        map.put("R6i12xlarge", "r6i.12xlarge");
        map.put("R6i16xlarge", "r6i.16xlarge");
        map.put("R6i24xlarge", "r6i.24xlarge");
        map.put("R6i32xlarge", "r6i.32xlarge");
        map.put("R6iMetal", "r6i.metal");
        map.put("T1Micro", "t1.micro");
        map.put("T2Nano", "t2.nano");
        map.put("T2Micro", "t2.micro");
        map.put("T2Small", "t2.small");
        map.put("T2Medium", "t2.medium");
        map.put("T2Large", "t2.large");
        map.put("T2Xlarge", "t2.xlarge");
        map.put("T22xlarge", "t2.2xlarge");
        map.put("T3Nano", "t3.nano");
        map.put("T3Micro", "t3.micro");
        map.put("T3Small", "t3.small");
        map.put("T3Medium", "t3.medium");
        map.put("T3Large", "t3.large");
        map.put("T3Xlarge", "t3.xlarge");
        map.put("T32xlarge", "t3.2xlarge");
        map.put("T3aNano", "t3a.nano");
        map.put("T3aMicro", "t3a.micro");
        map.put("T3aSmall", "t3a.small");
        map.put("T3aMedium", "t3a.medium");
        map.put("T3aLarge", "t3a.large");
        map.put("T3aXlarge", "t3a.xlarge");
        map.put("T3a2xlarge", "t3a.2xlarge");
        map.put("T4gNano", "t4g.nano");
        map.put("T4gMicro", "t4g.micro");
        map.put("T4gSmall", "t4g.small");
        map.put("T4gMedium", "t4g.medium");
        map.put("T4gLarge", "t4g.large");
        map.put("T4gXlarge", "t4g.xlarge");
        map.put("T4g2xlarge", "t4g.2xlarge");
        map.put("U6tb156xlarge", "u-6tb1.56xlarge");
        map.put("U6tb1112xlarge", "u-6tb1.112xlarge");
        map.put("U9tb1112xlarge", "u-9tb1.112xlarge");
        map.put("U12tb1112xlarge", "u-12tb1.112xlarge");
        map.put("U6tb1Metal", "u-6tb1.metal");
        map.put("U9tb1Metal", "u-9tb1.metal");
        map.put("U12tb1Metal", "u-12tb1.metal");
        map.put("U18tb1Metal", "u-18tb1.metal");
        map.put("U24tb1Metal", "u-24tb1.metal");
        map.put("Vt13xlarge", "vt1.3xlarge");
        map.put("Vt16xlarge", "vt1.6xlarge");
        map.put("Vt124xlarge", "vt1.24xlarge");
        map.put("X116xlarge", "x1.16xlarge");
        map.put("X132xlarge", "x1.32xlarge");
        map.put("X1eXlarge", "x1e.xlarge");
        map.put("X1e2xlarge", "x1e.2xlarge");
        map.put("X1e4xlarge", "x1e.4xlarge");
        map.put("X1e8xlarge", "x1e.8xlarge");
        map.put("X1e16xlarge", "x1e.16xlarge");
        map.put("X1e32xlarge", "x1e.32xlarge");
        map.put("X2iezn2xlarge", "x2iezn.2xlarge");
        map.put("X2iezn4xlarge", "x2iezn.4xlarge");
        map.put("X2iezn6xlarge", "x2iezn.6xlarge");
        map.put("X2iezn8xlarge", "x2iezn.8xlarge");
        map.put("X2iezn12xlarge", "x2iezn.12xlarge");
        map.put("X2ieznMetal", "x2iezn.metal");
        map.put("X2gdMedium", "x2gd.medium");
        map.put("X2gdLarge", "x2gd.large");
        map.put("X2gdXlarge", "x2gd.xlarge");
        map.put("X2gd2xlarge", "x2gd.2xlarge");
        map.put("X2gd4xlarge", "x2gd.4xlarge");
        map.put("X2gd8xlarge", "x2gd.8xlarge");
        map.put("X2gd12xlarge", "x2gd.12xlarge");
        map.put("X2gd16xlarge", "x2gd.16xlarge");
        map.put("X2gdMetal", "x2gd.metal");
        map.put("Z1dLarge", "z1d.large");
        map.put("Z1dXlarge", "z1d.xlarge");
        map.put("Z1d2xlarge", "z1d.2xlarge");
        map.put("Z1d3xlarge", "z1d.3xlarge");
        map.put("Z1d6xlarge", "z1d.6xlarge");
        map.put("Z1d12xlarge", "z1d.12xlarge");
        map.put("Z1dMetal", "z1d.metal");
        map.put("X2idn16xlarge", "x2idn.16xlarge");
        map.put("X2idn24xlarge", "x2idn.24xlarge");
        map.put("X2idn32xlarge", "x2idn.32xlarge");
        map.put("X2iednXlarge", "x2iedn.xlarge");
        map.put("X2iedn2xlarge", "x2iedn.2xlarge");
        map.put("X2iedn4xlarge", "x2iedn.4xlarge");
        map.put("X2iedn8xlarge", "x2iedn.8xlarge");
        map.put("X2iedn16xlarge", "x2iedn.16xlarge");
        map.put("X2iedn24xlarge", "x2iedn.24xlarge");
        map.put("X2iedn32xlarge", "x2iedn.32xlarge");
        map.put("C6aLarge", "c6a.large");
        map.put("C6aXlarge", "c6a.xlarge");
        map.put("C6a2xlarge", "c6a.2xlarge");
        map.put("C6a4xlarge", "c6a.4xlarge");
        map.put("C6a8xlarge", "c6a.8xlarge");
        map.put("C6a12xlarge", "c6a.12xlarge");
        map.put("C6a16xlarge", "c6a.16xlarge");
        map.put("C6a24xlarge", "c6a.24xlarge");
        map.put("C6a32xlarge", "c6a.32xlarge");
        map.put("C6a48xlarge", "c6a.48xlarge");
        map.put("C6aMetal", "c6a.metal");
        map.put("M6aMetal", "m6a.metal");
        map.put("I4iLarge", "i4i.large");
        map.put("I4iXlarge", "i4i.xlarge");
        map.put("I4i2xlarge", "i4i.2xlarge");
        map.put("I4i4xlarge", "i4i.4xlarge");
        map.put("I4i8xlarge", "i4i.8xlarge");
        map.put("I4i16xlarge", "i4i.16xlarge");
        map.put("I4i32xlarge", "i4i.32xlarge");
        map.put("I4iMetal", "i4i.metal");
        map.put("X2idnMetal", "x2idn.metal");
        map.put("X2iednMetal", "x2iedn.metal");
        map.put("C7gMedium", "c7g.medium");
        map.put("C7gLarge", "c7g.large");
        map.put("C7gXlarge", "c7g.xlarge");
        map.put("C7g2xlarge", "c7g.2xlarge");
        map.put("C7g4xlarge", "c7g.4xlarge");
        map.put("C7g8xlarge", "c7g.8xlarge");
        map.put("C7g12xlarge", "c7g.12xlarge");
        map.put("C7g16xlarge", "c7g.16xlarge");
        map.put("Mac2Metal", "mac2.metal");
        map.put("C6idLarge", "c6id.large");
        map.put("C6idXlarge", "c6id.xlarge");
        map.put("C6id2xlarge", "c6id.2xlarge");
        map.put("C6id4xlarge", "c6id.4xlarge");
        map.put("C6id8xlarge", "c6id.8xlarge");
        map.put("C6id12xlarge", "c6id.12xlarge");
        map.put("C6id16xlarge", "c6id.16xlarge");
        map.put("C6id24xlarge", "c6id.24xlarge");
        map.put("C6id32xlarge", "c6id.32xlarge");
        map.put("C6idMetal", "c6id.metal");
        map.put("M6idLarge", "m6id.large");
        map.put("M6idXlarge", "m6id.xlarge");
        map.put("M6id2xlarge", "m6id.2xlarge");
        map.put("M6id4xlarge", "m6id.4xlarge");
        map.put("M6id8xlarge", "m6id.8xlarge");
        map.put("M6id12xlarge", "m6id.12xlarge");
        map.put("M6id16xlarge", "m6id.16xlarge");
        map.put("M6id24xlarge", "m6id.24xlarge");
        map.put("M6id32xlarge", "m6id.32xlarge");
        map.put("M6idMetal", "m6id.metal");
        map.put("R6idLarge", "r6id.large");
        map.put("R6idXlarge", "r6id.xlarge");
        map.put("R6id2xlarge", "r6id.2xlarge");
        map.put("R6id4xlarge", "r6id.4xlarge");
        map.put("R6id8xlarge", "r6id.8xlarge");
        map.put("R6id12xlarge", "r6id.12xlarge");
        map.put("R6id16xlarge", "r6id.16xlarge");
        map.put("R6id24xlarge", "r6id.24xlarge");
        map.put("R6id32xlarge", "r6id.32xlarge");
        map.put("R6idMetal", "r6id.metal");
        map.put("R6aLarge", "r6a.large");
        map.put("R6aXlarge", "r6a.xlarge");
        map.put("R6a2xlarge", "r6a.2xlarge");
        map.put("R6a4xlarge", "r6a.4xlarge");
        map.put("R6a8xlarge", "r6a.8xlarge");
        map.put("R6a12xlarge", "r6a.12xlarge");
        map.put("R6a16xlarge", "r6a.16xlarge");
        map.put("R6a24xlarge", "r6a.24xlarge");
        map.put("R6a32xlarge", "r6a.32xlarge");
        map.put("R6a48xlarge", "r6a.48xlarge");
        map.put("R6aMetal", "r6a.metal");
        map.put("P4de24xlarge", "p4de.24xlarge");
        map.put("U3tb156xlarge", "u-3tb1.56xlarge");
        map.put("U18tb1112xlarge", "u-18tb1.112xlarge");
        map.put("U24tb1112xlarge", "u-24tb1.112xlarge");
        map.put("Trn12xlarge", "trn1.2xlarge");
        map.put("Trn132xlarge", "trn1.32xlarge");
        map.put("Hpc6id32xlarge", "hpc6id.32xlarge");
        map.put("C6inLarge", "c6in.large");
        map.put("C6inXlarge", "c6in.xlarge");
        map.put("C6in2xlarge", "c6in.2xlarge");
        map.put("C6in4xlarge", "c6in.4xlarge");
        map.put("C6in8xlarge", "c6in.8xlarge");
        map.put("C6in12xlarge", "c6in.12xlarge");
        map.put("C6in16xlarge", "c6in.16xlarge");
        map.put("C6in24xlarge", "c6in.24xlarge");
        map.put("C6in32xlarge", "c6in.32xlarge");
        map.put("M6inLarge", "m6in.large");
        map.put("M6inXlarge", "m6in.xlarge");
        map.put("M6in2xlarge", "m6in.2xlarge");
        map.put("M6in4xlarge", "m6in.4xlarge");
        map.put("M6in8xlarge", "m6in.8xlarge");
        map.put("M6in12xlarge", "m6in.12xlarge");
        map.put("M6in16xlarge", "m6in.16xlarge");
        map.put("M6in24xlarge", "m6in.24xlarge");
        map.put("M6in32xlarge", "m6in.32xlarge");
        map.put("M6idnLarge", "m6idn.large");
        map.put("M6idnXlarge", "m6idn.xlarge");
        map.put("M6idn2xlarge", "m6idn.2xlarge");
        map.put("M6idn4xlarge", "m6idn.4xlarge");
        map.put("M6idn8xlarge", "m6idn.8xlarge");
        map.put("M6idn12xlarge", "m6idn.12xlarge");
        map.put("M6idn16xlarge", "m6idn.16xlarge");
        map.put("M6idn24xlarge", "m6idn.24xlarge");
        map.put("M6idn32xlarge", "m6idn.32xlarge");
        map.put("R6inLarge", "r6in.large");
        map.put("R6inXlarge", "r6in.xlarge");
        map.put("R6in2xlarge", "r6in.2xlarge");
        map.put("R6in4xlarge", "r6in.4xlarge");
        map.put("R6in8xlarge", "r6in.8xlarge");
        map.put("R6in12xlarge", "r6in.12xlarge");
        map.put("R6in16xlarge", "r6in.16xlarge");
        map.put("R6in24xlarge", "r6in.24xlarge");
        map.put("R6in32xlarge", "r6in.32xlarge");
        map.put("R6idnLarge", "r6idn.large");
        map.put("R6idnXlarge", "r6idn.xlarge");
        map.put("R6idn2xlarge", "r6idn.2xlarge");
        map.put("R6idn4xlarge", "r6idn.4xlarge");
        map.put("R6idn8xlarge", "r6idn.8xlarge");
        map.put("R6idn12xlarge", "r6idn.12xlarge");
        map.put("R6idn16xlarge", "r6idn.16xlarge");
        map.put("R6idn24xlarge", "r6idn.24xlarge");
        map.put("R6idn32xlarge", "r6idn.32xlarge");
        map.put("C7gMetal", "c7g.metal");
        map.put("M7gMedium", "m7g.medium");
        map.put("M7gLarge", "m7g.large");
        map.put("M7gXlarge", "m7g.xlarge");
        map.put("M7g2xlarge", "m7g.2xlarge");
        map.put("M7g4xlarge", "m7g.4xlarge");
        map.put("M7g8xlarge", "m7g.8xlarge");
        map.put("M7g12xlarge", "m7g.12xlarge");
        map.put("M7g16xlarge", "m7g.16xlarge");
        map.put("M7gMetal", "m7g.metal");
        map.put("R7gMedium", "r7g.medium");
        map.put("R7gLarge", "r7g.large");
        map.put("R7gXlarge", "r7g.xlarge");
        map.put("R7g2xlarge", "r7g.2xlarge");
        map.put("R7g4xlarge", "r7g.4xlarge");
        map.put("R7g8xlarge", "r7g.8xlarge");
        map.put("R7g12xlarge", "r7g.12xlarge");
        map.put("R7g16xlarge", "r7g.16xlarge");
        map.put("R7gMetal", "r7g.metal");
        map.put("C6inMetal", "c6in.metal");
        map.put("M6inMetal", "m6in.metal");
        map.put("M6idnMetal", "m6idn.metal");
        map.put("R6inMetal", "r6in.metal");
        map.put("R6idnMetal", "r6idn.metal");
        map.put("Inf2Xlarge", "inf2.xlarge");
        map.put("Inf28xlarge", "inf2.8xlarge");
        map.put("Inf224xlarge", "inf2.24xlarge");
        map.put("Inf248xlarge", "inf2.48xlarge");
        map.put("Trn1n32xlarge", "trn1n.32xlarge");
        map.put("I4gLarge", "i4g.large");
        map.put("I4gXlarge", "i4g.xlarge");
        map.put("I4g2xlarge", "i4g.2xlarge");
        map.put("I4g4xlarge", "i4g.4xlarge");
        map.put("I4g8xlarge", "i4g.8xlarge");
        map.put("I4g16xlarge", "i4g.16xlarge");
        map.put("Hpc7g4xlarge", "hpc7g.4xlarge");
        map.put("Hpc7g8xlarge", "hpc7g.8xlarge");
        map.put("Hpc7g16xlarge", "hpc7g.16xlarge");
        map.put("C7gnMedium", "c7gn.medium");
        map.put("C7gnLarge", "c7gn.large");
        map.put("C7gnXlarge", "c7gn.xlarge");
        map.put("C7gn2xlarge", "c7gn.2xlarge");
        map.put("C7gn4xlarge", "c7gn.4xlarge");
        map.put("C7gn8xlarge", "c7gn.8xlarge");
        map.put("C7gn12xlarge", "c7gn.12xlarge");
        map.put("C7gn16xlarge", "c7gn.16xlarge");
        map.put("P548xlarge", "p5.48xlarge");
        map.put("M7iLarge", "m7i.large");
        map.put("M7iXlarge", "m7i.xlarge");
        map.put("M7i2xlarge", "m7i.2xlarge");
        map.put("M7i4xlarge", "m7i.4xlarge");
        map.put("M7i8xlarge", "m7i.8xlarge");
        map.put("M7i12xlarge", "m7i.12xlarge");
        map.put("M7i16xlarge", "m7i.16xlarge");
        map.put("M7i24xlarge", "m7i.24xlarge");
        map.put("M7i48xlarge", "m7i.48xlarge");
        map.put("M7iFlexLarge", "m7i-flex.large");
        map.put("M7iFlexXlarge", "m7i-flex.xlarge");
        map.put("M7iFlex2xlarge", "m7i-flex.2xlarge");
        map.put("M7iFlex4xlarge", "m7i-flex.4xlarge");
        map.put("M7iFlex8xlarge", "m7i-flex.8xlarge");
        map.put("M7aMedium", "m7a.medium");
        map.put("M7aLarge", "m7a.large");
        map.put("M7aXlarge", "m7a.xlarge");
        map.put("M7a2xlarge", "m7a.2xlarge");
        map.put("M7a4xlarge", "m7a.4xlarge");
        map.put("M7a8xlarge", "m7a.8xlarge");
        map.put("M7a12xlarge", "m7a.12xlarge");
        map.put("M7a16xlarge", "m7a.16xlarge");
        map.put("M7a24xlarge", "m7a.24xlarge");
        map.put("M7a32xlarge", "m7a.32xlarge");
        map.put("M7a48xlarge", "m7a.48xlarge");
        map.put("M7aMetal48xl", "m7a.metal-48xl");
        map.put("Hpc7a12xlarge", "hpc7a.12xlarge");
        map.put("Hpc7a24xlarge", "hpc7a.24xlarge");
        map.put("Hpc7a48xlarge", "hpc7a.48xlarge");
        map.put("Hpc7a96xlarge", "hpc7a.96xlarge");
        map.put("C7gdMedium", "c7gd.medium");
        map.put("C7gdLarge", "c7gd.large");
        map.put("C7gdXlarge", "c7gd.xlarge");
        map.put("C7gd2xlarge", "c7gd.2xlarge");
        map.put("C7gd4xlarge", "c7gd.4xlarge");
        map.put("C7gd8xlarge", "c7gd.8xlarge");
        map.put("C7gd12xlarge", "c7gd.12xlarge");
        map.put("C7gd16xlarge", "c7gd.16xlarge");
        map.put("M7gdMedium", "m7gd.medium");
        map.put("M7gdLarge", "m7gd.large");
        map.put("M7gdXlarge", "m7gd.xlarge");
        map.put("M7gd2xlarge", "m7gd.2xlarge");
        map.put("M7gd4xlarge", "m7gd.4xlarge");
        map.put("M7gd8xlarge", "m7gd.8xlarge");
        map.put("M7gd12xlarge", "m7gd.12xlarge");
        map.put("M7gd16xlarge", "m7gd.16xlarge");
        map.put("R7gdMedium", "r7gd.medium");
        map.put("R7gdLarge", "r7gd.large");
        map.put("R7gdXlarge", "r7gd.xlarge");
        map.put("R7gd2xlarge", "r7gd.2xlarge");
        map.put("R7gd4xlarge", "r7gd.4xlarge");
        map.put("R7gd8xlarge", "r7gd.8xlarge");
        map.put("R7gd12xlarge", "r7gd.12xlarge");
        map.put("R7gd16xlarge", "r7gd.16xlarge");
        map.put("R7aMedium", "r7a.medium");
        map.put("R7aLarge", "r7a.large");
        map.put("R7aXlarge", "r7a.xlarge");
        map.put("R7a2xlarge", "r7a.2xlarge");
        map.put("R7a4xlarge", "r7a.4xlarge");
        map.put("R7a8xlarge", "r7a.8xlarge");
        map.put("R7a12xlarge", "r7a.12xlarge");
        map.put("R7a16xlarge", "r7a.16xlarge");
        map.put("R7a24xlarge", "r7a.24xlarge");
        map.put("R7a32xlarge", "r7a.32xlarge");
        map.put("R7a48xlarge", "r7a.48xlarge");
        map.put("C7iLarge", "c7i.large");
        map.put("C7iXlarge", "c7i.xlarge");
        map.put("C7i2xlarge", "c7i.2xlarge");
        map.put("C7i4xlarge", "c7i.4xlarge");
        map.put("C7i8xlarge", "c7i.8xlarge");
        map.put("C7i12xlarge", "c7i.12xlarge");
        map.put("C7i16xlarge", "c7i.16xlarge");
        map.put("C7i24xlarge", "c7i.24xlarge");
        map.put("C7i48xlarge", "c7i.48xlarge");
        map.put("Mac2M2proMetal", "mac2-m2pro.metal");
        map.put("R7izLarge", "r7iz.large");
        map.put("R7izXlarge", "r7iz.xlarge");
        map.put("R7iz2xlarge", "r7iz.2xlarge");
        map.put("R7iz4xlarge", "r7iz.4xlarge");
        map.put("R7iz8xlarge", "r7iz.8xlarge");
        map.put("R7iz12xlarge", "r7iz.12xlarge");
        map.put("R7iz16xlarge", "r7iz.16xlarge");
        map.put("R7iz32xlarge", "r7iz.32xlarge");
        map.put("C7aMedium", "c7a.medium");
        map.put("C7aLarge", "c7a.large");
        map.put("C7aXlarge", "c7a.xlarge");
        map.put("C7a2xlarge", "c7a.2xlarge");
        map.put("C7a4xlarge", "c7a.4xlarge");
        map.put("C7a8xlarge", "c7a.8xlarge");
        map.put("C7a12xlarge", "c7a.12xlarge");
        map.put("C7a16xlarge", "c7a.16xlarge");
        map.put("C7a24xlarge", "c7a.24xlarge");
        map.put("C7a32xlarge", "c7a.32xlarge");
        map.put("C7a48xlarge", "c7a.48xlarge");
        map.put("C7aMetal48xl", "c7a.metal-48xl");
        map.put("R7aMetal48xl", "r7a.metal-48xl");
        map.put("R7iLarge", "r7i.large");
        map.put("R7iXlarge", "r7i.xlarge");
        map.put("R7i2xlarge", "r7i.2xlarge");
        map.put("R7i4xlarge", "r7i.4xlarge");
        map.put("R7i8xlarge", "r7i.8xlarge");
        map.put("R7i12xlarge", "r7i.12xlarge");
        map.put("R7i16xlarge", "r7i.16xlarge");
        map.put("R7i24xlarge", "r7i.24xlarge");
        map.put("R7i48xlarge", "r7i.48xlarge");
        map.put("Dl2q24xlarge", "dl2q.24xlarge");
        map.put("Mac2M2Metal", "mac2-m2.metal");
        map.put("I4i12xlarge", "i4i.12xlarge");
        map.put("I4i24xlarge", "i4i.24xlarge");
        map.put("C7iMetal24xl", "c7i.metal-24xl");
        map.put("C7iMetal48xl", "c7i.metal-48xl");
        map.put("M7iMetal24xl", "m7i.metal-24xl");
        map.put("M7iMetal48xl", "m7i.metal-48xl");
        map.put("R7iMetal24xl", "r7i.metal-24xl");
        map.put("R7iMetal48xl", "r7i.metal-48xl");
        map.put("R7izMetal16xl", "r7iz.metal-16xl");
        map.put("R7izMetal32xl", "r7iz.metal-32xl");
        map.put("C7gdMetal", "c7gd.metal");
        map.put("M7gdMetal", "m7gd.metal");
        map.put("R7gdMetal", "r7gd.metal");
        map.put("G6Xlarge", "g6.xlarge");
        map.put("G62xlarge", "g6.2xlarge");
        map.put("G64xlarge", "g6.4xlarge");
        map.put("G68xlarge", "g6.8xlarge");
        map.put("G612xlarge", "g6.12xlarge");
        map.put("G616xlarge", "g6.16xlarge");
        map.put("G624xlarge", "g6.24xlarge");
        map.put("G648xlarge", "g6.48xlarge");
        map.put("Gr64xlarge", "gr6.4xlarge");
        map.put("Gr68xlarge", "gr6.8xlarge");
        map.put("C7iFlexLarge", "c7i-flex.large");
        map.put("C7iFlexXlarge", "c7i-flex.xlarge");
        map.put("C7iFlex2xlarge", "c7i-flex.2xlarge");
        map.put("C7iFlex4xlarge", "c7i-flex.4xlarge");
        map.put("C7iFlex8xlarge", "c7i-flex.8xlarge");
        map.put("U7i12tb224xlarge", "u7i-12tb.224xlarge");
        map.put("U7in16tb224xlarge", "u7in-16tb.224xlarge");
        map.put("U7in24tb224xlarge", "u7in-24tb.224xlarge");
        map.put("U7in32tb224xlarge", "u7in-32tb.224xlarge");
        map.put("U7ib12tb224xlarge", "u7ib-12tb.224xlarge");
        map.put("C7gnMetal", "c7gn.metal");
        map.put("R8gMedium", "r8g.medium");
        map.put("R8gLarge", "r8g.large");
        map.put("R8gXlarge", "r8g.xlarge");
        map.put("R8g2xlarge", "r8g.2xlarge");
        map.put("R8g4xlarge", "r8g.4xlarge");
        map.put("R8g8xlarge", "r8g.8xlarge");
        map.put("R8g12xlarge", "r8g.12xlarge");
        map.put("R8g16xlarge", "r8g.16xlarge");
        map.put("R8g24xlarge", "r8g.24xlarge");
        map.put("R8g48xlarge", "r8g.48xlarge");
        map.put("R8gMetal24xl", "r8g.metal-24xl");
        map.put("R8gMetal48xl", "r8g.metal-48xl");
        map.put("Mac2M1ultraMetal", "mac2-m1ultra.metal");
        AWS_SDK_JAVA_V1 = Collections.unmodifiableMap(map);
    }
}

