/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.ec2.Messages;
import java.io.IOException;
import java.net.URL;
import java.security.Key;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.interfaces.DSAKey;
import java.security.interfaces.ECKey;
import java.security.interfaces.RSAKey;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.security.FIPS140;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.DSAPublicKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.RSAKeyParameters;
import org.bouncycastle.crypto.util.OpenSSHPublicKeyUtil;

public class FIPS140Utils {
    public static void ensureKeyInFipsMode(Key key) {
        if (!FIPS140.useCompliantAlgorithms()) {
            return;
        }
        if (key instanceof RSAKey) {
            if (((RSAKey)((Object)key)).getModulus().bitLength() < 2048) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeInFIPSMode());
            }
        } else if (key instanceof DSAKey) {
            if (((DSAKey)((Object)key)).getParams().getP().bitLength() < 2048) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeInFIPSMode());
            }
        } else if (key instanceof ECKey) {
            if (((ECKey)((Object)key)).getParams().getCurve().getField().getFieldSize() < 224) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeECInFIPSMode());
            }
        } else {
            throw new IllegalArgumentException(Messages.EC2Cloud_keyIsNotApprovedInFIPSMode(key.getAlgorithm()));
        }
    }

    public static void ensureNoPasswordLeak(URL url, String password) {
        FIPS140Utils.ensureNoPasswordLeak("https".equals(url.getProtocol()), password);
    }

    public static void ensureNoPasswordLeak(boolean useHTTPS, String password) {
        FIPS140Utils.ensureNoPasswordLeak(useHTTPS, !StringUtils.isEmpty((String)password));
    }

    public static void ensureNoPasswordLeak(boolean useHTTPS, boolean usePassword) {
        if (FIPS140.useCompliantAlgorithms() && !useHTTPS && usePassword) {
            throw new IllegalArgumentException(Messages.EC2Cloud_tlsIsRequiredInFIPSMode());
        }
    }

    public static void ensurePasswordLength(String password) {
        if (FIPS140.useCompliantAlgorithms() && (StringUtils.isBlank((String)password) || password.length() < 14)) {
            throw new IllegalArgumentException(Messages.EC2Cloud_passwordLengthInFIPSMode());
        }
    }

    public static void ensureNoSelfSignedCertificate(boolean allowSelfSignedCertificate) {
        if (FIPS140.useCompliantAlgorithms() && allowSelfSignedCertificate) {
            throw new IllegalArgumentException(Messages.EC2Cloud_selfSignedCertificateNotAllowedInFIPSMode());
        }
    }

    public static void ensurePrivateKeyInFipsMode(String privateKeyString) {
        if (!FIPS140.useCompliantAlgorithms()) {
            return;
        }
        if (StringUtils.isBlank((String)privateKeyString)) {
            throw new IllegalArgumentException(Messages.EC2Cloud_keyIsMandatoryInFIPSMode());
        }
        try {
            PrivateKey privateKey = PEMEncodable.decode((String)privateKeyString).toPrivateKey();
            FIPS140Utils.ensureKeyInFipsMode(privateKey);
        }
        catch (IOException | RuntimeException | UnrecoverableKeyException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void ensurePublicKeyInFipsMode(@NonNull String algorithm, @NonNull byte[] key) {
        if (!FIPS140.useCompliantAlgorithms()) {
            return;
        }
        AsymmetricKeyParameter asymmetricKeyParameter = OpenSSHPublicKeyUtil.parsePublicKey((byte[])key);
        if (asymmetricKeyParameter instanceof RSAKeyParameters) {
            RSAKeyParameters rsaKeyParameters = (RSAKeyParameters)asymmetricKeyParameter;
            if (rsaKeyParameters.getModulus().bitLength() < 2048) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeInFIPSMode());
            }
        } else if (asymmetricKeyParameter instanceof DSAPublicKeyParameters) {
            DSAPublicKeyParameters dsaPublicKeyParameters = (DSAPublicKeyParameters)asymmetricKeyParameter;
            if (dsaPublicKeyParameters.getParameters().getP().bitLength() < 2048) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeInFIPSMode());
            }
        } else if (asymmetricKeyParameter instanceof ECPublicKeyParameters) {
            ECPublicKeyParameters ecPublicKeyParameters = (ECPublicKeyParameters)asymmetricKeyParameter;
            if (ecPublicKeyParameters.getParameters().getCurve().getFieldSize() < 224) {
                throw new IllegalArgumentException(Messages.EC2Cloud_invalidKeySizeECInFIPSMode());
            }
        } else {
            throw new IllegalArgumentException(Messages.EC2Cloud_keyIsNotApprovedInFIPSMode(algorithm));
        }
    }
}

