/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;

public class DeviceMappingParser {
    private DeviceMappingParser() {
    }

    public static List<BlockDeviceMapping> parse(String customDeviceMapping) {
        ArrayList<BlockDeviceMapping> deviceMappings = new ArrayList<BlockDeviceMapping>();
        for (String mapping : customDeviceMapping.split(",")) {
            String[] mappingPair = mapping.split("=");
            String device = mappingPair[0];
            String blockDevice = mappingPair[1];
            BlockDeviceMapping.Builder deviceMappingBuilder = BlockDeviceMapping.builder().deviceName(device);
            if (blockDevice.equals("none")) {
                deviceMappingBuilder.noDevice("none");
            } else if (blockDevice.startsWith("ephemeral")) {
                deviceMappingBuilder.virtualName(blockDevice);
            } else {
                deviceMappingBuilder.ebs(DeviceMappingParser.parseEbs(blockDevice));
            }
            deviceMappings.add((BlockDeviceMapping)deviceMappingBuilder.build());
        }
        return deviceMappings;
    }

    private static EbsBlockDevice parseEbs(String blockDevice) {
        String[] parts = blockDevice.split(":");
        EbsBlockDevice.Builder ebsBuilder = EbsBlockDevice.builder();
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 0))) {
            ebsBuilder.snapshotId(parts[0]);
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 1))) {
            ebsBuilder.volumeSize(Integer.valueOf(parts[1]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 2))) {
            ebsBuilder.deleteOnTermination(Boolean.valueOf(parts[2]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 3))) {
            ebsBuilder.volumeType(parts[3]);
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 4))) {
            ebsBuilder.iops(Integer.valueOf(parts[4]));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 5))) {
            ebsBuilder.encrypted(Boolean.valueOf(parts[5].equals("encrypted")));
        }
        if (StringUtils.isNotBlank((String)DeviceMappingParser.getOrEmpty(parts, 6))) {
            ebsBuilder.throughput(Integer.valueOf(parts[6]));
        }
        return (EbsBlockDevice)ebsBuilder.build();
    }

    private static String getOrEmpty(String[] arr, int idx) {
        if (idx < arr.length) {
            return arr[idx];
        }
        return "";
    }
}

