/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.InstanceState;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import hudson.plugins.ec2.ssh.verifiers.HostKeyHelper;
import java.security.PublicKey;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public abstract class SshHostKeyVerificationStrategy
implements Describable<SshHostKeyVerificationStrategy> {
    public SshHostKeyVerificationStrategyDescriptor getDescriptor() {
        return (SshHostKeyVerificationStrategyDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }

    public abstract boolean verify(EC2Computer var1, HostKey var2, TaskListener var3) throws Exception;

    public boolean verify(EC2Computer computer, PublicKey serverKey, TaskListener listener) throws Exception {
        return this.verify(computer, HostKeyHelper.getInstance().getHostKey(serverKey), listener);
    }

    @Nullable
    HostKey getHostKeyFromConsole(@NonNull Logger logger, @NonNull EC2Computer computer, @NonNull String serverHostKeyAlgorithm) {
        TaskListener listener = computer.getListener();
        try {
            if (!computer.getState().equals((Object)InstanceState.RUNNING)) {
                EC2Cloud.log(logger, Level.INFO, listener, "The instance " + computer.getName() + " is not running, waiting to validate the key against the console");
            }
        }
        catch (InterruptedException e) {
            return null;
        }
        String line = this.getLineWithKey(logger, computer, serverHostKeyAlgorithm);
        HostKey key = line != null && !line.isEmpty() ? this.getKeyFromLine(logger, line, listener) : (line != null ? new HostKey(serverHostKeyAlgorithm, new byte[0]) : null);
        return key;
    }

    @CheckForNull
    String getLineWithKey(@NonNull Logger logger, @NonNull EC2Computer computer, @NonNull String serverHostKeyAlgorithm) {
        String line = null;
        String console = computer.getDecodedConsoleOutput();
        if (console == null) {
            EC2Cloud.log(logger, Level.INFO, computer.getListener(), "The instance " + computer.getName() + " has a blank console. Maybe the console is yet not available. If enough time has passed, consider changing the key verification strategy or the AMI used by one printing out the host key in the instance console");
            return null;
        }
        try {
            int start = console.indexOf(serverHostKeyAlgorithm);
            if (start <= -1) {
                EC2Cloud.log(logger, Level.INFO, computer.getListener(), String.format("The instance %s didn't print the host key. Expected a line starting with: \"%s\"", computer.getName(), serverHostKeyAlgorithm));
                return "";
            }
            int end = console.indexOf(10, start);
            line = console.substring(start, end);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return line;
    }

    @CheckForNull
    HostKey getKeyFromLine(@NonNull Logger logger, @NonNull String line, @Nullable TaskListener listener) {
        String[] parts = line.split(" ");
        if (parts.length >= 2) {
            return new HostKey(parts[0], Base64.getDecoder().decode(parts[1]));
        }
        EC2Cloud.log(logger, Level.INFO, listener, String.format("The line with the key doesn't have the required format. Found: \"%s\". Expected a line with this text: \"ALGORITHM THEHOSTKEY\", example: \"ssh-ed25519 AAAAC3NzaC1lZDI1NTE5AAAAIJbvbEIoY3tqKwkeRW/L1FnbCLLp8a1TwSOyZHKJqFFR \"", line));
        return null;
    }

    public static abstract class SshHostKeyVerificationStrategyDescriptor
    extends Descriptor<SshHostKeyVerificationStrategy> {
    }
}

