/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.ec2.util.FIPS140Utils;
import java.io.Serializable;
import java.util.Arrays;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.digest.DigestUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;

public final class HostKey
implements Serializable {
    private static final long serialVersionUID = -3873284593211178494L;
    private final String algorithm;
    private final byte[] key;

    public HostKey(@NonNull String algorithm, @NonNull byte[] key) {
        FIPS140Utils.ensurePublicKeyInFipsMode(algorithm, key);
        this.algorithm = algorithm;
        this.key = (byte[])key.clone();
    }

    @NonNull
    public String getAlgorithm() {
        return this.algorithm;
    }

    @NonNull
    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getFingerprint() {
        try {
            byte[] rawFingerprint = DigestUtils.getRawFingerprint((Digest)((Digest)BuiltinDigests.md5.get()), (byte[])this.getKey());
            return BufferUtils.toHex((char)':', (byte[])rawFingerprint).toLowerCase();
        }
        catch (Exception e) {
            return "";
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.algorithm == null ? 0 : this.algorithm.hashCode());
        result = 31 * result + Arrays.hashCode(this.key);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HostKey other = (HostKey)obj;
        if (this.algorithm == null ? other.algorithm != null : !this.algorithm.equals(other.algorithm)) {
            return false;
        }
        return Arrays.equals(this.key, other.key);
    }
}

