/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.verifiers;

import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.ssh.verifiers.HostKey;
import hudson.plugins.ec2.ssh.verifiers.HostKeyHelper;
import hudson.plugins.ec2.ssh.verifiers.Messages;
import hudson.plugins.ec2.ssh.verifiers.SshHostKeyVerificationStrategy;
import hudson.slaves.OfflineCause;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.localizer.Localizable;

public class AcceptNewStrategy
extends SshHostKeyVerificationStrategy {
    private static final Logger LOGGER = Logger.getLogger(AcceptNewStrategy.class.getName());

    @Override
    public boolean verify(EC2Computer computer, HostKey hostKey, TaskListener listener) throws IOException {
        HostKey existingHostKey = HostKeyHelper.getInstance().getHostKey((Computer)computer);
        if (null == existingHostKey) {
            HostKeyHelper.getInstance().saveHostKey((Computer)computer, hostKey);
            EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), String.format("The SSH key %s %s has been automatically trusted for connections to %s", hostKey.getAlgorithm(), hostKey.getFingerprint(), computer.getName()));
            return true;
        }
        if (existingHostKey.equals(hostKey)) {
            EC2Cloud.log(LOGGER, Level.INFO, computer.getListener(), "Connection allowed after the host key has been verified");
            return true;
        }
        EC2Cloud.log(LOGGER, Level.WARNING, computer.getListener(), String.format("The SSH key (%s) presented by the instance has changed since first saved (%s). The connection to %s is closed to prevent a possible man-in-the-middle attack", hostKey.getFingerprint(), existingHostKey.getFingerprint(), computer.getName()));
        computer.setTemporarilyOffline(true, OfflineCause.create((Localizable)Messages._OfflineCause_SSHKeyCheckFailed()));
        return false;
    }
}

