/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh.proxy;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.Base64;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class ProxyCONNECTListener
implements ClientProxyConnector {
    private static final long timeout = Duration.ofSeconds(10L).toMillis();
    public final String targetHost;
    public final int targetPort;
    public final String proxyUser;
    public final String proxyPass;

    public ProxyCONNECTListener(String targetHost, int targetPort, String proxyUser, String proxyPass) {
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.proxyUser = proxyUser;
        this.proxyPass = proxyPass;
    }

    public void sendClientProxyMetadata(ClientSession session) throws Exception {
        this.proxyCONNECT(session.getIoSession());
    }

    public void proxyCONNECT(IoSession ioSession) {
        StringBuilder connectRequest = new StringBuilder();
        connectRequest.append("CONNECT ").append(this.targetHost).append(':').append(this.targetPort).append(" HTTP/1.0\r\n");
        connectRequest.append("Host: ").append(this.targetHost).append(':').append(this.targetPort).append("\r\n");
        if (this.proxyUser != null && this.proxyPass != null) {
            String credentials = this.proxyUser + ":" + this.proxyPass;
            String encoded = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.ISO_8859_1));
            connectRequest.append("Proxy-Authorization: Basic ");
            connectRequest.append(encoded);
            connectRequest.append("\r\n");
        }
        connectRequest.append("\r\n");
        try {
            ioSession.writeBuffer((Buffer)new ByteArrayBuffer(connectRequest.toString().getBytes(StandardCharsets.US_ASCII))).await(timeout);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

