/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.amazonaws.services.ec2.model.InstanceType;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.XmlFile;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.labels.LabelAtom;
import hudson.model.listeners.SaveableListener;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.AssociateIPStrategy;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Filter;
import hudson.plugins.ec2.EC2OndemandSlave;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.EbsEncryptRootVolume;
import hudson.plugins.ec2.HostKeyVerificationStrategyEnum;
import hudson.plugins.ec2.SSHData;
import hudson.plugins.ec2.SpotConfiguration;
import hudson.plugins.ec2.Tenancy;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.plugins.ec2.util.DeviceMappingParser;
import hudson.plugins.ec2.util.EC2AgentConfig;
import hudson.plugins.ec2.util.EC2AgentFactory;
import hudson.plugins.ec2.util.InstanceTypeCompat;
import hudson.plugins.ec2.util.KeyPair;
import hudson.plugins.ec2.util.MinimumInstanceChecker;
import hudson.plugins.ec2.util.MinimumNumberOfInstancesTimeRangeConfig;
import hudson.security.Permission;
import hudson.slaves.NodeProperty;
import hudson.slaves.NodePropertyDescriptor;
import hudson.util.DescribableList;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import jenkins.slaves.iterators.api.NodeIterator;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.BlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.CancelSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.CreditSpecificationRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DeviceType;
import software.amazon.awssdk.services.ec2.model.EbsBlockDevice;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;
import software.amazon.awssdk.services.ec2.model.EnclaveOptionsRequest;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.HttpTokensState;
import software.amazon.awssdk.services.ec2.model.IamInstanceProfileSpecification;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceMarketOptionsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataEndpointState;
import software.amazon.awssdk.services.ec2.model.InstanceMetadataOptionsRequest;
import software.amazon.awssdk.services.ec2.model.InstanceNetworkInterfaceSpecification;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;
import software.amazon.awssdk.services.ec2.model.MarketType;
import software.amazon.awssdk.services.ec2.model.NitroEnclavesSupport;
import software.amazon.awssdk.services.ec2.model.Placement;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesRequest;
import software.amazon.awssdk.services.ec2.model.RequestSpotInstancesResponse;
import software.amazon.awssdk.services.ec2.model.RequestSpotLaunchSpecification;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.ResourceType;
import software.amazon.awssdk.services.ec2.model.RunInstancesMonitoringEnabled;
import software.amazon.awssdk.services.ec2.model.RunInstancesRequest;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.ShutdownBehavior;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.SpotMarketOptions;
import software.amazon.awssdk.services.ec2.model.SpotPlacement;
import software.amazon.awssdk.services.ec2.model.StartInstancesRequest;
import software.amazon.awssdk.services.ec2.model.StartInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagSpecification;

public class SlaveTemplate
implements Describable<SlaveTemplate> {
    private static final Logger LOGGER = Logger.getLogger(SlaveTemplate.class.getName());
    private static final String EC2_RESOURCE_ID_DELIMETERS = "[\\s,;]+";
    public String ami;
    public final String description;
    public final String zone;
    public final SpotConfiguration spotConfig;
    public final String securityGroups;
    public final String remoteFS;
    public String type;
    public final boolean ebsOptimized;
    public final boolean monitoring;
    public final boolean t2Unlimited;
    public final String labels;
    public final Node.Mode mode;
    public final String initScript;
    public final String tmpDir;
    public final String userData;
    public final String numExecutors;
    public final String remoteAdmin;
    public String javaPath;
    public final String jvmopts;
    public final String subnetId;
    public final String idleTerminationMinutes;
    private boolean terminateIdleDuringShutdown;
    public final String iamInstanceProfile;
    public final boolean deleteRootOnTermination;
    public final boolean useEphemeralDevices;
    public final String customDeviceMapping;
    public int instanceCap;
    private final int minimumNumberOfInstances;
    private MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig;
    private final int minimumNumberOfSpareInstances;
    public final boolean stopOnTerminate;
    private final List<EC2Tag> tags;
    public ConnectionStrategy connectionStrategy;
    public HostKeyVerificationStrategyEnum hostKeyVerificationStrategy;
    public AssociateIPStrategy associateIPStrategy;
    @Deprecated
    public transient boolean associatePublicIp;
    protected transient EC2Cloud parent;
    public AMITypeData amiType;
    public int launchTimeout;
    public boolean connectBySSHProcess;
    public int maxTotalUses;
    private boolean avoidUsingOrphanedNodes;
    private DescribableList<NodeProperty<?>, NodePropertyDescriptor> nodeProperties;
    public int nextSubnet;
    public String currentSubnetId;
    public Tenancy tenancy;
    public EbsEncryptRootVolume ebsEncryptRootVolume;
    private Boolean metadataSupported;
    private Boolean metadataEndpointEnabled;
    private Boolean metadataTokensRequired;
    private Integer metadataHopsLimit;
    private Boolean enclaveEnabled;
    private transient Set<LabelAtom> labelSet;
    private transient Set<String> securityGroupSet;
    @CheckForNull
    private String amiOwners;
    @CheckForNull
    private String amiUsers;
    @CheckForNull
    private List<EC2Filter> amiFilters;
    @Deprecated
    public transient String sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    @Deprecated
    public transient String slaveCommandPrefix;
    @Deprecated
    public transient String slaveCommandSuffix;
    @Deprecated
    public boolean usePrivateDnsName;
    @Deprecated
    public boolean connectUsingPublicIp;
    @Deprecated
    public transient boolean useDedicatedTenancy;

    @DataBoundConstructor
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, String type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String javaPath, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, AssociateIPStrategy associateIPStrategy, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy, EbsEncryptRootVolume ebsEncryptRootVolume, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported, Boolean enclaveEnabled) {
        if (StringUtils.isNotBlank((String)remoteAdmin) || StringUtils.isNotBlank((String)jvmopts) || StringUtils.isNotBlank((String)tmpDir)) {
            LOGGER.log(Level.FINE, "As remoteAdmin, jvmopts or tmpDir is not blank, we must ensure the user has ADMINISTER rights.");
            Jenkins j = Jenkins.getInstanceOrNull();
            if (j != null) {
                j.checkPermission(Jenkins.ADMINISTER);
            }
        }
        this.ami = ami;
        this.zone = zone;
        this.spotConfig = spotConfig;
        this.securityGroups = securityGroups;
        this.remoteFS = remoteFS;
        this.amiType = amiType;
        this.type = type != null && !type.isEmpty() ? InstanceTypeCompat.of(type).toString() : null;
        this.ebsOptimized = ebsOptimized;
        this.labels = Util.fixNull((String)labelString);
        this.mode = mode != null ? mode : Node.Mode.NORMAL;
        this.description = description;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.userData = StringUtils.trimToEmpty((String)userData);
        this.numExecutors = Util.fixNull((String)numExecutors).trim();
        this.remoteAdmin = remoteAdmin;
        this.javaPath = StringUtils.isNotBlank((String)javaPath) ? javaPath : "java";
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.subnetId = subnetId;
        this.tags = tags;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.connectionStrategy = connectionStrategy == null ? ConnectionStrategy.PRIVATE_IP : connectionStrategy;
        this.useDedicatedTenancy = tenancy == Tenancy.Dedicated;
        this.connectBySSHProcess = connectBySSHProcess;
        this.maxTotalUses = maxTotalUses;
        this.nodeProperties = new DescribableList(Saveable.NOOP, (Collection)Util.fixNull(nodeProperties));
        this.monitoring = monitoring;
        this.nextSubnet = 0;
        this.usePrivateDnsName = this.connectionStrategy.equals((Object)ConnectionStrategy.PRIVATE_DNS);
        this.connectUsingPublicIp = this.connectionStrategy.equals((Object)ConnectionStrategy.PUBLIC_IP);
        this.minimumNumberOfInstances = minimumNumberOfInstances;
        this.minimumNumberOfSpareInstances = minimumNumberOfSpareInstances;
        this.instanceCap = null == instanceCapStr || instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        try {
            this.launchTimeout = Integer.parseInt(launchTimeoutStr);
        }
        catch (NumberFormatException nfe) {
            this.launchTimeout = Integer.MAX_VALUE;
        }
        this.iamInstanceProfile = iamInstanceProfile;
        this.deleteRootOnTermination = deleteRootOnTermination;
        this.useEphemeralDevices = useEphemeralDevices;
        this.customDeviceMapping = customDeviceMapping;
        this.t2Unlimited = t2Unlimited;
        this.hostKeyVerificationStrategy = hostKeyVerificationStrategy != null ? hostKeyVerificationStrategy : HostKeyVerificationStrategyEnum.CHECK_NEW_SOFT;
        this.tenancy = tenancy != null ? tenancy : Tenancy.Default;
        this.ebsEncryptRootVolume = ebsEncryptRootVolume != null ? ebsEncryptRootVolume : EbsEncryptRootVolume.DEFAULT;
        this.metadataSupported = metadataSupported != null ? metadataSupported : EC2AbstractSlave.DEFAULT_METADATA_SUPPORTED;
        this.metadataEndpointEnabled = metadataEndpointEnabled != null ? metadataEndpointEnabled : EC2AbstractSlave.DEFAULT_METADATA_ENDPOINT_ENABLED;
        this.metadataTokensRequired = metadataTokensRequired != null ? metadataTokensRequired : EC2AbstractSlave.DEFAULT_METADATA_TOKENS_REQUIRED;
        this.metadataHopsLimit = metadataHopsLimit != null ? metadataHopsLimit : EC2AbstractSlave.DEFAULT_METADATA_HOPS_LIMIT;
        this.enclaveEnabled = enclaveEnabled != null ? enclaveEnabled : EC2AbstractSlave.DEFAULT_ENCLAVE_ENABLED;
        this.associateIPStrategy = associateIPStrategy != null ? associateIPStrategy : AssociateIPStrategy.DEFAULT;
        this.readResolve();
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, String type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String javaPath, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy, EbsEncryptRootVolume ebsEncryptRootVolume, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported, Boolean enclaveEnabled) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)type.toString()).toString(), ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, javaPath, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, AssociateIPStrategy.backwardsCompatible(associatePublicIp), customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, tenancy, ebsEncryptRootVolume, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, metadataSupported, enclaveEnabled);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String javaPath, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy, EbsEncryptRootVolume ebsEncryptRootVolume, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)type.toString()).toString(), ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, javaPath, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, tenancy, ebsEncryptRootVolume, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, metadataSupported, EC2AbstractSlave.DEFAULT_ENCLAVE_ENABLED);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String javaPath, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy, EbsEncryptRootVolume ebsEncryptRootVolume, Boolean metadataSupported, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)type.toString()).toString(), ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, "java", jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, tenancy, null, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, EC2AbstractSlave.DEFAULT_METADATA_SUPPORTED, EC2AbstractSlave.DEFAULT_ENCLAVE_ENABLED);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy, EbsEncryptRootVolume ebsEncryptRootVolume) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)type.toString()).toString(), ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, "java", jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, tenancy, null, EC2AbstractSlave.DEFAULT_METADATA_ENDPOINT_ENABLED, EC2AbstractSlave.DEFAULT_METADATA_TOKENS_REQUIRED, EC2AbstractSlave.DEFAULT_METADATA_HOPS_LIMIT, EC2AbstractSlave.DEFAULT_METADATA_SUPPORTED, EC2AbstractSlave.DEFAULT_ENCLAVE_ENABLED);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy, Tenancy tenancy) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, tenancy, null);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties, HostKeyVerificationStrategyEnum hostKeyVerificationStrategy) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, hostKeyVerificationStrategy, Tenancy.backwardsCompatible(useDedicatedTenancy));
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, int minimumNumberOfSpareInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, minimumNumberOfSpareInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties, null);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses, List<? extends NodeProperty<?>> nodeProperties) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, 0, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, nodeProperties);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, int minimumNumberOfInstances, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, minimumNumberOfInstances, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses, Collections.emptyList());
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean monitoring, boolean t2Unlimited, ConnectionStrategy connectionStrategy, int maxTotalUses) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, 0, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, connectionStrategy, maxTotalUses);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean connectUsingPublicIp, boolean monitoring, boolean t2Unlimited) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, monitoring, t2Unlimited, ConnectionStrategy.backwardsCompatible(usePrivateDnsName, connectUsingPublicIp, associatePublicIp), -1);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean deleteRootOnTermination, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess, boolean connectUsingPublicIp) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, deleteRootOnTermination, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, connectUsingPublicIp, false, false);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping, boolean connectBySSHProcess) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, false, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, connectBySSHProcess, false);
    }

    @Deprecated
    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, AMITypeData amiType, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, boolean useDedicatedTenancy, String launchTimeoutStr, boolean associatePublicIp, String customDeviceMapping) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, amiType, jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, useDedicatedTenancy, launchTimeoutStr, associatePublicIp, customDeviceMapping, false);
    }

    public SlaveTemplate(String ami, String zone, SpotConfiguration spotConfig, String securityGroups, String remoteFS, String sshPort, InstanceType type, boolean ebsOptimized, String labelString, Node.Mode mode, String description, String initScript, String tmpDir, String userData, String numExecutors, String remoteAdmin, String rootCommandPrefix, String slaveCommandPrefix, String slaveCommandSuffix, String jvmopts, boolean stopOnTerminate, String subnetId, List<EC2Tag> tags, String idleTerminationMinutes, boolean usePrivateDnsName, String instanceCapStr, String iamInstanceProfile, boolean useEphemeralDevices, String launchTimeoutStr) {
        this(ami, zone, spotConfig, securityGroups, remoteFS, type, ebsOptimized, labelString, mode, description, initScript, tmpDir, userData, numExecutors, remoteAdmin, new UnixData(rootCommandPrefix, slaveCommandPrefix, slaveCommandSuffix, sshPort, null), jvmopts, stopOnTerminate, subnetId, tags, idleTerminationMinutes, usePrivateDnsName, instanceCapStr, iamInstanceProfile, useEphemeralDevices, false, launchTimeoutStr, false, null);
    }

    public boolean isConnectBySSHProcess() {
        return this.connectBySSHProcess;
    }

    public EC2Cloud getParent() {
        return this.parent;
    }

    public String getLabelString() {
        return this.labels;
    }

    public Node.Mode getMode() {
        return this.mode;
    }

    public String getDisplayName() {
        return String.format("EC2 (%s) - %s", this.parent.getDisplayName(), this.description);
    }

    public String getSlaveName(String instanceId) {
        String agentName = String.format("%s (%s)", this.getDisplayName(), instanceId);
        try {
            Jenkins.checkGoodName((String)agentName);
            return agentName;
        }
        catch (Failure e) {
            return instanceId;
        }
    }

    public String getZone() {
        return this.zone;
    }

    public String getSecurityGroupString() {
        return this.securityGroups;
    }

    public Set<String> getSecurityGroupSet() {
        return this.securityGroupSet;
    }

    public Set<String> parseSecurityGroups() {
        if (this.securityGroups == null || this.securityGroups.trim().isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(this.securityGroups.split("\\s*,\\s*")));
    }

    public int getNumExecutors() {
        try {
            return Integer.parseInt(this.numExecutors);
        }
        catch (NumberFormatException e) {
            return EC2AbstractSlave.toNumExecutors(software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)this.type));
        }
    }

    public int getSshPort() {
        try {
            String sshPort = "";
            if (this.amiType.isSSHAgent()) {
                sshPort = ((SSHData)this.amiType).getSshPort();
            }
            return Integer.parseInt(sshPort);
        }
        catch (NumberFormatException e) {
            return 22;
        }
    }

    public String getRemoteAdmin() {
        return this.remoteAdmin;
    }

    public String getRootCommandPrefix() {
        return this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getRootCommandPrefix() : "";
    }

    public String getSlaveCommandPrefix() {
        return this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getSlaveCommandPrefix() : "";
    }

    public String getSlaveCommandSuffix() {
        return this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getSlaveCommandSuffix() : "";
    }

    public String chooseSubnetId() {
        if (StringUtils.isBlank((String)this.subnetId)) {
            return null;
        }
        String[] subnetIdList = this.getSubnetId().split(EC2_RESOURCE_ID_DELIMETERS);
        this.currentSubnetId = subnetIdList[this.nextSubnet];
        this.nextSubnet = (this.nextSubnet + 1) % subnetIdList.length;
        return this.currentSubnetId;
    }

    public String chooseSubnetId(boolean rotateSubnet) {
        if (rotateSubnet) {
            return this.chooseSubnetId();
        }
        return this.currentSubnetId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getCurrentSubnetId() {
        return this.currentSubnetId;
    }

    @Deprecated
    public boolean getAssociatePublicIp() {
        return AssociateIPStrategy.PUBLIC_IP == this.associateIPStrategy;
    }

    @Deprecated
    @DataBoundSetter
    public void setAssociatePublicIp(boolean associatePublicIp) {
        this.associatePublicIp = associatePublicIp;
        this.associateIPStrategy = AssociateIPStrategy.backwardsCompatible(associatePublicIp);
    }

    public AssociateIPStrategy getAssociateIPStrategy() {
        return this.associateIPStrategy;
    }

    @Deprecated
    @DataBoundSetter
    public void setConnectUsingPublicIp(boolean connectUsingPublicIp) {
        this.connectUsingPublicIp = connectUsingPublicIp;
        this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, this.getAssociatePublicIp());
    }

    @Deprecated
    @DataBoundSetter
    public void setUsePrivateDnsName(boolean usePrivateDnsName) {
        this.usePrivateDnsName = usePrivateDnsName;
        this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, this.getAssociatePublicIp());
    }

    @Deprecated
    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    @Deprecated
    public boolean isConnectUsingPublicIp() {
        return this.connectUsingPublicIp;
    }

    public List<EC2Tag> getTags() {
        if (null == this.tags) {
            return null;
        }
        return Collections.unmodifiableList(this.tags);
    }

    public String getidleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public boolean getTerminateIdleDuringShutdown() {
        return this.terminateIdleDuringShutdown;
    }

    @DataBoundSetter
    public void setTerminateIdleDuringShutdown(boolean terminateIdleDuringShutdown) {
        this.terminateIdleDuringShutdown = terminateIdleDuringShutdown;
    }

    public Set<LabelAtom> getLabelSet() {
        if (this.labelSet == null) {
            this.labelSet = Label.parse((String)this.labels);
        }
        return this.labelSet;
    }

    public String getAmi() {
        return this.ami;
    }

    public void setAmi(String ami) {
        this.ami = ami;
    }

    public AMITypeData getAmiType() {
        return this.amiType;
    }

    public void setAmiType(AMITypeData amiType) {
        this.amiType = amiType;
    }

    public int getMinimumNumberOfInstances() {
        return this.minimumNumberOfInstances;
    }

    public int getMinimumNumberOfSpareInstances() {
        return this.minimumNumberOfSpareInstances;
    }

    public MinimumNumberOfInstancesTimeRangeConfig getMinimumNumberOfInstancesTimeRangeConfig() {
        return this.minimumNumberOfInstancesTimeRangeConfig;
    }

    @DataBoundSetter
    public void setMinimumNumberOfInstancesTimeRangeConfig(MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig) {
        this.minimumNumberOfInstancesTimeRangeConfig = minimumNumberOfInstancesTimeRangeConfig;
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public int getSpotBlockReservationDuration() {
        if (this.spotConfig == null) {
            return 0;
        }
        return this.spotConfig.getSpotBlockReservationDuration();
    }

    public String getSpotBlockReservationDurationStr() {
        if (this.spotConfig == null) {
            return "";
        }
        int dur = this.getSpotBlockReservationDuration();
        if (dur == 0) {
            return "";
        }
        return String.valueOf(this.getSpotBlockReservationDuration());
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public String getSpotMaxBidPrice() {
        if (this.spotConfig == null) {
            return null;
        }
        return SpotConfiguration.normalizeBid(this.spotConfig.getSpotMaxBidPrice());
    }

    public String getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    @DataBoundSetter
    public void setHostKeyVerificationStrategy(HostKeyVerificationStrategyEnum hostKeyVerificationStrategy) {
        this.hostKeyVerificationStrategy = hostKeyVerificationStrategy != null ? hostKeyVerificationStrategy : HostKeyVerificationStrategyEnum.CHECK_NEW_SOFT;
    }

    @NonNull
    public HostKeyVerificationStrategyEnum getHostKeyVerificationStrategy() {
        return this.hostKeyVerificationStrategy != null ? this.hostKeyVerificationStrategy : HostKeyVerificationStrategyEnum.CHECK_NEW_SOFT;
    }

    @CheckForNull
    public String getAmiOwners() {
        return this.amiOwners;
    }

    @DataBoundSetter
    public void setAmiOwners(String amiOwners) {
        this.amiOwners = amiOwners;
    }

    @CheckForNull
    public String getAmiUsers() {
        return this.amiUsers;
    }

    @DataBoundSetter
    public void setAmiUsers(String amiUsers) {
        this.amiUsers = amiUsers;
    }

    @CheckForNull
    public List<EC2Filter> getAmiFilters() {
        return this.amiFilters;
    }

    @DataBoundSetter
    public void setAmiFilters(List<EC2Filter> amiFilters) {
        this.amiFilters = amiFilters;
    }

    @DataBoundSetter
    public void setAvoidUsingOrphanedNodes(Boolean avoidUsingOrphanedNodes) {
        this.avoidUsingOrphanedNodes = avoidUsingOrphanedNodes;
    }

    public String getDescription() {
        return this.description;
    }

    public String getType() {
        return this.type;
    }

    public String getRemoteFS() {
        return this.remoteFS;
    }

    public SpotConfiguration getSpotConfig() {
        return this.spotConfig;
    }

    public String getSecurityGroups() {
        return this.securityGroups;
    }

    public String getJavaPath() {
        return this.javaPath;
    }

    public String getJvmopts() {
        return this.jvmopts;
    }

    public boolean getStopOnTerminate() {
        return this.stopOnTerminate;
    }

    public String getIdleTerminationMinutes() {
        return this.idleTerminationMinutes;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public String getUserData() {
        return this.userData;
    }

    public boolean getConnectBySSHProcess() {
        return this.connectBySSHProcess;
    }

    public boolean getConnectUsingPublicIp() {
        return this.connectUsingPublicIp;
    }

    public boolean getDeleteRootOnTermination() {
        return this.deleteRootOnTermination;
    }

    public boolean getUseEphemeralDevices() {
        return this.useEphemeralDevices;
    }

    public boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public boolean getMonitoring() {
        return this.monitoring;
    }

    public boolean getT2Unlimited() {
        return this.t2Unlimited;
    }

    public EbsEncryptRootVolume getEbsEncryptRootVolume() {
        return this.ebsEncryptRootVolume;
    }

    public String getCustomDeviceMapping() {
        return this.customDeviceMapping;
    }

    public Tenancy getTenancy() {
        return this.tenancy;
    }

    public ConnectionStrategy getConnectionStrategy() {
        return this.connectionStrategy;
    }

    public boolean getUseDedicatedTenancy() {
        return this.useDedicatedTenancy;
    }

    public int getNextSubnet() {
        return this.nextSubnet;
    }

    public String toString() {
        return "SlaveTemplate{description='" + this.description + "', labels='" + this.labels + "'}";
    }

    public int getMaxTotalUses() {
        return this.maxTotalUses;
    }

    public boolean isAvoidUsingOrphanedNodes() {
        return this.avoidUsingOrphanedNodes;
    }

    public boolean getAvoidUsingOrphanedNodes() {
        return this.avoidUsingOrphanedNodes;
    }

    public Boolean getMetadataSupported() {
        return this.metadataSupported;
    }

    public Boolean getMetadataEndpointEnabled() {
        return this.metadataEndpointEnabled;
    }

    public Boolean getMetadataTokensRequired() {
        return this.metadataTokensRequired;
    }

    public Integer getMetadataHopsLimit() {
        return this.metadataHopsLimit;
    }

    public Tenancy getTenancyAttribute() {
        return this.tenancy;
    }

    public Boolean getEnclaveEnabled() {
        return this.enclaveEnabled;
    }

    public DescribableList<NodeProperty<?>, NodePropertyDescriptor> getNodeProperties() {
        return Objects.requireNonNull(this.nodeProperties);
    }

    @NonNull
    public List<EC2AbstractSlave> provision(int number, EnumSet<ProvisionOptions> provisionOptions) throws SdkException, IOException {
        Image image = this.getImage();
        if (this.spotConfig != null) {
            if (provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE) || provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE)) {
                return this.provisionSpot(image, number, provisionOptions);
            }
            return Collections.emptyList();
        }
        return this.provisionOndemand(image, number, provisionOptions);
    }

    private boolean checkInstance(Instance instance) {
        for (EC2AbstractSlave node : NodeIterator.nodes(EC2AbstractSlave.class)) {
            if (!node.getInstanceId().equals(instance.instanceId()) || instance.state().name().equals((Object)InstanceStateName.STOPPED)) continue;
            this.logInstanceCheck(instance, ". false - found existing corresponding Jenkins agent: " + node.getInstanceId());
            return false;
        }
        this.logInstanceCheck(instance, " true - Instance is not connected to Jenkins");
        return true;
    }

    private void logInstanceCheck(Instance instance, String message) {
        this.logProvisionInfo("checkInstance: " + instance.instanceId() + "." + message);
    }

    private boolean isSameIamInstanceProfile(Instance instance) {
        return StringUtils.isBlank((String)this.getIamInstanceProfile()) || instance.iamInstanceProfile() != null && instance.iamInstanceProfile().arn().equals(this.getIamInstanceProfile());
    }

    private boolean isTerminatingOrShuttindDown(InstanceStateName instanceStateName) {
        return instanceStateName.equals((Object)InstanceStateName.TERMINATED) || instanceStateName.equals((Object)InstanceStateName.SHUTTING_DOWN);
    }

    private void logProvisionInfo(String message) {
        LOGGER.info(String.valueOf(this) + ". " + message);
    }

    HashMap<RunInstancesRequest, List<Filter>> makeRunInstancesRequestAndFilters(Image image, int number, Ec2Client ec2) throws IOException {
        return this.makeRunInstancesRequestAndFilters(image, number, ec2, true);
    }

    @Deprecated
    HashMap<RunInstancesRequest, List<Filter>> makeRunInstancesRequestAndFilters(int number, Ec2Client ec2) throws IOException {
        return this.makeRunInstancesRequestAndFilters(this.getImage(), number, ec2);
    }

    HashMap<RunInstancesRequest, List<Filter>> makeRunInstancesRequestAndFilters(Image image, int number, Ec2Client ec2, boolean rotateSubnet) throws IOException {
        String imageId = image.imageId();
        RunInstancesRequest.Builder riRequestBuilder = RunInstancesRequest.builder().imageId(image.imageId()).minCount(Integer.valueOf(1)).maxCount(Integer.valueOf(number)).instanceType(this.type).ebsOptimized(Boolean.valueOf(this.ebsOptimized)).monitoring((RunInstancesMonitoringEnabled)RunInstancesMonitoringEnabled.builder().enabled(Boolean.valueOf(this.monitoring)).build());
        if (this.t2Unlimited) {
            CreditSpecificationRequest creditRequest = (CreditSpecificationRequest)CreditSpecificationRequest.builder().cpuCredits("unlimited").build();
            riRequestBuilder.creditSpecification(creditRequest);
        }
        riRequestBuilder.blockDeviceMappings(this.getBlockDeviceMappings(image));
        if (this.stopOnTerminate) {
            riRequestBuilder.instanceInitiatedShutdownBehavior(ShutdownBehavior.STOP);
            this.logProvisionInfo("Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Stop");
        } else {
            riRequestBuilder.instanceInitiatedShutdownBehavior(ShutdownBehavior.TERMINATE);
            this.logProvisionInfo("Setting Instance Initiated Shutdown Behavior : ShutdownBehavior.Terminate");
        }
        ArrayList<Filter> diFilters = new ArrayList<Filter>();
        diFilters.add((Filter)Filter.builder().name("image-id").values(new String[]{imageId}).build());
        diFilters.add((Filter)Filter.builder().name("instance-type").values(new String[]{this.type}).build());
        KeyPair keyPair = this.getKeyPair(ec2);
        if (keyPair == null) {
            this.logProvisionInfo("Could not retrieve a valid key pair.");
            return null;
        }
        riRequestBuilder.userData(Base64.getEncoder().encodeToString(this.userData.getBytes(StandardCharsets.UTF_8)));
        riRequestBuilder.keyName(keyPair.getKeyPairInfo().keyName());
        diFilters.add((Filter)Filter.builder().name("key-name").values(new String[]{keyPair.getKeyPairInfo().keyName()}).build());
        Placement.Builder placementBuilder = Placement.builder();
        if (StringUtils.isNotBlank((String)this.getZone())) {
            if (this.getTenancyAttribute().equals((Object)Tenancy.Dedicated)) {
                placementBuilder.tenancy("dedicated");
            }
            riRequestBuilder.placement((Placement)placementBuilder.build());
            diFilters.add((Filter)Filter.builder().name("availability-zone").values(new String[]{this.getZone()}).build());
        }
        if (this.getTenancyAttribute().equals((Object)Tenancy.Host)) {
            placementBuilder.tenancy("host");
            placement = (Placement)placementBuilder.build();
            riRequestBuilder.placement(placement);
            diFilters.add((Filter)Filter.builder().name("tenancy").values(new String[]{placement.tenancyAsString()}).build());
        } else if (this.getTenancyAttribute().equals((Object)Tenancy.Default)) {
            placementBuilder.tenancy("default");
            placement = (Placement)placementBuilder.build();
            riRequestBuilder.placement(placement);
            diFilters.add((Filter)Filter.builder().name("tenancy").values(new String[]{placement.tenancyAsString()}).build());
        }
        String subnetId = this.chooseSubnetId(rotateSubnet);
        LOGGER.log(Level.FINE, () -> String.format("Chose subnetId %s", subnetId));
        InstanceNetworkInterfaceSpecification.Builder netBuilder = InstanceNetworkInterfaceSpecification.builder();
        if (StringUtils.isNotBlank((String)subnetId)) {
            netBuilder.subnetId(subnetId);
            diFilters.add((Filter)Filter.builder().name("subnet-id").values(new String[]{subnetId}).build());
            if (!this.getSecurityGroupSet().isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                netBuilder.groups(groupIds);
                diFilters.add((Filter)Filter.builder().name("instance.group-id").values(groupIds).build());
            }
        } else {
            groupIds = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2).securityGroups().stream().map(SecurityGroup::groupId).collect(Collectors.toList());
            netBuilder.groups(groupIds);
            if (!groupIds.isEmpty()) {
                diFilters.add((Filter)Filter.builder().name("instance.group-id").values(groupIds).build());
            }
        }
        switch (this.getAssociateIPStrategy()) {
            case PUBLIC_IP: {
                netBuilder.associatePublicIpAddress(Boolean.valueOf(true));
                break;
            }
            case PRIVATE_IP: {
                netBuilder.associatePublicIpAddress(Boolean.valueOf(false));
                break;
            }
        }
        netBuilder.deviceIndex(Integer.valueOf(0));
        riRequestBuilder.networkInterfaces(new InstanceNetworkInterfaceSpecification[]{(InstanceNetworkInterfaceSpecification)netBuilder.build()});
        HashSet<Tag> instTags = this.buildTags("demand");
        for (Tag tag : instTags) {
            diFilters.add((Filter)Filter.builder().name("tag:" + tag.key()).values(new String[]{tag.value()}).build());
        }
        if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
            riRequestBuilder.iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(this.getIamInstanceProfile()).build());
        }
        ArrayList<TagSpecification> tagList = new ArrayList<TagSpecification>();
        tagList.add((TagSpecification)TagSpecification.builder().tags(instTags).resourceType(ResourceType.INSTANCE).build());
        tagList.add((TagSpecification)TagSpecification.builder().tags(instTags).resourceType(ResourceType.VOLUME).build());
        tagList.add((TagSpecification)TagSpecification.builder().tags(instTags).resourceType(ResourceType.NETWORK_INTERFACE).build());
        riRequestBuilder.tagSpecifications(tagList);
        if (this.metadataSupported.booleanValue()) {
            InstanceMetadataOptionsRequest.Builder instanceMetadataOptionsRequestBuilder = InstanceMetadataOptionsRequest.builder();
            instanceMetadataOptionsRequestBuilder.httpEndpoint(this.metadataEndpointEnabled != false ? InstanceMetadataEndpointState.ENABLED.toString() : InstanceMetadataEndpointState.DISABLED.toString());
            instanceMetadataOptionsRequestBuilder.httpPutResponseHopLimit(this.metadataHopsLimit == null ? EC2AbstractSlave.DEFAULT_METADATA_HOPS_LIMIT : this.metadataHopsLimit);
            instanceMetadataOptionsRequestBuilder.httpTokens(this.metadataTokensRequired != false ? HttpTokensState.REQUIRED.toString() : HttpTokensState.OPTIONAL.toString());
            riRequestBuilder.metadataOptions((InstanceMetadataOptionsRequest)instanceMetadataOptionsRequestBuilder.build());
        }
        if (this.enclaveEnabled.booleanValue()) {
            EnclaveOptionsRequest.Builder enclaveOptionsRequestBuilder = EnclaveOptionsRequest.builder().enabled(Boolean.valueOf(true));
            riRequestBuilder.enclaveOptions((EnclaveOptionsRequest)enclaveOptionsRequestBuilder.build());
        }
        HashMap<RunInstancesRequest, List<Filter>> ret = new HashMap<RunInstancesRequest, List<Filter>>();
        ret.put((RunInstancesRequest)riRequestBuilder.build(), diFilters);
        return ret;
    }

    @Deprecated
    HashMap<RunInstancesRequest, List<Filter>> makeRunInstancesRequestAndFilters(int number, Ec2Client ec2, boolean rotateSubnet) throws IOException {
        return this.makeRunInstancesRequestAndFilters(this.getImage(), number, ec2, rotateSubnet);
    }

    private List<EC2AbstractSlave> provisionOndemand(Image image, int number, EnumSet<ProvisionOptions> provisionOptions) throws IOException {
        return this.provisionOndemand(image, number, provisionOptions, false, false);
    }

    private List<EC2AbstractSlave> provisionOndemand(Image image, int number, EnumSet<ProvisionOptions> provisionOptions, boolean spotWithoutBidPrice, boolean fallbackSpotToOndemand) throws IOException {
        ArrayList<Object> newInstances;
        Ec2Client ec2 = this.getParent().connect();
        this.logProvisionInfo("Considering launching");
        HashMap<RunInstancesRequest, List<Filter>> runInstancesRequestFilterMap = this.makeRunInstancesRequestAndFilters(image, number, ec2);
        Map.Entry<RunInstancesRequest, List<Filter>> entry = runInstancesRequestFilterMap.entrySet().iterator().next();
        RunInstancesRequest riRequest = entry.getKey();
        List<Filter> diFilters = entry.getValue();
        DescribeInstancesRequest diRequest = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(diFilters).build();
        this.logProvisionInfo("Looking for existing instances with describe-instance: " + String.valueOf(diRequest));
        DescribeInstancesResponse diResult = ec2.describeInstances(diRequest);
        List<Object> orphansOrStopped = new ArrayList();
        if (!this.avoidUsingOrphanedNodes) {
            orphansOrStopped = this.findOrphansOrStopped(diResult, number);
            if (orphansOrStopped.isEmpty() && !provisionOptions.contains((Object)ProvisionOptions.FORCE_CREATE) && !provisionOptions.contains((Object)ProvisionOptions.ALLOW_CREATE)) {
                this.logProvisionInfo("No existing instance found - but cannot create new instance");
                return null;
            }
            this.wakeOrphansOrStoppedUp(ec2, orphansOrStopped);
            if (orphansOrStopped.size() == number) {
                return this.toSlaves(orphansOrStopped);
            }
        }
        RunInstancesRequest.Builder riRequestBuilder = riRequest.toBuilder();
        riRequestBuilder.maxCount(Integer.valueOf(number - orphansOrStopped.size()));
        if (spotWithoutBidPrice) {
            InstanceMarketOptionsRequest.Builder instanceMarketOptionsRequestBuilder = InstanceMarketOptionsRequest.builder().marketType(MarketType.SPOT);
            if (this.getSpotBlockReservationDuration() != 0) {
                SpotMarketOptions spotOptions = (SpotMarketOptions)SpotMarketOptions.builder().blockDurationMinutes(Integer.valueOf(this.getSpotBlockReservationDuration() * 60)).build();
                instanceMarketOptionsRequestBuilder.spotOptions(spotOptions);
            }
            riRequestBuilder.instanceMarketOptions((InstanceMarketOptionsRequest)instanceMarketOptionsRequestBuilder.build());
            try {
                newInstances = new ArrayList(ec2.runInstances((RunInstancesRequest)riRequestBuilder.build()).instances());
            }
            catch (Ec2Exception e) {
                if (fallbackSpotToOndemand && "InsufficientInstanceCapacity".equals(e.awsErrorDetails().errorCode())) {
                    this.logProvisionInfo("There is no spot capacity available matching your request, falling back to on-demand instance.");
                    riRequestBuilder.instanceMarketOptions((InstanceMarketOptionsRequest)instanceMarketOptionsRequestBuilder.build());
                    newInstances = new ArrayList(ec2.runInstances((RunInstancesRequest)riRequestBuilder.build()).instances());
                }
                throw e;
            }
        } else {
            try {
                newInstances = new ArrayList<Instance>(ec2.runInstances((RunInstancesRequest)riRequestBuilder.build()).instances());
            }
            catch (Ec2Exception e) {
                this.logProvisionInfo("Jenkins attempted to reserve " + riRequest.maxCount() + " instances and received this EC2 exception: " + e.getMessage());
                throw e;
            }
        }
        if (newInstances.isEmpty()) {
            this.logProvisionInfo("No new instances were created");
        }
        newInstances.addAll(orphansOrStopped);
        return this.toSlaves(newInstances);
    }

    void wakeOrphansOrStoppedUp(Ec2Client ec2, List<Instance> orphansOrStopped) {
        ArrayList<String> instances = new ArrayList<String>();
        for (Instance instance : orphansOrStopped) {
            if (instance.state().name().equals((Object)InstanceStateName.STOPPING) || instance.state().name().equals((Object)InstanceStateName.STOPPED)) {
                this.logProvisionInfo("Found stopped instances - will start it: " + String.valueOf(instance));
                instances.add(instance.instanceId());
                continue;
            }
            this.logProvisionInfo("Found existing pending or running: " + String.valueOf(instance.state().name()) + " instance: " + String.valueOf(instance));
        }
        if (!instances.isEmpty()) {
            StartInstancesRequest siRequest = (StartInstancesRequest)StartInstancesRequest.builder().instanceIds(instances).build();
            StartInstancesResponse siResult = ec2.startInstances(siRequest);
            this.logProvisionInfo("Result of starting stopped instances:" + String.valueOf(siResult));
        }
    }

    List<EC2AbstractSlave> toSlaves(List<Instance> newInstances) throws IOException {
        try {
            ArrayList<EC2AbstractSlave> slaves = new ArrayList<EC2AbstractSlave>(newInstances.size());
            for (Instance instance : newInstances) {
                slaves.add(this.newOndemandSlave(instance));
                this.logProvisionInfo("Return instance: " + String.valueOf(instance));
            }
            return slaves;
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError((Object)e);
        }
    }

    List<Instance> findOrphansOrStopped(DescribeInstancesResponse diResult, int number) {
        ArrayList<Instance> orphansOrStopped = new ArrayList<Instance>();
        int count = 0;
        for (Reservation reservation : diResult.reservations()) {
            for (Instance instance : reservation.instances()) {
                if (!this.isSameIamInstanceProfile(instance)) {
                    this.logInstanceCheck(instance, ". false - IAM Instance profile does not match: " + String.valueOf(instance.iamInstanceProfile()));
                    continue;
                }
                if (this.isTerminatingOrShuttindDown(instance.state().name())) {
                    this.logInstanceCheck(instance, ". false - Instance is terminated or shutting down");
                    continue;
                }
                if (this.checkInstance(instance)) {
                    this.logProvisionInfo("Found existing instance: " + String.valueOf(instance));
                    orphansOrStopped.add(instance);
                    ++count;
                }
                if (count != number) continue;
                return orphansOrStopped;
            }
        }
        return orphansOrStopped;
    }

    private void setupRootDevice(Image image, List<BlockDeviceMapping> deviceMappings) {
        if (!DeviceType.EBS.equals((Object)image.rootDeviceType())) {
            return;
        }
        if (deviceMappings.isEmpty()) {
            LOGGER.warning("AMI missing block devices");
            return;
        }
        BlockDeviceMapping rootMapping = deviceMappings.get(0);
        LOGGER.info("AMI had " + rootMapping.deviceName());
        LOGGER.info(rootMapping.ebs().toString());
        BlockDeviceMapping.Builder newRootMappingBuilder = rootMapping.toBuilder();
        EbsBlockDevice.Builder newRootDeviceBuilder = rootMapping.ebs().toBuilder();
        if (this.deleteRootOnTermination) {
            newRootDeviceBuilder.deleteOnTermination(Boolean.TRUE);
            for (BlockDeviceMapping mapping : image.blockDeviceMappings()) {
                LOGGER.info("Request had " + mapping.deviceName());
                if (!rootMapping.deviceName().equals(mapping.deviceName())) continue;
                newRootMappingBuilder.ebs((EbsBlockDevice)newRootDeviceBuilder.build());
                deviceMappings.remove(0);
                deviceMappings.add(0, (BlockDeviceMapping)newRootMappingBuilder.build());
            }
        }
        newRootDeviceBuilder.encrypted(this.ebsEncryptRootVolume.getValue());
        String message = String.format("EBS default encryption value set to: %s (%s)", this.ebsEncryptRootVolume.getDisplayText(), this.ebsEncryptRootVolume.getValue());
        this.logProvisionInfo(message);
        newRootMappingBuilder.ebs((EbsBlockDevice)newRootDeviceBuilder.build());
        deviceMappings.add(0, (BlockDeviceMapping)newRootMappingBuilder.build());
    }

    private List<BlockDeviceMapping> getNewEphemeralDeviceMapping(Image image) {
        List oldDeviceMapping = image.blockDeviceMappings();
        HashSet<String> occupiedDevices = new HashSet<String>();
        for (BlockDeviceMapping mapping : oldDeviceMapping) {
            occupiedDevices.add(mapping.deviceName());
        }
        ArrayList<String> available = new ArrayList<String>(Arrays.asList("ephemeral0", "ephemeral1", "ephemeral2", "ephemeral3"));
        ArrayList<BlockDeviceMapping> newDeviceMapping = new ArrayList<BlockDeviceMapping>(4);
        for (char suffix = 'b'; suffix <= 'z' && !available.isEmpty(); suffix = (char)(suffix + '\u0001')) {
            String deviceName = String.format("/dev/xvd%s", Character.valueOf(suffix));
            if (occupiedDevices.contains(deviceName)) continue;
            BlockDeviceMapping newMapping = (BlockDeviceMapping)BlockDeviceMapping.builder().deviceName(deviceName).virtualName((String)available.get(0)).build();
            newDeviceMapping.add(newMapping);
            available.remove(0);
        }
        return newDeviceMapping;
    }

    private void setupEphemeralDeviceMapping(Image image, List<BlockDeviceMapping> deviceMappings) {
        deviceMappings.addAll(this.getNewEphemeralDeviceMapping(image));
    }

    @NonNull
    private static List<String> makeImageAttributeList(@CheckForNull String attr) {
        return Stream.of(Util.tokenize((String)Util.fixNull((String)attr))).collect(Collectors.toList());
    }

    @NonNull
    private DescribeImagesRequest makeDescribeImagesRequest() throws SdkException {
        List<Filter> filters;
        List<String> users;
        List<String> owners;
        List<Object> imageIds = Util.fixEmptyAndTrim((String)this.ami) == null ? Collections.emptyList() : Collections.singletonList(this.ami);
        int numAttrs = Stream.of(imageIds, owners = SlaveTemplate.makeImageAttributeList(this.amiOwners), users = SlaveTemplate.makeImageAttributeList(this.amiUsers), filters = EC2Filter.toFilterList(this.amiFilters)).mapToInt(List::size).sum();
        if (numAttrs == 0) {
            throw SdkException.builder().message("Neither AMI ID nor AMI search attributes provided").build();
        }
        return (DescribeImagesRequest)DescribeImagesRequest.builder().imageIds(imageIds).owners(owners).executableUsers(users).filters(filters).build();
    }

    @NonNull
    private Image getImage() throws SdkException {
        DescribeImagesRequest request = this.makeDescribeImagesRequest();
        LOGGER.info("Getting image for request " + String.valueOf(request));
        ArrayList<Image> images = new ArrayList<Image>(this.getParent().connect().describeImages(request).images());
        if (images.isEmpty()) {
            throw SdkException.builder().message("Unable to find image for request " + String.valueOf(request)).build();
        }
        images.sort(Comparator.comparing(Image::creationDate).reversed());
        return (Image)images.get(0);
    }

    private void setupCustomDeviceMapping(List<BlockDeviceMapping> deviceMappings) {
        if (StringUtils.isNotBlank((String)this.customDeviceMapping)) {
            deviceMappings.addAll(DeviceMappingParser.parse(this.customDeviceMapping));
        }
    }

    private List<EC2AbstractSlave> provisionSpot(Image image, int number, EnumSet<ProvisionOptions> provisionOptions) throws IOException {
        if (!this.spotConfig.useBidPrice) {
            return this.provisionOndemand(image, 1, provisionOptions, true, this.spotConfig.getFallbackToOndemand());
        }
        Ec2Client ec2 = this.getParent().connect();
        String imageId = image.imageId();
        try {
            RequestSpotInstancesResponse reqResult;
            LOGGER.info("Launching " + imageId + " for template " + this.description);
            KeyPair keyPair = this.getKeyPair(ec2);
            RequestSpotInstancesRequest.Builder spotRequestBuilder = RequestSpotInstancesRequest.builder();
            if (this.getSpotMaxBidPrice() == null) {
                throw SdkException.builder().message("Invalid Spot price specified: " + this.getSpotMaxBidPrice()).build();
            }
            spotRequestBuilder.spotPrice(this.getSpotMaxBidPrice());
            spotRequestBuilder.instanceCount(Integer.valueOf(number));
            RequestSpotLaunchSpecification.Builder launchSpecificationBuilder = RequestSpotLaunchSpecification.builder();
            launchSpecificationBuilder.imageId(imageId);
            launchSpecificationBuilder.instanceType(this.type);
            launchSpecificationBuilder.ebsOptimized(Boolean.valueOf(this.ebsOptimized));
            launchSpecificationBuilder.monitoring((RunInstancesMonitoringEnabled)RunInstancesMonitoringEnabled.builder().enabled(Boolean.valueOf(this.monitoring)).build());
            if (StringUtils.isNotBlank((String)this.getZone())) {
                SpotPlacement placement = (SpotPlacement)SpotPlacement.builder().availabilityZone(this.getZone()).build();
                launchSpecificationBuilder.placement(placement);
            }
            InstanceNetworkInterfaceSpecification.Builder netBuilder = InstanceNetworkInterfaceSpecification.builder();
            String subnetId = this.chooseSubnetId();
            LOGGER.log(Level.FINE, () -> String.format("Chose subnetId %s", subnetId));
            if (StringUtils.isNotBlank((String)subnetId)) {
                netBuilder.subnetId(subnetId);
                if (!this.securityGroupSet.isEmpty() && !(groupIds = this.getEc2SecurityGroups(ec2)).isEmpty()) {
                    netBuilder.groups(groupIds);
                }
            } else if (!this.securityGroupSet.isEmpty()) {
                groupIds = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2).securityGroups().stream().map(SecurityGroup::groupId).collect(Collectors.toList());
                netBuilder.groups(groupIds);
            }
            String userDataString = Base64.getEncoder().encodeToString(this.userData.getBytes(StandardCharsets.UTF_8));
            launchSpecificationBuilder.userData(userDataString);
            launchSpecificationBuilder.keyName(keyPair.getKeyPairInfo().keyName());
            launchSpecificationBuilder.instanceType(this.type);
            switch (this.getAssociateIPStrategy()) {
                case PUBLIC_IP: {
                    netBuilder.associatePublicIpAddress(Boolean.valueOf(true));
                    break;
                }
                case PRIVATE_IP: 
                case DEFAULT: {
                    netBuilder.associatePublicIpAddress(Boolean.valueOf(false));
                    break;
                }
            }
            netBuilder.deviceIndex(Integer.valueOf(0));
            launchSpecificationBuilder.networkInterfaces(new InstanceNetworkInterfaceSpecification[]{(InstanceNetworkInterfaceSpecification)netBuilder.build()});
            HashSet<Tag> instTags = this.buildTags("spot");
            if (StringUtils.isNotBlank((String)this.getIamInstanceProfile())) {
                launchSpecificationBuilder.iamInstanceProfile((IamInstanceProfileSpecification)IamInstanceProfileSpecification.builder().arn(this.getIamInstanceProfile()).build());
            }
            launchSpecificationBuilder.blockDeviceMappings(this.getBlockDeviceMappings(image));
            spotRequestBuilder.launchSpecification((RequestSpotLaunchSpecification)launchSpecificationBuilder.build());
            if (this.getSpotBlockReservationDuration() != 0) {
                spotRequestBuilder.blockDurationMinutes(Integer.valueOf(this.getSpotBlockReservationDuration() * 60));
            }
            try {
                reqResult = ec2.requestSpotInstances((RequestSpotInstancesRequest)spotRequestBuilder.build());
            }
            catch (Ec2Exception e) {
                if (this.spotConfig.getFallbackToOndemand() && "MaxSpotInstanceCountExceeded".equals(e.awsErrorDetails().errorCode())) {
                    this.logProvisionInfo("There is no spot capacity available matching your request, falling back to on-demand instance.");
                    return this.provisionOndemand(image, number, provisionOptions);
                }
                throw e;
            }
            List reqInstances = reqResult.spotInstanceRequests();
            if (reqInstances.isEmpty()) {
                throw SdkException.builder().message("No spot instances found").build();
            }
            ArrayList<EC2AbstractSlave> slaves = new ArrayList<EC2AbstractSlave>(reqInstances.size());
            for (SpotInstanceRequest spotInstReq : reqInstances) {
                if (spotInstReq == null) {
                    throw SdkException.builder().message("Spot instance request is null").build();
                }
                String slaveName = spotInstReq.spotInstanceRequestId();
                if (this.spotConfig.getFallbackToOndemand()) {
                    for (int i = 0; i < 2 && spotInstReq.status().code().equals("pending-evaluation"); ++i) {
                        LOGGER.info("Spot request " + slaveName + " is still pending evaluation");
                        Thread.sleep(5000L);
                        LOGGER.info("Fetching info about spot request " + slaveName);
                        DescribeSpotInstanceRequestsRequest describeRequest = (DescribeSpotInstanceRequestsRequest)DescribeSpotInstanceRequestsRequest.builder().spotInstanceRequestIds(new String[]{slaveName}).build();
                        spotInstReq = (SpotInstanceRequest)ec2.describeSpotInstanceRequests(describeRequest).spotInstanceRequests().get(0);
                    }
                    List<String> spotRequestBadCodes = Arrays.asList("capacity-not-available", "capacity-oversubscribed", "price-too-low");
                    if (spotRequestBadCodes.contains(spotInstReq.status().code())) {
                        LOGGER.info("There is no spot capacity available matching your request, falling back to on-demand instance.");
                        List requestsToCancel = reqInstances.stream().map(SpotInstanceRequest::spotInstanceRequestId).collect(Collectors.toList());
                        CancelSpotInstanceRequestsRequest cancelRequest = (CancelSpotInstanceRequestsRequest)CancelSpotInstanceRequestsRequest.builder().spotInstanceRequestIds(requestsToCancel).build();
                        ec2.cancelSpotInstanceRequests(cancelRequest);
                        return this.provisionOndemand(image, number, provisionOptions);
                    }
                }
                this.updateRemoteTags(ec2, instTags, "InvalidSpotInstanceRequestID.NotFound", spotInstReq.spotInstanceRequestId());
                SpotInstanceRequest.Builder spotInstReqBuilder = spotInstReq.toBuilder();
                spotInstReqBuilder.tags(instTags);
                LOGGER.info("Spot instance id in provision: " + spotInstReq.spotInstanceRequestId());
                slaves.add(this.newSpotSlave((SpotInstanceRequest)spotInstReqBuilder.build()));
            }
            return slaves;
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    private List<BlockDeviceMapping> getBlockDeviceMappings(Image image) {
        ArrayList<BlockDeviceMapping> newMappings = new ArrayList<BlockDeviceMapping>(image.blockDeviceMappings());
        this.setupRootDevice(image, newMappings);
        if (this.useEphemeralDevices) {
            newMappings.addAll(this.getNewEphemeralDeviceMapping(image));
        } else if (StringUtils.isNotBlank((String)this.customDeviceMapping)) {
            newMappings.addAll(DeviceMappingParser.parse(this.customDeviceMapping));
        }
        return newMappings;
    }

    private HashSet<Tag> buildTags(String slaveType) {
        boolean hasCustomTypeTag = false;
        boolean hasJenkinsServerUrlTag = false;
        HashSet<Tag> instTags = new HashSet<Tag>();
        if (this.tags != null && !this.tags.isEmpty()) {
            for (EC2Tag t : this.tags) {
                instTags.add((Tag)Tag.builder().key(t.getName()).value(t.getValue()).build());
                if (StringUtils.equals((String)t.getName(), (String)"jenkins_slave_type")) {
                    hasCustomTypeTag = true;
                }
                if (!StringUtils.equals((String)t.getName(), (String)"jenkins_server_url")) continue;
                hasJenkinsServerUrlTag = true;
            }
        }
        if (!hasCustomTypeTag) {
            instTags.add((Tag)Tag.builder().key("jenkins_slave_type").value(EC2Cloud.getSlaveTypeTagValue(slaveType, this.description)).build());
        }
        JenkinsLocationConfiguration jenkinsLocation = JenkinsLocationConfiguration.get();
        if (!hasJenkinsServerUrlTag && jenkinsLocation.getUrl() != null) {
            instTags.add((Tag)Tag.builder().key("jenkins_server_url").value(jenkinsLocation.getUrl()).build());
        }
        if (this.parent != null && StringUtils.isNotBlank((String)this.parent.name)) {
            instTags.add((Tag)Tag.builder().key("jenkins_cloud_name").value(this.parent.name).build());
        }
        return instTags;
    }

    protected EC2OndemandSlave newOndemandSlave(Instance inst) throws Descriptor.FormException, IOException {
        EC2AgentConfig.OnDemand config = ((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)((EC2AgentConfig.OnDemandBuilder)new EC2AgentConfig.OnDemandBuilder().withName(this.getSlaveName(inst.instanceId()))).withInstanceId(inst.instanceId()).withDescription(this.description)).withRemoteFS(this.remoteFS)).withNumExecutors(this.getNumExecutors())).withLabelString(this.labels)).withMode(this.mode)).withInitScript(this.initScript)).withTmpDir(this.tmpDir)).withNodeProperties(this.nodeProperties.toList())).withRemoteAdmin(this.remoteAdmin)).withJavaPath(this.javaPath)).withJvmopts(this.jvmopts)).withStopOnTerminate(this.stopOnTerminate).withIdleTerminationMinutes(this.idleTerminationMinutes)).withPublicDNS(inst.publicDnsName()).withPrivateDNS(inst.privateDnsName()).withTags((List)EC2Tag.fromAmazonTags(inst.tags()))).withCloudName(this.parent.name)).withLaunchTimeout(this.getLaunchTimeout())).withAmiType(this.amiType)).withConnectionStrategy(this.connectionStrategy)).withMaxTotalUses(this.maxTotalUses)).withTenancyAttribute(this.tenancy).withMetadataSupported(this.metadataSupported).withMetadataEndpointEnabled(this.metadataEndpointEnabled).withMetadataTokensRequired(this.metadataTokensRequired).withMetadataHopsLimit(this.metadataHopsLimit).build();
        return EC2AgentFactory.getInstance().createOnDemandAgent(config);
    }

    protected EC2SpotSlave newSpotSlave(SpotInstanceRequest sir) throws Descriptor.FormException, IOException {
        EC2AgentConfig.Spot config = ((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)((EC2AgentConfig.SpotBuilder)new EC2AgentConfig.SpotBuilder().withName(this.getSlaveName(sir.spotInstanceRequestId()))).withSpotInstanceRequestId(sir.spotInstanceRequestId()).withDescription(this.description)).withRemoteFS(this.remoteFS)).withNumExecutors(this.getNumExecutors())).withMode(this.mode)).withInitScript(this.initScript)).withTmpDir(this.tmpDir)).withLabelString(this.labels)).withNodeProperties(this.nodeProperties.toList())).withRemoteAdmin(this.remoteAdmin)).withJavaPath(this.javaPath)).withJvmopts(this.jvmopts)).withIdleTerminationMinutes(this.idleTerminationMinutes)).withTags((List)EC2Tag.fromAmazonTags(sir.tags()))).withCloudName(this.parent.name)).withLaunchTimeout(this.getLaunchTimeout())).withAmiType(this.amiType)).withConnectionStrategy(this.connectionStrategy)).withMaxTotalUses(this.maxTotalUses)).build();
        return EC2AgentFactory.getInstance().createSpotAgent(config);
    }

    @CheckForNull
    private KeyPair getKeyPair(Ec2Client ec2) throws IOException, SdkException {
        EC2PrivateKey ec2PrivateKey = this.getParent().resolvePrivateKey();
        if (ec2PrivateKey == null) {
            throw SdkException.builder().message("No keypair credential found. Please configure a credential in the Jenkins configuration.").build();
        }
        KeyPair keyPair = ec2PrivateKey.find(ec2);
        if (keyPair == null) {
            throw SdkException.builder().message("No matching keypair found on EC2. Is the EC2 private key a valid one?").build();
        }
        LOGGER.fine("found matching keypair");
        return keyPair;
    }

    private void updateRemoteTags(Ec2Client ec2, Collection<Tag> instTags, @NonNull String catchErrorCode, String ... params) throws InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                ec2.createTags((CreateTagsRequest)CreateTagsRequest.builder().resources(params).tags(instTags).build());
                break;
            }
            catch (AwsServiceException e) {
                if (catchErrorCode.equals(e.awsErrorDetails().errorCode())) {
                    Thread.sleep(5000L);
                    continue;
                }
                LOGGER.log(Level.SEVERE, e.awsErrorDetails().errorMessage(), e);
                continue;
            }
        }
    }

    private List<String> getEc2SecurityGroups(Ec2Client ec2) throws SdkException {
        LOGGER.log(Level.FINE, () -> String.format("Get security group %s for EC2Cloud %s with currentSubnetId %s", this.securityGroupSet, this.getParent().name, this.getCurrentSubnetId()));
        ArrayList<String> groupIds = new ArrayList<String>();
        DescribeSecurityGroupsResponse groupResult = this.getSecurityGroupsBy("group-name", this.securityGroupSet, ec2);
        if (groupResult.securityGroups().isEmpty()) {
            groupResult = this.getSecurityGroupsBy("group-id", this.securityGroupSet, ec2);
        }
        for (SecurityGroup group : groupResult.securityGroups()) {
            LOGGER.log(Level.FINE, () -> String.format("Checking security group %s (vpc-id = %s, subnet-id = %s)", group.groupId(), group.vpcId(), this.getCurrentSubnetId()));
            if (group.vpcId() == null || group.vpcId().isEmpty()) continue;
            ArrayList<Filter> filters = new ArrayList<Filter>();
            filters.add((Filter)Filter.builder().name("vpc-id").values(new String[]{group.vpcId()}).build());
            filters.add((Filter)Filter.builder().name("state").values(new String[]{"available"}).build());
            filters.add((Filter)Filter.builder().name("subnet-id").values(new String[]{this.getCurrentSubnetId()}).build());
            DescribeSubnetsResponse subnetResult = ec2.describeSubnets((DescribeSubnetsRequest)DescribeSubnetsRequest.builder().filters(filters).build());
            List subnets = subnetResult.subnets();
            if (subnets == null || subnets.isEmpty()) continue;
            LOGGER.log(Level.FINE, () -> "Adding security group");
            groupIds.add(group.groupId());
        }
        if (this.securityGroupSet.size() != groupIds.size()) {
            throw SdkException.builder().message("Security groups must all be VPC security groups to work in a VPC context").build();
        }
        return groupIds;
    }

    private DescribeSecurityGroupsResponse getSecurityGroupsBy(String filterName, Set<String> filterValues, Ec2Client ec2) {
        DescribeSecurityGroupsRequest groupReq = (DescribeSecurityGroupsRequest)DescribeSecurityGroupsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name(filterName).values(filterValues).build()}).build();
        return ec2.describeSecurityGroups(groupReq);
    }

    public EC2AbstractSlave attach(String instanceId, TaskListener listener) throws SdkException, IOException {
        PrintStream logger = listener.getLogger();
        Ec2Client ec2 = this.getParent().connect();
        try {
            logger.println("Attaching to " + instanceId);
            LOGGER.info("Attaching to " + instanceId);
            DescribeInstancesRequest request = (DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(Collections.singletonList(instanceId)).build();
            Instance inst = (Instance)((Reservation)ec2.describeInstances(request).reservations().get(0)).instances().get(0);
            return this.newOndemandSlave(inst);
        }
        catch (Descriptor.FormException e) {
            throw new AssertionError();
        }
    }

    protected Object readResolve() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            j.checkPermission(Jenkins.ADMINISTER);
        }
        this.securityGroupSet = this.parseSecurityGroups();
        if (this.instanceCap == 0) {
            this.instanceCap = Integer.MAX_VALUE;
        }
        if (this.amiType == null) {
            this.amiType = new UnixData(this.rootCommandPrefix, this.slaveCommandPrefix, this.slaveCommandSuffix, this.sshPort, null);
        }
        if (this.type != null && !this.type.isEmpty()) {
            this.type = InstanceTypeCompat.of(this.type).toString();
        }
        if (this.associateIPStrategy == null) {
            this.associateIPStrategy = AssociateIPStrategy.backwardsCompatible(this.associatePublicIp);
        }
        if (this.connectionStrategy == null) {
            this.connectionStrategy = ConnectionStrategy.backwardsCompatible(this.usePrivateDnsName, this.connectUsingPublicIp, AssociateIPStrategy.PUBLIC_IP == this.associateIPStrategy);
        }
        if (this.maxTotalUses == 0) {
            this.maxTotalUses = -1;
        }
        if (this.nodeProperties == null) {
            this.nodeProperties = new DescribableList(Saveable.NOOP);
        }
        if (this.tenancy == null) {
            this.tenancy = Tenancy.Default;
        }
        if (this.useDedicatedTenancy) {
            this.tenancy = Tenancy.Dedicated;
        }
        if (this.ebsEncryptRootVolume == null) {
            this.ebsEncryptRootVolume = EbsEncryptRootVolume.DEFAULT;
        }
        if (this.metadataSupported == null) {
            this.metadataSupported = EC2AbstractSlave.DEFAULT_METADATA_ENDPOINT_ENABLED;
        }
        if (this.metadataEndpointEnabled == null) {
            this.metadataEndpointEnabled = EC2AbstractSlave.DEFAULT_METADATA_ENDPOINT_ENABLED;
        }
        if (this.metadataTokensRequired == null) {
            this.metadataTokensRequired = EC2AbstractSlave.DEFAULT_METADATA_TOKENS_REQUIRED;
        }
        if (this.metadataHopsLimit == null) {
            this.metadataHopsLimit = EC2AbstractSlave.DEFAULT_METADATA_HOPS_LIMIT;
        }
        if (StringUtils.isBlank((String)this.javaPath)) {
            this.javaPath = "java";
        }
        if (this.enclaveEnabled == null) {
            this.enclaveEnabled = EC2AbstractSlave.DEFAULT_ENCLAVE_ENABLED;
        }
        return this;
    }

    public Descriptor<SlaveTemplate> getDescriptor() {
        return Jenkins.get().getDescriptor(this.getClass());
    }

    public int getLaunchTimeout() {
        return this.launchTimeout <= 0 ? Integer.MAX_VALUE : this.launchTimeout;
    }

    public String getLaunchTimeoutStr() {
        if (this.launchTimeout == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.launchTimeout);
    }

    public boolean isWindowsSlave() {
        return this.amiType.isWindows();
    }

    public boolean isUnixSlave() {
        return this.amiType.isUnix();
    }

    public boolean isMacAgent() {
        return this.amiType.isMac();
    }

    public boolean isSSHAgent() {
        return this.amiType.isSSHAgent();
    }

    public boolean isWinRMAgent() {
        return this.amiType.isWinRMAgent();
    }

    public Secret getAdminPassword() {
        return this.amiType.isWinRMAgent() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWinRMAgent() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    DescribeInstancesResponse getDescribeInstanceResult(Ec2Client ec2, boolean allSubnets) throws IOException {
        HashMap<RunInstancesRequest, List<Filter>> runInstancesRequestFilterMap = this.makeRunInstancesRequestAndFilters(this.getImage(), 1, ec2, false);
        Map.Entry<RunInstancesRequest, List<Filter>> entry = runInstancesRequestFilterMap.entrySet().iterator().next();
        List<Filter> diFilters = entry.getValue();
        if (allSubnets) {
            ArrayList<Filter> rmvFilters = new ArrayList<Filter>();
            for (Filter f : diFilters) {
                if (!f.name().equals("subnet-id")) continue;
                rmvFilters.add(f);
            }
            for (Filter f : rmvFilters) {
                diFilters.remove(f);
            }
            Filter subnetFilter = (Filter)Filter.builder().name("subnet-id").values(Arrays.asList(this.getSubnetId().split(EC2_RESOURCE_ID_DELIMETERS))).build();
            diFilters.add(subnetFilter);
        }
        DescribeInstancesRequest diRequest = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(diFilters).build();
        return ec2.describeInstances(diRequest);
    }

    public boolean isAllowSelfSignedCertificate() {
        return this.amiType.isWinRMAgent() && ((WindowsData)this.amiType).isAllowSelfSignedCertificate();
    }

    public static enum ProvisionOptions {
        ALLOW_CREATE,
        FORCE_CREATE;

    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<SlaveTemplate> {
        public String getDisplayName() {
            return "";
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.get().getDescriptorList(AMITypeData.class);
        }

        public String getHelpFile(String fieldName) {
            String p = super.getHelpFile(fieldName);
            if (p != null) {
                return p;
            }
            Descriptor slaveDescriptor = Jenkins.get().getDescriptor(EC2OndemandSlave.class);
            if (slaveDescriptor != null && (p = slaveDescriptor.getHelpFile(fieldName)) != null) {
                return p;
            }
            slaveDescriptor = Jenkins.get().getDescriptor(EC2SpotSlave.class);
            if (slaveDescriptor != null) {
                return slaveDescriptor.getHelpFile(fieldName);
            }
            return null;
        }

        @Restricted(value={NoExternalUse.class})
        @POST
        public FormValidation doCheckDescription(@QueryParameter String value) {
            try {
                Jenkins.checkGoodName((String)value);
                return FormValidation.ok();
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        @RequirePOST
        public FormValidation doValidateType(@QueryParameter String value) {
            software.amazon.awssdk.services.ec2.model.InstanceType instanceType = software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)value);
            if (instanceType == software.amazon.awssdk.services.ec2.model.InstanceType.UNKNOWN_TO_SDK_VERSION) {
                return FormValidation.error((String)"Instance type unknown to SDK version");
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doValidateAmi(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String altEC2Endpoint, @QueryParameter String ami, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException {
            this.checkPermission(EC2Cloud.PROVISION);
            AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            Ec2Client ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.parseRegion(region), EC2Cloud.parseEndpoint(altEC2Endpoint));
            try {
                Image img = CloudHelper.getAmiImage(ec2, ami);
                if (img == null) {
                    return FormValidation.error((String)("No such AMI, or not usable with this accessId: " + ami));
                }
                String ownerAlias = img.imageOwnerAlias();
                return FormValidation.ok((String)(img.imageLocation() + (String)(ownerAlias != null ? " by " + ownerAlias : "")));
            }
            catch (SdkException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }

        private void checkPermission(Permission p) {
            EC2Cloud ancestorObject = (EC2Cloud)((Object)Stapler.getCurrentRequest2().findAncestorObject(EC2Cloud.class));
            if (ancestorObject != null) {
                ancestorObject.checkPermission(p);
            } else {
                Jenkins.get().checkPermission(p);
            }
        }

        @POST
        public FormValidation doCheckLabelString(@QueryParameter String value, @QueryParameter Node.Mode mode) {
            if (mode == Node.Mode.EXCLUSIVE && (value == null || value.trim().isEmpty())) {
                return FormValidation.warning((String)"You may want to assign labels to this node; it's marked to only run jobs that are exclusively tied to itself or a label.");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckIdleTerminationMinutes(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= -59) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Idle Termination time must be a greater than -59 (or null)");
        }

        @POST
        public FormValidation doCheckMaxTotalUses(@QueryParameter String value) {
            try {
                int val = Integer.parseInt(value);
                if (val >= -1) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Maximum Total Uses must be greater or equal to -1");
        }

        @POST
        public FormValidation doCheckMinimumNumberOfInstances(@QueryParameter String value, @QueryParameter String instanceCapStr) {
            block6: {
                if (value == null || value.trim().isEmpty()) {
                    return FormValidation.ok();
                }
                try {
                    int instanceCap;
                    int val = Integer.parseInt(value);
                    if (val < 0) break block6;
                    try {
                        instanceCap = Integer.parseInt(instanceCapStr);
                    }
                    catch (NumberFormatException ignore) {
                        instanceCap = Integer.MAX_VALUE;
                    }
                    if (val > instanceCap) {
                        return FormValidation.error((String)"Minimum number of instances must not be larger than AMI Instance Cap %d", (Object[])new Object[]{instanceCap});
                    }
                    return FormValidation.ok();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return FormValidation.error((String)"Minimum number of instances must be a non-negative integer (or null)");
        }

        @POST
        public FormValidation doCheckMinimumNoInstancesActiveTimeRangeFrom(@QueryParameter String value) {
            try {
                MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Please enter value in format 'h:mm a' or 'HH:mm'");
            }
        }

        @POST
        public FormValidation doCheckMinimumNoInstancesActiveTimeRangeTo(@QueryParameter String value) {
            try {
                MinimumNumberOfInstancesTimeRangeConfig.validateLocalTimeString(value);
                return FormValidation.ok();
            }
            catch (IllegalArgumentException e) {
                return FormValidation.error((String)"Please enter value in format 'h:mm a' or 'HH:mm'");
            }
        }

        @POST
        public FormValidation doCheckMonday(@QueryParameter boolean monday, @QueryParameter boolean tuesday, @QueryParameter boolean wednesday, @QueryParameter boolean thursday, @QueryParameter boolean friday, @QueryParameter boolean saturday, @QueryParameter boolean sunday) {
            if (!(monday || tuesday || wednesday || thursday || friday || saturday || sunday)) {
                return FormValidation.warning((String)"At least one day should be checked or minimum number of instances won't be active");
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckMinimumNumberOfSpareInstances(@QueryParameter String value, @QueryParameter String instanceCapStr) {
            block6: {
                if (value == null || value.trim().isEmpty()) {
                    return FormValidation.ok();
                }
                try {
                    int instanceCap;
                    int val = Integer.parseInt(value);
                    if (val < 0) break block6;
                    try {
                        instanceCap = Integer.parseInt(instanceCapStr);
                    }
                    catch (NumberFormatException ignore) {
                        instanceCap = Integer.MAX_VALUE;
                    }
                    if (val > instanceCap) {
                        return FormValidation.error((String)"Minimum number of spare instances must not be larger than AMI Instance Cap %d", (Object[])new Object[]{instanceCap});
                    }
                    return FormValidation.ok();
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return FormValidation.error((String)"Minimum number of spare instances must be a non-negative integer (or null)");
        }

        @POST
        public FormValidation doCheckInstanceCapStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val > 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"InstanceCap must be a non-negative integer (or null)");
        }

        @POST
        public FormValidation doCheckSpotBlockReservationDurationStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= 0 && val <= 6) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Spot Block Reservation Duration must be an integer between 0 & 6");
        }

        @POST
        public FormValidation doCheckLaunchTimeoutStr(@QueryParameter String value) {
            if (value == null || value.trim().isEmpty()) {
                return FormValidation.ok();
            }
            try {
                int val = Integer.parseInt(value);
                if (val >= 0) {
                    return FormValidation.ok();
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return FormValidation.error((String)"Launch Timeout must be a non-negative integer (or null)");
        }

        @RequirePOST
        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException, ServletException {
            this.checkPermission(EC2Cloud.PROVISION);
            AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public String getDefaultTenancy() {
            return Tenancy.Default.name();
        }

        @POST
        public FormValidation doCheckSpotMaxBidPrice(@QueryParameter String spotMaxBidPrice) {
            if (SpotConfiguration.normalizeBid(spotMaxBidPrice) != null) {
                return FormValidation.ok();
            }
            return FormValidation.error((String)"Not a correct bid price");
        }

        public String getDefaultConnectionStrategy() {
            return ConnectionStrategy.PRIVATE_IP.name();
        }

        public List<NodePropertyDescriptor> getNodePropertyDescriptors() {
            return NodePropertyDescriptor.for_((List)NodeProperty.all(), EC2AbstractSlave.class);
        }

        @RequirePOST
        public ListBoxModel doFillTypeItems(@QueryParameter String type) {
            ListBoxModel items = new ListBoxModel();
            List knownValues = software.amazon.awssdk.services.ec2.model.InstanceType.knownValues().stream().map(software.amazon.awssdk.services.ec2.model.InstanceType::toString).sorted().collect(Collectors.toList());
            for (String value : knownValues) {
                items.add((Object)new ListBoxModel.Option(value, value, Objects.equals(value, type)));
            }
            return items;
        }

        @POST
        public ListBoxModel doFillConnectionStrategyItems(@QueryParameter String connectionStrategy) {
            return Stream.of(ConnectionStrategy.values()).map(v -> {
                if (v.name().equals(connectionStrategy)) {
                    return new ListBoxModel.Option(v.getDisplayText(), v.name(), true);
                }
                return new ListBoxModel.Option(v.getDisplayText(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        @POST
        public FormValidation doCheckConnectionStrategy(@QueryParameter String connectionStrategy) {
            return Stream.of(ConnectionStrategy.values()).filter(v -> v.name().equals(connectionStrategy)).findFirst().map(s -> FormValidation.ok()).orElse(FormValidation.error((String)"Could not find selected connection strategy"));
        }

        @POST
        public ListBoxModel doFillAssociateIPStrategyItems(@QueryParameter String associateIPStrategy) {
            this.checkPermission(EC2Cloud.PROVISION);
            return Stream.of(AssociateIPStrategy.values()).map(v -> {
                if (v.name().equals(associateIPStrategy)) {
                    return new ListBoxModel.Option(v.getDisplayText(), v.name(), true);
                }
                return new ListBoxModel.Option(v.getDisplayText(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        @POST
        public FormValidation doCheckAssociateIPStrategy(@QueryParameter String associateIPStrategy) {
            this.checkPermission(EC2Cloud.PROVISION);
            return Stream.of(AssociateIPStrategy.values()).filter(v -> v.name().equals(associateIPStrategy)).findFirst().map(s -> FormValidation.ok()).orElse(FormValidation.error((String)"Could not find selected associate IP strategy"));
        }

        public String getDefaultAssociateIPStrategy() {
            return AssociateIPStrategy.DEFAULT.name();
        }

        public String getDefaultHostKeyVerificationStrategy() {
            return HostKeyVerificationStrategyEnum.CHECK_NEW_HARD.name();
        }

        @POST
        public ListBoxModel doFillHostKeyVerificationStrategyItems(@QueryParameter String hostKeyVerificationStrategy) {
            return Stream.of(HostKeyVerificationStrategyEnum.values()).map(v -> {
                if (v.name().equals(hostKeyVerificationStrategy)) {
                    return new ListBoxModel.Option(v.getDisplayText(), v.name(), true);
                }
                return new ListBoxModel.Option(v.getDisplayText(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        @POST
        public FormValidation doCheckHostKeyVerificationStrategy(@QueryParameter String hostKeyVerificationStrategy) {
            Stream<HostKeyVerificationStrategyEnum> stream = Stream.of(HostKeyVerificationStrategyEnum.values());
            Stream<HostKeyVerificationStrategyEnum> filteredStream = stream.filter(v -> v.name().equals(hostKeyVerificationStrategy));
            Optional<HostKeyVerificationStrategyEnum> matched = filteredStream.findFirst();
            Optional<FormValidation> okResult = matched.map(s -> FormValidation.ok());
            return okResult.orElse(FormValidation.error((String)String.format("Could not find selected host key verification (%s)", hostKeyVerificationStrategy)));
        }

        @POST
        public ListBoxModel doFillTenancyItems(@QueryParameter String tenancy) {
            return Stream.of(Tenancy.values()).map(v -> {
                if (v.name().equals(tenancy)) {
                    return new ListBoxModel.Option(v.name(), v.name(), true);
                }
                return new ListBoxModel.Option(v.name(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        public String getDefaultEbsEncryptRootVolume() {
            return EbsEncryptRootVolume.DEFAULT.getDisplayText();
        }

        @POST
        public ListBoxModel doFillEbsEncryptRootVolumeItems(@QueryParameter String ebsEncryptRootVolume) {
            return Stream.of(EbsEncryptRootVolume.values()).map(v -> {
                if (v.name().equals(ebsEncryptRootVolume)) {
                    return new ListBoxModel.Option(v.getDisplayText(), v.name(), true);
                }
                return new ListBoxModel.Option(v.getDisplayText(), v.name(), false);
            }).collect(Collectors.toCollection(ListBoxModel::new));
        }

        @POST
        public FormValidation doEbsEncryptRootVolume(@QueryParameter String ebsEncryptRootVolume) {
            Stream<EbsEncryptRootVolume> stream = Stream.of(EbsEncryptRootVolume.values());
            Stream<EbsEncryptRootVolume> filteredStream = stream.filter(v -> v.name().equals(ebsEncryptRootVolume));
            Optional<EbsEncryptRootVolume> matched = filteredStream.findFirst();
            Optional<FormValidation> okResult = matched.map(s -> FormValidation.ok());
            return okResult.orElse(FormValidation.error((String)String.format("Could not find selected option (%s)", ebsEncryptRootVolume)));
        }

        @RequirePOST
        public FormValidation doCheckEnclaveEnabled(@QueryParameter boolean enclaveEnabled, @QueryParameter String type, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String altEC2Endpoint, @QueryParameter String roleArn, @QueryParameter String roleSessionName) {
            this.checkPermission(EC2Cloud.PROVISION);
            if (enclaveEnabled && type != null && !type.isEmpty()) {
                AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
                Ec2Client ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.parseRegion(region), EC2Cloud.parseEndpoint(altEC2Endpoint));
                DescribeInstanceTypesRequest request = (DescribeInstanceTypesRequest)DescribeInstanceTypesRequest.builder().instanceTypes(new software.amazon.awssdk.services.ec2.model.InstanceType[]{software.amazon.awssdk.services.ec2.model.InstanceType.fromValue((String)type)}).build();
                DescribeInstanceTypesResponse response = ec2.describeInstanceTypes(request);
                for (InstanceTypeInfo instanceTypeInfo : response.instanceTypes()) {
                    if (!InstanceTypeHypervisor.UNKNOWN_TO_SDK_VERSION.equals((Object)instanceTypeInfo.hypervisor()) && !InstanceTypeHypervisor.NITRO.equals((Object)instanceTypeInfo.hypervisor())) {
                        return FormValidation.error((String)"The selected instance type does not use the AWS Nitro System.");
                    }
                    if (!NitroEnclavesSupport.UNSUPPORTED.equals((Object)instanceTypeInfo.nitroEnclavesSupport())) continue;
                    return FormValidation.error((String)"The selected instance type does not support AWS Nitro Enclaves.");
                }
            }
            return FormValidation.ok();
        }
    }

    @Extension
    public static final class OnSaveListener
    extends SaveableListener {
        public void onChange(Saveable o, XmlFile file) {
            if (o instanceof Jenkins) {
                MinimumInstanceChecker.checkForMinimumInstances();
            }
        }
    }
}

