/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.thoughtworks.xstream.converters.Converter;
import hudson.Extension;
import hudson.Plugin;
import hudson.model.Describable;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AmazonEC2Cloud;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2OndemandSlave;
import hudson.plugins.ec2.InstanceTypeConverter;
import hudson.plugins.ec2.util.MinimumInstanceChecker;
import java.io.IOException;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class PluginImpl
extends Plugin
implements Describable<PluginImpl> {
    private static final Logger LOGGER = Logger.getLogger(PluginImpl.class.getName());
    private long dismissInsecureMessages;

    public void saveDismissInsecureMessages(long dismissInsecureMessages) {
        this.dismissInsecureMessages = dismissInsecureMessages;
        try {
            this.save();
        }
        catch (IOException io) {
            LOGGER.warning("There was a problem saving that you want to dismiss all messages related to insecure EC2 templates");
        }
    }

    public long getDismissInsecureMessages() {
        return this.dismissInsecureMessages;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)Jenkins.get().getDescriptorOrDie(((Object)((Object)this)).getClass());
    }

    public static PluginImpl get() {
        return (PluginImpl)Jenkins.get().getPlugin(PluginImpl.class);
    }

    public void postInitialize() throws IOException {
        Jenkins.XSTREAM.alias("hudson.plugins.ec2.EC2Cloud", AmazonEC2Cloud.class, EC2Cloud.class);
        Jenkins.XSTREAM.alias("hudson.plugins.ec2.EC2Slave", EC2OndemandSlave.class);
        Jenkins.XSTREAM.registerConverter((Converter)new InstanceTypeConverter());
        this.load();
        MinimumInstanceChecker.checkForMinimumInstances();
    }

    @Extension
    public static final class DescriptorImpl
    extends Descriptor<PluginImpl> {
        public String getDisplayName() {
            return "EC2 PluginImpl";
        }
    }
}

