/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.SSHData;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;

public class MacData
extends SSHData {
    @DataBoundConstructor
    public MacData(String rootCommandPrefix, String slaveCommandPrefix, String slaveCommandSuffix, String sshPort, String bootDelay) {
        super(rootCommandPrefix, slaveCommandPrefix, slaveCommandSuffix, sshPort, bootDelay);
    }

    @Override
    protected Object readResolve() {
        Jenkins.get().checkPermission(Jenkins.ADMINISTER);
        return this;
    }

    @Override
    public boolean isMac() {
        return true;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootCommandPrefix == null ? 0 : this.rootCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandPrefix == null ? 0 : this.slaveCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandSuffix == null ? 0 : this.slaveCommandSuffix.hashCode());
        result = 31 * result + (this.sshPort == null ? 0 : this.sshPort.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MacData other = (MacData)((Object)obj);
        if (StringUtils.isEmpty((String)this.rootCommandPrefix) ? !StringUtils.isEmpty((String)other.rootCommandPrefix) : !this.rootCommandPrefix.equals(other.rootCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandPrefix) ? !StringUtils.isEmpty((String)other.slaveCommandPrefix) : !this.slaveCommandPrefix.equals(other.slaveCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandSuffix) ? !StringUtils.isEmpty((String)other.slaveCommandSuffix) : !this.slaveCommandSuffix.equals(other.slaveCommandSuffix)) {
            return false;
        }
        return !(StringUtils.isEmpty((String)this.sshPort) ? !StringUtils.isEmpty((String)other.sshPort) : !this.sshPort.equals(other.sshPort));
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AMITypeData> {
        public String getDisplayName() {
            return "mac";
        }
    }
}

