/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class InstanceTypeConverter
implements Converter {
    private static final Map<String, InstanceType> TYPICAL_INSTANCE_TYPES = new HashMap<String, InstanceType>();

    public boolean canConvert(Class type) {
        return InstanceType.class == type;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        InstanceType instanceType = (InstanceType)source;
        writer.setValue(instanceType.name());
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        InstanceType instanceType = null;
        String stringValue = reader.getValue();
        try {
            instanceType = InstanceType.valueOf((String)stringValue);
        }
        catch (IllegalArgumentException e) {
            instanceType = TYPICAL_INSTANCE_TYPES.get(stringValue.toUpperCase());
        }
        return instanceType;
    }

    static {
        TYPICAL_INSTANCE_TYPES.put("DEFAULT", InstanceType.M1_SMALL);
        TYPICAL_INSTANCE_TYPES.put("LARGE", InstanceType.M1_LARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE", InstanceType.M1_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("MEDIUM_HCPU", InstanceType.C1_MEDIUM);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_HCPU", InstanceType.C1_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_HMEM", InstanceType.M2_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_HMEM_M3", InstanceType.M3_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_DOUBLE_HMEM", InstanceType.M2_2_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_QUAD_HMEM", InstanceType.M2_4_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_QUAD_HMEM_M3", InstanceType.M3_2_XLARGE);
        TYPICAL_INSTANCE_TYPES.put("XLARGE_CLUSTER_COMPUTE", InstanceType.CC1_4_XLARGE);
    }
}

