/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;
import software.amazon.awssdk.services.ec2.model.Tag;

public class EC2Tag
extends AbstractDescribableImpl<EC2Tag> {
    private final String name;
    private final String value;
    public static final String TAG_NAME_JENKINS_SLAVE_TYPE = "jenkins_slave_type";
    public static final String TAG_NAME_JENKINS_SERVER_URL = "jenkins_server_url";
    public static final String TAG_NAME_JENKINS_CLOUD_NAME = "jenkins_cloud_name";

    @DataBoundConstructor
    public EC2Tag(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public EC2Tag(Tag t) {
        this.name = t.key();
        this.value = t.value();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "EC2Tag: " + this.name + "->" + this.value;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        EC2Tag other = (EC2Tag)((Object)o);
        if (this.name == null && other.name != null || this.name != null && !this.name.equals(other.name)) {
            return false;
        }
        return (this.value != null || other.value == null) && (this.value == null || this.value.equals(other.value));
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value);
    }

    public static List<EC2Tag> fromAmazonTags(List<Tag> amazonTags) {
        if (null == amazonTags) {
            return null;
        }
        LinkedList<EC2Tag> result = new LinkedList<EC2Tag>();
        for (Tag t : amazonTags) {
            result.add(new EC2Tag(t));
        }
        return result;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<EC2Tag> {
        public String getDisplayName() {
            return "";
        }
    }
}

