/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.cloudbees.jenkins.plugins.awscredentials.AWSCredentialsImpl;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.SystemCredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.domains.Domain;
import com.google.common.annotations.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.ItemGroup;
import hudson.model.Label;
import hudson.model.ModelObject;
import hudson.model.Node;
import hudson.model.PeriodicWork;
import hudson.model.TaskListener;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2PrivateKey;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.Messages;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.plugins.ec2.util.FIPS140Utils;
import hudson.plugins.ec2.util.KeyPair;
import hudson.security.ACL;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import hudson.util.FormValidation;
import hudson.util.HttpResponses;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import hudson.util.StreamTaskListener;
import jakarta.servlet.ServletException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.regex.Pattern;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.interceptor.RequirePOST;
import org.kohsuke.stapler.verb.POST;
import org.springframework.security.core.Authentication;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.InstanceProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.http.apache.ProxyConfiguration;
import software.amazon.awssdk.regions.RegionMetadata;
import software.amazon.awssdk.regions.ServiceEndpointKey;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeRegionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.Region;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.SpotInstanceRequest;
import software.amazon.awssdk.services.ec2.model.SpotInstanceState;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class EC2Cloud
extends Cloud {
    private static final Logger LOGGER = Logger.getLogger(EC2Cloud.class.getName());
    public static final String DEFAULT_EC2_HOST = "us-east-1";
    public static final String EC2_SLAVE_TYPE_SPOT = "spot";
    public static final String EC2_SLAVE_TYPE_DEMAND = "demand";
    public static final String EC2_REQUEST_EXPIRED_ERROR_CODE = "RequestExpired";
    private static final SimpleFormatter sf = new SimpleFormatter();
    public static final String SSH_PRIVATE_KEY_FILEPATH = EC2Cloud.class.getName() + ".sshPrivateKeyFilePath";
    private transient ReentrantLock slaveCountingLock = new ReentrantLock();
    private final boolean useInstanceProfileForCredentials;
    private final String roleArn;
    private final String roleSessionName;
    @CheckForNull
    private String credentialsId;
    @Deprecated
    @CheckForNull
    private transient String accessId;
    @Deprecated
    @CheckForNull
    private transient Secret secretKey;
    @Deprecated
    @CheckForNull
    private transient EC2PrivateKey privateKey;
    @CheckForNull
    private String sshKeysCredentialsId;
    private final int instanceCap;
    private List<? extends SlaveTemplate> templates;
    private transient KeyPair usableKeyPair;
    private String region;
    private String altEC2Endpoint;
    private boolean noDelayProvisioning;
    private boolean cleanUpOrphanedNodes;
    private volatile transient Ec2Client connection;

    @DataBoundConstructor
    public EC2Cloud(String name, boolean useInstanceProfileForCredentials, String credentialsId, String region, String privateKey, String sshKeysCredentialsId, String instanceCapStr, List<? extends SlaveTemplate> templates, String roleArn, String roleSessionName) {
        super(name);
        this.useInstanceProfileForCredentials = useInstanceProfileForCredentials;
        this.roleArn = roleArn;
        this.roleSessionName = roleSessionName;
        this.credentialsId = Util.fixEmpty((String)credentialsId);
        this.region = Util.fixEmpty((String)region);
        this.sshKeysCredentialsId = Util.fixEmpty((String)sshKeysCredentialsId);
        this.templates = templates == null ? Collections.emptyList() : templates;
        this.instanceCap = instanceCapStr == null || instanceCapStr.isEmpty() ? Integer.MAX_VALUE : Integer.parseInt(instanceCapStr);
        this.readResolve();
    }

    @Deprecated
    public EC2Cloud(String name, boolean useInstanceProfileForCredentials, String credentialsId, String region, String privateKey, String instanceCapStr, List<? extends SlaveTemplate> templates, String roleArn, String roleSessionName) {
        this(name, useInstanceProfileForCredentials, credentialsId, region, privateKey, null, instanceCapStr, templates, roleArn, roleSessionName);
    }

    @Deprecated
    protected EC2Cloud(String id, boolean useInstanceProfileForCredentials, String credentialsId, String privateKey, String instanceCapStr, List<? extends SlaveTemplate> templates, String roleArn, String roleSessionName) {
        this(id, useInstanceProfileForCredentials, credentialsId, privateKey, null, null, instanceCapStr, templates, roleArn, roleSessionName);
    }

    @CheckForNull
    public EC2PrivateKey resolvePrivateKey() {
        if (!System.getProperty(SSH_PRIVATE_KEY_FILEPATH, "").isEmpty()) {
            LOGGER.fine(() -> "(resolvePrivateKey) secret key file configured, will load from disk");
            return EC2PrivateKey.fetchFromDisk();
        }
        if (this.sshKeysCredentialsId != null) {
            LOGGER.fine(() -> "(resolvePrivateKey) Using jenkins ssh credential");
            SSHUserPrivateKey privateKeyCredential = EC2Cloud.getSshCredential(this.sshKeysCredentialsId, (ItemGroup)Jenkins.get());
            if (privateKeyCredential != null) {
                String privateKey = privateKeyCredential.getPrivateKey();
                FIPS140Utils.ensurePrivateKeyInFipsMode(privateKey);
                return new EC2PrivateKey(privateKey);
            }
        }
        return null;
    }

    @Deprecated
    public String getCloudName() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }

    public String getRegion() {
        if (this.region == null) {
            this.region = DEFAULT_EC2_HOST;
        }
        if (this.region.indexOf(95) > 0) {
            return this.region.replace('_', '-').toLowerCase(Locale.ENGLISH);
        }
        return this.region;
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static software.amazon.awssdk.regions.Region parseRegion(@CheckForNull String input) {
        String regionId = Util.fixEmpty((String)input);
        if (regionId == null) {
            return null;
        }
        return software.amazon.awssdk.regions.Region.regions().stream().filter(r -> r.id().equals(regionId)).findFirst().orElse(null);
    }

    @Restricted(value={NoExternalUse.class})
    @CheckForNull
    public static URI parseEndpoint(@CheckForNull String input) {
        String endpoint = Util.fixEmpty((String)input);
        if (endpoint == null) {
            return null;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            LOGGER.log(Level.WARNING, "The alternate EC2 endpoint is malformed ({0}).", endpoint);
            return null;
        }
    }

    @NonNull
    static software.amazon.awssdk.regions.Region getBootstrapRegion(@CheckForNull URI endpoint) {
        if (endpoint != null) {
            ServiceMetadata metadata = Ec2Client.serviceMetadata();
            for (software.amazon.awssdk.regions.Region region : metadata.regions()) {
                ServiceEndpointKey key = ServiceEndpointKey.builder().region(region).build();
                if (endpoint.getHost() == null || !endpoint.getHost().equals(metadata.endpointFor(key).toString())) continue;
                return region;
            }
        }
        return software.amazon.awssdk.regions.Region.US_EAST_1;
    }

    public boolean isNoDelayProvisioning() {
        return this.noDelayProvisioning;
    }

    @DataBoundSetter
    public void setNoDelayProvisioning(boolean noDelayProvisioning) {
        this.noDelayProvisioning = noDelayProvisioning;
    }

    public boolean isCleanUpOrphanedNodes() {
        return this.cleanUpOrphanedNodes;
    }

    @DataBoundSetter
    public void setCleanUpOrphanedNodes(boolean cleanUpOrphanedNodes) {
        this.cleanUpOrphanedNodes = cleanUpOrphanedNodes;
    }

    public String getAltEC2Endpoint() {
        return this.altEC2Endpoint;
    }

    @DataBoundSetter
    public void setAltEC2Endpoint(String altEC2Endpoint) {
        this.altEC2Endpoint = altEC2Endpoint;
    }

    public void addTemplate(SlaveTemplate newTemplate) throws Exception {
        String newTemplateDescription = newTemplate.description;
        if (this.getTemplate(newTemplateDescription) != null) {
            throw new Exception(String.format("A SlaveTemplate with description %s already exists", newTemplateDescription));
        }
        ArrayList<? extends SlaveTemplate> templatesHolder = new ArrayList<SlaveTemplate>(this.templates);
        templatesHolder.add(newTemplate);
        this.templates = templatesHolder;
    }

    public void updateTemplate(SlaveTemplate newTemplate, String oldTemplateDescription) throws Exception {
        Optional<SlaveTemplate> optionalOldTemplate = this.templates.stream().filter(template -> Objects.equals(template.description, oldTemplateDescription)).findFirst();
        if (optionalOldTemplate.isEmpty()) {
            throw new Exception(String.format("A SlaveTemplate with description %s does not exist", oldTemplateDescription));
        }
        int oldTemplateIndex = this.templates.indexOf(optionalOldTemplate.get());
        ArrayList<? extends SlaveTemplate> templatesHolder = new ArrayList<SlaveTemplate>(this.templates);
        templatesHolder.set(oldTemplateIndex, newTemplate);
        this.templates = templatesHolder;
    }

    private void migratePrivateSshKeyToCredential(final String privateKey) {
        Optional<SSHUserPrivateKey> keyCredential = SystemCredentialsProvider.getInstance().getCredentials().stream().filter(SSHUserPrivateKey.class::isInstance).filter(cred -> ((SSHUserPrivateKey)cred).getPrivateKey().trim().equals(privateKey.trim())).map(cred -> (SSHUserPrivateKey)cred).findFirst();
        if (keyCredential.isPresent()) {
            this.sshKeysCredentialsId = keyCredential.get().getId();
        } else {
            String credsId = UUID.randomUUID().toString();
            BasicSSHUserPrivateKey sshKeyCredentials = new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, credsId, "key", new BasicSSHUserPrivateKey.PrivateKeySource(){

                @NonNull
                public List<String> getPrivateKeys() {
                    return Collections.singletonList(privateKey.trim());
                }
            }, "", "EC2 Cloud Private Key - " + this.getDisplayName());
            this.addNewGlobalCredential((Credentials)sshKeyCredentials);
            this.sshKeysCredentialsId = credsId;
        }
    }

    protected Object readResolve() {
        this.slaveCountingLock = new ReentrantLock();
        for (SlaveTemplate slaveTemplate : this.templates) {
            slaveTemplate.parent = this;
        }
        if (this.sshKeysCredentialsId == null && this.privateKey != null) {
            String privateKey = this.privateKey.getPrivateKey();
            FIPS140Utils.ensurePrivateKeyInFipsMode(privateKey);
            this.migratePrivateSshKeyToCredential(privateKey);
        }
        this.privateKey = null;
        if (this.accessId != null && this.secretKey != null && this.credentialsId == null) {
            String secretKeyEncryptedValue = this.secretKey.getEncryptedValue();
            SystemCredentialsProvider systemCredentialsProvider = SystemCredentialsProvider.getInstance();
            for (Credentials credentials : systemCredentialsProvider.getCredentials()) {
                AmazonWebServicesCredentials awsCreds;
                AwsCredentials awsCredentials;
                if (!(credentials instanceof AmazonWebServicesCredentials) || !this.accessId.equals((awsCredentials = (awsCreds = (AmazonWebServicesCredentials)credentials).resolveCredentials()).accessKeyId()) || !Secret.toString((Secret)this.secretKey).equals(awsCredentials.secretAccessKey())) continue;
                this.credentialsId = awsCreds.getId();
                this.accessId = null;
                this.secretKey = null;
                return this;
            }
            String credsId = UUID.randomUUID().toString();
            this.addNewGlobalCredential((Credentials)new AWSCredentialsImpl(CredentialsScope.SYSTEM, credsId, this.accessId, secretKeyEncryptedValue, "EC2 Cloud - " + this.getDisplayName()));
            this.credentialsId = credsId;
            this.accessId = null;
            this.secretKey = null;
            LOGGER.log(Level.WARNING, "EC2 Plugin could not migrate credentials to the Jenkins Global Credentials Store, EC2 Plugin for cloud {0} must be manually reconfigured", this.getDisplayName());
        }
        return this;
    }

    private void addNewGlobalCredential(Credentials credentials) {
        for (CredentialsStore credentialsStore : CredentialsProvider.lookupStores((ModelObject)Jenkins.get())) {
            if (!(credentialsStore instanceof SystemCredentialsProvider.StoreImpl)) continue;
            try {
                credentialsStore.addCredentials(Domain.global(), credentials);
            }
            catch (IOException e) {
                this.credentialsId = null;
                LOGGER.log(Level.WARNING, "Exception converting legacy configuration to the new credentials API", e);
            }
        }
    }

    public boolean isUseInstanceProfileForCredentials() {
        return this.useInstanceProfileForCredentials;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public String getRoleSessionName() {
        return this.roleSessionName;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @CheckForNull
    public String getSshKeysCredentialsId() {
        return this.sshKeysCredentialsId;
    }

    @Deprecated
    public EC2PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public String getInstanceCapStr() {
        if (this.instanceCap == Integer.MAX_VALUE) {
            return "";
        }
        return String.valueOf(this.instanceCap);
    }

    public int getInstanceCap() {
        return this.instanceCap;
    }

    public List<SlaveTemplate> getTemplates() {
        return Collections.unmodifiableList(this.templates);
    }

    @CheckForNull
    public SlaveTemplate getTemplate(String template) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!slaveTemplate.description.equals(template)) continue;
            return slaveTemplate;
        }
        return null;
    }

    @Deprecated
    public SlaveTemplate getTemplate(Label label) {
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (!(slaveTemplate.getMode() == Node.Mode.NORMAL ? label == null || label.matches(slaveTemplate.getLabelSet()) : slaveTemplate.getMode() == Node.Mode.EXCLUSIVE && label != null && label.matches(slaveTemplate.getLabelSet()))) continue;
            return slaveTemplate;
        }
        return null;
    }

    public Collection<SlaveTemplate> getTemplates(Label label) {
        ArrayList<SlaveTemplate> matchingTemplates = new ArrayList<SlaveTemplate>();
        for (SlaveTemplate slaveTemplate : this.templates) {
            if (slaveTemplate.getMode() == Node.Mode.NORMAL) {
                if (label != null && !label.matches(slaveTemplate.getLabelSet())) continue;
                matchingTemplates.add(slaveTemplate);
                continue;
            }
            if (slaveTemplate.getMode() != Node.Mode.EXCLUSIVE || label == null || !label.matches(slaveTemplate.getLabelSet())) continue;
            matchingTemplates.add(slaveTemplate);
        }
        return matchingTemplates;
    }

    @CheckForNull
    public synchronized KeyPair getKeyPair() throws SdkException, IOException {
        EC2PrivateKey ec2PrivateKey;
        if (this.usableKeyPair == null && (ec2PrivateKey = this.resolvePrivateKey()) != null) {
            this.usableKeyPair = ec2PrivateKey.find(this.connect());
        }
        return this.usableKeyPair;
    }

    @RequirePOST
    public void doAttach(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String id) throws ServletException, IOException, SdkException {
        this.checkPermission(PROVISION);
        SlaveTemplate t = this.getTemplates().get(0);
        StringWriter sw = new StringWriter();
        StreamTaskListener listener = new StreamTaskListener((Writer)sw);
        EC2AbstractSlave node = t.attach(id, (TaskListener)listener);
        Jenkins.get().addNode((Node)node);
        rsp.sendRedirect2(req.getContextPath() + "/computer/" + node.getNodeName());
    }

    @RequirePOST
    public HttpResponse doProvision(@QueryParameter String template) throws ServletException, IOException {
        this.checkPermission(PROVISION);
        if (template == null) {
            throw HttpResponses.error((int)400, (String)"The 'template' query parameter is missing");
        }
        SlaveTemplate t = this.getTemplate(template);
        if (t == null) {
            throw HttpResponses.error((int)400, (String)("No such template: " + template));
        }
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            throw HttpResponses.error((int)400, (String)"Jenkins instance is quieting down");
        }
        if (jenkinsInstance.isTerminating()) {
            throw HttpResponses.error((int)400, (String)"Jenkins instance is terminating");
        }
        try {
            List<EC2AbstractSlave> nodes = this.getNewOrExistingAvailableSlave(t, 1, true);
            if (nodes == null || nodes.isEmpty()) {
                throw HttpResponses.error((int)400, (String)("Cloud or AMI instance cap would be exceeded for: " + template));
            }
            Computer c = nodes.get(0).toComputer();
            if (nodes.get(0).getStopOnTerminate() && c != null) {
                c.connect(false);
            }
            jenkinsInstance.addNode((Node)nodes.get(0));
            return HttpResponses.redirectViaContextPath((String)("/computer/" + nodes.get(0).getNodeName()));
        }
        catch (SdkException e) {
            throw HttpResponses.error((int)500, (Throwable)e);
        }
    }

    private int countCurrentEC2Slaves(SlaveTemplate template) throws SdkException {
        String jenkinsServerUrl = JenkinsLocationConfiguration.get().getUrl();
        if (jenkinsServerUrl == null) {
            LOGGER.log(Level.WARNING, "No Jenkins server URL specified, it is strongly recommended to open /configure and set the server URL. Not having has disabled the per-controller instance cap counting (cf. https://github.com/jenkinsci/ec2-plugin/pull/310)");
        }
        LOGGER.log(Level.FINE, "Counting current agents: " + (String)(template != null ? " AMI: " + template.getAmi() + " TemplateDesc: " + template.description : " All AMIS") + " Jenkins Server: " + jenkinsServerUrl);
        int n = 0;
        HashSet<String> instanceIds = new HashSet<String>();
        String description = template != null ? template.description : null;
        List<Filter> filters = this.getGenericFilters(jenkinsServerUrl, template);
        filters.add((Filter)Filter.builder().name("instance-state-name").values(new String[]{"running", "pending", "stopping"}).build());
        DescribeInstancesRequest dir = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(filters).build();
        DescribeInstancesResponse result = null;
        do {
            result = this.connect().describeInstances(dir);
            dir = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(filters).nextToken(result.nextToken()).build();
            for (Reservation r : result.reservations()) {
                for (Instance i : r.instances()) {
                    if (!this.isEc2ProvisionedAmiSlave(i.tags(), description)) continue;
                    LOGGER.log(Level.FINE, "Existing instance found: " + i.instanceId() + " AMI: " + i.imageId() + (String)(template != null ? " Template: " + description : "") + " Jenkins Server: " + jenkinsServerUrl);
                    ++n;
                    instanceIds.add(i.instanceId());
                }
            }
        } while (result.nextToken() != null);
        return n += this.countCurrentEC2SpotSlaves(template, jenkinsServerUrl, instanceIds);
    }

    private int countCurrentEC2SpotSlaves(SlaveTemplate template, String jenkinsServerUrl, Set<String> instanceIds) throws SdkException {
        int n = 0;
        String description = template != null ? template.description : null;
        List sirs = null;
        List<Filter> filters = this.getGenericFilters(jenkinsServerUrl, template);
        if (template != null) {
            filters.add((Filter)Filter.builder().name("launch.image-id").values(new String[]{template.getAmi()}).build());
        }
        DescribeSpotInstanceRequestsRequest dsir = (DescribeSpotInstanceRequestsRequest)DescribeSpotInstanceRequestsRequest.builder().filters(filters).maxResults(Integer.valueOf(100)).build();
        HashSet<SpotInstanceRequest> sirSet = new HashSet<SpotInstanceRequest>();
        DescribeSpotInstanceRequestsResponse sirResp = null;
        do {
            sirResp = this.connect().describeSpotInstanceRequests(dsir);
            sirs = sirResp.spotInstanceRequests();
            dsir = (DescribeSpotInstanceRequestsRequest)DescribeSpotInstanceRequestsRequest.builder().filters(filters).maxResults(Integer.valueOf(100)).nextToken(sirResp.nextToken()).build();
            if (sirs == null) continue;
            block3: for (SpotInstanceRequest sir : sirs) {
                sirSet.add(sir);
                if (sir.state() == SpotInstanceState.OPEN || sir.state() == SpotInstanceState.ACTIVE) {
                    if (sir.instanceId() != null && instanceIds.contains(sir.instanceId()) || !this.isEc2ProvisionedAmiSlave(sir.tags(), description)) continue;
                    LOGGER.log(Level.FINE, "Spot instance request found: " + sir.spotInstanceRequestId() + " AMI: " + sir.instanceId() + " state: " + String.valueOf(sir.state()) + " status: " + String.valueOf(sir.status()));
                    ++n;
                    if (sir.instanceId() == null) continue;
                    instanceIds.add(sir.instanceId());
                    continue;
                }
                for (Node node : Jenkins.get().getNodes()) {
                    try {
                        if (!(node instanceof EC2SpotSlave)) continue;
                        EC2SpotSlave ec2Slave = (EC2SpotSlave)node;
                        if (!ec2Slave.getSpotInstanceRequestId().equals(sir.spotInstanceRequestId())) continue;
                        LOGGER.log(Level.INFO, "Removing dead request: " + sir.spotInstanceRequestId() + " AMI: " + sir.instanceId() + " state: " + String.valueOf(sir.state()) + " status: " + String.valueOf(sir.status()));
                        Jenkins.get().removeNode(node);
                        continue block3;
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, "Failed to remove node for dead request: " + sir.spotInstanceRequestId() + " AMI: " + sir.instanceId() + " state: " + String.valueOf(sir.state()) + " status: " + String.valueOf(sir.status()), e);
                    }
                }
            }
        } while (sirResp.nextToken() != null);
        return n += this.countJenkinsNodeSpotInstancesWithoutRequests(template, sirSet, instanceIds);
    }

    private int countJenkinsNodeSpotInstancesWithoutRequests(SlaveTemplate template, Set<SpotInstanceRequest> sirSet, Set<String> instanceIds) throws SdkException {
        int n = 0;
        for (Node node : Jenkins.get().getNodes()) {
            if (!(node instanceof EC2SpotSlave)) continue;
            EC2SpotSlave ec2Slave = (EC2SpotSlave)node;
            SpotInstanceRequest sir = ec2Slave.getSpotRequest();
            if (sir == null) {
                LOGGER.log(Level.FINE, "Found spot node without request: " + ec2Slave.getSpotInstanceRequestId());
                ++n;
                continue;
            }
            if (sirSet.contains(sir)) continue;
            sirSet.add(sir);
            if (sir.state() != SpotInstanceState.OPEN && sir.state() != SpotInstanceState.ACTIVE || template == null) continue;
            List instanceTags = sir.tags();
            for (Tag tag : instanceTags) {
                if (!StringUtils.equals((String)tag.key(), (String)"jenkins_slave_type") || !StringUtils.equals((String)tag.value(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, template.description)) || !sir.launchSpecification().imageId().equals(template.getAmi()) || sir.instanceId() != null && instanceIds.contains(sir.instanceId())) continue;
                LOGGER.log(Level.FINE, "Spot instance request found (from node): " + sir.spotInstanceRequestId() + " AMI: " + sir.instanceId() + " state: " + String.valueOf(sir.state()) + " status: " + String.valueOf(sir.status()));
                ++n;
                if (sir.instanceId() == null) continue;
                instanceIds.add(sir.instanceId());
            }
        }
        return n;
    }

    private List<Filter> getGenericFilters(String jenkinsServerUrl, SlaveTemplate template) {
        List<EC2Tag> tags;
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add((Filter)Filter.builder().name("tag-key").values(new String[]{"jenkins_slave_type"}).build());
        if (jenkinsServerUrl != null) {
            filters.add((Filter)Filter.builder().name("tag:jenkins_server_url").values(new String[]{jenkinsServerUrl}).build());
        } else {
            filters.add((Filter)Filter.builder().name("tag-key").values(new String[]{"jenkins_server_url"}).build());
        }
        if (template != null && (tags = template.getTags()) != null) {
            for (EC2Tag tag : tags) {
                if (tag.getName() == null || tag.getValue() == null) continue;
                filters.add((Filter)Filter.builder().name("tag:" + tag.getName()).values(new String[]{tag.getValue()}).build());
            }
        }
        return filters;
    }

    private boolean isEc2ProvisionedAmiSlave(List<Tag> tags, String description) {
        for (Tag tag : tags) {
            if (!StringUtils.equals((String)tag.key(), (String)"jenkins_slave_type")) continue;
            if (description == null) {
                return true;
            }
            if (StringUtils.equals((String)tag.value(), (String)EC2_SLAVE_TYPE_DEMAND) || StringUtils.equals((String)tag.value(), (String)EC2_SLAVE_TYPE_SPOT)) {
                return true;
            }
            return StringUtils.equals((String)tag.value(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_DEMAND, description)) || StringUtils.equals((String)tag.value(), (String)EC2Cloud.getSlaveTypeTagValue(EC2_SLAVE_TYPE_SPOT, description));
        }
        return false;
    }

    private int getPossibleNewSlavesCount(SlaveTemplate template) throws SdkException {
        int estimatedTotalSlaves = this.countCurrentEC2Slaves(null);
        int estimatedAmiSlaves = this.countCurrentEC2Slaves(template);
        int availableTotalSlaves = this.instanceCap - estimatedTotalSlaves;
        int availableAmiSlaves = template.getInstanceCap() - estimatedAmiSlaves;
        LOGGER.log(Level.FINE, "Available Total Agents: " + availableTotalSlaves + " Available AMI agents: " + availableAmiSlaves + " AMI: " + template.getAmi() + " TemplateDesc: " + template.description);
        return Math.min(availableAmiSlaves, availableTotalSlaves);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<EC2AbstractSlave> getNewOrExistingAvailableSlave(SlaveTemplate t, int number, boolean forceCreateNew) throws IOException {
        try {
            this.slaveCountingLock.lock();
            int possibleSlavesCount = this.getPossibleNewSlavesCount(t);
            if (possibleSlavesCount <= 0) {
                LOGGER.log(Level.INFO, "{0}. Cannot provision - no capacity for instances: " + possibleSlavesCount, t);
                List<EC2AbstractSlave> list = null;
                return list;
            }
            EnumSet<SlaveTemplate.ProvisionOptions> provisionOptions = forceCreateNew ? EnumSet.of(SlaveTemplate.ProvisionOptions.FORCE_CREATE) : EnumSet.of(SlaveTemplate.ProvisionOptions.ALLOW_CREATE);
            if (number > possibleSlavesCount) {
                LOGGER.log(Level.INFO, String.format("%d nodes were requested for the template %s, but because of instance cap only %d can be provisioned", number, t, possibleSlavesCount));
                number = possibleSlavesCount;
            }
            List<EC2AbstractSlave> list = t.provision(number, provisionOptions);
            return list;
        }
        finally {
            this.slaveCountingLock.unlock();
        }
    }

    public Collection<NodeProvisioner.PlannedNode> provision(Label label, int excessWorkload) {
        Collection<SlaveTemplate> matchingTemplates = this.getTemplates(label);
        ArrayList<NodeProvisioner.PlannedNode> plannedNodes = new ArrayList<NodeProvisioner.PlannedNode>();
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return Collections.emptyList();
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return Collections.emptyList();
        }
        for (SlaveTemplate t : matchingTemplates) {
            try {
                LOGGER.log(Level.INFO, "{0}. Attempting to provision agent needed by excess workload of " + excessWorkload + " units", t);
                int number = Math.max(excessWorkload / t.getNumExecutors(), 1);
                List<EC2AbstractSlave> slaves = this.getNewOrExistingAvailableSlave(t, number, false);
                if (slaves == null || slaves.isEmpty()) {
                    LOGGER.warning("Can't raise nodes for " + String.valueOf(t));
                    continue;
                }
                for (EC2AbstractSlave slave : slaves) {
                    if (slave == null) {
                        LOGGER.warning("Can't raise node for " + String.valueOf(t));
                        continue;
                    }
                    plannedNodes.add(this.createPlannedNode(t, slave));
                    excessWorkload -= t.getNumExecutors();
                }
                LOGGER.log(Level.INFO, "{0}. Attempting provision finished, excess workload: " + excessWorkload, t);
                if (excessWorkload != 0) continue;
                break;
            }
            catch (AwsServiceException e) {
                LOGGER.log(Level.WARNING, String.valueOf(t) + ". Exception during provisioning", e);
                if (!EC2_REQUEST_EXPIRED_ERROR_CODE.equals(e.awsErrorDetails().errorCode()) && !"ExpiredToken".equals(e.awsErrorDetails().errorCode())) continue;
                LOGGER.log(Level.INFO, "Reconnecting to EC2 due to RequestExpired or ExpiredToken error");
                try {
                    this.reconnectToEc2();
                }
                catch (IOException e2) {
                    LOGGER.log(Level.WARNING, "Failed to reconnect ec2", e2);
                }
            }
            catch (IOException | SdkException e) {
                LOGGER.log(Level.WARNING, String.valueOf(t) + ". Exception during provisioning", e);
            }
        }
        LOGGER.log(Level.INFO, "We have now {0} computers, waiting for {1} more", new Object[]{jenkinsInstance.getComputers().length, plannedNodes.size()});
        return plannedNodes;
    }

    private static void attachSlavesToJenkins(Jenkins jenkins, List<EC2AbstractSlave> slaves, SlaveTemplate t) throws IOException {
        for (EC2AbstractSlave slave : slaves) {
            if (slave == null) {
                LOGGER.warning("Can't raise node for " + String.valueOf(t));
                continue;
            }
            Computer c = slave.toComputer();
            if (slave.getStopOnTerminate() && c != null) {
                c.connect(false);
            }
            jenkins.addNode((Node)slave);
        }
    }

    public void provision(SlaveTemplate t, int number) {
        Jenkins jenkinsInstance = Jenkins.get();
        if (jenkinsInstance.isQuietingDown()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is quieting down");
            return;
        }
        if (jenkinsInstance.isTerminating()) {
            LOGGER.log(Level.FINE, "Not provisioning nodes, Jenkins instance is terminating");
            return;
        }
        try {
            LOGGER.log(Level.INFO, "{0}. Attempting to provision {1} agent(s)", new Object[]{t, number});
            List<EC2AbstractSlave> slaves = this.getNewOrExistingAvailableSlave(t, number, false);
            if (slaves == null || slaves.isEmpty()) {
                LOGGER.warning("Can't raise nodes for " + String.valueOf(t));
                return;
            }
            EC2Cloud.attachSlavesToJenkins(jenkinsInstance, slaves, t);
            LOGGER.log(Level.INFO, "{0}. Attempting provision finished", t);
            LOGGER.log(Level.INFO, "We have now {0} computers, waiting for {1} more", new Object[]{Jenkins.get().getComputers().length, number});
        }
        catch (IOException | SdkException e) {
            LOGGER.log(Level.WARNING, String.valueOf(t) + ". Exception during provisioning", e);
        }
    }

    void attemptReattachOrphanOrStoppedNodes(Jenkins jenkinsInstance, SlaveTemplate template, int requestedNum) throws IOException {
        LOGGER.info("Attempting to wake & re-attach orphan/stopped nodes");
        Ec2Client ec2 = this.connect();
        DescribeInstancesResponse diResult = template.getDescribeInstanceResult(ec2, true);
        List<Instance> orphansOrStopped = template.findOrphansOrStopped(diResult, requestedNum);
        template.wakeOrphansOrStoppedUp(ec2, orphansOrStopped);
        while (orphansOrStopped.size() > requestedNum) {
            orphansOrStopped.remove(0);
        }
        EC2Cloud.attachSlavesToJenkins(jenkinsInstance, template.toSlaves(orphansOrStopped), template);
        if (!orphansOrStopped.isEmpty()) {
            LOGGER.info("Found and re-attached " + orphansOrStopped.size() + " orphan/stopped nodes");
        }
    }

    private NodeProvisioner.PlannedNode createPlannedNode(final SlaveTemplate t, final EC2AbstractSlave slave) {
        return new NodeProvisioner.PlannedNode(t.getDisplayName(), Computer.threadPoolForRemoting.submit(new Callable<Node>(){
            int retryCount = 0;
            private static final int DESCRIBE_LIMIT = 2;

            @Override
            public Node call() throws Exception {
                while (true) {
                    Instance instance;
                    String instanceId = slave.getInstanceId();
                    if (slave instanceof EC2SpotSlave) {
                        if (((EC2SpotSlave)slave).isSpotRequestDead()) {
                            LOGGER.log(Level.WARNING, "{0} Spot request died, can't do anything. Terminate provisioning", t);
                            return null;
                        }
                        if (StringUtils.isEmpty((String)instanceId)) {
                            Thread.sleep(5000L);
                            continue;
                        }
                    }
                    if ((instance = CloudHelper.getInstanceWithRetry(instanceId, slave.getCloud())) == null) {
                        LOGGER.log(Level.WARNING, "{0} Can't find instance with instance id `{1}` in cloud {2}. Terminate provisioning ", new Object[]{t, instanceId, slave.cloudName});
                        return null;
                    }
                    InstanceStateName state = instance.state().name();
                    if (state.equals((Object)InstanceStateName.RUNNING)) {
                        Computer c = slave.toComputer();
                        if (c != null) {
                            c.connect(false);
                        }
                        long secondsSinceStart = Instant.now().until(instance.launchTime(), ChronoUnit.SECONDS);
                        LOGGER.log(Level.INFO, "{0} Node {1} moved to RUNNING state in {2} seconds and is ready to be connected by Jenkins", new Object[]{t, slave.getNodeName(), secondsSinceStart});
                        return slave;
                    }
                    if (!state.equals((Object)InstanceStateName.PENDING)) {
                        if (this.retryCount >= 2) {
                            LOGGER.log(Level.WARNING, "Instance {0} did not move to running after {1} attempts, terminating provisioning", new Object[]{instanceId, this.retryCount});
                            return null;
                        }
                        LOGGER.log(Level.INFO, "Attempt {0}: {1}. Node {2} is neither pending, neither running, it''s {3}. Will try again after 5s", new Object[]{this.retryCount, t, slave.getNodeName(), state});
                        ++this.retryCount;
                    }
                    Thread.sleep(5000L);
                }
            }
        }), t.getNumExecutors());
    }

    public boolean canProvision(Label label) {
        return !this.getTemplates(label).isEmpty();
    }

    protected AwsCredentialsProvider createCredentialsProvider() {
        return EC2Cloud.createCredentialsProvider(this.isUseInstanceProfileForCredentials(), this.getCredentialsId(), this.getRoleArn(), this.getRoleSessionName(), this.getRegion());
    }

    public static String getSlaveTypeTagValue(String slaveType, String templateDescription) {
        return templateDescription != null ? slaveType + "_" + templateDescription : slaveType;
    }

    public static AwsCredentialsProvider createCredentialsProvider(boolean useInstanceProfileForCredentials, String credentialsId) {
        if (useInstanceProfileForCredentials) {
            return InstanceProfileCredentialsProvider.create();
        }
        if (StringUtils.isBlank((String)credentialsId)) {
            return DefaultCredentialsProvider.builder().build();
        }
        AmazonWebServicesCredentials credentials = EC2Cloud.getCredentials(credentialsId);
        if (credentials != null) {
            return StaticCredentialsProvider.create((AwsCredentials)credentials.resolveCredentials());
        }
        return DefaultCredentialsProvider.builder().build();
    }

    public static AwsCredentialsProvider createCredentialsProvider(boolean useInstanceProfileForCredentials, String credentialsId, String roleArn, String roleSessionName, String region) {
        AwsCredentialsProvider provider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
        if (StringUtils.isNotEmpty((String)roleArn)) {
            AssumeRoleRequest assumeRoleRequest = (AssumeRoleRequest)AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(StringUtils.defaultIfBlank((String)roleSessionName, (String)"Jenkins")).build();
            StsClientBuilder stsClientBuilder = (StsClientBuilder)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(provider)).httpClient(EC2Cloud.getHttpClient())).overrideConfiguration(EC2Cloud.createClientOverrideConfiguration());
            software.amazon.awssdk.regions.Region parsed = EC2Cloud.parseRegion(region);
            if (parsed != null) {
                stsClientBuilder.region(parsed);
            }
            StsClient stsClient = (StsClient)stsClientBuilder.build();
            return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(assumeRoleRequest).build();
        }
        return provider;
    }

    @CheckForNull
    private static AmazonWebServicesCredentials getCredentials(@CheckForNull String credentialsId) {
        if (StringUtils.isBlank((String)credentialsId)) {
            return null;
        }
        return (AmazonWebServicesCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(AmazonWebServicesCredentials.class, (ItemGroup)Jenkins.get(), (Authentication)ACL.SYSTEM2, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)credentialsId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ec2Client reconnectToEc2() throws IOException {
        EC2Cloud eC2Cloud = this;
        synchronized (eC2Cloud) {
            this.connection = AmazonEC2Factory.getInstance().connect(this.createCredentialsProvider(), EC2Cloud.parseRegion(this.getRegion()), EC2Cloud.parseEndpoint(this.getAltEC2Endpoint()));
            return this.connection;
        }
    }

    public Ec2Client connect() throws SdkException {
        try {
            if (this.connection != null) {
                return this.connection;
            }
            return this.reconnectToEc2();
        }
        catch (IOException e) {
            throw SdkException.create((String)"Failed to retrieve the endpoint", (Throwable)e);
        }
    }

    public static SdkHttpClient getHttpClient() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxy = instance != null ? instance.proxy : null;
        ApacheHttpClient.Builder builder = ApacheHttpClient.builder();
        if (proxy != null && proxy.name != null && !proxy.name.isEmpty()) {
            List patterns;
            ProxyConfiguration.Builder proxyConfiguration = software.amazon.awssdk.http.apache.ProxyConfiguration.builder().endpoint(URI.create(String.format("http://%s:%s", proxy.name, proxy.port)));
            if (proxy.getUserName() != null) {
                proxyConfiguration.username(proxy.getUserName());
                proxyConfiguration.password(Secret.toString((Secret)proxy.getSecretPassword()));
            }
            if ((patterns = proxy.getNoProxyHostPatterns()) != null && !patterns.isEmpty()) {
                patterns.stream().map(Pattern::pattern).forEach(arg_0 -> ((ProxyConfiguration.Builder)proxyConfiguration).addNonProxyHost(arg_0));
            }
            builder.proxyConfiguration((software.amazon.awssdk.http.apache.ProxyConfiguration)proxyConfiguration.build());
        }
        return builder.build();
    }

    public static ClientOverrideConfiguration createClientOverrideConfiguration() {
        ClientOverrideConfiguration config = (ClientOverrideConfiguration)ClientOverrideConfiguration.builder().putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)Aws4Signer.create()).retryPolicy(RetryPolicy.builder().numRetries(Integer.valueOf(16)).build()).build();
        return config;
    }

    public static URL checkEndPoint(String url) throws FormValidation {
        try {
            return new URL(url);
        }
        catch (MalformedURLException ex) {
            throw FormValidation.error((String)"Endpoint URL is not a valid URL");
        }
    }

    @CheckForNull
    private static SSHUserPrivateKey getSshCredential(String id, ItemGroup context) {
        SSHUserPrivateKey credential = (SSHUserPrivateKey)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItemGroup(SSHUserPrivateKey.class, (ItemGroup)context, null, Collections.emptyList()), (CredentialsMatcher)CredentialsMatchers.withId((String)id));
        if (credential == null) {
            LOGGER.log(Level.WARNING, "EC2 Plugin could not find the specified credentials ({0}) in the Jenkins Global Credentials Store, EC2 Plugin for cloud must be manually reconfigured", new String[]{id});
        }
        return credential;
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message) {
        EC2Cloud.log(logger, level, listener, message, null);
    }

    public static void log(Logger logger, Level level, TaskListener listener, String message, Throwable exception) {
        logger.log(level, (String)message, exception);
        if (listener != null) {
            if (exception != null) {
                message = (String)message + " Exception: " + String.valueOf(exception);
            }
            LogRecord lr = new LogRecord(level, (String)message);
            lr.setLoggerName(LOGGER.getName());
            PrintStream printStream = listener.getLogger();
            printStream.print(sf.format(lr));
        }
    }

    @Extension
    public static class EC2ConnectionUpdater
    extends PeriodicWork {
        public long getRecurrencePeriod() {
            return TimeUnit.SECONDS.toMillis(60L);
        }

        protected void doRun() throws IOException {
            Jenkins instance = Jenkins.get();
            if (instance.clouds != null) {
                for (Cloud cloud : instance.clouds) {
                    if (!(cloud instanceof EC2Cloud)) continue;
                    EC2Cloud ec2_cloud = (EC2Cloud)cloud;
                    LOGGER.finer(() -> "Checking EC2 Connection on: " + ec2_cloud.getDisplayName());
                    try {
                        if (ec2_cloud.connection == null) continue;
                        ArrayList<Filter> filters = new ArrayList<Filter>();
                        filters.add((Filter)Filter.builder().name("tag-key").values(new String[]{"bogus-EC2ConnectionKeepalive"}).build());
                        DescribeInstancesRequest dir = (DescribeInstancesRequest)DescribeInstancesRequest.builder().filters(filters).build();
                        ec2_cloud.connection.describeInstances(dir);
                    }
                    catch (SdkException e) {
                        LOGGER.finer(() -> "Reconnecting to EC2 on: " + ec2_cloud.getDisplayName());
                        ec2_cloud.reconnectToEc2();
                    }
                }
            }
        }
    }

    @Extension
    @Symbol(value={"amazonEC2"})
    public static class DescriptorImpl
    extends Descriptor<Cloud> {
        public String getDisplayName() {
            return "Amazon EC2";
        }

        public InstanceType[] getInstanceTypes() {
            return InstanceType.values();
        }

        @POST
        public FormValidation doCheckUseInstanceProfileForCredentials(@QueryParameter boolean value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER) || !value) {
                return FormValidation.ok();
            }
            try {
                InstanceProfileCredentialsProvider.builder().build().resolveCredentials();
                return FormValidation.ok();
            }
            catch (SdkException e) {
                return FormValidation.error((String)Messages.EC2Cloud_FailedToObtainCredentialsFromEC2(), (Object[])new Object[]{e.getMessage()});
            }
        }

        @POST
        public ListBoxModel doFillSshKeysCredentialsIdItems(@AncestorInPath ItemGroup context, @QueryParameter String sshKeysCredentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                result = result.includeEmptyValue().includeMatchingAs(Jenkins.getAuthentication2(), context, SSHUserPrivateKey.class, Collections.emptyList(), CredentialsMatchers.always()).includeMatchingAs(ACL.SYSTEM2, context, SSHUserPrivateKey.class, Collections.emptyList(), CredentialsMatchers.always()).includeCurrentValue(sshKeysCredentialsId);
            }
            return result;
        }

        @RequirePOST
        @Restricted(value={NoExternalUse.class})
        @NonNull
        @VisibleForTesting
        public FormValidation doCheckRoleSessionName(@QueryParameter String roleArn, @QueryParameter String roleSessionName) {
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER) && StringUtils.isNotEmpty((String)roleArn) && StringUtils.isBlank((String)roleSessionName)) {
                return FormValidation.warning((String)"Session Name is recommended when specifying an Arn Role. If empty, 'Jenkins' will be used.");
            }
            return FormValidation.ok();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequirePOST
        public FormValidation doCheckSshKeysCredentialsId(@AncestorInPath ItemGroup context, @QueryParameter String value) throws IOException, ServletException {
            String line;
            String privateKey;
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
            if (System.getProperty(SSH_PRIVATE_KEY_FILEPATH, "").isEmpty()) {
                if (value == null || value.isEmpty()) {
                    return FormValidation.error((String)"No ssh credentials selected and no private key file defined");
                }
                SSHUserPrivateKey sshCredential = EC2Cloud.getSshCredential(value, context);
                if (sshCredential == null) return FormValidation.error((String)("Failed to find credential \"" + value + "\" in store."));
                privateKey = sshCredential.getPrivateKey();
            } else {
                EC2PrivateKey k = EC2PrivateKey.fetchFromDisk();
                if (k == null) {
                    validations.add(FormValidation.error((String)("Failed to find private key file " + System.getProperty(SSH_PRIVATE_KEY_FILEPATH))));
                    if (StringUtils.isEmpty((String)value)) return FormValidation.aggregate(validations);
                    validations.add(FormValidation.warning((String)"Private key file path defined, selected credential will be ignored"));
                    return FormValidation.aggregate(validations);
                }
                privateKey = k.getPrivateKey();
            }
            boolean hasStart = false;
            boolean hasEnd = false;
            BufferedReader br = new BufferedReader(new StringReader(privateKey));
            while ((line = br.readLine()) != null) {
                if (line.equals("-----BEGIN RSA PRIVATE KEY-----") || line.equals("-----BEGIN OPENSSH PRIVATE KEY-----")) {
                    hasStart = true;
                }
                if (!line.equals("-----END RSA PRIVATE KEY-----") && !line.equals("-----END OPENSSH PRIVATE KEY-----")) continue;
                hasEnd = true;
            }
            if (!hasStart) {
                validations.add(FormValidation.error((String)"This doesn't look like a private key at all"));
            }
            if (!hasEnd) {
                validations.add(FormValidation.error((String)"The private key is missing the trailing 'END RSA PRIVATE KEY' marker. Copy&paste error?"));
            }
            if (!System.getProperty(SSH_PRIVATE_KEY_FILEPATH, "").isEmpty()) {
                if (!StringUtils.isEmpty((String)value)) {
                    validations.add(FormValidation.warning((String)"Using private key file instead of selected credential"));
                } else {
                    validations.add(FormValidation.ok((String)"Using private key file"));
                }
            }
            try {
                FIPS140Utils.ensurePrivateKeyInFipsMode(privateKey);
            }
            catch (IllegalArgumentException ex) {
                validations.add(FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage()));
            }
            validations.add(FormValidation.ok((String)"SSH key validation successful"));
            return FormValidation.aggregate(validations);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @RequirePOST
        public FormValidation doTestConnection(@AncestorInPath ItemGroup context, @QueryParameter String region, @QueryParameter String altEC2Endpoint, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String sshKeysCredentialsId, @QueryParameter String roleArn, @QueryParameter String roleSessionName) throws IOException, ServletException {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                EC2PrivateKey pk;
                ArrayList<FormValidation> validations = new ArrayList<FormValidation>();
                LOGGER.fine(() -> "begin doTestConnection()");
                String privateKey = "";
                if (System.getProperty(SSH_PRIVATE_KEY_FILEPATH, "").isEmpty()) {
                    LOGGER.fine(() -> "static credential is in use");
                    SSHUserPrivateKey sshCredential = EC2Cloud.getSshCredential(sshKeysCredentialsId, context);
                    if (sshCredential == null) return FormValidation.error((String)("Failed to find credential \"" + sshKeysCredentialsId + "\" in store."));
                    privateKey = sshCredential.getPrivateKey();
                } else {
                    EC2PrivateKey k = EC2PrivateKey.fetchFromDisk();
                    if (k == null) {
                        validations.add(FormValidation.error((String)("Failed to find private key file " + System.getProperty(SSH_PRIVATE_KEY_FILEPATH))));
                        if (StringUtils.isEmpty((String)sshKeysCredentialsId)) return FormValidation.aggregate(validations);
                        validations.add(FormValidation.warning((String)"Private key file path defined, selected credential will be ignored"));
                        return FormValidation.aggregate(validations);
                    }
                    privateKey = k.getPrivateKey();
                }
                LOGGER.fine(() -> "private key found ok");
                if (Util.fixEmpty((String)region) == null) {
                    region = EC2Cloud.DEFAULT_EC2_HOST;
                }
                AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
                Ec2Client ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.parseRegion(region), EC2Cloud.parseEndpoint(altEC2Endpoint));
                ec2.describeInstances();
                if (!privateKey.trim().isEmpty() && (pk = new EC2PrivateKey(privateKey)).find(ec2) == null) {
                    validations.add(FormValidation.error((String)("The EC2 key pair private key isn't registered to this EC2 region (fingerprint is " + pk.getFingerprint() + ")")));
                }
                if (!System.getProperty(SSH_PRIVATE_KEY_FILEPATH, "").isEmpty()) {
                    if (!StringUtils.isEmpty((String)sshKeysCredentialsId)) {
                        validations.add(FormValidation.warning((String)"Using private key file instead of selected credential"));
                    } else {
                        validations.add(FormValidation.ok((String)"Using private key file"));
                    }
                }
                try {
                    FIPS140Utils.ensurePrivateKeyInFipsMode(privateKey);
                }
                catch (IllegalArgumentException ex) {
                    validations.add(FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage()));
                }
                validations.add(FormValidation.ok((String)Messages.EC2Cloud_Success()));
                return FormValidation.aggregate(validations);
            }
            catch (SdkException e) {
                LOGGER.log(Level.WARNING, "Failed to check EC2 credential", e);
                return FormValidation.error((String)e.getMessage());
            }
        }

        @RequirePOST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath ItemGroup context) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new StandardListBoxModel();
            }
            return new StandardListBoxModel().includeEmptyValue().includeMatchingAs(ACL.SYSTEM2, context, AmazonWebServicesCredentials.class, Collections.emptyList(), CredentialsMatchers.always());
        }

        @POST
        public FormValidation doCheckCloudName(@QueryParameter String value) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                Jenkins.checkGoodName((String)value);
            }
            catch (Failure e) {
                return FormValidation.error((String)e.getMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAltEC2Endpoint(@QueryParameter String value) {
            if (Util.fixEmpty((String)value) != null) {
                try {
                    new URL(value);
                }
                catch (MalformedURLException ignored) {
                    return FormValidation.error((String)Messages.EC2Cloud_MalformedUrl());
                }
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public ListBoxModel doFillRegionItems(@QueryParameter String altEC2Endpoint, @QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId) throws IOException, ServletException {
            ListBoxModel model = new ListBoxModel();
            if (Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                try {
                    AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId);
                    URI endpoint = EC2Cloud.parseEndpoint(altEC2Endpoint);
                    Ec2Client client = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.getBootstrapRegion(endpoint), endpoint);
                    DescribeRegionsResponse regions = client.describeRegions();
                    List regionList = regions.regions();
                    for (Region r : regionList) {
                        String name = r.regionName();
                        software.amazon.awssdk.regions.Region rr = software.amazon.awssdk.regions.Region.of((String)name);
                        RegionMetadata regionMetadata = rr != null ? RegionMetadata.of((software.amazon.awssdk.regions.Region)rr) : null;
                        model.add(regionMetadata != null ? regionMetadata.description() : name, name);
                    }
                }
                catch (SdkClientException sdkClientException) {
                    // empty catch block
                }
            }
            return model;
        }
    }
}

