/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.ConnectionStrategy;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Tag;
import hudson.plugins.ec2.SSHData;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.Tenancy;
import hudson.plugins.ec2.UnixData;
import hudson.plugins.ec2.WindowsData;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.plugins.ec2.util.ResettableCountDownLatch;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import hudson.util.ListBoxModel;
import hudson.util.Secret;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.CreateTagsRequest;
import software.amazon.awssdk.services.ec2.model.DeleteTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceBlockDeviceMapping;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.StopInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TerminateInstancesRequest;

public abstract class EC2AbstractSlave
extends Slave {
    public static final Boolean DEFAULT_METADATA_SUPPORTED = Boolean.TRUE;
    public static final Boolean DEFAULT_METADATA_ENDPOINT_ENABLED = Boolean.TRUE;
    public static final Boolean DEFAULT_METADATA_TOKENS_REQUIRED = Boolean.TRUE;
    public static final Boolean DEFAULT_ENCLAVE_ENABLED = Boolean.FALSE;
    public static final Integer DEFAULT_METADATA_HOPS_LIMIT = 1;
    public static final String DEFAULT_JAVA_PATH = "java";
    private static final Logger LOGGER = Logger.getLogger(EC2AbstractSlave.class.getName());
    protected String instanceId;
    public final String initScript;
    public final String tmpDir;
    public final String remoteAdmin;
    public final String templateDescription;
    public final String javaPath;
    public final String jvmopts;
    public final boolean stopOnTerminate;
    public final String idleTerminationMinutes;
    @Deprecated
    public transient boolean useDedicatedTenancy;
    public boolean isConnected = false;
    public List<EC2Tag> tags;
    public final String cloudName;
    public AMITypeData amiType;
    public int maxTotalUses;
    public final Tenancy tenancy;
    private String instanceType;
    private Boolean metadataSupported;
    private Boolean metadataEndpointEnabled;
    private Boolean metadataTokensRequired;
    private Integer metadataHopsLimit;
    private Boolean enclaveEnabled;
    public transient String publicDNS;
    public transient String privateDNS;
    protected transient Instance lastFetchInstance = null;
    protected transient long lastFetchTime;
    protected transient ResettableCountDownLatch terminateScheduled = new ResettableCountDownLatch(1, false);
    protected static final long MIN_FETCH_TIME = Long.getLong("hudson.plugins.ec2.EC2AbstractSlave.MIN_FETCH_TIME", TimeUnit.SECONDS.toMillis(20L));
    protected final int launchTimeout;
    @Deprecated
    protected transient int sshPort;
    @Deprecated
    public transient String rootCommandPrefix;
    @Deprecated
    public transient boolean usePrivateDnsName;
    public transient String slaveCommandPrefix;
    public transient String slaveCommandSuffix;
    private transient Instant createdTime;
    public static final String TEST_ZONE = "testZone";

    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String javaPath, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported, Boolean enclaveEnabled) throws Descriptor.FormException, IOException {
        super(name, remoteFS, launcher);
        this.setNumExecutors(numExecutors);
        this.setMode(mode);
        this.setLabelString(labelString);
        this.setRetentionStrategy(retentionStrategy);
        this.setNodeProperties(nodeProperties);
        this.instanceId = instanceId;
        this.templateDescription = templateDescription;
        this.initScript = initScript;
        this.tmpDir = tmpDir;
        this.remoteAdmin = remoteAdmin;
        this.javaPath = javaPath;
        this.jvmopts = jvmopts;
        this.stopOnTerminate = stopOnTerminate;
        this.idleTerminationMinutes = idleTerminationMinutes;
        this.tags = tags;
        this.usePrivateDnsName = connectionStrategy == ConnectionStrategy.PRIVATE_DNS;
        this.useDedicatedTenancy = tenancy == Tenancy.Dedicated;
        this.cloudName = cloudName;
        this.launchTimeout = launchTimeout;
        this.amiType = amiType;
        this.maxTotalUses = maxTotalUses;
        this.tenancy = tenancy != null ? tenancy : Tenancy.Default;
        this.metadataEndpointEnabled = metadataEndpointEnabled;
        this.metadataTokensRequired = metadataTokensRequired;
        this.metadataHopsLimit = metadataHopsLimit;
        this.metadataSupported = metadataSupported;
        this.enclaveEnabled = enclaveEnabled;
        this.readResolve();
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String javaPath, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit, Boolean metadataSupported) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, DEFAULT_JAVA_PATH, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, tenancy, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, metadataSupported, DEFAULT_ENCLAVE_ENABLED);
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String javaPath, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy, Boolean metadataEndpointEnabled, Boolean metadataTokensRequired, Integer metadataHopsLimit) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, DEFAULT_JAVA_PATH, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, tenancy, metadataEndpointEnabled, metadataTokensRequired, metadataHopsLimit, DEFAULT_METADATA_SUPPORTED);
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses, Tenancy tenancy) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, DEFAULT_JAVA_PATH, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, tenancy, DEFAULT_METADATA_ENDPOINT_ENABLED, DEFAULT_METADATA_TOKENS_REQUIRED, DEFAULT_METADATA_HOPS_LIMIT);
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean useDedicatedTenancy, int launchTimeout, AMITypeData amiType, ConnectionStrategy connectionStrategy, int maxTotalUses) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, launchTimeout, amiType, connectionStrategy, maxTotalUses, Tenancy.backwardsCompatible(useDedicatedTenancy));
    }

    @Deprecated
    public EC2AbstractSlave(String name, String instanceId, String templateDescription, String remoteFS, int numExecutors, Node.Mode mode, String labelString, ComputerLauncher launcher, RetentionStrategy<EC2Computer> retentionStrategy, String initScript, String tmpDir, List<? extends NodeProperty<?>> nodeProperties, String remoteAdmin, String jvmopts, boolean stopOnTerminate, String idleTerminationMinutes, List<EC2Tag> tags, String cloudName, boolean usePrivateDnsName, boolean useDedicatedTenancy, int launchTimeout, AMITypeData amiType) throws Descriptor.FormException, IOException {
        this(name, instanceId, templateDescription, remoteFS, numExecutors, mode, labelString, launcher, retentionStrategy, initScript, tmpDir, nodeProperties, remoteAdmin, jvmopts, stopOnTerminate, idleTerminationMinutes, tags, cloudName, useDedicatedTenancy, launchTimeout, amiType, ConnectionStrategy.backwardsCompatible(usePrivateDnsName, false, false), -1);
    }

    protected Object readResolve() {
        SlaveTemplate template;
        EC2Cloud cloud;
        EC2AbstractSlave o = (EC2AbstractSlave)((Object)super.readResolve());
        if (o.instanceId == null) {
            o.instanceId = this.getNodeName();
        }
        if (o.amiType == null) {
            o.amiType = new UnixData(o.rootCommandPrefix, o.slaveCommandPrefix, o.slaveCommandSuffix, Integer.toString(o.sshPort), null);
        }
        if (o.maxTotalUses == 0 && (cloud = this.getCloud()) != null && (template = cloud.getTemplate(o.templateDescription)) != null && template.getMaxTotalUses() == -1) {
            o.maxTotalUses = -1;
        }
        if (o.terminateScheduled == null) {
            o.terminateScheduled = new ResettableCountDownLatch(1, false);
        }
        return o;
    }

    public EC2Cloud getCloud() {
        return (EC2Cloud)Jenkins.get().getCloud(this.cloudName);
    }

    static int toNumExecutors(InstanceType it) {
        switch (it) {
            case T1_MICRO: {
                return 1;
            }
            case M1_SMALL: {
                return 1;
            }
            case M1_MEDIUM: {
                return 2;
            }
            case M3_MEDIUM: {
                return 2;
            }
            case T3_NANO: {
                return 2;
            }
            case T3_A_NANO: {
                return 2;
            }
            case T3_MICRO: {
                return 2;
            }
            case T3_A_MICRO: {
                return 2;
            }
            case T3_SMALL: {
                return 2;
            }
            case T3_A_SMALL: {
                return 2;
            }
            case T3_MEDIUM: {
                return 2;
            }
            case T3_A_MEDIUM: {
                return 2;
            }
            case A1_LARGE: {
                return 2;
            }
            case T3_LARGE: {
                return 3;
            }
            case T3_A_LARGE: {
                return 3;
            }
            case M1_LARGE: {
                return 4;
            }
            case M3_LARGE: {
                return 4;
            }
            case M4_LARGE: {
                return 4;
            }
            case M5_LARGE: {
                return 4;
            }
            case M5_A_LARGE: {
                return 4;
            }
            case T3_XLARGE: {
                return 5;
            }
            case T3_A_XLARGE: {
                return 5;
            }
            case A1_XLARGE: {
                return 5;
            }
            case C1_MEDIUM: {
                return 5;
            }
            case M2_XLARGE: {
                return 6;
            }
            case C3_LARGE: {
                return 7;
            }
            case C4_LARGE: {
                return 7;
            }
            case C5_LARGE: {
                return 7;
            }
            case C5_D_LARGE: {
                return 7;
            }
            case M1_XLARGE: {
                return 8;
            }
            case T3_2_XLARGE: {
                return 10;
            }
            case T3_A_2_XLARGE: {
                return 10;
            }
            case A1_2_XLARGE: {
                return 10;
            }
            case M2_2_XLARGE: {
                return 13;
            }
            case M3_XLARGE: {
                return 13;
            }
            case M4_XLARGE: {
                return 13;
            }
            case M5_XLARGE: {
                return 13;
            }
            case M5_A_XLARGE: {
                return 13;
            }
            case A1_4_XLARGE: {
                return 14;
            }
            case C3_XLARGE: {
                return 14;
            }
            case C4_XLARGE: {
                return 14;
            }
            case C5_XLARGE: {
                return 14;
            }
            case C5_D_XLARGE: {
                return 14;
            }
            case C1_XLARGE: {
                return 20;
            }
            case M2_4_XLARGE: {
                return 26;
            }
            case M3_2_XLARGE: {
                return 26;
            }
            case M4_2_XLARGE: {
                return 26;
            }
            case M5_2_XLARGE: {
                return 26;
            }
            case M5_A_2_XLARGE: {
                return 26;
            }
            case G2_2_XLARGE: {
                return 26;
            }
            case C3_2_XLARGE: {
                return 28;
            }
            case C4_2_XLARGE: {
                return 28;
            }
            case C5_2_XLARGE: {
                return 28;
            }
            case C5_D_2_XLARGE: {
                return 28;
            }
            case CC1_4_XLARGE: {
                return 33;
            }
            case CG1_4_XLARGE: {
                return 33;
            }
            case HI1_4_XLARGE: {
                return 35;
            }
            case HS1_8_XLARGE: {
                return 35;
            }
            case C3_4_XLARGE: {
                return 55;
            }
            case C4_4_XLARGE: {
                return 55;
            }
            case C5_4_XLARGE: {
                return 55;
            }
            case C5_D_4_XLARGE: {
                return 55;
            }
            case M4_4_XLARGE: {
                return 55;
            }
            case M5_4_XLARGE: {
                return 55;
            }
            case M5_A_4_XLARGE: {
                return 55;
            }
            case CC2_8_XLARGE: {
                return 88;
            }
            case CR1_8_XLARGE: {
                return 88;
            }
            case C3_8_XLARGE: {
                return 108;
            }
            case C4_8_XLARGE: {
                return 108;
            }
            case C5_9_XLARGE: {
                return 108;
            }
            case C5_D_9_XLARGE: {
                return 108;
            }
            case M4_10_XLARGE: {
                return 120;
            }
            case M5_12_XLARGE: {
                return 120;
            }
            case M5_A_12_XLARGE: {
                return 120;
            }
            case M4_16_XLARGE: {
                return 160;
            }
            case C5_18_XLARGE: {
                return 216;
            }
            case C5_D_18_XLARGE: {
                return 216;
            }
            case M5_24_XLARGE: {
                return 240;
            }
            case M5_A_24_XLARGE: {
                return 240;
            }
            case DL1_24_XLARGE: {
                return 250;
            }
            case MAC1_METAL: {
                return 1;
            }
        }
        return 1;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public Computer createComputer() {
        return new EC2Computer(this);
    }

    public static Instance getInstance(String instanceId, EC2Cloud cloud) {
        Instance i = null;
        try {
            i = CloudHelper.getInstanceWithRetry(instanceId, cloud);
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + instanceId + " Exception: " + String.valueOf(e));
        }
        return i;
    }

    public abstract Future<?> terminate();

    void stop() {
        try {
            Ec2Client ec2 = this.getCloud().connect();
            StopInstancesRequest request = (StopInstancesRequest)StopInstancesRequest.builder().instanceIds(Collections.singletonList(this.getInstanceId())).build();
            LOGGER.fine("Sending stop request for " + this.getInstanceId());
            ec2.stopInstances(request);
            LOGGER.info("EC2 instance stop request sent for " + this.getInstanceId());
            Computer computer = this.toComputer();
            if (computer != null) {
                computer.disconnect(null);
            }
        }
        catch (SdkException e) {
            LOGGER.log(Level.WARNING, "Failed to stop EC2 instance: " + this.getInstanceId(), e);
        }
    }

    boolean terminateInstance() {
        try {
            Ec2Client ec2 = this.getCloud().connect();
            TerminateInstancesRequest request = (TerminateInstancesRequest)TerminateInstancesRequest.builder().instanceIds(Collections.singletonList(this.getInstanceId())).build();
            LOGGER.fine("Sending terminate request for " + this.getInstanceId());
            ec2.terminateInstances(request);
            LOGGER.info("EC2 instance terminate request sent for " + this.getInstanceId());
            return true;
        }
        catch (SdkException e) {
            LOGGER.log(Level.WARNING, "Failed to terminate EC2 instance: " + this.getInstanceId(), e);
            return false;
        }
    }

    public Node reconfigure(StaplerRequest2 req, JSONObject form) throws Descriptor.FormException {
        if (form == null) {
            return null;
        }
        EC2AbstractSlave result = (EC2AbstractSlave)super.reconfigure(req, form);
        if (result != null) {
            this.clearLiveInstancedata();
            result.pushLiveInstancedata();
            return result;
        }
        return null;
    }

    public boolean isAcceptingTasks() {
        return this.terminateScheduled.getCount() == 0L;
    }

    void idleTimeout() {
        LOGGER.info("EC2 instance idle time expired: " + this.getInstanceId());
        if (!this.stopOnTerminate) {
            this.terminate();
        } else {
            this.stop();
        }
    }

    void launchTimeout() {
        LOGGER.info("EC2 instance failed to launch: " + this.getInstanceId());
        this.terminate();
    }

    public long getLaunchTimeoutInMillis() {
        return (long)this.launchTimeout * 1000L;
    }

    public String getRemoteAdmin() {
        if (this.remoteAdmin == null || this.remoteAdmin.isEmpty()) {
            return this.amiType.isWindows() ? "Administrator" : "root";
        }
        return this.remoteAdmin;
    }

    String getRootCommandPrefix() {
        String commandPrefix;
        String string = commandPrefix = this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getRootCommandPrefix() : "";
        if (commandPrefix == null || commandPrefix.isEmpty()) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getSlaveCommandPrefix() {
        String commandPrefix;
        String string = commandPrefix = this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getSlaveCommandPrefix() : "";
        if (commandPrefix == null || commandPrefix.isEmpty()) {
            return "";
        }
        return commandPrefix + " ";
    }

    String getSlaveCommandSuffix() {
        String commandSuffix;
        String string = commandSuffix = this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getSlaveCommandSuffix() : "";
        if (commandSuffix == null || commandSuffix.isEmpty()) {
            return "";
        }
        return " " + commandSuffix;
    }

    String getJavaPath() {
        return Util.fixNull((String)this.javaPath);
    }

    String getJvmopts() {
        return Util.fixNull((String)this.jvmopts);
    }

    public int getSshPort() {
        String sshPort;
        String string = sshPort = this.amiType.isSSHAgent() ? ((SSHData)this.amiType).getSshPort() : "22";
        if (sshPort == null || sshPort.isEmpty()) {
            return 22;
        }
        int port = 0;
        try {
            port = Integer.parseInt(sshPort);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port != 0 ? port : 22;
    }

    public boolean getStopOnTerminate() {
        return this.stopOnTerminate;
    }

    public void onConnected() {
        this.isConnected = true;
    }

    protected boolean isAlive(boolean force) {
        this.fetchLiveInstanceData(force);
        if (this.lastFetchInstance == null) {
            return false;
        }
        return !this.lastFetchInstance.state().name().equals((Object)InstanceStateName.TERMINATED);
    }

    private void fetchLiveInstanceData(boolean force) throws SdkException {
        long now = System.currentTimeMillis();
        if (this.lastFetchTime > 0L && now - this.lastFetchTime < MIN_FETCH_TIME && !force) {
            return;
        }
        if (this.getInstanceId() == null || this.getInstanceId().isEmpty()) {
            return;
        }
        Instance i = null;
        try {
            i = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + String.valueOf(e));
            return;
        }
        this.lastFetchTime = now;
        this.lastFetchInstance = i;
        if (i == null) {
            return;
        }
        this.publicDNS = i.publicDnsName();
        this.privateDNS = i.privateIpAddress();
        this.createdTime = i.launchTime();
        this.instanceType = i.instanceType().name();
        if (!i.tags().isEmpty()) {
            this.tags = new LinkedList<EC2Tag>();
            for (Tag t : i.tags()) {
                this.tags.add(new EC2Tag(t.key(), t.value()));
            }
        }
    }

    protected void clearLiveInstancedata() throws SdkException {
        Instance inst = null;
        try {
            inst = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + String.valueOf(e));
            return;
        }
        if (!this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add((Tag)Tag.builder().key(t.getName()).value(t.getValue()).build());
            }
            List<String> resources = this.getResourcesToTag(inst);
            DeleteTagsRequest tagRequest = (DeleteTagsRequest)DeleteTagsRequest.builder().resources(resources).tags(instTags).build();
            this.getCloud().connect().deleteTags(tagRequest);
        }
    }

    protected void pushLiveInstancedata() throws SdkException {
        Instance inst = null;
        try {
            inst = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        catch (InterruptedException e) {
            LOGGER.fine("InterruptedException while get " + this.getInstanceId() + " Exception: " + String.valueOf(e));
        }
        if (inst != null && this.tags != null && !this.tags.isEmpty()) {
            HashSet<Tag> instTags = new HashSet<Tag>();
            for (EC2Tag t : this.tags) {
                instTags.add((Tag)Tag.builder().key(t.getName()).value(t.getValue()).build());
            }
            List<String> resources = this.getResourcesToTag(inst);
            CreateTagsRequest tagRequest = (CreateTagsRequest)CreateTagsRequest.builder().resources(resources).tags(instTags).build();
            this.getCloud().connect().createTags(tagRequest);
        }
    }

    private List<String> getResourcesToTag(Instance inst) {
        ArrayList<String> resources = new ArrayList<String>();
        resources.add(inst.instanceId());
        for (InstanceBlockDeviceMapping blockDeviceMapping : inst.blockDeviceMappings()) {
            resources.add(blockDeviceMapping.ebs().volumeId());
        }
        return resources;
    }

    public String getPublicDNS() {
        this.fetchLiveInstanceData(false);
        return this.publicDNS;
    }

    public String getPrivateDNS() {
        this.fetchLiveInstanceData(false);
        return this.privateDNS;
    }

    public String getInstanceType() {
        this.fetchLiveInstanceData(false);
        return this.instanceType;
    }

    public List<EC2Tag> getTags() {
        this.fetchLiveInstanceData(false);
        return Collections.unmodifiableList(this.tags);
    }

    public Instant getCreatedTime() {
        this.fetchLiveInstanceData(false);
        return this.createdTime;
    }

    @Deprecated
    public boolean getUsePrivateDnsName() {
        return this.usePrivateDnsName;
    }

    public Secret getAdminPassword() {
        return this.amiType.isWinRMAgent() ? ((WindowsData)this.amiType).getPassword() : Secret.fromString((String)"");
    }

    public boolean isUseHTTPS() {
        return this.amiType.isWinRMAgent() && ((WindowsData)this.amiType).isUseHTTPS();
    }

    public int getBootDelay() {
        return this.amiType.getBootDelayInMillis();
    }

    public Boolean getMetadataSupported() {
        return this.metadataSupported;
    }

    public Boolean getMetadataEndpointEnabled() {
        return this.metadataEndpointEnabled;
    }

    public Boolean getMetadataTokensRequired() {
        return this.metadataTokensRequired;
    }

    public Integer getMetadataHopsLimit() {
        return this.metadataHopsLimit;
    }

    public Boolean getEnclaveEnabled() {
        return this.enclaveEnabled;
    }

    public boolean isSpecifyPassword() {
        return this.amiType.isWinRMAgent() && ((WindowsData)this.amiType).isSpecifyPassword();
    }

    public boolean isAllowSelfSignedCertificate() {
        return this.amiType.isWinRMAgent() && ((WindowsData)this.amiType).isAllowSelfSignedCertificate();
    }

    public static ListBoxModel fillZoneItems(AwsCredentialsProvider credentialsProvider, String region) {
        ListBoxModel model = new ListBoxModel();
        if (!StringUtils.isEmpty((String)region)) {
            Ec2Client client = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.parseRegion(region), null);
            DescribeAvailabilityZonesResponse zones = client.describeAvailabilityZones();
            List zoneList = zones.availabilityZones();
            model.add("<not specified>", "");
            for (AvailabilityZone z : zoneList) {
                model.add(z.zoneName(), z.zoneName());
            }
        }
        return model;
    }

    public abstract String getEc2Type();

    public static abstract class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public abstract String getDisplayName();

        public boolean isInstantiable() {
            return false;
        }

        @POST
        public ListBoxModel doFillZoneItems(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String roleArn, @QueryParameter String roleSessionName) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return new ListBoxModel();
            }
            AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            return EC2AbstractSlave.fillZoneItems(credentialsProvider, region);
        }

        public List<Descriptor<AMITypeData>> getAMITypeDescriptors() {
            return Jenkins.get().getDescriptorList(AMITypeData.class);
        }
    }
}

