/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.plugins.ec2.EC2Cloud;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.DescribeAvailabilityZonesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;

final class CloudHelper {
    private static final Logger LOGGER = Logger.getLogger(CloudHelper.class.getName());

    CloudHelper() {
    }

    static Instance getInstanceWithRetry(String instanceId, EC2Cloud cloud) throws SdkException, InterruptedException {
        for (int i = 0; i < 5; ++i) {
            try {
                return CloudHelper.getInstance(instanceId, cloud);
            }
            catch (AwsServiceException e) {
                if (!"InvalidInstanceID.NotFound".equals(e.awsErrorDetails().errorCode()) && !"RequestExpired".equals(e.awsErrorDetails().errorCode())) {
                    throw e;
                }
                Thread.sleep(5000L);
                continue;
            }
        }
        return CloudHelper.getInstance(instanceId, cloud);
    }

    @CheckForNull
    static Instance getInstance(String instanceId, EC2Cloud cloud) throws SdkException {
        if (StringUtils.isEmpty((String)instanceId) || cloud == null) {
            return null;
        }
        DescribeInstancesRequest request = (DescribeInstancesRequest)DescribeInstancesRequest.builder().instanceIds(Collections.singletonList(instanceId)).build();
        List reservations = cloud.connect().describeInstances(request).reservations();
        if (reservations.size() != 1) {
            String message = "Unexpected number of reservations reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + String.valueOf(reservations) + ".";
            if (reservations.isEmpty()) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.info(message);
            throw SdkException.builder().message(message).build();
        }
        Reservation reservation = (Reservation)reservations.get(0);
        List instances = reservation.instances();
        if (instances.size() != 1) {
            String message = "Unexpected number of instances reported by EC2 for instance id '" + instanceId + "', expected 1 result, found " + String.valueOf(instances) + ".";
            if (instances.isEmpty()) {
                message = message + " Instance seems to be dead.";
            }
            LOGGER.info(message);
            throw SdkException.builder().message(message).build();
        }
        return (Instance)instances.get(0);
    }

    @CheckForNull
    static Image getAmiImage(Ec2Client ec2, String ami) {
        List<String> images = Collections.singletonList(ami);
        List owners = Collections.emptyList();
        List users = Collections.emptyList();
        DescribeImagesRequest.Builder requestBuilder = DescribeImagesRequest.builder();
        requestBuilder.imageIds(images);
        requestBuilder.owners(owners);
        requestBuilder.executableUsers(users);
        List img = ec2.describeImages((DescribeImagesRequest)requestBuilder.build()).images();
        if (img == null || img.isEmpty()) {
            return null;
        }
        return (Image)img.get(0);
    }

    static ArrayList<String> getAvailabilityZones(Ec2Client ec2) {
        ArrayList<String> availabilityZones = new ArrayList<String>();
        DescribeAvailabilityZonesResponse zones = ec2.describeAvailabilityZones();
        List zoneList = zones.availabilityZones();
        for (AvailabilityZone z : zoneList) {
            availabilityZones.add(z.zoneName());
        }
        return availabilityZones;
    }
}

