/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.win.winrm;

import hudson.plugins.ec2.util.FIPS140Utils;
import hudson.plugins.ec2.win.winrm.NegotiateNTLMSchemaFactory;
import hudson.plugins.ec2.win.winrm.RuntimeIOException;
import hudson.plugins.ec2.win.winrm.WinRMConnectException;
import hudson.plugins.ec2.win.winrm.WinRMConnectionManagerFactory;
import hudson.plugins.ec2.win.winrm.request.RequestFactory;
import hudson.plugins.ec2.win.winrm.soap.Namespaces;
import hudson.remoting.FastPipedOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.ParseException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.XPath;
import org.jaxen.NamespaceContext;
import org.jaxen.SimpleNamespaceContext;

public class WinRMClient {
    private static final Logger LOGGER = Logger.getLogger(WinRMClient.class.getName());
    private final URL url;
    private final String username;
    private final String password;
    private String shellId;
    private String commandId;
    private int exitCode;
    private final RequestFactory factory;
    private final ThreadLocal<BasicAuthCache> authCache = new ThreadLocal();
    private boolean useHTTPS;
    private BasicCredentialsProvider credsProvider;
    private final boolean allowSelfSignedCertificate;

    @Deprecated
    public WinRMClient(URL url, String username, String password) {
        this(url, username, password, false);
    }

    public WinRMClient(URL url, String username, String password, boolean allowSelfSignedCertificate) {
        FIPS140Utils.ensureNoPasswordLeak(url, password);
        FIPS140Utils.ensureNoSelfSignedCertificate(allowSelfSignedCertificate);
        this.url = url;
        this.username = username;
        this.password = password;
        this.factory = new RequestFactory(url);
        this.allowSelfSignedCertificate = allowSelfSignedCertificate;
        this.setupHTTPClient();
    }

    public void openShell() {
        LOGGER.log(Level.FINE, () -> "opening winrm shell to: " + String.valueOf(this.url));
        Document request = this.factory.newOpenShellRequest().build();
        this.shellId = WinRMClient.first(this.sendRequest(request), "//*[@Name='ShellId']");
        LOGGER.log(Level.FINER, () -> "shellid: " + this.shellId);
    }

    public void executeCommand(String command) {
        LOGGER.log(Level.FINE, () -> "winrm execute on " + this.shellId + " command: " + command);
        Document request = this.factory.newExecuteCommandRequest(this.shellId, command).build();
        this.commandId = WinRMClient.first(this.sendRequest(request), "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":CommandId");
        LOGGER.log(Level.FINER, () -> "winrm started execution on " + this.shellId + " commandId: " + this.commandId);
    }

    public void deleteShell() {
        if (this.shellId == null) {
            throw new IllegalStateException("no shell has been created");
        }
        LOGGER.log(Level.FINE, () -> "closing winrm shell " + this.shellId);
        Document request = this.factory.newDeleteShellRequest(this.shellId).build();
        this.sendRequest(request);
    }

    public void signal() {
        if (this.commandId == null) {
            throw new IllegalStateException("no command is running");
        }
        LOGGER.log(Level.FINE, () -> "signalling winrm shell " + this.shellId + " command: " + this.commandId);
        Document request = this.factory.newSignalRequest(this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public void sendInput(byte[] input) {
        LOGGER.log(Level.FINE, () -> "--> sending " + input.length);
        Document request = this.factory.newSendInputRequest(input, this.shellId, this.commandId).build();
        this.sendRequest(request);
    }

    public boolean slurpOutput(FastPipedOutputStream stdout, FastPipedOutputStream stderr) throws IOException {
        LOGGER.log(Level.FINE, () -> "--> SlurpOutput");
        HashMap<String, FastPipedOutputStream> streams = new HashMap<String, FastPipedOutputStream>();
        streams.put("stdout", stdout);
        streams.put("stderr", stderr);
        Document request = this.factory.newGetOutputRequest(this.shellId, this.commandId).build();
        Document response = this.sendRequest(request);
        XPath xpath = DocumentHelper.createXPath((String)("//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":Stream"));
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.addNamespace(Namespaces.NS_WIN_SHELL.getPrefix(), Namespaces.NS_WIN_SHELL.getURI());
        xpath.setNamespaceContext((NamespaceContext)namespaceContext);
        for (Node node : xpath.selectNodes((Object)response)) {
            if (!(node instanceof Element)) continue;
            Element e = (Element)node;
            FastPipedOutputStream stream = (FastPipedOutputStream)streams.get(e.attribute("Name").getText().toLowerCase());
            byte[] decode = Base64.getDecoder().decode(e.getText());
            LOGGER.log(Level.FINE, () -> "piping " + decode.length + " bytes from " + e.attribute("Name").getText().toLowerCase());
            stream.write(decode);
        }
        XPath done = DocumentHelper.createXPath((String)"//*[@State='http://schemas.microsoft.com/wbem/wsman/1/windows/shell/CommandState/Done']");
        done.setNamespaceContext((NamespaceContext)namespaceContext);
        List nodes = done.selectNodes((Object)response);
        if (nodes != null && nodes.isEmpty()) {
            LOGGER.log(Level.FINE, "keep going baby!");
            return true;
        }
        this.exitCode = Integer.parseInt(WinRMClient.first(response, "//" + Namespaces.NS_WIN_SHELL.getPrefix() + ":ExitCode"));
        LOGGER.log(Level.FINE, () -> "no more output - command is now done - exit code: " + this.exitCode);
        return false;
    }

    public int exitCode() {
        return this.exitCode;
    }

    private static String first(Document doc, String selector) {
        XPath xpath = DocumentHelper.createXPath((String)selector);
        List nodes = xpath.selectNodes((Object)doc);
        if (!nodes.isEmpty() && nodes.get(0) instanceof Element) {
            return ((Node)nodes.get(0)).getText();
        }
        throw new RuntimeException("Malformed response for " + selector + " in " + doc.asXML());
    }

    private void setupHTTPClient() {
        this.credsProvider = new BasicCredentialsProvider();
        this.credsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1), (Credentials)new UsernamePasswordCredentials(this.username, this.password));
    }

    private HttpClient buildHTTPClient() {
        FIPS140Utils.ensureNoPasswordLeak(this.useHTTPS, this.password);
        FIPS140Utils.ensureNoPasswordLeak(this.url, this.password);
        FIPS140Utils.ensureNoSelfSignedCertificate(this.allowSelfSignedCertificate);
        HttpClientBuilder builder = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)this.credsProvider);
        if (!this.username.contains("\\") && !this.username.contains("/")) {
            Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)new BasicSchemeFactory()).register("Negotiate", (Object)new NegotiateNTLMSchemaFactory()).build();
            builder.setDefaultAuthSchemeRegistry((Lookup)authSchemeRegistry);
        }
        if (this.useHTTPS) {
            WinRMConnectionManagerFactory.WinRMHttpConnectionManager connectionManager = this.allowSelfSignedCertificate ? WinRMConnectionManagerFactory.SSL_ALLOW_SELF_SIGNED : WinRMConnectionManagerFactory.SSL;
            builder.setSSLSocketFactory((LayeredConnectionSocketFactory)connectionManager.getSocketFactory());
            builder.setConnectionManager((HttpClientConnectionManager)connectionManager.getConnectionManager());
        } else {
            builder.setConnectionManager((HttpClientConnectionManager)WinRMConnectionManagerFactory.DEFAULT.getConnectionManager());
        }
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(5000).setSocketTimeout(0).build();
        builder.setDefaultRequestConfig(requestConfig);
        SocketConfig socketConfig = SocketConfig.custom().setTcpNoDelay(true).build();
        builder.setDefaultSocketConfig(socketConfig);
        builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean retryRequest = super.retryRequest(exception, executionCount, context);
                if (retryRequest) {
                    int sleepTime = executionCount * 5;
                    try {
                        TimeUnit.SECONDS.sleep(sleepTime);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new RuntimeException("Exception while executing command", e);
                    }
                }
                return retryRequest;
            }
        });
        return builder.build();
    }

    private Document sendRequest(Document request) {
        return this.sendRequest(request, 0);
    }

    private Document sendRequest(Document request, int retry) {
        if (retry > 3) {
            throw new RuntimeException("Too many retry for request");
        }
        HttpClient httpclient = this.buildHTTPClient();
        BasicHttpContext context = new BasicHttpContext();
        if (this.authCache.get() == null) {
            this.authCache.set(new BasicAuthCache());
        }
        context.setAttribute("http.auth.auth-cache", (Object)this.authCache.get());
        try {
            HttpPost post = new HttpPost(this.url.toURI());
            StringEntity entity = new StringEntity(request.asXML(), ContentType.APPLICATION_SOAP_XML);
            post.setEntity((HttpEntity)entity);
            LOGGER.log(Level.FINEST, () -> "Request:\nPOST " + String.valueOf(this.url) + "\n" + request.asXML());
            HttpResponse response = httpclient.execute((HttpUriRequest)post, (HttpContext)context);
            HttpEntity responseEntity = response.getEntity();
            if (response.getStatusLine().getStatusCode() != 200) {
                if (response.getStatusLine().getStatusCode() == 500 && responseEntity.getContentType() != null && entity.getContentType().getValue().startsWith(ContentType.APPLICATION_SOAP_XML.getMimeType())) {
                    String respStr = EntityUtils.toString((HttpEntity)responseEntity);
                    if (respStr.contains("TimedOut")) {
                        return DocumentHelper.parseText((String)respStr);
                    }
                } else {
                    if (response.getStatusLine().getStatusCode() == 401) {
                        LOGGER.log(Level.WARNING, "winrm returned 401 - shouldn't happen though - retrying in 2 minutes");
                        try {
                            Thread.sleep(TimeUnit.MINUTES.toMillis(2L));
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                        }
                        this.authCache.set(new BasicAuthCache());
                        LOGGER.log(Level.WARNING, "winrm returned 401 - retrying now");
                        return this.sendRequest(request, ++retry);
                    }
                    LOGGER.log(Level.WARNING, "winrm service " + this.shellId + " unexpected HTTP Response (" + response.getStatusLine().getReasonPhrase() + "): " + EntityUtils.toString((HttpEntity)response.getEntity()));
                    throw new RuntimeException("Unexpected HTTP response " + response.getStatusLine().getStatusCode() + " on " + String.valueOf(this.url) + ": " + response.getStatusLine().getReasonPhrase());
                }
            }
            if (responseEntity.getContentType() == null || !entity.getContentType().getValue().startsWith(ContentType.APPLICATION_SOAP_XML.getMimeType())) {
                throw new RuntimeException("Unexpected WinRM content type: " + String.valueOf(entity.getContentType()));
            }
            Document responseDocument = DocumentHelper.parseText((String)EntityUtils.toString((HttpEntity)responseEntity));
            LOGGER.log(Level.FINEST, () -> "Response:\n" + responseDocument.asXML());
            return responseDocument;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Invalid WinRM URI " + String.valueOf(this.url));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Invalid WinRM body " + request.asXML());
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException("HTTP Error " + e.getMessage(), e);
        }
        catch (HttpHostConnectException e) {
            LOGGER.log(Level.SEVERE, "Can't connect to host", e);
            throw new WinRMConnectException("Can't connect to host: " + e.getMessage(), e);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "I/O Exception in HTTP POST", e);
            throw new RuntimeIOException("I/O Exception " + e.getMessage(), e);
        }
        catch (ParseException e) {
            LOGGER.log(Level.SEVERE, "XML Parse exception in HTTP POST", e);
            throw new RuntimeException("Unparseable XML in winRM response " + e.getMessage(), e);
        }
        catch (DocumentException e) {
            LOGGER.log(Level.SEVERE, "XML Document exception in HTTP POST", e);
            throw new RuntimeException("Invalid XML document in winRM response " + e.getMessage(), e);
        }
    }

    public String getTimeout() {
        return this.factory.getTimeout();
    }

    public void setTimeout(String timeout) {
        this.factory.setTimeout(timeout);
    }

    public void setUseHTTPS(boolean useHTTPS) {
        FIPS140Utils.ensureNoPasswordLeak(useHTTPS, this.password);
        this.useHTTPS = useHTTPS;
    }
}

