/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Readiness;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.ssh.EC2SSHLauncher;
import hudson.plugins.ec2.util.KeyHelper;
import hudson.plugins.ec2.util.KeyPair;
import hudson.plugins.ec2.util.SSHClientHelper;
import hudson.slaves.CommandLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.CloseableScpClient;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceType;

public class EC2MacLauncher
extends EC2SSHLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2MacLauncher.class.getName());
    private static final String READINESS_SLEEP_MS = "jenkins.ec2.readinessSleepMs";
    private static final String READINESS_TRIES = "jenkins.ec2.readinessTries";
    private static final String CORRETTO_LATEST_URL = "https://corretto.aws/downloads/latest";
    private static int readinessSleepMs = 1000;
    private static int readinessTries = 120;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchScript(EC2Computer computer, TaskListener listener) throws IOException, SdkException, InterruptedException {
        PrintStream logger = listener.getLogger();
        EC2AbstractSlave node = computer.getNode();
        SlaveTemplate template = computer.getSlaveTemplate();
        if (node == null) {
            throw new IllegalStateException();
        }
        long timeout = node.getLaunchTimeoutInMillis();
        if (template == null) {
            throw new IOException("Could not find corresponding agent template for " + computer.getDisplayName());
        }
        if (node instanceof EC2Readiness) {
            EC2Readiness readinessNode = (EC2Readiness)((Object)node);
            int tries = readinessTries;
            while (tries-- > 0 && !readinessNode.isReady()) {
                this.logInfo(computer, listener, "Node still not ready. Current status: " + readinessNode.getEc2ReadinessStatus());
                Thread.sleep(readinessSleepMs);
            }
            if (!readinessNode.isReady()) {
                throw SdkException.builder().message("Node still not ready, timed out after " + readinessTries * readinessSleepMs / 1000 + "s with status " + readinessNode.getEc2ReadinessStatus()).build();
            }
        }
        this.logInfo(computer, listener, "Launching instance: " + node.getInstanceId());
        String javaPath = node.javaPath;
        String tmpDir = Util.fixEmptyAndTrim((String)node.tmpDir) != null ? node.tmpDir : "/tmp";
        try (SshClient client = SSHClientHelper.getInstance().setupSshClient(computer);){
            boolean isBootstrapped = this.bootstrap(computer, listener, template);
            if (!isBootstrapped) {
                this.logWarning(computer, listener, "bootstrapresult failed");
                return;
            }
            int bootDelay = node.getBootDelay();
            if (bootDelay > 0) {
                this.logInfo(computer, listener, "SSH service responded. Waiting " + bootDelay + "ms for service to stabilize");
                Thread.sleep(bootDelay);
                this.logInfo(computer, listener, "SSH service should have stabilized");
            }
            this.logInfo(computer, listener, "connect fresh as root");
            try (ClientSession clientSession = this.connectToSsh(client, computer, listener, template);){
                boolean isAuthenticated;
                KeyPair key = computer.getCloud().getKeyPair();
                if (key == null) {
                    isAuthenticated = false;
                } else {
                    clientSession.addPublicKeyIdentity(KeyHelper.decodeKeyPair(key.getMaterial(), ""));
                    clientSession.auth().await(timeout);
                    isAuthenticated = clientSession.isAuthenticated();
                }
                if (!isAuthenticated) {
                    this.logWarning(computer, listener, "Authentication failed");
                    return;
                }
                try (CloseableScpClient scp = this.createScpClient(clientSession);){
                    String timestamp = Duration.ofMillis(System.currentTimeMillis()).toSeconds() + " 0";
                    ScpTimestampCommandDetails scpTimestamp = ScpTimestampCommandDetails.parse((String)("T" + timestamp + " " + timestamp));
                    String initScript = node.initScript;
                    this.logInfo(computer, listener, "Creating tmp directory (" + tmpDir + ") if it does not exist");
                    this.executeRemote(clientSession, "mkdir -p " + tmpDir, logger);
                    if (StringUtils.isNotBlank((String)initScript) && !this.executeRemote(clientSession, "test -e ~/.hudson-run-init", logger)) {
                        this.logInfo(computer, listener, "Upload init script");
                        scp.upload(initScript.getBytes(StandardCharsets.UTF_8), tmpDir + "/init.sh", List.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), scpTimestamp);
                        this.logInfo(computer, listener, "Executing init script");
                        String initCommand = this.buildUpCommand(computer, tmpDir + "/init.sh");
                        this.executeRemote(clientSession, initCommand, logger);
                        this.logInfo(computer, listener, "Creating ~/.hudson-run-init");
                        String createHudsonRunInitCommand = this.buildUpCommand(computer, "touch ~/.hudson-run-init");
                        this.executeRemote(clientSession, createHudsonRunInitCommand, logger);
                    }
                    try {
                        Instance nodeInstance = computer.describeInstance();
                        if (nodeInstance.instanceType().equals((Object)InstanceType.MAC2_METAL)) {
                            LOGGER.info("Running Command for mac2.metal");
                            this.executeRemote(computer, clientSession, javaPath + " -fullversion", "curl -L -O https://corretto.aws/downloads/latest/amazon-corretto-11-aarch64-macos-jdk.pkg; sudo installer -pkg amazon-corretto-11-aarch64-macos-jdk.pkg -target /", logger, listener);
                        } else {
                            this.executeRemote(computer, clientSession, javaPath + " -fullversion", "curl -L -O https://corretto.aws/downloads/latest/amazon-corretto-11-x64-macos-jdk.pkg; sudo installer -pkg amazon-corretto-11-x64-macos-jdk.pkg -target /", logger, listener);
                        }
                    }
                    catch (InterruptedException ex) {
                        LOGGER.warning(ex.getMessage());
                    }
                    this.logInfo(computer, listener, "Copying remoting.jar to: " + tmpDir);
                    scp.upload(Jenkins.get().getJnlpJars("remoting.jar").readFully(), tmpDir + "/remoting.jar", List.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE), scpTimestamp);
                }
            }
            client.stop();
        }
        String jvmopts = node.jvmopts;
        String prefix = computer.getSlaveCommandPrefix();
        String suffix = computer.getSlaveCommandSuffix();
        String remoteFS = node.getRemoteFS();
        String workDir = Util.fixEmptyAndTrim((String)remoteFS) != null ? remoteFS : tmpDir;
        String launchString = prefix + " " + javaPath + " " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + "/remoting.jar -workDir " + workDir + suffix;
        SlaveTemplate slaveTemplate = computer.getSlaveTemplate();
        if (slaveTemplate != null && slaveTemplate.isConnectBySSHProcess()) {
            File identityKeyFile = this.createIdentityKeyFile(computer);
            try {
                String sshClientLaunchString = String.format("ssh -o StrictHostKeyChecking=%s -i %s %s@%s -p %d %s", slaveTemplate.getHostKeyVerificationStrategy().getSshCommandEquivalentFlag(), identityKeyFile.getAbsolutePath(), node.remoteAdmin, EC2MacLauncher.getEC2HostAddress(computer, template), node.getSshPort(), launchString);
                this.logInfo(computer, listener, "Launching remoting agent (via SSH client process): " + sshClientLaunchString);
                CommandLauncher commandLauncher = new CommandLauncher(sshClientLaunchString, null);
                commandLauncher.launch((SlaveComputer)computer, listener);
            }
            finally {
                if (!identityKeyFile.delete()) {
                    LOGGER.log(Level.WARNING, "Failed to delete identity key file");
                }
            }
        } else {
            this.launchRemotingAgent(computer, listener, launchString, template, timeout, logger);
        }
    }

    static {
        String prop = System.getProperty(READINESS_TRIES);
        if (prop != null) {
            readinessTries = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(READINESS_SLEEP_MS)) != null) {
            readinessSleepMs = Integer.parseInt(prop);
        }
    }
}

