/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.Cloud;
import hudson.util.ListBoxModel;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousNonBlockingStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.services.ec2.model.Instance;

public class EC2Step
extends Step {
    private String cloud;
    private String template;

    @DataBoundConstructor
    public EC2Step(String cloud, String template) {
        this.cloud = cloud;
        this.template = template;
    }

    public String getCloud() {
        return this.cloud;
    }

    public String getTemplate() {
        return this.template;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution(this, context);
    }

    public static class Execution
    extends SynchronousNonBlockingStepExecution<Instance> {
        private final String cloud;
        private final String template;

        Execution(EC2Step step, StepContext context) {
            super(context);
            this.cloud = step.cloud;
            this.template = step.template;
        }

        protected Instance run() throws Exception {
            Cloud cl = this.getByDisplayName((Jenkins.CloudList)Jenkins.get().clouds, this.cloud);
            if (cl instanceof EC2Cloud) {
                SlaveTemplate t = ((EC2Cloud)cl).getTemplate(this.template);
                if (t != null) {
                    SlaveTemplate.ProvisionOptions universe = SlaveTemplate.ProvisionOptions.ALLOW_CREATE;
                    EnumSet<SlaveTemplate.ProvisionOptions> opt = EnumSet.noneOf(SlaveTemplate.ProvisionOptions.class);
                    opt.add(universe);
                    List<EC2AbstractSlave> instances = t.provision(1, opt);
                    if (instances == null) {
                        throw new IllegalArgumentException("Error in AWS Cloud. Please review AWS template defined in Jenkins configuration.");
                    }
                    EC2AbstractSlave slave = instances.get(0);
                    return CloudHelper.getInstanceWithRetry(slave.getInstanceId(), (EC2Cloud)cl);
                }
                throw new IllegalArgumentException("Error in AWS Cloud. Please review AWS template defined in Jenkins configuration.");
            }
            throw new IllegalArgumentException("Error in AWS Cloud. Please review EC2 settings in Jenkins configuration.");
        }

        public Cloud getByDisplayName(Jenkins.CloudList clouds, String name) {
            Iterator i$ = clouds.iterator();
            Cloud c = (Cloud)i$.next();
            while (!c.getDisplayName().equals(name)) {
                if (!i$.hasNext()) {
                    return null;
                }
                c = (Cloud)i$.next();
            }
            return c;
        }
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "ec2";
        }

        public String getDisplayName() {
            return "Cloud template provisioning";
        }

        @POST
        public ListBoxModel doFillCloudItems() {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel r = new ListBoxModel();
            r.add("", "");
            Jenkins.get().clouds.getAll(EC2Cloud.class).forEach(c -> r.add(c.getDisplayName(), c.getDisplayName()));
            return r;
        }

        @POST
        public ListBoxModel doFillTemplateItems(@QueryParameter String cloudName) {
            Jenkins.get().checkPermission(Jenkins.SYSTEM_READ);
            ListBoxModel r = new ListBoxModel();
            Cloud cloud = Jenkins.get().getCloud(Util.fixEmpty((String)cloudName));
            if (cloud instanceof EC2Cloud) {
                EC2Cloud ec2Cloud = (EC2Cloud)cloud;
                for (SlaveTemplate template : ec2Cloud.getTemplates()) {
                    for (String labelList : template.labels.split(" ")) {
                        r.add(labelList + "  (AMI: " + template.getAmi() + ", REGION: " + ec2Cloud.getRegion() + ", TYPE: " + template.type + ")", labelList);
                    }
                }
            }
            return r;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }
    }
}

