/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.init.Terminator;
import hudson.model.Computer;
import hudson.model.Queue;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.util.MinimumNumberOfInstancesTimeRangeConfig;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import jenkins.model.Jenkins;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class MinimumInstanceChecker {
    private static final Logger LOGGER = Logger.getLogger(MinimumInstanceChecker.class.getName());
    @SuppressFBWarnings(value={"MS_SHOULD_BE_FINAL"}, justification="Needs to be overridden from tests")
    public static Clock clock = Clock.systemDefaultZone();

    private static Stream<EC2Computer> agentsForTemplate(@NonNull SlaveTemplate agentTemplate) {
        return Arrays.stream(Jenkins.get().getComputers()).filter(EC2Computer.class::isInstance).map(EC2Computer.class::cast).filter(computer -> {
            SlaveTemplate computerTemplate = computer.getSlaveTemplate();
            return computerTemplate != null && Objects.equals(computerTemplate.description, agentTemplate.description);
        });
    }

    public static int countCurrentNumberOfAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.agentsForTemplate(agentTemplate).count();
    }

    private static Stream<EC2Computer> idleAgents(@NonNull SlaveTemplate agentTemplate) {
        return MinimumInstanceChecker.agentsForTemplate(agentTemplate).filter(Computer::isIdle);
    }

    public static int countCurrentNumberOfSpareAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.idleAgents(agentTemplate).filter(Computer::isOnline).count();
    }

    public static int countCurrentNumberOfProvisioningAgents(@NonNull SlaveTemplate agentTemplate) {
        return (int)MinimumInstanceChecker.idleAgents(agentTemplate).filter(Computer::isOffline).filter(Computer::isConnecting).count();
    }

    public static int countQueueItemsForAgentTemplate(@NonNull SlaveTemplate agentTemplate) {
        return (int)Queue.getInstance().getBuildableItems().stream().map(item -> item.getAssignedLabel()).filter(Objects::nonNull).filter(label -> label.matches(agentTemplate.getLabelSet())).count();
    }

    public static synchronized void checkForMinimumInstances() {
        Jenkins jenkins = Jenkins.get();
        boolean hasMinimumRequirements = jenkins.clouds.stream().filter(EC2Cloud.class::isInstance).map(EC2Cloud.class::cast).flatMap(cloud -> cloud.getTemplates().stream()).anyMatch(template -> template.getMinimumNumberOfInstances() > 0 || template.getMinimumNumberOfSpareInstances() > 0);
        if (!hasMinimumRequirements) {
            return;
        }
        jenkins.clouds.stream().filter(EC2Cloud.class::isInstance).map(EC2Cloud.class::cast).forEach(cloud -> cloud.getTemplates().forEach(agentTemplate -> {
            int numberToProvision;
            if (!MinimumInstanceChecker.minimumInstancesActive(agentTemplate.getMinimumNumberOfInstancesTimeRangeConfig())) {
                return;
            }
            int requiredMinAgents = agentTemplate.getMinimumNumberOfInstances();
            int requiredMinSpareAgents = agentTemplate.getMinimumNumberOfSpareInstances();
            int currentNumberOfAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfAgents(agentTemplate);
            int currentNumberOfSpareAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfSpareAgents(agentTemplate);
            int currentNumberOfProvisioningAgentsForTemplate = MinimumInstanceChecker.countCurrentNumberOfProvisioningAgents(agentTemplate);
            int currentBuildsWaitingForTemplate = MinimumInstanceChecker.countQueueItemsForAgentTemplate(agentTemplate);
            int provisionForMinAgents = 0;
            int provisionForMinSpareAgents = 0;
            provisionForMinAgents = requiredMinAgents - currentNumberOfAgentsForTemplate;
            if (provisionForMinAgents < 0) {
                provisionForMinAgents = 0;
            }
            if (requiredMinSpareAgents > 0 && (provisionForMinSpareAgents = requiredMinSpareAgents + currentBuildsWaitingForTemplate - (currentNumberOfSpareAgentsForTemplate + provisionForMinAgents + currentNumberOfProvisioningAgentsForTemplate)) < 0) {
                provisionForMinSpareAgents = 0;
            }
            if ((numberToProvision = provisionForMinAgents + provisionForMinSpareAgents) > 0 || requiredMinAgents > 0 || requiredMinSpareAgents > 0) {
                LOGGER.log(Level.FINE, "MinimumInstanceChecker for template {0}: toProvision={1}", new Object[]{agentTemplate.description, numberToProvision});
            }
            if (numberToProvision > 0) {
                cloud.provision((SlaveTemplate)agentTemplate, numberToProvision);
            }
        }));
    }

    public static boolean minimumInstancesActive(MinimumNumberOfInstancesTimeRangeConfig minimumNumberOfInstancesTimeRangeConfig) {
        if (minimumNumberOfInstancesTimeRangeConfig == null) {
            return true;
        }
        LocalTime fromTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeFromAsTime();
        LocalTime toTime = minimumNumberOfInstancesTimeRangeConfig.getMinimumNoInstancesActiveTimeRangeToAsTime();
        LocalDateTime now = LocalDateTime.now(clock);
        LocalTime nowTime = LocalTime.from(now);
        boolean passingMidnight = false;
        if (toTime.isBefore(fromTime)) {
            passingMidnight = true;
        }
        if (passingMidnight) {
            if (nowTime.isAfter(fromTime)) {
                String today = now.getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getDay(today);
            }
            if (nowTime.isBefore(toTime)) {
                String yesterday = now.minusDays(1L).getDayOfWeek().name().toLowerCase();
                return minimumNumberOfInstancesTimeRangeConfig.getDay(yesterday);
            }
        } else if (nowTime.isAfter(fromTime) && nowTime.isBefore(toTime)) {
            String today = now.getDayOfWeek().name().toLowerCase();
            return minimumNumberOfInstancesTimeRangeConfig.getDay(today);
        }
        return false;
    }

    @Terminator
    public static void discardIdleInstances() throws Exception {
        LOGGER.fine("Looking for idle instances to discard");
        ArrayList futures = new ArrayList();
        Jenkins.get().clouds.stream().filter(EC2Cloud.class::isInstance).map(EC2Cloud.class::cast).forEach(cloud -> cloud.getTemplates().stream().filter(SlaveTemplate::getTerminateIdleDuringShutdown).forEach(agentTemplate -> MinimumInstanceChecker.idleAgents(agentTemplate).forEach(computer -> {
            EC2AbstractSlave agent = computer.getNode();
            if (agent != null) {
                LOGGER.info(() -> "discarding idle instance " + agent.getInstanceId());
                futures.add(agent.terminate());
            }
        })));
        for (Future future : futures) {
            future.get(5L, TimeUnit.SECONDS);
        }
    }
}

