/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Label;
import hudson.model.LoadStatistics;
import hudson.model.Node;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.slaves.Cloud;
import hudson.slaves.NodeProvisioner;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension(ordinal=100.0)
public class NoDelayProvisionerStrategy
extends NodeProvisioner.Strategy {
    private static final Logger LOGGER = Logger.getLogger(NoDelayProvisionerStrategy.class.getName());

    public NodeProvisioner.StrategyDecision apply(NodeProvisioner.StrategyState strategyState) {
        Label label = strategyState.getLabel();
        LoadStatistics.LoadStatisticsSnapshot snapshot = strategyState.getSnapshot();
        int provisionedButNotExecuting = this.countProvisionedButNotExecutingNodes(label);
        int availableCapacity = snapshot.getAvailableExecutors() + snapshot.getConnectingExecutors() + strategyState.getPlannedCapacitySnapshot() + strategyState.getAdditionalPlannedCapacity() + provisionedButNotExecuting;
        int currentDemand = snapshot.getQueueLength();
        LOGGER.log(Level.FINE, "Available capacity={0}, currentDemand={1}", new Object[]{availableCapacity, currentDemand});
        if (availableCapacity < currentDemand) {
            Jenkins jenkinsInstance = Jenkins.get();
            for (Cloud cloud : jenkinsInstance.clouds) {
                if (!(cloud instanceof EC2Cloud)) continue;
                EC2Cloud ec2 = (EC2Cloud)cloud;
                if (!cloud.canProvision(new Cloud.CloudState(label, 0)) || !ec2.isNoDelayProvisioning()) continue;
                int numToProvision = currentDemand - availableCapacity;
                LOGGER.log(Level.FINE, "Planned {0} new nodes", numToProvision);
                Collection plannedNodes = cloud.provision(new Cloud.CloudState(label, 0), numToProvision);
                LOGGER.log(Level.FINE, "Planned {0} new nodes", plannedNodes.size());
                strategyState.recordPendingLaunches(plannedNodes);
                LOGGER.log(Level.FINE, "After provisioning, available capacity={0}, currentDemand={1}", new Object[]{availableCapacity += plannedNodes.size(), currentDemand});
                break;
            }
        }
        if (availableCapacity >= currentDemand) {
            LOGGER.log(Level.FINE, "Provisioning completed");
            return NodeProvisioner.StrategyDecision.PROVISIONING_COMPLETED;
        }
        LOGGER.log(Level.FINE, "Provisioning not complete, consulting remaining strategies");
        return NodeProvisioner.StrategyDecision.CONSULT_REMAINING_STRATEGIES;
    }

    @VisibleForTesting
    int countProvisionedButNotExecutingNodes(Label label) {
        Jenkins jenkins = Jenkins.get();
        Set<Node> nodes = label != null ? label.getNodes() : Set.copyOf(jenkins.getNodes());
        int count = 0;
        int totalEC2Nodes = 0;
        int offlineNodes = 0;
        int connectingNodes = 0;
        int onlineNodes = 0;
        for (Node node : nodes) {
            if (!(node instanceof EC2AbstractSlave)) continue;
            ++totalEC2Nodes;
            Computer computer = node.toComputer();
            if (computer == null) continue;
            if (computer.isOnline()) {
                ++onlineNodes;
            } else if (computer.isConnecting()) {
                ++connectingNodes;
            } else if (computer.isOffline()) {
                ++offlineNodes;
            }
            if (!computer.isOffline() || computer.isConnecting()) continue;
            count += node.getNumExecutors();
        }
        LOGGER.log(Level.FINER, "EC2 nodes for label {0}: total={1}, offline={2}, connecting={3}, online={4}", new Object[]{label, totalEC2Nodes, offlineNodes, connectingNodes, onlineNodes});
        return count;
    }
}

