/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.util.KeyPair;
import hudson.util.Secret;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.UnrecoverableKeyException;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.Cipher;
import jenkins.bouncycastle.api.PEMEncodable;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;

public class EC2PrivateKey {
    private static final Logger LOGGER = Logger.getLogger(EC2PrivateKey.class.getName());
    private final Secret privateKey;

    EC2PrivateKey(String privateKey) {
        this.privateKey = Secret.fromString((String)privateKey.trim());
    }

    public String getPrivateKey() {
        return this.privateKey.getPlainText();
    }

    @Restricted(value={NoExternalUse.class})
    public Secret getPrivateKeySecret() {
        return this.privateKey;
    }

    public String getFingerprint() throws IOException {
        String pemData = this.privateKey.getPlainText();
        if (pemData == null || pemData.isEmpty()) {
            throw new IOException("This private key cannot be empty");
        }
        try {
            return PEMEncodable.decode((String)pemData).getPrivateKeyFingerprint();
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("This private key is password protected, which isn't supported yet");
        }
    }

    public String getPublicFingerprint() throws IOException {
        try {
            return PEMEncodable.decode((String)this.privateKey.getPlainText()).getPublicKeyFingerprint();
        }
        catch (UnrecoverableKeyException e) {
            throw new IOException("This private key is password protected, which isn't supported yet");
        }
    }

    public boolean isPrivateKey() throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new StringReader(this.privateKey.getPlainText()));
        while ((line = br.readLine()) != null) {
            if (!line.equals("-----BEGIN RSA PRIVATE KEY-----")) continue;
            return true;
        }
        return false;
    }

    public KeyPair find(Ec2Client ec2) throws IOException, SdkException {
        String fp = this.getFingerprint();
        String pfp = this.getPublicFingerprint();
        for (KeyPairInfo kp : ec2.describeKeyPairs().keyPairs()) {
            if (kp.keyFingerprint().equalsIgnoreCase(fp)) {
                return new KeyPair((KeyPairInfo)KeyPairInfo.builder().keyName(kp.keyName()).keyFingerprint(fp).build(), Secret.toString((Secret)this.privateKey));
            }
            if (!kp.keyFingerprint().equalsIgnoreCase(pfp)) continue;
            return new KeyPair((KeyPairInfo)KeyPairInfo.builder().keyName(kp.keyName()).keyFingerprint(pfp).build(), Secret.toString((Secret)this.privateKey));
        }
        return null;
    }

    public String decryptWindowsPassword(String encodedPassword) throws SdkException {
        try {
            Cipher cipher = Cipher.getInstance("RSA/NONE/PKCS1Padding");
            cipher.init(2, PEMEncodable.decode((String)this.privateKey.getPlainText()).toPrivateKey());
            byte[] cipherText = Base64.getDecoder().decode(StringUtils.deleteWhitespace((String)encodedPassword));
            byte[] plainText = cipher.doFinal(cipherText);
            return new String(plainText, StandardCharsets.US_ASCII);
        }
        catch (Exception e) {
            throw SdkException.create((String)"Unable to decode password", (Throwable)e);
        }
    }

    @CheckForNull
    public static EC2PrivateKey fetchFromDisk() {
        return EC2PrivateKey.fetchFromDisk(System.getProperty(EC2Cloud.SSH_PRIVATE_KEY_FILEPATH, ""));
    }

    @CheckForNull
    public static EC2PrivateKey fetchFromDisk(String filepath) {
        if (StringUtils.isNotEmpty((String)filepath)) {
            try {
                return new EC2PrivateKey(Files.readString(Paths.get(filepath, new String[0]), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOGGER.log(Level.WARNING, "unable to read private key from file " + filepath, e);
                return null;
            }
        }
        return null;
    }

    public int hashCode() {
        return this.privateKey.hashCode();
    }

    public boolean equals(Object that) {
        if (that != null && this.getClass() == that.getClass()) {
            return this.privateKey.equals((Object)((EC2PrivateKey)that).privateKey);
        }
        return false;
    }

    public String toString() {
        return this.privateKey.getPlainText();
    }
}

