/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Util;
import hudson.model.Slave;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.EC2SpotSlave;
import hudson.plugins.ec2.InstanceState;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.kohsuke.stapler.HttpRedirect;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.verb.POST;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceTypesResponse;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputRequest;
import software.amazon.awssdk.services.ec2.model.GetConsoleOutputResponse;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceTypeHypervisor;
import software.amazon.awssdk.services.ec2.model.InstanceTypeInfo;

public class EC2Computer
extends SlaveComputer {
    private static final Logger LOGGER = Logger.getLogger(EC2Computer.class.getName());
    private volatile Instance ec2InstanceDescription;
    private volatile Boolean isNitro;

    public EC2Computer(EC2AbstractSlave slave) {
        super((Slave)slave);
    }

    public EC2AbstractSlave getNode() {
        return (EC2AbstractSlave)super.getNode();
    }

    @CheckForNull
    public String getInstanceId() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getInstanceId();
    }

    public String getEc2Type() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getEc2Type();
    }

    public String getSpotInstanceRequestId() {
        EC2AbstractSlave node = this.getNode();
        if (node instanceof EC2SpotSlave) {
            return ((EC2SpotSlave)node).getSpotInstanceRequestId();
        }
        return "";
    }

    public EC2Cloud getCloud() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getCloud();
    }

    @CheckForNull
    public SlaveTemplate getSlaveTemplate() {
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            return node.getCloud().getTemplate(node.templateDescription);
        }
        return null;
    }

    public String getConsoleOutput() throws SdkException {
        try {
            return this.getDecodedConsoleOutputResponse().output();
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public String getDecodedConsoleOutput() throws SdkException {
        try {
            String encodedOutput = this.getDecodedConsoleOutputResponse().output();
            byte[] decoded = Base64.getDecoder().decode(encodedOutput);
            return new String(decoded, StandardCharsets.UTF_8);
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private GetConsoleOutputResponse getDecodedConsoleOutputResponse() throws SdkException, InterruptedException {
        Ec2Client ec2 = this.getCloud().connect();
        GetConsoleOutputRequest.Builder requestBuilder = GetConsoleOutputRequest.builder().instanceId(this.getInstanceId());
        if (this.checkIfNitro()) {
            requestBuilder.latest(Boolean.valueOf(true));
        }
        return ec2.getConsoleOutput((GetConsoleOutputRequest)requestBuilder.build());
    }

    private boolean checkIfNitro() throws SdkException, InterruptedException {
        try {
            if (this.isNitro == null) {
                InstanceTypeHypervisor hypervisor;
                DescribeInstanceTypesRequest request = (DescribeInstanceTypesRequest)DescribeInstanceTypesRequest.builder().instanceTypes(Collections.singletonList(this.describeInstance().instanceType())).build();
                Ec2Client ec2 = this.getCloud().connect();
                DescribeInstanceTypesResponse result = ec2.describeInstanceTypes(request);
                this.isNitro = result.instanceTypes().size() == 1 ? Boolean.valueOf((hypervisor = ((InstanceTypeInfo)result.instanceTypes().get(0)).hypervisor()) == InstanceTypeHypervisor.NITRO) : Boolean.valueOf(false);
            }
            return this.isNitro;
        }
        catch (SdkException e) {
            LOGGER.log(Level.WARNING, "Could not describe-instance-types to check if instance is nitro based", e);
            this.isNitro = false;
            return this.isNitro;
        }
    }

    public Instance describeInstance() throws SdkException, InterruptedException {
        if (this.ec2InstanceDescription == null) {
            this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        }
        return this.ec2InstanceDescription;
    }

    public Instance updateInstanceDescription() throws SdkException, InterruptedException {
        this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        return this.ec2InstanceDescription;
    }

    public InstanceState getState() throws SdkException, InterruptedException {
        this.ec2InstanceDescription = CloudHelper.getInstanceWithRetry(this.getInstanceId(), this.getCloud());
        return InstanceState.find(this.ec2InstanceDescription.state().name().toString());
    }

    public long getUptime() throws SdkException, InterruptedException {
        return this.describeInstance().launchTime().until(Instant.now(), ChronoUnit.MILLIS);
    }

    public String getUptimeString() throws SdkException, InterruptedException {
        return Util.getTimeSpanString((long)this.getUptime());
    }

    public Instant getLaunchTime() throws InterruptedException {
        return this.describeInstance().launchTime();
    }

    @POST
    public HttpResponse doDoDelete() throws IOException {
        this.checkPermission(DELETE);
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            node.terminate();
        }
        return new HttpRedirect("..");
    }

    @CheckForNull
    public String getRemoteAdmin() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? null : node.getRemoteAdmin();
    }

    public int getSshPort() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? 22 : node.getSshPort();
    }

    public String getRootCommandPrefix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getRootCommandPrefix();
    }

    public String getSlaveCommandPrefix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getSlaveCommandPrefix();
    }

    public String getSlaveCommandSuffix() {
        EC2AbstractSlave node = this.getNode();
        return node == null ? "" : node.getSlaveCommandSuffix();
    }

    public void onConnected() {
        EC2AbstractSlave node = this.getNode();
        if (node != null) {
            node.onConnected();
        }
    }
}

