/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.ssh;

import hudson.Util;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.plugins.ec2.EC2Readiness;
import hudson.plugins.ec2.SlaveTemplate;
import hudson.plugins.ec2.ssh.EC2SSHLauncher;
import hudson.plugins.ec2.util.KeyHelper;
import hudson.plugins.ec2.util.KeyPair;
import hudson.plugins.ec2.util.SSHClientHelper;
import hudson.slaves.CommandLauncher;
import hudson.slaves.SlaveComputer;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.attribute.PosixFilePermission;
import java.time.Duration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.CloseableScpClient;
import org.apache.sshd.scp.common.helpers.ScpTimestampCommandDetails;
import software.amazon.awssdk.core.exception.SdkException;

public class EC2UnixLauncher
extends EC2SSHLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2UnixLauncher.class.getName());
    private static final String READINESS_SLEEP_MS = "jenkins.ec2.readinessSleepMs";
    private static final String READINESS_TRIES = "jenkins.ec2.readinessTries";
    private static int readinessSleepMs = 1000;
    private static int readinessTries = 120;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void launchScript(EC2Computer computer, TaskListener listener) throws IOException, SdkException, InterruptedException {
        PrintStream logger = listener.getLogger();
        EC2AbstractSlave node = computer.getNode();
        SlaveTemplate template = computer.getSlaveTemplate();
        if (node == null) {
            throw new IllegalStateException();
        }
        long timeout = node.getLaunchTimeoutInMillis();
        if (template == null) {
            throw new IOException("Could not find corresponding agent template for " + computer.getDisplayName());
        }
        if (node instanceof EC2Readiness) {
            EC2Readiness readinessNode = (EC2Readiness)((Object)node);
            int tries = readinessTries;
            while (tries-- > 0 && !readinessNode.isReady()) {
                this.logInfo(computer, listener, "Node still not ready. Current status: " + readinessNode.getEc2ReadinessStatus());
                Thread.sleep(readinessSleepMs);
            }
            if (!readinessNode.isReady()) {
                throw SdkException.builder().message("Node still not ready, timed out after " + readinessTries * readinessSleepMs / 1000 + "s with status " + readinessNode.getEc2ReadinessStatus()).build();
            }
        }
        this.logInfo(computer, listener, "Launching instance: " + node.getInstanceId());
        String javaPath = node.javaPath;
        String tmpDir = Util.fixEmptyAndTrim((String)node.tmpDir) != null ? node.tmpDir : "/tmp";
        try (SshClient client = SSHClientHelper.getInstance().setupSshClient(computer);){
            boolean isBootstrapped = this.bootstrap(computer, listener, template);
            if (!isBootstrapped) {
                this.logWarning(computer, listener, "bootstrapresult failed");
                return;
            }
            int bootDelay = node.getBootDelay();
            if (bootDelay > 0) {
                this.logInfo(computer, listener, "SSH service responded. Waiting " + bootDelay + "ms for service to stabilize");
                Thread.sleep(bootDelay);
                this.logInfo(computer, listener, "SSH service should have stabilized");
            }
            this.logInfo(computer, listener, "connect fresh as root");
            try (ClientSession clientSession = this.connectToSsh(client, computer, listener, template);){
                boolean isAuthenticated;
                KeyPair key = computer.getCloud().getKeyPair();
                if (key == null) {
                    isAuthenticated = false;
                } else {
                    clientSession.addPublicKeyIdentity(KeyHelper.decodeKeyPair(key.getMaterial(), ""));
                    clientSession.auth().await(timeout);
                    isAuthenticated = clientSession.isAuthenticated();
                }
                if (!isAuthenticated) {
                    this.logWarning(computer, listener, "Authentication failed");
                    return;
                }
                try (CloseableScpClient scp = this.createScpClient(clientSession);){
                    String timestamp = Duration.ofMillis(System.currentTimeMillis()).toSeconds() + " 0";
                    ScpTimestampCommandDetails scpTimestamp = ScpTimestampCommandDetails.parse((String)("T" + timestamp + " " + timestamp));
                    String initScript = node.initScript;
                    this.logInfo(computer, listener, "Creating tmp directory (" + tmpDir + ") if it does not exist");
                    this.executeRemote(clientSession, "mkdir -p " + tmpDir, logger);
                    if (StringUtils.isNotBlank((String)initScript) && !this.executeRemote(clientSession, "test -e ~/.hudson-run-init", logger)) {
                        this.logInfo(computer, listener, "Upload init script");
                        scp.upload(initScript.getBytes(StandardCharsets.UTF_8), tmpDir + "/init.sh", List.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE), scpTimestamp);
                        this.logInfo(computer, listener, "Executing init script");
                        String initCommand = this.buildUpCommand(computer, tmpDir + "/init.sh");
                        if (this.executeRemote(clientSession, initCommand, logger)) {
                            this.log(Level.FINE, computer, listener, "Init script executed successfully and creating ~/.hudson-run-init");
                            String createHudsonRunInitCommand = this.buildUpCommand(computer, "touch ~/.hudson-run-init");
                            if (!this.executeRemote(clientSession, createHudsonRunInitCommand, logger)) {
                                this.logInfo(computer, listener, "Unable to create ~/.hudson-run-init");
                            }
                        } else {
                            this.log(Level.WARNING, computer, listener, "Failed to execute init script on " + node.getInstanceId());
                            clientSession.close();
                            scp.close();
                            client.stop();
                            throw new IOException("Failed to execute init script on " + node.getInstanceId());
                        }
                    }
                    this.executeRemote(computer, clientSession, javaPath + " -fullversion", "sudo amazon-linux-extras install java-openjdk11 -y; sudo yum install -y fontconfig java-11-openjdk", logger, listener);
                    this.executeRemote(computer, clientSession, "which scp", "sudo yum install -y openssh-clients", logger, listener);
                    this.logInfo(computer, listener, "Copying remoting.jar to: " + tmpDir);
                    scp.upload(Jenkins.get().getJnlpJars("remoting.jar").readFully(), tmpDir + "/remoting.jar", List.of(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE), scpTimestamp);
                }
            }
            client.stop();
        }
        String jvmopts = node.jvmopts;
        String prefix = computer.getSlaveCommandPrefix();
        String suffix = computer.getSlaveCommandSuffix();
        String remoteFS = node.getRemoteFS();
        String workDir = Util.fixEmptyAndTrim((String)remoteFS) != null ? remoteFS : tmpDir;
        String launchString = prefix + " " + javaPath + " " + (jvmopts != null ? jvmopts : "") + " -jar " + tmpDir + "/remoting.jar -workDir " + workDir + suffix;
        if (template.isConnectBySSHProcess()) {
            File identityKeyFile = this.createIdentityKeyFile(computer);
            String ec2HostAddress = EC2UnixLauncher.getEC2HostAddress(computer, template);
            File hostKeyFile = this.createHostKeyFile(computer, ec2HostAddress, listener);
            String userKnownHostsFileFlag = "";
            if (hostKeyFile != null) {
                userKnownHostsFileFlag = String.format(" -o \"UserKnownHostsFile=%s\"", hostKeyFile.getAbsolutePath());
            }
            try {
                String sshClientLaunchString = String.format("ssh -o StrictHostKeyChecking=%s%s%s -i %s %s@%s -p %d %s", template.getHostKeyVerificationStrategy().getSshCommandEquivalentFlag(), userKnownHostsFileFlag, EC2UnixLauncher.getEC2HostKeyAlgorithmFlag(computer), identityKeyFile.getAbsolutePath(), node.remoteAdmin, ec2HostAddress, node.getSshPort(), launchString);
                this.logInfo(computer, listener, "Launching remoting agent (via SSH client process): " + sshClientLaunchString);
                CommandLauncher commandLauncher = new CommandLauncher(sshClientLaunchString, null);
                commandLauncher.launch((SlaveComputer)computer, listener);
            }
            finally {
                if (!identityKeyFile.delete()) {
                    LOGGER.log(Level.WARNING, "Failed to delete identity key file");
                }
                if (hostKeyFile != null && !hostKeyFile.delete()) {
                    LOGGER.log(Level.WARNING, "Failed to delete host key file");
                }
            }
        } else {
            this.launchRemotingAgent(computer, listener, launchString, template, timeout, logger);
        }
    }

    static {
        String prop = System.getProperty(READINESS_TRIES);
        if (prop != null) {
            readinessTries = Integer.parseInt(prop);
        }
        if ((prop = System.getProperty(READINESS_SLEEP_MS)) != null) {
            readinessSleepMs = Integer.parseInt(prop);
        }
    }
}

