/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.plugins.ec2.AMITypeData;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;

public abstract class SSHData
extends AMITypeData {
    protected final String rootCommandPrefix;
    protected final String slaveCommandPrefix;
    protected final String slaveCommandSuffix;
    protected final String sshPort;
    protected final String bootDelay;

    protected SSHData(String rootCommandPrefix, String slaveCommandPrefix, String slaveCommandSuffix, String sshPort, String bootDelay) {
        this.rootCommandPrefix = rootCommandPrefix;
        this.slaveCommandPrefix = slaveCommandPrefix;
        this.slaveCommandSuffix = slaveCommandSuffix;
        this.sshPort = sshPort;
        this.bootDelay = bootDelay;
        this.readResolve();
    }

    protected Object readResolve() {
        Jenkins j = Jenkins.getInstanceOrNull();
        if (j != null) {
            j.checkPermission(Jenkins.ADMINISTER);
        }
        return this;
    }

    @Override
    public boolean isWindows() {
        return false;
    }

    @Override
    public boolean isUnix() {
        return false;
    }

    @Override
    public boolean isMac() {
        return false;
    }

    @Override
    public boolean isSSHAgent() {
        return true;
    }

    @Override
    public boolean isWinRMAgent() {
        return false;
    }

    public String getRootCommandPrefix() {
        return this.rootCommandPrefix;
    }

    public String getSlaveCommandPrefix() {
        return this.slaveCommandPrefix;
    }

    public String getSlaveCommandSuffix() {
        return this.slaveCommandSuffix;
    }

    public String getSshPort() {
        return this.sshPort == null || this.sshPort.isEmpty() ? "22" : this.sshPort;
    }

    @Override
    public String getBootDelay() {
        return this.bootDelay;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.rootCommandPrefix == null ? 0 : this.rootCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandPrefix == null ? 0 : this.slaveCommandPrefix.hashCode());
        result = 31 * result + (this.slaveCommandSuffix == null ? 0 : this.slaveCommandSuffix.hashCode());
        result = 31 * result + (this.sshPort == null ? 0 : this.sshPort.hashCode());
        result = 31 * result + (this.bootDelay == null ? 0 : this.bootDelay.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SSHData other = (SSHData)((Object)obj);
        if (StringUtils.isEmpty((String)this.rootCommandPrefix) ? !StringUtils.isEmpty((String)other.rootCommandPrefix) : !this.rootCommandPrefix.equals(other.rootCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandPrefix) ? !StringUtils.isEmpty((String)other.slaveCommandPrefix) : !this.slaveCommandPrefix.equals(other.slaveCommandPrefix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.slaveCommandSuffix) ? !StringUtils.isEmpty((String)other.slaveCommandSuffix) : !this.slaveCommandSuffix.equals(other.slaveCommandSuffix)) {
            return false;
        }
        if (StringUtils.isEmpty((String)this.sshPort) ? !StringUtils.isEmpty((String)other.sshPort) : !this.sshPort.equals(other.sshPort)) {
            return false;
        }
        return !(this.bootDelay == null ? other.bootDelay != null : !this.bootDelay.equals(other.bootDelay));
    }
}

