/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.AsyncPeriodicWork;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.util.MinimumInstanceChecker;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.model.Ec2Exception;

@Extension
public class EC2SlaveMonitor
extends AsyncPeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(EC2SlaveMonitor.class.getName());
    private final Long recurrencePeriod = Long.getLong("jenkins.ec2.checkAlivePeriod", TimeUnit.MINUTES.toMillis(10L));

    public EC2SlaveMonitor() {
        super("EC2 alive agents monitor");
        LOGGER.log(Level.FINE, "EC2 check alive period is {0}ms", this.recurrencePeriod);
    }

    public long getRecurrencePeriod() {
        return this.recurrencePeriod;
    }

    protected void execute(TaskListener listener) throws IOException, InterruptedException {
        this.removeDeadNodes();
        MinimumInstanceChecker.checkForMinimumInstances();
    }

    private void removeDeadNodes() {
        for (Node node : Jenkins.get().getNodes()) {
            if (!(node instanceof EC2AbstractSlave)) continue;
            EC2AbstractSlave ec2Slave = (EC2AbstractSlave)node;
            try {
                if (ec2Slave.isAlive(true)) continue;
                LOGGER.info("EC2 instance is dead: " + ec2Slave.getInstanceId());
                ec2Slave.terminate();
            }
            catch (SdkException e) {
                if (e instanceof Ec2Exception && "RequestExpired".equals(((Ec2Exception)e).awsErrorDetails().errorCode())) {
                    LOGGER.info("EC2 request expired, skipping consideration of " + ec2Slave.getInstanceId() + " due to unknown state.");
                    continue;
                }
                LOGGER.info("EC2 instance is dead and failed to terminate: " + ec2Slave.getInstanceId());
                this.removeNode(ec2Slave);
            }
        }
    }

    private void removeNode(EC2AbstractSlave ec2Slave) {
        try {
            Jenkins.get().removeNode((Node)ec2Slave);
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to remove node: " + ec2Slave.getInstanceId());
        }
    }
}

