/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.model.Descriptor;
import hudson.plugins.ec2.AMITypeData;
import hudson.plugins.ec2.util.FIPS140Utils;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class WindowsData
extends AMITypeData {
    private final Secret password;
    private final boolean useHTTPS;
    private final String bootDelay;
    private final boolean specifyPassword;
    private final Boolean allowSelfSignedCertificate;

    @DataBoundConstructor
    public WindowsData(String password, boolean useHTTPS, String bootDelay, boolean specifyPassword, boolean allowSelfSignedCertificate) throws Descriptor.FormException {
        try {
            FIPS140Utils.ensureNoSelfSignedCertificate(allowSelfSignedCertificate);
        }
        catch (IllegalArgumentException e) {
            throw new Descriptor.FormException((Throwable)e, "allowSelfSignedCertificate");
        }
        this.password = Secret.fromString((String)password);
        this.useHTTPS = useHTTPS;
        this.bootDelay = bootDelay;
        if (!specifyPassword && !this.password.getPlainText().isEmpty()) {
            specifyPassword = true;
        }
        this.specifyPassword = specifyPassword;
        try {
            if (specifyPassword) {
                FIPS140Utils.ensureNoPasswordLeak(useHTTPS, password);
                FIPS140Utils.ensurePasswordLength(password);
            }
        }
        catch (IllegalArgumentException e) {
            throw new Descriptor.FormException((Throwable)e, "password");
        }
        this.allowSelfSignedCertificate = allowSelfSignedCertificate;
    }

    @Deprecated
    public WindowsData(String password, boolean useHTTPS, String bootDelay, boolean specifyPassword) throws Descriptor.FormException {
        this(password, useHTTPS, bootDelay, specifyPassword, true);
    }

    public WindowsData(String password, boolean useHTTPS, String bootDelay) throws Descriptor.FormException {
        this(password, useHTTPS, bootDelay, false);
    }

    @Override
    public boolean isWindows() {
        return true;
    }

    @Override
    public boolean isUnix() {
        return false;
    }

    @Override
    public boolean isMac() {
        return false;
    }

    @Override
    public boolean isSSHAgent() {
        return false;
    }

    @Override
    public boolean isWinRMAgent() {
        return true;
    }

    public Secret getPassword() {
        return this.password;
    }

    public boolean isUseHTTPS() {
        return this.useHTTPS;
    }

    @Override
    public String getBootDelay() {
        return this.bootDelay;
    }

    public boolean isSpecifyPassword() {
        return this.specifyPassword;
    }

    @Override
    public int getBootDelayInMillis() {
        try {
            return (int)TimeUnit.SECONDS.toMillis(Integer.parseInt(this.bootDelay));
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    public boolean isAllowSelfSignedCertificate() {
        return this.allowSelfSignedCertificate == null || this.allowSelfSignedCertificate != false;
    }

    public int hashCode() {
        return Objects.hash(this.password, this.useHTTPS, this.bootDelay, this.specifyPassword);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        WindowsData other = (WindowsData)((Object)obj);
        if (this.bootDelay == null ? other.bootDelay != null : !this.bootDelay.equals(other.bootDelay)) {
            return false;
        }
        if (this.password == null ? other.password != null : !this.password.equals((Object)other.password)) {
            return false;
        }
        if (this.allowSelfSignedCertificate == null ? other.allowSelfSignedCertificate != null : !this.allowSelfSignedCertificate.equals(other.allowSelfSignedCertificate)) {
            return false;
        }
        return this.useHTTPS == other.useHTTPS && this.specifyPassword == other.specifyPassword;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<AMITypeData> {
        public String getDisplayName() {
            return "windows";
        }

        @POST
        public FormValidation doCheckPassword(@QueryParameter String password) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                FIPS140Utils.ensurePasswordLength(password);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckUseHTTPS(@QueryParameter boolean useHTTPS, @QueryParameter String password) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                FIPS140Utils.ensureNoPasswordLeak(useHTTPS, password);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }

        @POST
        public FormValidation doCheckAllowSelfSignedCertificate(@QueryParameter boolean allowSelfSignedCertificate) {
            if (!Jenkins.get().hasPermission(Jenkins.ADMINISTER)) {
                return FormValidation.ok();
            }
            try {
                FIPS140Utils.ensureNoSelfSignedCertificate(allowSelfSignedCertificate);
            }
            catch (IllegalArgumentException ex) {
                return FormValidation.error((Throwable)ex, (String)ex.getLocalizedMessage());
            }
            return FormValidation.ok();
        }
    }
}

