/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.model.Slave;
import hudson.model.TaskListener;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Computer;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.SlaveComputer;
import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.scp.client.CloseableScpClient;
import org.apache.sshd.scp.client.ScpClient;
import org.apache.sshd.scp.client.ScpClientCreator;
import software.amazon.awssdk.core.exception.SdkException;

public abstract class EC2ComputerLauncher
extends ComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(EC2ComputerLauncher.class.getName());

    public void launch(SlaveComputer slaveComputer, TaskListener listener) {
        block4: {
            try {
                EC2Computer computer = (EC2Computer)slaveComputer;
                this.launchScript(computer, listener);
            }
            catch (IOException | SdkException e) {
                e.printStackTrace(listener.error(e.getMessage()));
                Slave slave = slaveComputer.getNode();
                if (slave instanceof EC2AbstractSlave) {
                    EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slave;
                    LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                    ec2AbstractSlave.terminate();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                e.printStackTrace(listener.error(e.getMessage()));
                Slave slave = slaveComputer.getNode();
                if (!(slave instanceof EC2AbstractSlave)) break block4;
                EC2AbstractSlave ec2AbstractSlave = (EC2AbstractSlave)slave;
                LOGGER.log(Level.FINE, String.format("Terminating the ec2 agent %s due a problem launching or connecting to it", slaveComputer.getName()), e);
                ec2AbstractSlave.terminate();
            }
        }
    }

    protected abstract void launchScript(EC2Computer var1, TaskListener var2) throws SdkException, IOException, InterruptedException;

    protected int waitCompletion(ClientChannel clientChannel, long timeout) {
        Set clientChannelEvents = clientChannel.waitFor((Collection)ClientSession.REMOTE_COMMAND_WAIT_EVENTS, timeout);
        if (clientChannelEvents.contains(ClientChannelEvent.TIMEOUT)) {
            return -1;
        }
        return clientChannel.getExitStatus();
    }

    protected CloseableScpClient createScpClient(ClientSession session) {
        ScpClientCreator creator = ScpClientCreator.instance();
        ScpClient client = creator.createScpClient(session);
        return CloseableScpClient.singleSessionInstance((ScpClient)client);
    }
}

