/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.plugins.ec2.EC2AbstractSlave;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.InstanceState;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Reservation;
import software.amazon.awssdk.services.ec2.model.Tag;

@Extension
public class EC2CleanupOrphanedNodes
extends PeriodicWork {
    private final Logger LOGGER = Logger.getLogger(EC2CleanupOrphanedNodes.class.getName());
    @VisibleForTesting
    static final String NODE_EXPIRES_AT_TAG_NAME = "jenkins_node_expires_at";
    private static final long RECURRENCE_PERIOD = Long.parseLong(System.getProperty(EC2CleanupOrphanedNodes.class.getName() + ".recurrencePeriod", String.valueOf(3600000L)));
    private static final int LOST_MULTIPLIER = Integer.parseInt(System.getProperty(EC2CleanupOrphanedNodes.class.getName() + ".lostMultiplier", "3"));

    public long getRecurrencePeriod() {
        return RECURRENCE_PERIOD;
    }

    protected void doRun() {
        this.LOGGER.fine(() -> "Starting clean up activity for orphaned nodes");
        this.getClouds().forEach(this::cleanCloud);
    }

    @VisibleForTesting
    void cleanCloud(@NonNull EC2Cloud cloud) {
        Ec2Client connection;
        if (!cloud.isCleanUpOrphanedNodes()) {
            this.LOGGER.fine(() -> "Skipping clean up activity for cloud: " + cloud.getDisplayName() + " as it is disabled.");
            return;
        }
        this.LOGGER.fine(() -> "Processing clean up activity for cloud: " + cloud.getDisplayName());
        try {
            connection = cloud.connect();
        }
        catch (SdkException e) {
            this.LOGGER.log(Level.WARNING, "Failed to connect to EC2 cloud: " + cloud.getDisplayName(), e);
            return;
        }
        Set<Instance> remoteInstances = this.getAllRemoteInstance(connection, cloud);
        Set<String> localConnectedEC2Instances = this.getConnectedAgentInstanceIds(cloud);
        this.addMissingTags(connection, remoteInstances, cloud);
        Set<String> remoteInstancesIds = remoteInstances.stream().map(Instance::instanceId).collect(Collectors.toSet());
        Set<String> updatedInstances = this.updateLocalInstancesTag(connection, localConnectedEC2Instances, remoteInstancesIds, cloud);
        remoteInstances.stream().filter(remote -> !updatedInstances.contains(remote.instanceId())).filter(this::isOrphaned).forEach(remote -> this.terminateInstance(remote.instanceId(), connection));
    }

    private List<EC2Cloud> getClouds() {
        return Jenkins.get().clouds.getAll(EC2Cloud.class);
    }

    private Set<Instance> getAllRemoteInstance(Ec2Client connection, EC2Cloud cloud) throws SdkException {
        DescribeInstancesResponse result;
        HashSet<Instance> instanceIds = new HashSet<Instance>();
        String nextToken = null;
        JenkinsLocationConfiguration jenkinsLocation = JenkinsLocationConfiguration.get();
        if (jenkinsLocation.getUrl() == null) {
            this.LOGGER.warning("Jenkins server URL is not set in JenkinsLocationConfiguration.Returning empty remote instance list for cloud: " + cloud.getDisplayName());
            return instanceIds;
        }
        do {
            DescribeInstancesRequest.Builder requestBuilder = DescribeInstancesRequest.builder().maxResults(Integer.valueOf(500)).filters(new Filter[]{(Filter)Filter.builder().name("instance-state-name").values(new String[]{InstanceState.RUNNING.getCode(), InstanceState.PENDING.getCode(), InstanceState.STOPPING.getCode()}).build(), this.tagFilter("jenkins_server_url", jenkinsLocation.getUrl()), this.tagFilter("jenkins_cloud_name", cloud.getDisplayName())});
            requestBuilder.nextToken(nextToken);
            result = connection.describeInstances((DescribeInstancesRequest)requestBuilder.build());
            for (Reservation r : result.reservations()) {
                instanceIds.addAll(new HashSet(r.instances()));
            }
        } while ((nextToken = result.nextToken()) != null);
        this.LOGGER.fine(() -> "Found " + instanceIds.size() + " remote instance ID(s) for cloud: " + cloud.getDisplayName() + ". Instance IDs: " + instanceIds.stream().map(Instance::instanceId).collect(Collectors.joining(", ")));
        return instanceIds;
    }

    private Set<String> getConnectedAgentInstanceIds(EC2Cloud cloud) {
        return Jenkins.get().getNodes().stream().filter(EC2AbstractSlave.class::isInstance).map(EC2AbstractSlave.class::cast).filter(node -> ((Object)((Object)cloud)).equals((Object)node.getCloud())).map(node -> {
            this.LOGGER.fine(() -> "Connected agent: " + node.getNodeName() + ", Instance ID: " + node.getInstanceId());
            return node.getInstanceId();
        }).collect(Collectors.toSet());
    }

    private void addMissingTags(Ec2Client connection, Set<Instance> remoteInstances, EC2Cloud cloud) {
        HashSet<String> instancesToTag = new HashSet<String>();
        for (Instance remoteInstance : remoteInstances) {
            boolean hasTag = remoteInstance.tags().stream().anyMatch(tag -> NODE_EXPIRES_AT_TAG_NAME.equals(tag.key()));
            if (hasTag) continue;
            instancesToTag.add(remoteInstance.instanceId());
        }
        if (instancesToTag.isEmpty()) {
            this.LOGGER.fine(() -> "No instances to tag in cloud: " + cloud.getDisplayName());
            return;
        }
        this.LOGGER.fine(() -> "Creating tags for " + instancesToTag.size() + " instances");
        this.createOrUpdateExpiryTagInBulk(connection, cloud, instancesToTag);
    }

    private Set<String> updateLocalInstancesTag(Ec2Client connection, Set<String> localInstanceIds, Set<String> remoteInstanceIds, EC2Cloud cloud) {
        if (localInstanceIds.isEmpty()) {
            this.LOGGER.fine(() -> "No local EC2 agents found, skipping tag update.");
            return Set.of();
        }
        Sets.SetView instanceIdsToUpdate = Sets.intersection(remoteInstanceIds, localInstanceIds);
        if (instanceIdsToUpdate.isEmpty()) {
            this.LOGGER.fine(() -> "No local EC2 agents found in remote instances, skipping tag update.");
            return Set.of();
        }
        this.LOGGER.fine(() -> EC2CleanupOrphanedNodes.lambda$updateLocalInstancesTag$14((Set)instanceIdsToUpdate));
        this.createOrUpdateExpiryTagInBulk(connection, cloud, (Set<String>)instanceIdsToUpdate);
        return instanceIdsToUpdate;
    }

    private void createOrUpdateExpiryTagInBulk(Ec2Client connection, EC2Cloud cloud, Set<String> instancesToTag) {
        String nodeExpiresAtTagValue = OffsetDateTime.now(ZoneOffset.UTC).plus(RECURRENCE_PERIOD * (long)LOST_MULTIPLIER, ChronoUnit.MILLIS).toString();
        List batches = Lists.partition(new ArrayList<String>(instancesToTag), (int)500);
        this.LOGGER.fine(() -> "Creating or updating tags in batches of " + batches.size() + " for cloud: " + cloud.getDisplayName());
        for (List batch : batches) {
            try {
                connection.createTags(builder -> builder.resources((Collection)batch).tags(new Tag[]{(Tag)Tag.builder().key(NODE_EXPIRES_AT_TAG_NAME).value(nodeExpiresAtTagValue).build()}).build());
                this.LOGGER.finer(() -> "Created or Updated tag for instances " + String.valueOf(batch) + " to " + nodeExpiresAtTagValue + " in cloud: " + cloud.getDisplayName());
            }
            catch (SdkException e) {
                this.LOGGER.log(Level.WARNING, "Error updating tags for instances " + String.valueOf(batch), e);
            }
        }
    }

    private boolean isOrphaned(Instance remote) {
        String nodeExpiresAt = remote.tags() != null ? (String)remote.tags().stream().filter(tag -> NODE_EXPIRES_AT_TAG_NAME.equals(tag.key())).map(Tag::value).findFirst().orElse(null) : null;
        if (nodeExpiresAt == null) {
            this.LOGGER.fine(() -> "Instance " + remote.instanceId() + " does not have the tag jenkins_node_expires_at");
            return false;
        }
        String currentTime = OffsetDateTime.now(ZoneOffset.UTC).toString();
        boolean isOrphan = nodeExpiresAt.compareTo(currentTime) < 0;
        this.LOGGER.fine(() -> "Instance " + remote.instanceId() + ", nodeExpiresAt: " + nodeExpiresAt + ", currentDate: " + currentTime + ", isOrphan: " + isOrphan);
        return isOrphan;
    }

    private void terminateInstance(String instanceId, Ec2Client connection) {
        this.LOGGER.info(() -> "Removing orphaned instance: " + instanceId);
        try {
            connection.terminateInstances(builder -> builder.instanceIds(new String[]{instanceId}).build());
        }
        catch (SdkException ex) {
            this.LOGGER.log(Level.WARNING, "Error terminating remote instance " + instanceId, ex);
        }
    }

    private Filter tagFilter(String tagName, String tagValue) {
        return (Filter)Filter.builder().name("tag:" + tagName).values(new String[]{tagValue}).build();
    }

    private static /* synthetic */ String lambda$updateLocalInstancesTag$14(Set instanceIdsToUpdate) {
        return "Updating tags for " + instanceIdsToUpdate.size() + " instances";
    }
}

