/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2.util;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.plugins.ec2.util.FIPS140Utils;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.digest.BuiltinDigests;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.bouncycastle.asn1.ASN1BitString;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.sec.ECPrivateKey;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.interfaces.EdDSAPrivateKey;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.util.Properties;

public abstract class KeyHelper {
    private static final Logger LOGGER = Logger.getLogger(KeyHelper.class.getName());

    private KeyHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static KeyPair decodeKeyPair(@NonNull String pem, @NonNull String password) throws IOException {
        try (PEMParser pemParser = new PEMParser((Reader)new StringReader(pem));){
            Object object = pemParser.readObject();
            if (object == null) {
                throw new IllegalArgumentException("Failed to parse PEM input");
            }
            JcaPEMKeyConverter converter = new JcaPEMKeyConverter();
            if (object instanceof PEMEncryptedKeyPair) {
                PEMKeyPair decryptedKeyPair = ((PEMEncryptedKeyPair)object).decryptKeyPair(new JcePEMDecryptorProviderBuilder().build(password.toCharArray()));
                PrivateKey privateKey = converter.getPrivateKey(decryptedKeyPair.getPrivateKeyInfo());
                FIPS140Utils.ensureKeyInFipsMode(privateKey);
                PublicKey publicKey2 = converter.getPublicKey(decryptedKeyPair.getPublicKeyInfo());
                KeyPair keyPair = new KeyPair(publicKey2, privateKey);
                return keyPair;
            }
            if (object instanceof PrivateKeyInfo) {
                PrivateKeyInfo privateKeyInfo = (PrivateKeyInfo)object;
                PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
                FIPS140Utils.ensureKeyInFipsMode(privateKey);
                PublicKey publicKey3 = KeyHelper.generatePublicKeyFromPrivateKey(privateKeyInfo, privateKey);
                KeyPair publicKey2 = new KeyPair(publicKey3, privateKey);
                return publicKey2;
            }
            if (object instanceof SubjectPublicKeyInfo) {
                PublicKey publicKey = converter.getPublicKey((SubjectPublicKeyInfo)object);
                FIPS140Utils.ensureKeyInFipsMode(publicKey);
                KeyPair publicKey3 = new KeyPair(publicKey, null);
                return publicKey3;
            }
            if (!(object instanceof PEMKeyPair)) throw new IllegalArgumentException("Unsupported PEM object type: " + object.getClass().getName());
            SubjectPublicKeyInfo publicKeyInfo = ((PEMKeyPair)object).getPublicKeyInfo();
            PrivateKeyInfo privateKeyInfo = ((PEMKeyPair)object).getPrivateKeyInfo();
            PrivateKey privateKey = converter.getPrivateKey(privateKeyInfo);
            FIPS140Utils.ensureKeyInFipsMode(privateKey);
            PublicKey publicKey = converter.getPublicKey(publicKeyInfo);
            KeyPair keyPair = new KeyPair(publicKey, privateKey);
            return keyPair;
        }
        catch (Exception e) {
            throw new IOException("Failed to parse PEM input", e);
        }
    }

    static PublicKey generatePublicKeyFromPrivateKey(PrivateKeyInfo privateKeyInfo, @NonNull PrivateKey privateKey) {
        try {
            if (privateKey instanceof RSAPrivateCrtKey) {
                return KeyFactory.getInstance("RSA").generatePublic(new RSAPublicKeySpec(((RSAPrivateCrtKey)privateKey).getModulus(), ((RSAPrivateCrtKey)privateKey).getPublicExponent()));
            }
            if (privateKey instanceof DSAPrivateKey) {
                DSAParams dsaParams = ((DSAPrivateKey)privateKey).getParams();
                return KeyFactory.getInstance("DSA").generatePublic(new DSAPublicKeySpec(dsaParams.getG().modPow(((DSAPrivateKey)privateKey).getX(), dsaParams.getP()), dsaParams.getP(), dsaParams.getQ(), dsaParams.getG()));
            }
            if (privateKey instanceof java.security.interfaces.ECPrivateKey) {
                ASN1BitString asn1BitString = ECPrivateKey.getInstance((Object)privateKeyInfo.getPrivateKey().getOctets()).getPublicKey();
                return KeyFactory.getInstance("EC").generatePublic(new X509EncodedKeySpec(new SubjectPublicKeyInfo(privateKeyInfo.getPrivateKeyAlgorithm(), asn1BitString).getEncoded()));
            }
            if (privateKey instanceof EdDSAPrivateKey) {
                return ((EdDSAPrivateKey)privateKey).getPublicKey();
            }
            return null;
        }
        catch (IOException | NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }

    public static String getSshAlgorithm(@NonNull PublicKey serverKey) {
        try {
            Properties.setThreadOverride((String)"org.bouncycastle.emulate.oracle", (boolean)true);
            String sshAlgorithm = KeyUtils.getKeyType((Key)serverKey);
            if (sshAlgorithm == null && "Ed25519".equals(serverKey.getAlgorithm())) {
                sshAlgorithm = "ssh-ed25519";
            }
            String string = sshAlgorithm;
            return string;
        }
        finally {
            Properties.removeThreadOverride((String)"org.bouncycastle.emulate.oracle");
        }
    }

    public static String getFingerprint(@NonNull PublicKey serverKey) {
        try {
            Properties.setThreadOverride((String)"org.bouncycastle.emulate.oracle", (boolean)true);
            byte[] rawFingerprint = KeyUtils.getRawFingerprint((Digest)((Digest)BuiltinDigests.md5.get()), (PublicKey)serverKey);
            String string = BufferUtils.toHex((char)':', (byte[])rawFingerprint).toLowerCase(Locale.ROOT);
            return string;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Error computing fingerprint", e);
            String string = "";
            return string;
        }
        finally {
            Properties.removeThreadOverride((String)"org.bouncycastle.emulate.oracle");
        }
    }
}

