/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.ec2;

import hudson.Extension;
import hudson.Functions;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.plugins.ec2.CloudHelper;
import hudson.plugins.ec2.EC2Cloud;
import hudson.plugins.ec2.util.AmazonEC2Factory;
import hudson.security.Permission;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotPriceHistoryResponse;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.PlatformValues;
import software.amazon.awssdk.services.ec2.model.SpotPrice;

public final class SpotConfiguration
extends AbstractDescribableImpl<SpotConfiguration> {
    public final boolean useBidPrice;
    private String spotMaxBidPrice;
    private boolean fallbackToOndemand;
    private int spotBlockReservationDuration;

    @Deprecated
    public SpotConfiguration(boolean useBidPrice, String spotMaxBidPrice, boolean fallbackToOndemand, String spotBlockReservationDurationStr) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = spotMaxBidPrice;
        this.fallbackToOndemand = fallbackToOndemand;
        this.spotBlockReservationDuration = null == spotBlockReservationDurationStr || spotBlockReservationDurationStr.isEmpty() ? 0 : Integer.parseInt(spotBlockReservationDurationStr);
    }

    @DataBoundConstructor
    public SpotConfiguration(boolean useBidPrice) {
        this.useBidPrice = useBidPrice;
        this.spotMaxBidPrice = "";
    }

    public String getSpotMaxBidPrice() {
        return this.spotMaxBidPrice;
    }

    @DataBoundSetter
    public void setSpotMaxBidPrice(String spotMaxBidPrice) {
        this.spotMaxBidPrice = spotMaxBidPrice;
    }

    public boolean getFallbackToOndemand() {
        return this.fallbackToOndemand;
    }

    @DataBoundSetter
    public void setFallbackToOndemand(boolean fallbackToOndemand) {
        this.fallbackToOndemand = fallbackToOndemand;
    }

    public int getSpotBlockReservationDuration() {
        return this.spotBlockReservationDuration;
    }

    @DataBoundSetter
    public void setSpotBlockReservationDuration(int spotBlockReservationDuration) {
        this.spotBlockReservationDuration = spotBlockReservationDuration;
    }

    public boolean equals(Object obj) {
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        SpotConfiguration config = (SpotConfiguration)((Object)obj);
        String normalizedBid = SpotConfiguration.normalizeBid(this.spotMaxBidPrice);
        String otherNormalizedBid = SpotConfiguration.normalizeBid(config.spotMaxBidPrice);
        boolean normalizedBidsAreEqual = Objects.equals(normalizedBid, otherNormalizedBid);
        boolean blockReservationIsEqual = true;
        if (this.spotBlockReservationDuration != config.spotBlockReservationDuration) {
            blockReservationIsEqual = false;
        }
        return this.useBidPrice == config.useBidPrice && this.fallbackToOndemand == config.fallbackToOndemand && normalizedBidsAreEqual && blockReservationIsEqual;
    }

    public int hashCode() {
        return Objects.hash(this.useBidPrice, this.spotMaxBidPrice, this.fallbackToOndemand);
    }

    public static String normalizeBid(String bid) {
        try {
            float spotPrice = Float.parseFloat(bid);
            if ((double)spotPrice < 0.001) {
                return null;
            }
            return Float.toString(spotPrice);
        }
        catch (NumberFormatException ex) {
            return null;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<SpotConfiguration> {
        public String getDisplayName() {
            return "spotConfig";
        }

        @RequirePOST
        public FormValidation doCurrentSpotPrice(@QueryParameter boolean useInstanceProfileForCredentials, @QueryParameter String credentialsId, @QueryParameter String region, @QueryParameter String altEC2Endpoint, @QueryParameter String type, @QueryParameter String zone, @QueryParameter String roleArn, @QueryParameter String roleSessionName, @QueryParameter String ami) throws IOException, ServletException {
            Functions.checkPermission((Permission)EC2Cloud.PROVISION);
            String cp = "";
            Object zoneStr = "";
            AwsCredentialsProvider credentialsProvider = EC2Cloud.createCredentialsProvider(useInstanceProfileForCredentials, credentialsId, roleArn, roleSessionName, region);
            Ec2Client ec2 = AmazonEC2Factory.getInstance().connect(credentialsProvider, EC2Cloud.parseRegion(region), null);
            if (ec2 != null) {
                try {
                    Image img;
                    DescribeSpotPriceHistoryRequest.Builder requestBuilder = DescribeSpotPriceHistoryRequest.builder();
                    if (CloudHelper.getAvailabilityZones(ec2).contains(zone)) {
                        requestBuilder.availabilityZone(zone);
                        zoneStr = zone + " availability zone";
                    } else {
                        zoneStr = region + " region";
                    }
                    InstanceType ec2Type = InstanceType.fromValue((String)type);
                    if (ec2Type == null || ec2Type == InstanceType.UNKNOWN_TO_SDK_VERSION) {
                        return FormValidation.error((String)("Could not resolve instance type: " + type));
                    }
                    if (!ami.isEmpty() && (img = CloudHelper.getAmiImage(ec2, ami)) != null) {
                        ArrayList<String> productDescriptions = new ArrayList<String>();
                        productDescriptions.add(img.platform() == PlatformValues.WINDOWS ? "Windows" : "Linux/UNIX");
                        requestBuilder.productDescriptions(productDescriptions);
                    }
                    ArrayList<InstanceType> instanceType = new ArrayList<InstanceType>();
                    instanceType.add(ec2Type);
                    requestBuilder.instanceTypes(instanceType);
                    requestBuilder.startTime(Instant.now());
                    DescribeSpotPriceHistoryResponse result = ec2.describeSpotPriceHistory((DescribeSpotPriceHistoryRequest)requestBuilder.build());
                    if (!result.spotPriceHistory().isEmpty()) {
                        SpotPrice currentPrice = (SpotPrice)result.spotPriceHistory().get(0);
                        cp = currentPrice.spotPrice();
                    }
                }
                catch (AwsServiceException e) {
                    return FormValidation.error((String)e.getMessage());
                }
            }
            if (cp.isEmpty()) {
                return FormValidation.error((String)"Could not retrieve current Spot price");
            }
            cp = cp.substring(0, cp.length() - 3);
            return FormValidation.ok((String)("The current Spot price for a " + type + " in the " + (String)zoneStr + " is $" + cp));
        }
    }
}

