/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.EC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2FleetStatusInfo;
import com.amazon.jenkins.ec2fleet.EC2FleetStatusWidget;
import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.slaves.Cloud;
import hudson.widgets.Widget;
import java.util.ArrayList;
import java.util.List;
import jenkins.model.Jenkins;

@Extension
public class EC2FleetStatusWidgetUpdater
extends PeriodicWork {
    public long getRecurrencePeriod() {
        return 10000L;
    }

    protected void doRun() {
        ArrayList<EC2FleetStatusInfo> info = new ArrayList<EC2FleetStatusInfo>();
        for (Cloud cloud : EC2FleetStatusWidgetUpdater.getClouds()) {
            EC2FleetCloud fleetCloud;
            FleetStateStats stats;
            if (!(cloud instanceof EC2FleetCloud) || (stats = (fleetCloud = (EC2FleetCloud)cloud).getStats()) == null) continue;
            info.add(new EC2FleetStatusInfo(fleetCloud.getFleet(), stats.getState().getDetailed(), fleetCloud.getLabelString(), stats.getNumActive(), stats.getNumDesired()));
        }
        for (Widget w : EC2FleetStatusWidgetUpdater.getWidgets()) {
            if (!(w instanceof EC2FleetStatusWidget)) continue;
            ((EC2FleetStatusWidget)w).setStatusList(info);
        }
    }

    @VisibleForTesting
    static List<Widget> getWidgets() {
        return Jenkins.get().getWidgets();
    }

    @VisibleForTesting
    static List<Cloud> getClouds() {
        return Jenkins.get().clouds;
    }
}

