/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.EC2FleetCloud;
import com.amazon.jenkins.ec2fleet.FleetStateStats;
import com.fasterxml.jackson.databind.ObjectMapper;
import hudson.Extension;
import hudson.model.RootAction;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jenkins.model.Jenkins;

@Extension
public class EC2FleetStatsApi
implements RootAction {
    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    public String getUrlName() {
        return "ec2-fleet";
    }

    public void doStats(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        ArrayList statsList = new ArrayList();
        for (Cloud cloud : Jenkins.get().clouds) {
            EC2FleetCloud fleetCloud;
            FleetStateStats stats;
            if (!(cloud instanceof EC2FleetCloud) || (stats = (fleetCloud = (EC2FleetCloud)cloud).getStats()) == null) continue;
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("fleet", fleetCloud.getFleet());
            data.put("state", stats.getState().getDetailed());
            data.put("label", fleetCloud.getLabelString());
            data.put("numActive", stats.getNumActive());
            data.put("numDesired", stats.getNumDesired());
            statsList.add(data);
        }
        rsp.setContentType("application/json");
        new ObjectMapper().writeValue((Writer)rsp.getWriter(), statsList);
    }
}

