/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.AbstractEC2FleetCloud;
import com.amazon.jenkins.ec2fleet.EC2FleetNodeComputer;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Failure;
import hudson.model.Node;
import hudson.model.Slave;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.EphemeralNode;
import hudson.slaves.NodeProperty;
import hudson.slaves.RetentionStrategy;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

public class EC2FleetNode
extends Slave
implements EphemeralNode {
    private static final Logger LOGGER = Logger.getLogger(EC2FleetNode.class.getName());
    private String cloudName;
    private String instanceId;
    private final int maxTotalUses;
    private int usesRemaining;

    public EC2FleetNode(String instanceId, String nodeDescription, String remoteFS, int numExecutors, Node.Mode mode, String label, List<? extends NodeProperty<?>> nodeProperties, String cloudName, ComputerLauncher launcher, int maxTotalUses) throws IOException, Descriptor.FormException {
        super(instanceId, nodeDescription, remoteFS, numExecutors, mode, label, launcher, RetentionStrategy.NOOP, nodeProperties);
        this.cloudName = cloudName;
        this.instanceId = instanceId;
        this.maxTotalUses = maxTotalUses;
        this.usesRemaining = maxTotalUses;
    }

    public String getCloudName() {
        return this.cloudName;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public int getMaxTotalUses() {
        return this.maxTotalUses;
    }

    public int getUsesRemaining() {
        return this.usesRemaining;
    }

    public void decrementUsesRemaining() {
        --this.usesRemaining;
    }

    public Node asNode() {
        return this;
    }

    public String getDisplayName() {
        String name = String.format("%s %s", this.cloudName, this.instanceId);
        try {
            Jenkins.checkGoodName((String)name);
            return name;
        }
        catch (Failure e) {
            return this.instanceId;
        }
    }

    public Computer createComputer() {
        return new EC2FleetNodeComputer(this);
    }

    public AbstractEC2FleetCloud getCloud() {
        return (AbstractEC2FleetCloud)Jenkins.get().getCloud(this.cloudName);
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends Slave.SlaveDescriptor {
        public String getDisplayName() {
            return "Fleet Slave";
        }

        public boolean isInstantiable() {
            return false;
        }
    }
}

