/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.jenkins.ec2fleet;

import com.amazon.jenkins.ec2fleet.EC2FleetCloud;
import com.google.common.annotations.VisibleForTesting;
import hudson.Extension;
import hudson.model.PeriodicWork;
import hudson.slaves.Cloud;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;

@Extension
public class CloudNanny
extends PeriodicWork {
    private static final Logger LOGGER = Logger.getLogger(CloudNanny.class.getName());
    private final Map<EC2FleetCloud, AtomicInteger> recurrenceCounters = Collections.synchronizedMap(new WeakHashMap());

    public long getRecurrencePeriod() {
        return 1000L;
    }

    protected void doRun() {
        for (Cloud cloud : CloudNanny.getClouds()) {
            EC2FleetCloud fleetCloud;
            AtomicInteger recurrenceCounter;
            if (!(cloud instanceof EC2FleetCloud) || (recurrenceCounter = this.getRecurrenceCounter(fleetCloud = (EC2FleetCloud)cloud)).decrementAndGet() > 0) continue;
            recurrenceCounter.set(fleetCloud.getCloudStatusIntervalSec());
            try {
                this.updateCloudWithScaler(CloudNanny.getClouds(), fleetCloud);
                fleetCloud.update();
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, String.format("Error during fleet '%s' stats update", fleetCloud.name), e);
            }
        }
    }

    @VisibleForTesting
    static Jenkins.CloudList getClouds() {
        return Jenkins.get().clouds;
    }

    private void updateCloudWithScaler(Jenkins.CloudList clouds, EC2FleetCloud oldCloud) throws IOException {
        if (oldCloud.getExecutorScaler() != null) {
            return;
        }
        EC2FleetCloud.ExecutorScaler scaler = oldCloud.isScaleExecutorsByWeight() ? new EC2FleetCloud.WeightedScaler() : new EC2FleetCloud.NoScaler();
        scaler.withNumExecutors(oldCloud.getNumExecutors());
        EC2FleetCloud fleetCloudWithScaler = this.createCloudWithScaler(oldCloud, scaler);
        clouds.replace((Object)oldCloud, (Object)fleetCloudWithScaler);
        Jenkins.get().save();
    }

    private EC2FleetCloud createCloudWithScaler(EC2FleetCloud oldCloud, EC2FleetCloud.ExecutorScaler scaler) {
        return new EC2FleetCloud(oldCloud.getDisplayName(), oldCloud.getAwsCredentialsId(), oldCloud.getAwsCredentialsId(), oldCloud.getRegion(), oldCloud.getEndpoint(), oldCloud.getFleet(), oldCloud.getLabelString(), oldCloud.getFsRoot(), oldCloud.getComputerConnector(), oldCloud.isPrivateIpUsed(), oldCloud.isAlwaysReconnect(), oldCloud.getIdleMinutes(), oldCloud.getMinSize(), oldCloud.getMaxSize(), oldCloud.getMinSpareSize(), oldCloud.getNumExecutors(), oldCloud.isAddNodeOnlyIfRunning(), oldCloud.isRestrictUsage(), String.valueOf(oldCloud.getMaxTotalUses()), oldCloud.isDisableTaskResubmit(), oldCloud.getInitOnlineTimeoutSec(), oldCloud.getInitOnlineCheckIntervalSec(), oldCloud.getCloudStatusIntervalSec(), oldCloud.isNoDelayProvision(), oldCloud.isScaleExecutorsByWeight(), scaler);
    }

    private AtomicInteger getRecurrenceCounter(EC2FleetCloud fleetCloud) {
        AtomicInteger counter = new AtomicInteger(fleetCloud.getCloudStatusIntervalSec());
        AtomicInteger existing = this.recurrenceCounters.putIfAbsent(fleetCloud, counter);
        return existing != null ? existing : counter;
    }
}

