/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.pipeline;

import com.nirima.jenkins.plugins.docker.DockerCloud;
import com.nirima.jenkins.plugins.docker.DockerTemplate;
import com.nirima.jenkins.plugins.docker.DockerTemplateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Action;
import hudson.model.Computer;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.slaves.Cloud;
import hudson.slaves.WorkspaceList;
import io.jenkins.docker.DockerComputer;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerAttachConnector;
import io.jenkins.docker.connector.DockerComputerConnector;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.DynamicContext;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.support.actions.WorkspaceActionImpl;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

class DockerNodeStepExecution
extends StepExecution {
    private static final long serialVersionUID = 1959552800000929329L;
    @Restricted(value={NoExternalUse.class})
    static final DockerComputerConnector DEFAULT_CONNECTOR = new DockerComputerAttachConnector();
    private final String dockerHost;
    private final String credentialsId;
    private final String image;
    private final String remoteFs;
    private final Serializable connector;
    private volatile transient CompletableFuture<DockerTransientNode> task;
    private volatile String nodeName;

    public DockerNodeStepExecution(StepContext context, @Nullable DockerComputerConnector connector, String dockerHost, String credentialsId, String image, String remoteFs) {
        super(context);
        if (connector != null) {
            DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)connector);
            this.connector = (Serializable)((Object)connector);
        } else {
            DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)DEFAULT_CONNECTOR);
            this.connector = (Serializable)((Object)DEFAULT_CONNECTOR);
        }
        this.dockerHost = dockerHost;
        this.credentialsId = credentialsId;
        this.image = image;
        this.remoteFs = remoteFs;
    }

    @Restricted(value={NoExternalUse.class})
    static void assertIsSerializableDockerComputerConnector(Object connector) {
        Class<?> clazz;
        String whatUserTried = connector.toString();
        String msg = DockerNodeStepExecution.getReasonWhyThisIsNotASerializableDockerComputerConnector(whatUserTried, clazz = connector.getClass());
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
    }

    @Restricted(value={NoExternalUse.class})
    static String getReasonWhyThisIsNotASerializableDockerComputerConnector(String whatUserTried, Class<? extends Object> clazz) {
        boolean extendsOk = DockerComputerConnector.class.isAssignableFrom(clazz);
        boolean implementsOk = Serializable.class.isAssignableFrom(clazz);
        if (extendsOk && implementsOk) {
            return null;
        }
        String msg = whatUserTried + " is not valid." + (String)(extendsOk ? "" : " It does not extend " + DockerComputerConnector.class.getCanonicalName() + ".") + (String)(implementsOk ? "" : " It does not implement " + Serializable.class.getCanonicalName() + ".");
        return msg;
    }

    public boolean start() throws Exception {
        TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
        listener.getLogger().println("Launching new docker node based on " + this.image);
        this.task = CompletableFuture.supplyAsync(() -> this.createNode(listener));
        this.task.thenAccept(node -> this.invokeBody((DockerTransientNode)((Object)node), listener));
        return false;
    }

    public void onResume() {
        try {
            if (this.nodeName == null) {
                this.start();
            }
        }
        catch (Exception x) {
            this.getContext().onFailure((Throwable)x);
        }
    }

    private DockerTransientNode createNode(TaskListener listener) {
        DockerTransientNode node;
        String uuid = UUID.randomUUID().toString();
        DockerTemplate t = new DockerTemplate(new DockerTemplateBase(this.image), (DockerComputerConnector)((Object)this.connector), uuid, this.remoteFs, "1");
        t.setMode(Node.Mode.EXCLUSIVE);
        DockerAPI api = this.dockerHost == null && this.credentialsId == null ? DockerNodeStepExecution.defaultApi() : new DockerAPI(new DockerServerEndpoint(this.dockerHost, this.credentialsId));
        Computer computer = null;
        try {
            node = t.provisionNode(api, listener);
            node.setDockerAPI(api);
            node.setAcceptingTasks(false);
            node.robustlyAddToJenkins();
            listener.getLogger().println("Waiting for node to be online ...");
            while ((computer = node.toComputer()) == null || computer.isOffline()) {
                Thread.sleep(1000L);
            }
            listener.getLogger().println("Node " + node.getNodeName() + " is online.");
        }
        catch (Exception e) {
            if (computer != null) {
                try {
                    String computerLogAsString = computer.getLog();
                    listener.getLogger().println("Node provisioning failed: " + String.valueOf(e));
                    listener.getLogger().println(computerLogAsString);
                    listener.getLogger().println("See log above for details.");
                }
                catch (IOException x) {
                    listener.getLogger().println("Failed to capture docker agent provisioning log " + String.valueOf(x));
                }
            }
            this.getContext().onFailure((Throwable)e);
            return null;
        }
        return node;
    }

    private static DockerAPI defaultApi() {
        for (Cloud cloud : Jenkins.get().clouds) {
            if (!(cloud instanceof DockerCloud)) continue;
            return ((DockerCloud)cloud).getDockerApi();
        }
        throw new IllegalStateException("Must either specify dockerHost/credentialsId, or define at least one Docker cloud");
    }

    private void invokeBody(DockerTransientNode node, TaskListener listener) {
        this.nodeName = node.getNodeName();
        FilePath ws = null;
        Computer computer = null;
        EnvVars env = null;
        try {
            ws = node.createPath(node.getRemoteFS() + "/workspace");
            FlowNode flowNode = (FlowNode)this.getContext().get(FlowNode.class);
            flowNode.addAction((Action)new WorkspaceActionImpl(ws, flowNode));
            computer = node.toComputer();
            if (computer == null) {
                throw new IllegalStateException("Agent not started");
            }
            env = computer.getEnvironment();
            env.overrideExpandingAll((Map)computer.buildEnvironment(listener));
            env.put("NODE_NAME", computer.getName());
            env.put("EXECUTOR_NUMBER", "0");
            env.put("NODE_LABELS", DockerNodeStepExecution.join(node.getAssignedLabels(), " "));
            if (ws != null) {
                env.put("WORKSPACE", ws.getRemote());
            } else {
                listener.getLogger().println("Unexpected null workspace, WORKSPACE not added to environment");
            }
            FilePath tempDir = WorkspaceList.tempDir((FilePath)ws);
            if (tempDir != null) {
                env.put("WORKSPACE_TMP", tempDir.getRemote());
            }
        }
        catch (IOException | InterruptedException e) {
            this.getContext().onFailure((Throwable)e);
        }
        this.getContext().newBodyInvoker().withCallback((BodyExecutionCallback)new Callback((Node)node)).withContexts(new Object[]{computer, env, ws}).start();
    }

    private static String join(Collection<?> objects, String delimiter) {
        return objects.stream().map(Object::toString).collect(Collectors.joining(delimiter));
    }

    public void stop(@NonNull Throwable cause) throws Exception {
        if (this.task != null) {
            this.task.cancel(true);
        }
    }

    private static class Callback
    extends BodyExecutionCallback.TailCall {
        private final String nodeName;

        public Callback(Node node) {
            this.nodeName = node.getNodeName();
        }

        protected void finished(StepContext context) throws Exception {
            DockerTransientNode node = (DockerTransientNode)Jenkins.get().getNode(this.nodeName);
            if (node != null) {
                TaskListener listener = (TaskListener)context.get(TaskListener.class);
                listener.getLogger().println("Terminating docker node ...");
                node._terminate(listener);
                node.robustlyRemoveFromJenkins();
            }
        }
    }

    @Extension
    public static final class ProvideDockerTransientNode
    extends DynamicContext.Typed<DockerTransientNode> {
        protected Class<DockerTransientNode> type() {
            return DockerTransientNode.class;
        }

        protected DockerTransientNode get(DynamicContext.DelegatedContext context) throws IOException, InterruptedException {
            Computer c = (Computer)context.get(Computer.class);
            return c instanceof DockerComputer ? (DockerTransientNode)((DockerComputer)c).getNode() : null;
        }
    }
}

