/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.pipeline;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.DescriptorExtensionList;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.TaskListener;
import hudson.util.ListBoxModel;
import io.jenkins.docker.connector.DockerComputerConnector;
import io.jenkins.docker.pipeline.DockerNodeStepExecution;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.workflow.graph.FlowNode;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class DockerNodeStep
extends Step {
    private String dockerHost;
    private String credentialsId;
    private String image;
    private String remoteFs;
    private DockerComputerConnector connector;

    @DataBoundConstructor
    public DockerNodeStep(String image) {
        this.image = image;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    @DataBoundSetter
    public void setDockerHost(String dockerHost) {
        this.dockerHost = Util.fixEmpty((String)dockerHost);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getImage() {
        return this.image;
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = Util.fixEmpty((String)remoteFs);
    }

    public <T extends DockerComputerConnector> T getConnector() {
        if (this.connector == null) {
            return null;
        }
        DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)this.connector);
        return (T)((Object)this.connector);
    }

    @DataBoundSetter
    public void setConnector(DockerComputerConnector connector) {
        if (connector == null || connector.equals((Object)DockerNodeStepExecution.DEFAULT_CONNECTOR)) {
            this.connector = null;
        } else {
            DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)connector);
            this.connector = connector;
        }
    }

    public StepExecution start(StepContext context) throws Exception {
        return new DockerNodeStepExecution(context, this.connector, this.dockerHost, this.credentialsId, this.image, this.remoteFs);
    }

    @Extension(optional=true)
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "dockerNode";
        }

        @NonNull
        public String getDisplayName() {
            return "Docker Node (\u26a0\ufe0f Experimental)";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            DockerServerEndpoint.DescriptorImpl descriptor = (DockerServerEndpoint.DescriptorImpl)Jenkins.get().getDescriptorOrDie(DockerServerEndpoint.class);
            return descriptor.doFillCredentialsIdItems(item, uri);
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Set.of(TaskListener.class, FlowNode.class);
        }

        public Set<? extends Class<?>> getProvidedContext() {
            return Set.of(Computer.class, FilePath.class, Node.class, Launcher.class);
        }

        public List<Descriptor<? extends DockerComputerConnector>> getAcceptableConnectorDescriptors() {
            ArrayList<Descriptor<? extends DockerComputerConnector>> result = new ArrayList<Descriptor<? extends DockerComputerConnector>>();
            DescriptorExtensionList<DockerComputerConnector, Descriptor<DockerComputerConnector>> all = DockerComputerConnector.all();
            for (Descriptor connectorDescriptor : all) {
                Class connectorClass = connectorDescriptor.getKlass().toJavaClass();
                String reason = DockerNodeStepExecution.getReasonWhyThisIsNotASerializableDockerComputerConnector(connectorClass.toGenericString(), connectorClass);
                if (reason != null) continue;
                result.add((Descriptor<? extends DockerComputerConnector>)connectorDescriptor);
            }
            return result;
        }
    }
}

