/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.pipeline;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.util.ListBoxModel;
import io.jenkins.docker.connector.DockerComputerConnector;
import io.jenkins.docker.pipeline.DockerNodeStep;
import io.jenkins.docker.pipeline.DockerNodeStepExecution;
import java.net.URL;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.jenkinsci.plugins.pipeline.modeldefinition.parser.CompatibilityLoader;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.verb.POST;

public class DockerAgent
extends DeclarativeAgent<DockerAgent> {
    private static final long serialVersionUID = 1L;
    private final String image;
    private String dockerHost;
    private String credentialsId;
    private String remoteFs;
    @SuppressFBWarnings(value={"SE_BAD_FIELD"}, justification="Checked in setter")
    private DockerComputerConnector connector;

    @DataBoundConstructor
    public DockerAgent(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public String getDockerHost() {
        return this.dockerHost;
    }

    @DataBoundSetter
    public void setDockerHost(String dockerHost) {
        this.dockerHost = Util.fixEmpty((String)dockerHost);
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @DataBoundSetter
    public void setCredentialsId(String credentialsId) {
        this.credentialsId = Util.fixEmpty((String)credentialsId);
    }

    public String getRemoteFs() {
        return this.remoteFs;
    }

    @DataBoundSetter
    public void setRemoteFs(String remoteFs) {
        this.remoteFs = Util.fixEmpty((String)remoteFs);
    }

    public DockerComputerConnector getConnector() {
        if (this.connector == null) {
            return null;
        }
        DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)this.connector);
        return this.connector;
    }

    @DataBoundSetter
    public void setConnector(DockerComputerConnector connector) {
        if (connector == null || connector.equals((Object)DockerNodeStepExecution.DEFAULT_CONNECTOR)) {
            this.connector = null;
        } else {
            DockerNodeStepExecution.assertIsSerializableDockerComputerConnector((Object)connector);
            this.connector = connector;
        }
    }

    public Map<String, Object> getAsArgs() {
        LinkedHashMap<String, Object> args = new LinkedHashMap<String, Object>();
        args.put("image", this.image);
        if (this.dockerHost != null) {
            args.put("dockerHost", this.dockerHost);
        }
        if (this.credentialsId != null) {
            args.put("credentialsId", this.credentialsId);
        }
        if (this.remoteFs != null) {
            args.put("remoteFs", this.remoteFs);
        }
        if (this.connector != null) {
            args.put("connector", (Object)this.connector);
        }
        return args;
    }

    @Extension(optional=true)
    public static final class Compat
    implements CompatibilityLoader {
        public URL loadGroovySource(String clazz) {
            return "io.jenkins.docker.pipeline.DockerAgentScript".equals(clazz) ? DockerAgent.class.getResource("DockerAgentScript-old.groovy") : null;
        }
    }

    @Symbol(value={"dockerContainer"})
    @Extension
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<DockerAgent> {
        public String getDisplayName() {
            return "Start a Docker container with a new agent (\u26a0\ufe0f Experimental)";
        }

        @POST
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String uri) {
            return ((DockerServerEndpoint.DescriptorImpl)ExtensionList.lookupSingleton(DockerServerEndpoint.DescriptorImpl.class)).doFillCredentialsIdItems(item, uri);
        }

        public List<Descriptor<? extends DockerComputerConnector>> getAcceptableConnectorDescriptors() {
            return ((DockerNodeStep.DescriptorImpl)((Object)ExtensionList.lookupSingleton(DockerNodeStep.DescriptorImpl.class))).getAcceptableConnectorDescriptors();
        }
    }
}

