/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.exception.NotFoundException;
import com.github.dockerjava.api.model.Frame;
import hudson.model.Queue;
import hudson.model.TaskListener;
import hudson.slaves.ComputerLauncher;
import hudson.slaves.DelegatingComputerLauncher;
import hudson.slaves.SlaveComputer;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import java.io.Closeable;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

class DockerDelegatingComputerLauncher
extends DelegatingComputerLauncher {
    private static final Logger LOGGER = Logger.getLogger(DockerDelegatingComputerLauncher.class.getName());
    private static final Level LOG_LEVEL = Level.FINE;
    private final DockerAPI api;
    private final String containerId;
    private transient boolean haveLoggedOnDisconnectAlready;

    public DockerDelegatingComputerLauncher(ComputerLauncher launcher, DockerAPI api, String containerId) {
        super(launcher);
        this.api = api;
        this.containerId = containerId;
    }

    public void launch(SlaveComputer computer, TaskListener listener) throws IOException, InterruptedException {
        try (DockerClient client = this.api.getClient();){
            client.inspectContainerCmd(this.containerId).exec();
        }
        catch (NotFoundException handledByCode) {
            LOGGER.log(LOG_LEVEL, "Container " + this.containerId + " no longer exists - NOT launching agent.");
            Queue.withLock(() -> {
                DockerTransientNode node = (DockerTransientNode)computer.getNode();
                node._terminate(listener);
            });
            return;
        }
        LOGGER.log(LOG_LEVEL, "Container " + this.containerId + " exists - launching agent.");
        super.launch(computer, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDisconnect(SlaveComputer computer, TaskListener listener) {
        boolean shouldSeeWhatTheContainerLogged;
        DockerDelegatingComputerLauncher dockerDelegatingComputerLauncher = this;
        synchronized (dockerDelegatingComputerLauncher) {
            shouldSeeWhatTheContainerLogged = !this.haveLoggedOnDisconnectAlready;
            this.haveLoggedOnDisconnectAlready = true;
        }
        if (shouldSeeWhatTheContainerLogged) {
            DockerLog callback = new DockerLog();
            try (DockerClient client = this.api.getClient();){
                client.logContainerCmd(this.containerId).withStdErr(Boolean.valueOf(true)).withStdOut(Boolean.valueOf(true)).withTail(Integer.valueOf(100)).exec((ResultCallback)callback);
            }
            catch (Exception ignored) {
                LOGGER.log(LOG_LEVEL, "Container " + this.containerId + " log could not be inspected.", ignored);
            }
        }
        super.beforeDisconnect(computer, listener);
    }

    private class DockerLog
    implements ResultCallback<Frame> {
        private DockerLog() {
        }

        public void close() throws IOException {
        }

        public void onStart(Closeable closeable) {
        }

        public void onNext(Frame object) {
            LOGGER.log(LOG_LEVEL, "Container " + DockerDelegatingComputerLauncher.this.containerId + " logged: " + object.toString());
        }

        public void onError(Throwable throwable) {
            LOGGER.log(LOG_LEVEL, "Container " + DockerDelegatingComputerLauncher.this.containerId + " threw:", throwable);
        }

        public void onComplete() {
        }
    }
}

