/*
 * Decompiled with CFR 0.152.
 */
package io.jenkins.docker.connector;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHAuthenticator;
import com.cloudbees.jenkins.plugins.sshcredentials.impl.BasicSSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernameListBoxModel;
import com.github.dockerjava.api.DockerClient;
import com.github.dockerjava.api.command.CreateContainerCmd;
import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.HostConfig;
import com.github.dockerjava.api.model.NetworkSettings;
import com.github.dockerjava.api.model.PortBinding;
import com.github.dockerjava.api.model.Ports;
import com.nirima.jenkins.plugins.docker.utils.JenkinsUtils;
import com.nirima.jenkins.plugins.docker.utils.PortUtils;
import com.trilead.ssh2.Connection;
import com.trilead.ssh2.signature.RSAKeyAlgorithm;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TaskListener;
import hudson.plugins.sshslaves.SSHLauncher;
import hudson.plugins.sshslaves.verifiers.NonVerifyingKeyVerificationStrategy;
import hudson.plugins.sshslaves.verifiers.SshHostKeyVerificationStrategy;
import hudson.security.ACL;
import hudson.security.AccessControlled;
import hudson.slaves.ComputerLauncher;
import hudson.util.FormValidation;
import hudson.util.ListBoxModel;
import io.jenkins.docker.DockerTransientNode;
import io.jenkins.docker.client.DockerAPI;
import io.jenkins.docker.connector.DockerComputerConnector;
import io.jenkins.docker.connector.HostPortComparator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import jenkins.bouncycastle.api.PEMEncodable;
import jenkins.model.Jenkins;
import org.apache.tools.tar.TarEntry;
import org.apache.tools.tar.TarOutputStream;
import org.jenkinsci.Symbol;
import org.jenkinsci.main.modules.instance_identity.InstanceIdentity;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComputerSSHConnector
extends DockerComputerConnector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerComputerSSHConnector.class);
    private final SSHKeyStrategy sshKeyStrategy;
    private int port;
    @CheckForNull
    private String jvmOptions;
    @CheckForNull
    private String javaPath;
    @CheckForNull
    private String prefixStartSlaveCmd;
    @CheckForNull
    private String suffixStartSlaveCmd;
    @CheckForNull
    private Integer launchTimeoutSeconds;
    @CheckForNull
    private Integer maxNumRetries;
    @CheckForNull
    private Integer retryWaitTime;

    @DataBoundConstructor
    public DockerComputerSSHConnector(SSHKeyStrategy sshKeyStrategy) {
        this.sshKeyStrategy = sshKeyStrategy;
        this.port = 22;
        this.maxNumRetries = 30;
        this.retryWaitTime = 2;
    }

    public SSHKeyStrategy getSshKeyStrategy() {
        return this.sshKeyStrategy;
    }

    public int getPort() {
        return this.port;
    }

    @DataBoundSetter
    public void setPort(int port) {
        this.port = port;
    }

    @CheckForNull
    public String getJvmOptions() {
        return Util.fixEmptyAndTrim((String)this.jvmOptions);
    }

    @DataBoundSetter
    public void setJvmOptions(String jvmOptions) {
        this.jvmOptions = Util.fixEmptyAndTrim((String)jvmOptions);
    }

    @CheckForNull
    public String getJavaPath() {
        return Util.fixEmptyAndTrim((String)this.javaPath);
    }

    @DataBoundSetter
    public void setJavaPath(String javaPath) {
        this.javaPath = Util.fixEmptyAndTrim((String)javaPath);
    }

    @CheckForNull
    public String getPrefixStartSlaveCmd() {
        return Util.fixEmptyAndTrim((String)this.prefixStartSlaveCmd);
    }

    @DataBoundSetter
    public void setPrefixStartSlaveCmd(String prefixStartSlaveCmd) {
        this.prefixStartSlaveCmd = Util.fixEmptyAndTrim((String)prefixStartSlaveCmd);
    }

    @CheckForNull
    public String getSuffixStartSlaveCmd() {
        return Util.fixEmptyAndTrim((String)this.suffixStartSlaveCmd);
    }

    @DataBoundSetter
    public void setSuffixStartSlaveCmd(String suffixStartSlaveCmd) {
        this.suffixStartSlaveCmd = Util.fixEmptyAndTrim((String)suffixStartSlaveCmd);
    }

    @CheckForNull
    public Integer getLaunchTimeoutSeconds() {
        return this.launchTimeoutSeconds;
    }

    @DataBoundSetter
    public void setLaunchTimeoutSeconds(Integer launchTimeoutSeconds) {
        this.launchTimeoutSeconds = launchTimeoutSeconds;
    }

    @CheckForNull
    public Integer getMaxNumRetries() {
        return this.maxNumRetries;
    }

    @DataBoundSetter
    public void setMaxNumRetries(Integer maxNumRetries) {
        this.maxNumRetries = maxNumRetries;
    }

    @CheckForNull
    public Integer getRetryWaitTime() {
        return this.retryWaitTime;
    }

    @DataBoundSetter
    public void setRetryWaitTime(Integer retryWaitTime) {
        this.retryWaitTime = retryWaitTime;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(new Object[]{this.javaPath, this.jvmOptions, this.launchTimeoutSeconds, this.maxNumRetries, this.port, this.prefixStartSlaveCmd, this.retryWaitTime, this.sshKeyStrategy, this.suffixStartSlaveCmd});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        DockerComputerSSHConnector other = (DockerComputerSSHConnector)((Object)obj);
        return Objects.equals(this.javaPath, other.javaPath) && Objects.equals(this.jvmOptions, other.jvmOptions) && Objects.equals(this.launchTimeoutSeconds, other.launchTimeoutSeconds) && Objects.equals(this.maxNumRetries, other.maxNumRetries) && this.port == other.port && Objects.equals(this.prefixStartSlaveCmd, other.prefixStartSlaveCmd) && Objects.equals(this.retryWaitTime, other.retryWaitTime) && Objects.equals((Object)this.sshKeyStrategy, (Object)other.sshKeyStrategy) && Objects.equals(this.suffixStartSlaveCmd, other.suffixStartSlaveCmd);
    }

    public String toString() {
        StringBuilder sb = JenkinsUtils.startToString((Object)this);
        JenkinsUtils.bldToString(sb, "sshKeyStrategy", (Object)this.sshKeyStrategy);
        JenkinsUtils.bldToString(sb, "port", this.port);
        JenkinsUtils.bldToString(sb, "jvmOptions", this.jvmOptions);
        JenkinsUtils.bldToString(sb, "javaPath", this.javaPath);
        JenkinsUtils.bldToString(sb, "prefixStartSlaveCmd", this.prefixStartSlaveCmd);
        JenkinsUtils.bldToString(sb, "suffixStartSlaveCmd", this.suffixStartSlaveCmd);
        JenkinsUtils.bldToString(sb, "launchTimeoutSeconds", this.launchTimeoutSeconds);
        JenkinsUtils.bldToString(sb, "maxNumRetries", this.maxNumRetries);
        JenkinsUtils.bldToString(sb, "retryWaitTime", this.retryWaitTime);
        JenkinsUtils.endToString(sb);
        return sb.toString();
    }

    @Override
    public void beforeContainerCreated(DockerAPI api, String workdir, CreateContainerCmd cmd) throws IOException, InterruptedException {
        Ports portBindings;
        String[] cmdArray = cmd.getCmd();
        if (cmdArray == null || cmdArray.length == 0) {
            if (this.sshKeyStrategy.getInjectedKey() != null) {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port), "-o", "AuthorizedKeysCommand=/root/authorized_key", "-o", "AuthorizedKeysCommandUser=root"});
            } else {
                cmd.withCmd(new String[]{"/usr/sbin/sshd", "-D", "-p", String.valueOf(this.port)});
            }
        }
        cmd.withPortSpecs(new String[]{this.port + "/tcp"});
        PortBinding sshPortBinding = PortBinding.parse((String)(":" + this.port));
        HostConfig hostConfig = cmd.getHostConfig();
        if (hostConfig == null) {
            hostConfig = new HostConfig();
            cmd.withHostConfig(hostConfig);
        }
        if ((portBindings = hostConfig.getPortBindings()) != null) {
            Ports.Binding[] portBinding = (Ports.Binding[])portBindings.getBindings().get(sshPortBinding.getExposedPort());
            if (portBinding == null || portBinding.length == 0) {
                portBindings.add(new PortBinding[]{sshPortBinding});
            }
            hostConfig.withPortBindings(portBindings);
        } else {
            hostConfig.withPortBindings(new PortBinding[]{sshPortBinding});
        }
        cmd.withExposedPorts(new ExposedPort[]{ExposedPort.parse((String)(this.port + "/tcp"))});
    }

    @Override
    public void beforeContainerStarted(DockerAPI api, String workdir, DockerTransientNode node) throws IOException, InterruptedException {
        String key = this.sshKeyStrategy.getInjectedKey();
        if (key != null) {
            String containerId = node.getContainerId();
            String authorizedKeysCommand = "#!/bin/sh\n[ \"$1\" = \"" + this.sshKeyStrategy.getUser() + "\" ] && echo '" + key + "'|| :";
            byte[] authorizedKeysCommandAsBytes = authorizedKeysCommand.getBytes(StandardCharsets.UTF_8);
            try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
                 TarOutputStream tar = new TarOutputStream((OutputStream)bos);){
                TarEntry entry = new TarEntry("authorized_key");
                entry.setSize((long)authorizedKeysCommandAsBytes.length);
                entry.setMode(448);
                tar.putNextEntry(entry);
                tar.write(authorizedKeysCommandAsBytes);
                tar.closeEntry();
                tar.close();
                try (ByteArrayInputStream is = new ByteArrayInputStream(bos.toByteArray());
                     DockerClient client = api.getClient();){
                    client.copyArchiveToContainerCmd(containerId).withTarInputStream((InputStream)is).withRemotePath("/root").exec();
                }
            }
        }
    }

    @Override
    protected ComputerLauncher createLauncher(DockerAPI api, String workdir, InspectContainerResponse inspect, TaskListener listener) throws IOException, InterruptedException {
        Integer sshTimeoutSeconds;
        Integer retryWaitTimeOrNull;
        if ("exited".equals(inspect.getState().getStatus())) {
            LOGGER.error("Failed to launch docker SSH agent :" + inspect.getState().getExitCodeLong());
            throw new IOException("Failed to launch docker SSH agent. Container exited with status " + inspect.getState().getExitCodeLong());
        }
        LOGGER.debug("container created {}", (Object)inspect);
        InetSocketAddress address = DockerComputerSSHConnector.getBindingForPort(api, inspect, this.port);
        PortUtils.ConnectionCheck connectionCheck = PortUtils.connectionCheck(address);
        PortUtils.ConnectionCheckSSH connectionCheckSSH = connectionCheck.useSSH();
        Integer maxNumRetriesOrNull = this.getMaxNumRetries();
        if (maxNumRetriesOrNull != null) {
            connectionCheck.withRetries(maxNumRetriesOrNull);
        }
        if ((retryWaitTimeOrNull = this.getRetryWaitTime()) != null) {
            connectionCheck.withEveryRetryWaitFor(retryWaitTimeOrNull, TimeUnit.SECONDS);
        }
        if ((sshTimeoutSeconds = this.getLaunchTimeoutSeconds()) != null) {
            connectionCheckSSH.withSSHTimeout(sshTimeoutSeconds, TimeUnit.SECONDS);
        }
        long timestampBeforeConnectionCheck = System.nanoTime();
        if (!connectionCheck.execute() || !connectionCheckSSH.execute()) {
            long timestampAfterConnectionCheckEnded = System.nanoTime();
            long nanosecondsElapsed = timestampAfterConnectionCheckEnded - timestampBeforeConnectionCheck;
            long secondsElapsed = TimeUnit.NANOSECONDS.toSeconds(nanosecondsElapsed);
            long millisecondsElapsed = TimeUnit.NANOSECONDS.toMillis(nanosecondsElapsed) - TimeUnit.SECONDS.toMillis(secondsElapsed);
            throw new IOException("SSH service hadn't started after " + secondsElapsed + " seconds and " + millisecondsElapsed + " milliseconds.Try increasing the number of retries (currently " + maxNumRetriesOrNull + ") and/or the retry wait time (currently " + retryWaitTimeOrNull + ") to allow for containers taking longer to start.");
        }
        return this.sshKeyStrategy.getSSHLauncher(address, this);
    }

    private static InetSocketAddress getBindingForPort(DockerAPI api, InspectContainerResponse ir, int internalPort) {
        ExposedPort sshPort = new ExposedPort(internalPort);
        Integer port = 22;
        NetworkSettings networkSettings = ir.getNetworkSettings();
        Ports ports = networkSettings.getPorts();
        Map bindings = ports.getBindings();
        Ports.Binding[] sshBindings = (Ports.Binding[])bindings.get(sshPort);
        Ports.Binding b = Stream.of(sshBindings).sorted(new HostPortComparator()).findFirst().orElse(null);
        if (b != null) {
            String hps = b.getHostPortSpec();
            port = Integer.valueOf(hps);
        }
        String host = DockerComputerSSHConnector.getExternalIP(api, ir, networkSettings, sshBindings);
        return new InetSocketAddress(host, (int)port);
    }

    private static String getExternalIP(DockerAPI api, InspectContainerResponse ir, NetworkSettings networkSettings, Ports.Binding[] sshBindings) {
        String driver;
        String dockerHostname = api.getHostname();
        if (dockerHostname != null && !dockerHostname.trim().isEmpty()) {
            return dockerHostname;
        }
        if (api.isSwarm()) {
            for (Ports.Binding b : sshBindings) {
                String ipAddress = b.getHostIp();
                if (ipAddress == null || "0.0.0.0".equals(ipAddress) || "::".equals(ipAddress)) continue;
                return ipAddress;
            }
        }
        if ((driver = ir.getExecDriver()) != null && driver.startsWith("sdc")) {
            return networkSettings.getIpAddress();
        }
        URI uri = URI.create(api.getDockerHost().getUri());
        if (uri.getScheme().equals("unix")) {
            return "0.0.0.0";
        }
        return uri.getHost();
    }

    @Restricted(value={NoExternalUse.class})
    static StandardUsernameCredentials makeCredentials(String credId, String user, String privateKey) {
        return new BasicSSHUserPrivateKey(CredentialsScope.SYSTEM, credId, user, (BasicSSHUserPrivateKey.PrivateKeySource)new BasicSSHUserPrivateKey.DirectEntryPrivateKeySource(privateKey), null, "private key for docker ssh agent");
    }

    public static abstract class SSHKeyStrategy
    extends AbstractDescribableImpl<SSHKeyStrategy> {
        public abstract String getInjectedKey() throws IOException;

        public abstract String getUser();

        public abstract ComputerLauncher getSSHLauncher(InetSocketAddress var1, DockerComputerSSHConnector var2) throws IOException;

        public abstract boolean equals(Object var1);

        public abstract int hashCode();

        public abstract String toString();
    }

    private static class InjectKeySSHLauncher
    extends SSHLauncher {
        private static final String CREDENTIAL_ID = "InstanceIdentity";
        private String user;
        private String privateKey;

        public InjectKeySSHLauncher(String host, int port, String user, String privateKey, String jvmOptions, String javaPath, String prefixStartSlaveCmd, String suffixStartSlaveCmd, Integer launchTimeoutSeconds, Integer maxNumRetries, Integer retryWaitTime, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
            super(host, port, CREDENTIAL_ID, jvmOptions, javaPath, prefixStartSlaveCmd, suffixStartSlaveCmd, launchTimeoutSeconds, maxNumRetries, retryWaitTime, sshHostKeyVerificationStrategy);
            this.user = user;
            this.privateKey = privateKey;
        }

        public StandardUsernameCredentials getCredentials() {
            return DockerComputerSSHConnector.makeCredentials(CREDENTIAL_ID, this.user, this.privateKey);
        }

        @Extension
        public static final class DescriptorImpl
        extends SSHLauncher.DescriptorImpl {
            @NonNull
            public String getDisplayName() {
                return "Docker variant of " + super.getDisplayName() + " with SSH key injection";
            }

            public FormValidation doCheckCredentialsId(ItemGroup context, AccessControlled _context, String host, String port, String value) {
                return FormValidation.ok();
            }
        }
    }

    public static class ManuallyConfiguredSSHKey
    extends SSHKeyStrategy {
        private final String credentialsId;
        private final SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy;

        @DataBoundConstructor
        public ManuallyConfiguredSSHKey(String credentialsId, SshHostKeyVerificationStrategy sshHostKeyVerificationStrategy) {
            this.credentialsId = credentialsId;
            this.sshHostKeyVerificationStrategy = sshHostKeyVerificationStrategy;
        }

        public String getCredentialsId() {
            return this.credentialsId;
        }

        @Override
        public String getUser() {
            return SSHLauncher.lookupSystemCredentials((String)this.credentialsId).getUsername();
        }

        public SshHostKeyVerificationStrategy getSshHostKeyVerificationStrategy() {
            return this.sshHostKeyVerificationStrategy;
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.credentialsId, this.sshHostKeyVerificationStrategy);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ManuallyConfiguredSSHKey other = (ManuallyConfiguredSSHKey)((Object)obj);
            return Objects.equals(this.credentialsId, other.credentialsId) && Objects.equals(this.sshHostKeyVerificationStrategy, other.sshHostKeyVerificationStrategy);
        }

        @Override
        public String toString() {
            StringBuilder sb = JenkinsUtils.startToString((Object)this);
            JenkinsUtils.bldToString(sb, "credentialsId", this.credentialsId);
            JenkinsUtils.bldToString(sb, "sshHostKeyVerificationStrategy", this.sshHostKeyVerificationStrategy);
            JenkinsUtils.endToString(sb);
            return sb.toString();
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            return new SSHLauncher(address.getHostString(), address.getPort(), this.getCredentialsId(), connector.getJvmOptions(), connector.getJavaPath(), connector.getPrefixStartSlaveCmd(), connector.getSuffixStartSlaveCmd(), connector.getLaunchTimeoutSeconds(), connector.getMaxNumRetries(), connector.getRetryWaitTime(), this.sshHostKeyVerificationStrategy);
        }

        @Override
        public String getInjectedKey() throws IOException {
            return null;
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @NonNull
            public String getDisplayName() {
                return "Use configured SSH credentials";
            }

            public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item context, @QueryParameter String credentialsId) {
                if (!this.hasPermission(context)) {
                    return new StandardUsernameListBoxModel().includeCurrentValue(credentialsId);
                }
                return new StandardUsernameListBoxModel().includeMatchingAs(ACL.SYSTEM, context, StandardUsernameCredentials.class, List.of(), SSHAuthenticator.matcher(Connection.class)).includeCurrentValue(credentialsId);
            }

            private boolean hasPermission(Item context) {
                if (context != null) {
                    return context.hasPermission(Item.CONFIGURE);
                }
                return Jenkins.get().hasPermission(Jenkins.ADMINISTER);
            }
        }
    }

    public static class InjectSSHKey
    extends SSHKeyStrategy {
        private final String user;

        @DataBoundConstructor
        public InjectSSHKey(String user) {
            this.user = user;
        }

        @Override
        public String getUser() {
            return this.user;
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            InjectSSHKey other = (InjectSSHKey)((Object)obj);
            return Objects.equals(this.user, other.user);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.user);
        }

        @Override
        public String toString() {
            StringBuilder sb = JenkinsUtils.startToString((Object)this);
            JenkinsUtils.bldToString(sb, "user", this.user);
            JenkinsUtils.endToString(sb);
            return sb.toString();
        }

        @Override
        public ComputerLauncher getSSHLauncher(InetSocketAddress address, DockerComputerSSHConnector connector) throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            String pem = PEMEncodable.create((Key)id.getPrivate()).encode();
            return new InjectKeySSHLauncher(address.getHostString(), address.getPort(), this.user, pem, connector.getJvmOptions(), connector.getJavaPath(), connector.getPrefixStartSlaveCmd(), connector.getSuffixStartSlaveCmd(), connector.getLaunchTimeoutSeconds(), connector.getMaxNumRetries(), connector.getRetryWaitTime(), (SshHostKeyVerificationStrategy)new NonVerifyingKeyVerificationStrategy());
        }

        @Override
        public String getInjectedKey() throws IOException {
            InstanceIdentity id = InstanceIdentity.get();
            return "ssh-rsa " + Base64.getEncoder().encodeToString(new RSAKeyAlgorithm().encodePublicKey(id.getPublic()));
        }

        @Extension
        public static final class DescriptorImpl
        extends Descriptor<SSHKeyStrategy> {
            @NonNull
            public String getDisplayName() {
                return "Inject SSH key";
            }
        }
    }

    @Extension
    @Symbol(value={"ssh"})
    public static final class DescriptorImpl
    extends Descriptor<DockerComputerConnector> {
        public String getDisplayName() {
            return "Connect with SSH";
        }

        public List getSSHKeyStrategyDescriptors() {
            return Jenkins.get().getDescriptorList(SSHKeyStrategy.class);
        }
    }
}

